/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.ClassLoaderConfigurationData;
import com.intellij.ide.plugins.ContainerDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.ModuleDependenciesDescriptor;
import com.intellij.ide.plugins.PluginContentDescriptor;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginLoadingError;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.SubPluginClassLoader;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.UrlClassLoader;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class ClassLoaderConfigurator {
    @NonNls
    private static final Set<String> IMPL_CLASS_NAMES = new ReferenceOpenHashSet(Arrays.asList("implementation", "implementationClass", "builderClass", "serviceImplementation", "class", "className", "instance", "implementation-class"));
    private final boolean usePluginClassLoader;
    private final ClassLoader coreLoader;
    final Map<PluginId, IdeaPluginDescriptorImpl> idMap;
    private final Map<String, String[]> additionalLayoutMap;
    private Optional<IdeaPluginDescriptorImpl> javaDep;
    private final Set<ClassLoader> loaders;
    private final List<String> packagePrefixes;
    private final boolean hasAllModules;
    private final UrlClassLoader.Builder urlClassLoaderBuilder;
    private final Set<String> pluginPackagePrefixUniqueGuard;
    private final ClassPath.ResourceFileFactory resourceFileFactory;

    ClassLoaderConfigurator(boolean usePluginClassLoader, @NotNull ClassLoader coreLoader, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @NotNull Map<String, String[]> additionalLayoutMap) {
        ClassPath.ResourceFileFactory resourceFileFactory;
        if (coreLoader == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(0);
        }
        if (idMap == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(1);
        }
        if (additionalLayoutMap == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(2);
        }
        this.loaders = new LinkedHashSet<ClassLoader>();
        this.packagePrefixes = new ArrayList<String>();
        this.pluginPackagePrefixUniqueGuard = new HashSet<String>();
        this.usePluginClassLoader = usePluginClassLoader;
        this.coreLoader = coreLoader;
        this.idMap = idMap;
        this.additionalLayoutMap = additionalLayoutMap;
        this.hasAllModules = idMap.containsKey(PluginManagerCore.ALL_MODULES_MARKER);
        this.urlClassLoaderBuilder = UrlClassLoader.build().useCache();
        try {
            resourceFileFactory = MethodHandles.lookup().findStatic(coreLoader.loadClass("com.intellij.util.lang.PathClassLoader"), "getResourceFileFactory", MethodType.methodType(ClassPath.ResourceFileFactory.class)).invokeExact();
        }
        catch (ClassNotFoundException ignore) {
            resourceFileFactory = null;
        }
        catch (Throwable e) {
            ClassLoaderConfigurator.getLogger().error(e);
            resourceFileFactory = null;
        }
        this.resourceFileFactory = resourceFileFactory;
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance((String)"#com.intellij.ide.plugins.PluginManager");
        if (logger == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(3);
        }
        return logger;
    }

    void configureDependenciesIfNeeded(@NotNull @NotNull Map<IdeaPluginDescriptorImpl, @NotNull List<IdeaPluginDescriptorImpl>> mainToSub, @NotNull IdeaPluginDescriptorImpl dependencyPlugin) {
        if (mainToSub == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(4);
        }
        if (dependencyPlugin == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(5);
        }
        for (Map.Entry<IdeaPluginDescriptorImpl, List<IdeaPluginDescriptorImpl>> entry : mainToSub.entrySet()) {
            IdeaPluginDescriptorImpl mainDependent = entry.getKey();
            PluginClassLoader mainDependentClassLoader = (PluginClassLoader)((Object)Objects.requireNonNull(mainDependent.getClassLoader()));
            if (ClassLoaderConfigurator.isClassloaderPerDescriptorEnabled(mainDependent)) {
                block1: for (PluginDependency dependency : Objects.requireNonNull(mainDependent.pluginDependencies)) {
                    this.urlClassLoaderBuilder.files((List)mainDependentClassLoader.getFiles());
                    for (IdeaPluginDescriptorImpl subDescriptor : entry.getValue()) {
                        if (subDescriptor != dependency.subDescriptor) continue;
                        this.configureSubPlugin(dependency, (ClassLoader)((Object)mainDependentClassLoader), mainDependent);
                        continue block1;
                    }
                }
                continue;
            }
            mainDependentClassLoader.attachParent(Objects.requireNonNull(dependencyPlugin.getClassLoader()));
            for (IdeaPluginDescriptorImpl subDescriptor : entry.getValue()) {
                subDescriptor.setClassLoader((ClassLoader)((Object)mainDependentClassLoader));
            }
        }
        this.loaders.clear();
        this.urlClassLoaderBuilder.files(Collections.emptyList());
    }

    void configure(@NotNull IdeaPluginDescriptorImpl mainDependent) {
        List<Path> classPath;
        IdeaPluginDescriptorImpl implicitDependency;
        String pluginPackagePrefix;
        if (mainDependent == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(6);
        }
        if ((pluginPackagePrefix = mainDependent.packagePrefix) != null && !this.pluginPackagePrefixUniqueGuard.add(pluginPackagePrefix)) {
            throw new PluginException("Package prefix " + pluginPackagePrefix + " is already used", mainDependent.getPluginId());
        }
        if (mainDependent.getPluginId() == PluginManagerCore.CORE_ID || mainDependent.isUseCoreClassLoader()) {
            this.setPluginClassLoaderForMainAndSubPlugins(mainDependent, this.coreLoader);
            return;
        }
        if (!this.usePluginClassLoader) {
            this.setPluginClassLoaderForMainAndSubPlugins(mainDependent, null);
        }
        this.loaders.clear();
        if (this.hasAllModules && (implicitDependency = PluginManagerCore.getImplicitDependency(mainDependent, () -> {
            if (this.javaDep == null) {
                this.javaDep = Optional.ofNullable(this.idMap.get(PluginManagerCore.JAVA_PLUGIN_ID));
            }
            return this.javaDep.orElse(null);
        })) != null) {
            this.addLoaderOrLogError(mainDependent, implicitDependency, this.loaders);
        }
        if ((classPath = mainDependent.jarFiles) == null) {
            classPath = this.collectClassPath(mainDependent);
        } else {
            mainDependent.jarFiles = null;
        }
        this.urlClassLoaderBuilder.files(classPath);
        List<PluginDependency> pluginDependencies = mainDependent.pluginDependencies;
        if (pluginDependencies == null) {
            assert (!mainDependent.isUseIdeaClassLoader());
            mainDependent.setClassLoader((ClassLoader)((Object)this.createPluginClassLoader(mainDependent)));
            return;
        }
        for (PluginDependency dependency : pluginDependencies) {
            if (dependency.isDisabledOrBroken || ClassLoaderConfigurator.isClassloaderPerDescriptorEnabled(mainDependent) && dependency.subDescriptor != null) continue;
            this.addClassloaderIfDependencyEnabled(dependency.id, mainDependent);
        }
        Object mainDependentClassLoader = mainDependent.isUseIdeaClassLoader() ? ClassLoaderConfigurator.configureUsingIdeaClassloader(classPath, mainDependent) : this.createPluginClassLoader(mainDependent);
        if (this.usePluginClassLoader && ClassLoaderConfigurator.isClassloaderPerDescriptorEnabled(mainDependent)) {
            mainDependent.setClassLoader((ClassLoader)mainDependentClassLoader);
            for (PluginDependency dependencyInfo : pluginDependencies) {
                this.configureSubPlugin(dependencyInfo, (ClassLoader)mainDependentClassLoader, mainDependent);
            }
        } else {
            this.setPluginClassLoaderForMainAndSubPlugins(mainDependent, (ClassLoader)mainDependentClassLoader);
        }
        this.loaders.clear();
        this.urlClassLoaderBuilder.files(Collections.emptyList());
    }

    @NotNull
    private PluginClassLoader createPluginClassLoader(@NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (descriptor2 == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(7);
        }
        ClassLoader[] parentLoaders = this.loaders.isEmpty() ? PluginClassLoader.EMPTY_CLASS_LOADER_ARRAY : this.loaders.toArray(PluginClassLoader.EMPTY_CLASS_LOADER_ARRAY);
        return ClassLoaderConfigurator.createPluginClassLoader(parentLoaders, descriptor2, this.urlClassLoaderBuilder, this.coreLoader, this.resourceFileFactory);
    }

    @NotNull
    private static PluginClassLoader createPluginClassLoader(@NotNull @NotNull ClassLoader @NotNull [] parentLoaders, @NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull UrlClassLoader.Builder urlClassLoaderBuilder, @NotNull ClassLoader coreLoader, @Nullable ClassPath.ResourceFileFactory resourceFileFactory) {
        boolean isMain;
        if (parentLoaders == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(8);
        }
        if (descriptor2 == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(9);
        }
        if (urlClassLoaderBuilder == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(10);
        }
        if (coreLoader == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(11);
        }
        String idString = descriptor2.id.getIdString();
        boolean bl = isMain = descriptor2.descriptorPath == null;
        if (isMain) {
            switch (idString) {
                case "com.intellij.diagram": {
                    return ClassLoaderConfigurator.createPluginClassLoaderWithExtraPackage(parentLoaders, descriptor2, urlClassLoaderBuilder, coreLoader, resourceFileFactory, "com.intellij.diagram.");
                }
                case "com.intellij.struts2": {
                    return ClassLoaderConfigurator.createPluginClassLoaderWithExtraPackage(parentLoaders, descriptor2, urlClassLoaderBuilder, coreLoader, resourceFileFactory, "com.intellij.lang.ognl.");
                }
                case "com.intellij.properties": {
                    return ClassLoaderConfigurator.createPluginClassloader(parentLoaders, descriptor2, urlClassLoaderBuilder, coreLoader, resourceFileFactory, new PluginClassLoader.ResolveScopeManager(){

                        @Override
                        public boolean isDefinitelyAlienClass(String name, String packagePrefix) {
                            return !name.startsWith(packagePrefix) && !name.startsWith("com.intellij.ultimate.PluginVerifier") && !name.equals("com.intellij.codeInspection.unused.ImplicitPropertyUsageProvider");
                        }
                    });
                }
            }
            if (descriptor2.packagePrefix != null) {
                return ClassLoaderConfigurator.createPluginClassloader(parentLoaders, descriptor2, urlClassLoaderBuilder, coreLoader, resourceFileFactory, ClassLoaderConfigurator.createPluginDependencyAndContentBasedScope(descriptor2));
            }
        } else if (!descriptor2.contentDescriptor.modules.isEmpty()) {
            return ClassLoaderConfigurator.createPluginClassloader(parentLoaders, descriptor2, urlClassLoaderBuilder, coreLoader, resourceFileFactory, ClassLoaderConfigurator.createModuleContentBasedScope(descriptor2));
        }
        if (descriptor2.packagePrefix == null) {
            return new PluginClassLoader(urlClassLoaderBuilder, parentLoaders, (PluginDescriptor)descriptor2, descriptor2.getPluginPath(), coreLoader, null, null, resourceFileFactory);
        }
        return ClassLoaderConfigurator.createPluginClassloader(parentLoaders, descriptor2, urlClassLoaderBuilder, coreLoader, resourceFileFactory, new PluginClassLoader.ResolveScopeManager(){

            @Override
            public boolean isDefinitelyAlienClass(String name, String packagePrefix) {
                return !name.startsWith(packagePrefix) && !name.startsWith("com.intellij.ultimate.PluginVerifier");
            }
        });
    }

    @NotNull
    private static PluginClassLoader createPluginClassloader(@NotNull @NotNull ClassLoader @NotNull [] parentLoaders, @NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull UrlClassLoader.Builder urlClassLoaderBuilder, @NotNull ClassLoader coreLoader, @Nullable ClassPath.ResourceFileFactory resourceFileFactory, @Nullable PluginClassLoader.ResolveScopeManager resolveScopeManager) {
        if (parentLoaders == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(12);
        }
        if (descriptor2 == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(13);
        }
        if (urlClassLoaderBuilder == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(14);
        }
        if (coreLoader == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(15);
        }
        return new PluginClassLoader(urlClassLoaderBuilder, parentLoaders, (PluginDescriptor)descriptor2, descriptor2.getPluginPath(), coreLoader, resolveScopeManager, descriptor2.packagePrefix, resourceFileFactory);
    }

    @NotNull
    private static PluginClassLoader createPluginClassLoaderWithExtraPackage(@NotNull @NotNull ClassLoader @NotNull [] parentLoaders, @NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull UrlClassLoader.Builder urlClassLoaderBuilder, @NotNull ClassLoader coreLoader, @Nullable ClassPath.ResourceFileFactory resourceFileFactory, final @NotNull String customPackage) {
        if (parentLoaders == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(16);
        }
        if (descriptor2 == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(17);
        }
        if (urlClassLoaderBuilder == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(18);
        }
        if (coreLoader == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(19);
        }
        if (customPackage == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(20);
        }
        return ClassLoaderConfigurator.createPluginClassloader(parentLoaders, descriptor2, urlClassLoaderBuilder, coreLoader, resourceFileFactory, new PluginClassLoader.ResolveScopeManager(){

            @Override
            public boolean isDefinitelyAlienClass(String name, String packagePrefix) {
                return !name.startsWith(packagePrefix) && !name.startsWith("com.intellij.ultimate.PluginVerifier") && !name.startsWith(customPackage);
            }
        });
    }

    @NotNull
    private static PluginClassLoader.ResolveScopeManager createPluginDependencyAndContentBasedScope(@NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (descriptor2 == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(21);
        }
        List<String> contentPackagePrefixes = ClassLoaderConfigurator.getContentPackagePrefixes(descriptor2);
        List<String> dependencyPackagePrefixes = ClassLoaderConfigurator.getDependencyPackagePrefixes(descriptor2);
        String pluginId = descriptor2.getPluginId().getIdString();
        PluginClassLoader.ResolveScopeManager resolveScopeManager = (name, __) -> {
            for (String prefix : contentPackagePrefixes) {
                if (!name.startsWith(prefix)) continue;
                ClassLoaderConfigurator.getLogger().error("Class " + name + " must be not requested from main classloader of " + pluginId + " plugin");
                return true;
            }
            for (String prefix : dependencyPackagePrefixes) {
                if (!name.startsWith(prefix)) continue;
                return true;
            }
            return false;
        };
        if (resolveScopeManager == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(22);
        }
        return resolveScopeManager;
    }

    @NotNull
    private static List<String> getContentPackagePrefixes(@NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (descriptor2 == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(23);
        }
        ArrayList<String> result2 = null;
        for (PluginContentDescriptor.ModuleItem item : descriptor2.contentDescriptor.modules) {
            String packagePrefix;
            if (item.isInjected || (packagePrefix = item.packageName) == null) continue;
            if (result2 == null) {
                result2 = new ArrayList<String>(descriptor2.contentDescriptor.modules.size());
            }
            result2.add(packagePrefix + '.');
        }
        List<String> list2 = result2 == null ? Collections.emptyList() : result2;
        if (list2 == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(24);
        }
        return list2;
    }

    @NotNull
    private static List<String> getDependencyPackagePrefixes(@NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (descriptor2 == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(25);
        }
        if (descriptor2.dependencyDescriptor.modules.isEmpty()) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                ClassLoaderConfigurator.$$$reportNull$$$0(26);
            }
            return list2;
        }
        ArrayList<String> result2 = new ArrayList<String>(descriptor2.dependencyDescriptor.modules.size());
        for (ModuleDependenciesDescriptor.ModuleItem item : descriptor2.dependencyDescriptor.modules) {
            String packagePrefix = item.packageName;
            if (packagePrefix == null || item.name.equals("intellij.platform.commercial.verifier")) continue;
            result2.add(packagePrefix + '.');
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    @NotNull
    private static PluginClassLoader.ResolveScopeManager createModuleContentBasedScope(@NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (descriptor2 == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(28);
        }
        ArrayList<String> packagePrefixes = new ArrayList<String>(descriptor2.contentDescriptor.modules.size());
        for (PluginContentDescriptor.ModuleItem item : descriptor2.contentDescriptor.modules) {
            String packagePrefix2 = item.packageName;
            if (packagePrefix2 == null) continue;
            packagePrefixes.add(packagePrefix2 + '.');
        }
        PluginClassLoader.ResolveScopeManager resolveScopeManager = (name, packagePrefix) -> {
            if (name.startsWith(packagePrefix) || name.startsWith("com.intellij.ultimate.PluginVerifier")) {
                return false;
            }
            for (String prefix : packagePrefixes) {
                if (!name.startsWith(prefix)) continue;
                return false;
            }
            return true;
        };
        if (resolveScopeManager == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(29);
        }
        return resolveScopeManager;
    }

    private static boolean isClassloaderPerDescriptorEnabled(@NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (descriptor2 == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(30);
        }
        return ClassLoaderConfigurationData.isClassloaderPerDescriptorEnabled(descriptor2.id, descriptor2.packagePrefix);
    }

    private void configureSubPlugin(@NotNull PluginDependency dependencyInfo, @NotNull ClassLoader mainDependentClassLoader, @NotNull IdeaPluginDescriptorImpl parentDescriptor) {
        IdeaPluginDescriptorImpl dependency;
        IdeaPluginDescriptorImpl dependent;
        if (dependencyInfo == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(31);
        }
        if (mainDependentClassLoader == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(32);
        }
        if (parentDescriptor == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(33);
        }
        IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = dependent = dependencyInfo.isDisabledOrBroken ? null : dependencyInfo.subDescriptor;
        if (dependent == null) {
            return;
        }
        assert (!dependent.isUseIdeaClassLoader());
        String pluginPackagePrefix = dependent.packagePrefix;
        if (pluginPackagePrefix == null) {
            if (parentDescriptor.packagePrefix != null) {
                throw new PluginException("Sub descriptor must specify package if it is specified for main plugin descriptor (descriptorFile=" + dependent.descriptorPath + ")", parentDescriptor.id);
            }
        } else {
            String parentId;
            if (pluginPackagePrefix.equals(parentDescriptor.packagePrefix)) {
                throw new PluginException("Sub descriptor must not specify the same package as main plugin descriptor", parentDescriptor.id);
            }
            if (!(parentDescriptor.packagePrefix != null || (parentId = parentDescriptor.id.getIdString()).equals("Docker") || parentId.equals("org.jetbrains.plugins.ruby") || parentId.equals("JavaScript"))) {
                throw new PluginException("Sub descriptor must not specify package if one is not specified for main plugin descriptor", parentDescriptor.id);
            }
            if (!this.pluginPackagePrefixUniqueGuard.add(pluginPackagePrefix)) {
                throw new PluginException("Package prefix " + pluginPackagePrefix + " is already used", parentDescriptor.id);
            }
        }
        if ((dependency = this.idMap.get(dependencyInfo.id)) == null || !dependency.isEnabled()) {
            return;
        }
        if (pluginPackagePrefix == null) {
            this.packagePrefixes.clear();
            ClassLoaderConfigurator.collectPackagePrefixes(dependent, this.packagePrefixes);
            if (this.packagePrefixes.isEmpty()) {
                ClassLoaderConfigurator.getLogger().debug("Optional descriptor " + dependencyInfo + " contains only bean extension points or light services");
            }
        }
        this.loaders.clear();
        if (parentDescriptor.descriptorPath == null) {
            this.addSiblingClassloaderIfNeeded(dependent, parentDescriptor);
        }
        this.loaders.add(mainDependentClassLoader);
        this.addLoaderOrLogError(dependent, dependency, this.loaders);
        List<PluginDependency> pluginDependencies = dependent.pluginDependencies;
        if (pluginDependencies != null) {
            for (PluginDependency subDependency : pluginDependencies) {
                if (subDependency.isDisabledOrBroken || subDependency.subDescriptor != null) continue;
                this.addClassloaderIfDependencyEnabled(subDependency.id, dependent);
            }
        }
        PluginClassLoader subClassloader = pluginPackagePrefix == null ? new SubPluginClassLoader(dependent, this.urlClassLoaderBuilder, this.loaders.toArray(PluginClassLoader.EMPTY_CLASS_LOADER_ARRAY), this.packagePrefixes.toArray(ArrayUtilRt.EMPTY_STRING_ARRAY), this.coreLoader, this.resourceFileFactory) : this.createPluginClassLoader(dependent);
        dependent.setClassLoader((ClassLoader)((Object)subClassloader));
        if (pluginDependencies != null) {
            for (PluginDependency subDependency : pluginDependencies) {
                this.configureSubPlugin(subDependency, (ClassLoader)((Object)subClassloader), dependent);
            }
        }
    }

    private void addSiblingClassloaderIfNeeded(@NotNull IdeaPluginDescriptorImpl dependent, @NotNull IdeaPluginDescriptorImpl parentDescriptor) {
        if (dependent == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(34);
        }
        if (parentDescriptor == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(35);
        }
        if (!ClassLoaderConfigurationData.SEPARATE_CLASSLOADER_FOR_SUB) {
            return;
        }
        for (ModuleDependenciesDescriptor.ModuleItem dependentModuleDependency : dependent.dependencyDescriptor.modules) {
            PluginContentDescriptor.ModuleItem dependencyContentModule = parentDescriptor.contentDescriptor.findModuleByName(dependentModuleDependency.name);
            if (dependencyContentModule == null) {
                throw new PluginException("Main descriptor " + parentDescriptor + " must list module in content if it is specified as dependency in sub descriptor (descriptorFile=" + dependent.descriptorPath + ")", parentDescriptor.id);
            }
            for (PluginDependency dependencyPluginDependency : Objects.requireNonNull(parentDescriptor.pluginDependencies)) {
                if (dependencyPluginDependency.isDisabledOrBroken || dependencyPluginDependency.subDescriptor == null || !dependentModuleDependency.packageName.equals(dependencyPluginDependency.subDescriptor.packagePrefix)) continue;
                ClassLoader classLoader = dependencyPluginDependency.subDescriptor.getClassLoader();
                if (classLoader == null) {
                    throw new PluginException("Classloader is null for sibling. Please ensure that content entry in the main plugin specifies module with package `" + dependentModuleDependency.packageName + "` before module with package `" + dependent.packagePrefix + "`(descriptorFile=" + dependent.descriptorPath + ")", parentDescriptor.id);
                }
                this.loaders.add(classLoader);
            }
        }
    }

    private void addClassloaderIfDependencyEnabled(@NotNull PluginId dependencyId, @NotNull IdeaPluginDescriptorImpl dependent) {
        ClassLoader loader2;
        IdeaPluginDescriptorImpl dependency;
        if (dependencyId == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(36);
        }
        if (dependent == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(37);
        }
        if ((dependency = this.idMap.get(dependencyId)) == null) {
            return;
        }
        if (ClassLoaderConfigurationData.SEPARATE_CLASSLOADER_FOR_SUB && dependency.pluginDependencies != null) {
            for (ModuleDependenciesDescriptor.ModuleItem dependentModuleDependency : dependent.dependencyDescriptor.modules) {
                if (dependency.contentDescriptor.findModuleByName(dependentModuleDependency.name) == null) continue;
                for (PluginDependency pluginDependency : dependency.pluginDependencies) {
                    if (pluginDependency.isDisabledOrBroken || pluginDependency.subDescriptor == null || !dependentModuleDependency.packageName.equals(pluginDependency.subDescriptor.packagePrefix)) continue;
                    this.loaders.add(pluginDependency.subDescriptor.getClassLoader());
                }
            }
        }
        if ((loader2 = dependency.getClassLoader()) == null) {
            ClassLoaderConfigurator.getLogger().error(PluginLoadingError.formatErrorMessage(dependent, "requires missing class loader for '" + dependency.getName() + "'"));
        } else if (loader2 != this.coreLoader) {
            this.loaders.add(loader2);
        }
    }

    private static void collectPackagePrefixes(@NotNull IdeaPluginDescriptorImpl dependent, @NotNull List<String> packagePrefixes) {
        if (dependent == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(38);
        }
        if (packagePrefixes == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(39);
        }
        dependent.getUnsortedEpNameToExtensionElements().values().forEach(elements -> {
            block0: for (Element element2 : elements) {
                if (!element2.hasAttributes()) continue;
                for (String attributeName : IMPL_CLASS_NAMES) {
                    String className = element2.getAttributeValue(attributeName);
                    if (className == null || className.isEmpty()) continue;
                    ClassLoaderConfigurator.addPackageByClassNameIfNeeded(className, packagePrefixes);
                    continue block0;
                }
            }
        });
        ClassLoaderConfigurator.collectFromServices(dependent.appContainerDescriptor, packagePrefixes);
        ClassLoaderConfigurator.collectFromServices(dependent.projectContainerDescriptor, packagePrefixes);
        ClassLoaderConfigurator.collectFromServices(dependent.moduleContainerDescriptor, packagePrefixes);
    }

    private static void addPackageByClassNameIfNeeded(@NotNull String name, @NotNull List<String> packagePrefixes) {
        if (name == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(40);
        }
        if (packagePrefixes == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(41);
        }
        for (String packagePrefix : packagePrefixes) {
            if (!name.startsWith(packagePrefix)) continue;
            return;
        }
        if (name.indexOf(36) != -1) {
            packagePrefixes.add(name);
            return;
        }
        int lastPackageDot = name.lastIndexOf(46);
        if (lastPackageDot > 0 && lastPackageDot != name.length()) {
            ClassLoaderConfigurator.addPackagePrefixIfNeeded(packagePrefixes, name.substring(0, lastPackageDot + 1));
        }
    }

    private static void addPackagePrefixIfNeeded(@NotNull List<String> packagePrefixes, @NotNull String packagePrefix) {
        if (packagePrefixes == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(42);
        }
        if (packagePrefix == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(43);
        }
        for (int i2 = 0; i2 < packagePrefixes.size(); ++i2) {
            String existingPackagePrefix = packagePrefixes.get(i2);
            if (packagePrefix.startsWith(existingPackagePrefix)) {
                return;
            }
            if (!existingPackagePrefix.startsWith(packagePrefix) || existingPackagePrefix.indexOf(36) != -1) continue;
            packagePrefixes.set(i2, packagePrefix);
            for (int j = packagePrefixes.size() - 1; j > i2; --j) {
                if (!packagePrefixes.get(j).startsWith(packagePrefix)) continue;
                packagePrefixes.remove(j);
            }
            return;
        }
        packagePrefixes.add(packagePrefix);
    }

    private static void collectFromServices(@NotNull ContainerDescriptor containerDescriptor, @NotNull List<String> packagePrefixes) {
        List<ServiceDescriptor> services;
        if (containerDescriptor == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(44);
        }
        if (packagePrefixes == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(45);
        }
        if ((services = containerDescriptor.services) == null) {
            return;
        }
        for (ServiceDescriptor service : services) {
            if (service.serviceImplementation != null) {
                ClassLoaderConfigurator.addPackageByClassNameIfNeeded(service.serviceImplementation, packagePrefixes);
            }
            if (service.headlessImplementation == null) continue;
            ClassLoaderConfigurator.addPackageByClassNameIfNeeded(service.headlessImplementation, packagePrefixes);
        }
    }

    @NotNull
    private static ClassLoader configureUsingIdeaClassloader(@NotNull List<? extends Path> classPath, @NotNull IdeaPluginDescriptorImpl descriptor2) {
        ClassLoader classLoader;
        if (classPath == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(46);
        }
        if (descriptor2 == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(47);
        }
        ClassLoaderConfigurator.getLogger().warn(descriptor2.getPluginId() + " uses deprecated `use-idea-classloader` attribute");
        ClassLoader loader2 = ClassLoaderConfigurator.class.getClassLoader();
        try {
            MethodHandle addFiles = MethodHandles.lookup().findVirtual(loader2.getClass(), "addFiles", MethodType.methodType(Void.TYPE, List.class));
            addFiles.invoke(loader2, classPath);
            classLoader = loader2;
        }
        catch (Throwable e) {
            throw new IllegalStateException("An unexpected core classloader: " + loader2, e);
        }
        if (classLoader == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(48);
        }
        return classLoader;
    }

    private void addLoaderOrLogError(@NotNull IdeaPluginDescriptorImpl dependent, @NotNull IdeaPluginDescriptorImpl dependency, @NotNull Collection<? super ClassLoader> loaders) {
        ClassLoader loader2;
        if (dependent == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(49);
        }
        if (dependency == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(50);
        }
        if (loaders == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(51);
        }
        if ((loader2 = dependency.getClassLoader()) == null) {
            ClassLoaderConfigurator.getLogger().error(PluginLoadingError.formatErrorMessage(dependent, "requires missing class loader for '" + dependency.getName() + "'"));
        } else if (loader2 != this.coreLoader) {
            loaders.add(loader2);
        }
    }

    private void setPluginClassLoaderForMainAndSubPlugins(@NotNull IdeaPluginDescriptorImpl rootDescriptor, @Nullable ClassLoader classLoader) {
        if (rootDescriptor == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(52);
        }
        rootDescriptor.setClassLoader(classLoader);
        for (PluginDependency dependency : rootDescriptor.getPluginDependencies()) {
            IdeaPluginDescriptorImpl descriptor2;
            if (dependency.subDescriptor == null || (descriptor2 = this.idMap.get(dependency.id)) == null || !descriptor2.isEnabled()) continue;
            this.setPluginClassLoaderForMainAndSubPlugins(dependency.subDescriptor, classLoader);
        }
    }

    @NotNull
    private List<Path> collectClassPath(@NotNull IdeaPluginDescriptorImpl descriptor2) {
        Path productionDirectory;
        Path pluginPath;
        if (descriptor2 == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(53);
        }
        if (!Files.isDirectory(pluginPath = descriptor2.path, new LinkOption[0])) {
            List<Path> list2 = Collections.singletonList(pluginPath);
            if (list2 == null) {
                ClassLoaderConfigurator.$$$reportNull$$$0(54);
            }
            return list2;
        }
        ArrayList<Path> result2 = new ArrayList<Path>();
        Path classesDir = pluginPath.resolve("classes");
        if (Files.exists(classesDir, new LinkOption[0])) {
            result2.add(classesDir);
        }
        if (this.usePluginClassLoader && (productionDirectory = pluginPath.getParent()).endsWith("production")) {
            result2.add(pluginPath);
            String moduleName = pluginPath.getFileName().toString();
            String[] additionalPaths = this.additionalLayoutMap.get(moduleName);
            if (additionalPaths != null) {
                for (String path : additionalPaths) {
                    result2.add(productionDirectory.resolve(path));
                }
            }
        }
        try (DirectoryStream<Path> childStream2 = Files.newDirectoryStream(pluginPath.resolve("lib"));){
            for (Path f : childStream2) {
                if (Files.isRegularFile(f, new LinkOption[0])) {
                    String name = f.getFileName().toString();
                    if (!StringUtilRt.endsWithIgnoreCase((CharSequence)name, (CharSequence)".jar") && !StringUtilRt.endsWithIgnoreCase((CharSequence)name, (CharSequence)".zip")) continue;
                    result2.add(f);
                    continue;
                }
                result2.add(f);
            }
        }
        catch (NoSuchFileException childStream2) {
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().debug((Throwable)e);
        }
        ArrayList<Path> arrayList = result2;
        if (arrayList == null) {
            ClassLoaderConfigurator.$$$reportNull$$$0(55);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 48: 
            case 54: 
            case 55: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 48: 
            case 54: 
            case 55: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreLoader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idMap";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalLayoutMap";
                break;
            }
            case 3: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 48: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/ClassLoaderConfigurator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainToSub";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyPlugin";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainDependent";
                break;
            }
            case 7: 
            case 9: 
            case 13: 
            case 17: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 30: 
            case 47: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 8: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentLoaders";
                break;
            }
            case 10: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlClassLoaderBuilder";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customPackage";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyInfo";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainDependentClassLoader";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDescriptor";
                break;
            }
            case 34: 
            case 37: 
            case 38: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependent";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyId";
                break;
            }
            case 39: 
            case 41: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagePrefixes";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagePrefix";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerDescriptor";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loaders";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/ClassLoaderConfigurator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginDependencyAndContentBasedScope";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentPackagePrefixes";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyPackagePrefixes";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleContentBasedScope";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "configureUsingIdeaClassloader";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "collectClassPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 48: 
            case 54: 
            case 55: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "configureDependenciesIfNeeded";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createPluginClassLoader";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createPluginClassloader";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createPluginClassLoaderWithExtraPackage";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createPluginDependencyAndContentBasedScope";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getContentPackagePrefixes";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDependencyPackagePrefixes";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createModuleContentBasedScope";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isClassloaderPerDescriptorEnabled";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "configureSubPlugin";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addSiblingClassloaderIfNeeded";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addClassloaderIfDependencyEnabled";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "collectPackagePrefixes";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "addPackageByClassNameIfNeeded";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addPackagePrefixIfNeeded";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "collectFromServices";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "configureUsingIdeaClassloader";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addLoaderOrLogError";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "setPluginClassLoaderForMainAndSubPlugins";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "collectClassPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 48: 
            case 54: 
            case 55: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

