/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.icons.AllIcons;
import com.intellij.ide.navigationToolbar.NavBarModel;
import com.intellij.ide.navigationToolbar.NavBarModelExtension;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.structureView.StructureViewBundle;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IconUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavBarPresentation {
    private final Project myProject;
    private EditorColorsScheme scheme;

    public NavBarPresentation(Project project) {
        this.myProject = project;
        this.updateScheme();
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myProject).subscribe(LafManagerListener.TOPIC, laf -> this.updateScheme());
    }

    private void updateScheme() {
        this.scheme = EditorColorsManager.getInstance().getSchemeForCurrentUITheme();
    }

    private SimpleTextAttributes getErrorAttributes() {
        SimpleTextAttributes schemeAttributes = SimpleTextAttributes.fromTextAttributes(this.scheme.getAttributes(CodeInsightColors.ERRORS_ATTRIBUTES));
        return SimpleTextAttributes.merge(new SimpleTextAttributes(8192, schemeAttributes.getFgColor()), schemeAttributes);
    }

    @Nullable
    public Icon getIcon(Object object) {
        if (!NavBarModel.isValid(object)) {
            return null;
        }
        for (NavBarModelExtension modelExtension : NavBarModelExtension.EP_NAME.getExtensionList()) {
            Icon icon2 = modelExtension.getIcon(object);
            if (icon2 == null) continue;
            return icon2;
        }
        if (object instanceof Project) {
            return AllIcons.Nodes.Project;
        }
        if (object instanceof Module) {
            return ModuleType.get((Module)((Module)object)).getIcon();
        }
        try {
            if (object instanceof PsiElement) {
                Icon icon3 = (Icon)ReadAction.compute(() -> ((PsiElement)object).isValid() ? ((PsiElement)object).getIcon(0) : null);
                if (icon3 != null && (icon3.getIconHeight() > 32 || icon3.getIconWidth() > 32)) {
                    icon3 = IconUtil.cropIcon(icon3, 32, 32);
                }
                return icon3;
            }
        }
        catch (IndexNotReadyException e) {
            return null;
        }
        if (object instanceof JdkOrderEntry) {
            Sdk jdk = ((JdkOrderEntry)object).getJdk();
            if (jdk == null) {
                return null;
            }
            SdkTypeId sdkType = jdk.getSdkType();
            return ((SdkType)sdkType).getIcon();
        }
        if (object instanceof LibraryOrderEntry) {
            return AllIcons.Nodes.PpLibFolder;
        }
        if (object instanceof ModuleOrderEntry) {
            return ModuleType.get((Module)((ModuleOrderEntry)object).getModule()).getIcon();
        }
        return null;
    }

    @NotNull
    @Nls
    protected String getPresentableText(Object object, boolean forPopup) {
        String text2 = NavBarPresentation.calcPresentableText(object, forPopup);
        Object object2 = text2.length() > 50 ? text2.substring(0, 47) + "..." : text2;
        if (object2 == null) {
            NavBarPresentation.$$$reportNull$$$0(0);
        }
        return object2;
    }

    @NotNull
    @Nls
    public static String calcPresentableText(Object object, boolean forPopup) {
        if (!NavBarModel.isValid(object)) {
            String string = StructureViewBundle.message("node.structureview.invalid", new Object[0]);
            if (string == null) {
                NavBarPresentation.$$$reportNull$$$0(1);
            }
            return string;
        }
        for (NavBarModelExtension modelExtension : NavBarModelExtension.EP_NAME.getExtensionList()) {
            String text2 = modelExtension.getPresentableText(object, forPopup);
            if (text2 == null) continue;
            String string = text2;
            if (string == null) {
                NavBarPresentation.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = object.toString();
        if (string == null) {
            NavBarPresentation.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected SimpleTextAttributes getTextAttributes(Object object, boolean selected2) {
        if (!NavBarModel.isValid(object)) {
            return SimpleTextAttributes.REGULAR_ATTRIBUTES;
        }
        if (object instanceof PsiElement) {
            VirtualFile vDir;
            if (!((Boolean)ReadAction.compute(() -> ((PsiElement)object).isValid())).booleanValue()) {
                return SimpleTextAttributes.GRAYED_ATTRIBUTES;
            }
            PsiFile psiFile = ((PsiElement)object).getContainingFile();
            if (psiFile != null) {
                VirtualFile virtualFile = psiFile.getVirtualFile();
                return new SimpleTextAttributes(null, selected2 ? null : FileStatusManager.getInstance((Project)this.myProject).getStatus(virtualFile).getColor(), this.getErrorAttributes().getWaveColor(), virtualFile != null && WolfTheProblemSolver.getInstance((Project)this.myProject).isProblemFile(virtualFile) ? this.getErrorAttributes().getStyle() : 0);
            }
            if (object instanceof PsiDirectory && ((vDir = ((PsiDirectory)object).getVirtualFile()).getParent() == null || ProjectRootsUtil.isModuleContentRoot(vDir, this.myProject))) {
                return SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            }
            if (NavBarPresentation.wolfHasProblemFilesBeneath((PsiElement)object)) {
                return this.getErrorAttributes();
            }
        } else if (object instanceof Module) {
            if (WolfTheProblemSolver.getInstance((Project)this.myProject).hasProblemFilesBeneath((Module)object)) {
                return this.getErrorAttributes();
            }
        } else if (object instanceof Project) {
            Module[] modules2;
            Project project = (Project)object;
            for (Module module : modules2 = (Module[])ReadAction.compute(() -> ModuleManager.getInstance((Project)project).getModules())) {
                if (!WolfTheProblemSolver.getInstance((Project)project).hasProblemFilesBeneath(module)) continue;
                return this.getErrorAttributes();
            }
        }
        return SimpleTextAttributes.REGULAR_ATTRIBUTES;
    }

    public static boolean wolfHasProblemFilesBeneath(PsiElement scope) {
        return WolfTheProblemSolver.getInstance((Project)scope.getProject()).hasProblemFilesBeneath(virtualFile -> {
            if (scope instanceof PsiDirectory) {
                PsiDirectory directory = (PsiDirectory)scope;
                if (!VfsUtil.isAncestor((VirtualFile)directory.getVirtualFile(), (VirtualFile)virtualFile, (boolean)false)) {
                    return false;
                }
                return ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)scope.getProject()) == ModuleUtil.findModuleForPsiElement((PsiElement)scope);
            }
            if (scope instanceof PsiDirectoryContainer) {
                PsiDirectory[] psiDirectories;
                for (PsiDirectory directory : psiDirectories = ((PsiDirectoryContainer)scope).getDirectories()) {
                    if (!VfsUtil.isAncestor((VirtualFile)directory.getVirtualFile(), (VirtualFile)virtualFile, (boolean)false)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/navigationToolbar/NavBarPresentation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "calcPresentableText";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

