/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.impl.Origin;
import com.intellij.ide.impl.ProjectOriginInfoProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.io.URLUtil;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0007\u001a\u0014\u0010\t\u001a\u0004\u0018\u00010\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0001\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"KNOWN_HOSTINGS", "", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getOriginFromUrl", "Lcom/intellij/ide/impl/Origin;", "url", "getProjectOriginUrl", "projectDir", "Ljava/nio/file/Path;", "intellij.platform.ide.impl"})
public final class TrustedHostsKt {
    private static final List<String> KNOWN_HOSTINGS = CollectionsKt.listOf((Object[])new String[]{"git.jetbrains.space", "github.com", "bitbucket.org", "gitlab.com"});
    private static final Logger LOG;

    @NlsSafe
    @Nullable
    public static final String getProjectOriginUrl(@Nullable Path projectDir) {
        if (projectDir == null) {
            return null;
        }
        ExtensionPointName extensionPointName = ExtensionPointName.create((String)"com.intellij.projectOriginInfoProvider");
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"ExtensionPointName.creat\u2026ojectOriginInfoProvider\")");
        ExtensionPointName epName = extensionPointName;
        for (ProjectOriginInfoProvider extension2 : (ProjectOriginInfoProvider[])epName.getExtensions()) {
            String url = extension2.getOriginUrl(projectDir);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @VisibleForTesting
    @Nullable
    public static final Origin getOriginFromUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            String urlWithScheme = URLUtil.containsScheme((String)url) ? url : "ssh://" + url;
            URI uri = new URI(urlWithScheme);
            String host = uri.getHost();
            if (host == null && Intrinsics.areEqual((Object)uri.getScheme(), (Object)"ssh") && uri.getAuthority() != null) {
                String string = uri.getAuthority();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.authority");
                List at = StringsKt.split$default((CharSequence)string, (String[])new String[]{"@"}, (boolean)false, (int)0, (int)6, null);
                String hostAndOrg = at.size() > 1 ? (String)at.get(1) : (String)at.get(0);
                List comma = StringsKt.split$default((CharSequence)hostAndOrg, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
                host = (String)comma.get(0);
                if (comma.size() > 1) {
                    String org = (String)comma.get(1);
                    return new Origin(uri.getScheme(), host + '/' + org);
                }
            }
            if (host == null) {
                return null;
            }
            if (KNOWN_HOSTINGS.contains(host)) {
                String string;
                String path;
                String string2 = path = uri.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"path");
                int secondSlash = StringsKt.indexOf$default((CharSequence)string2, (String)"/", (int)1, (boolean)false, (int)4, null);
                if (secondSlash >= 0) {
                    String string3 = path;
                    int n = 0;
                    boolean bl = false;
                    String string4 = string3.substring(n, secondSlash);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                } else {
                    string = path;
                }
                String organization = string;
                return new Origin(uri.getScheme(), uri.getHost() + organization);
            }
            String string = uri.getScheme();
            String string5 = uri.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"uri.host");
            return new Origin(string, string5);
        }
        catch (Exception e) {
            LOG.warn("Couldn't parse URL " + url, (Throwable)e);
            return null;
        }
    }

    static {
        Logger logger = Logger.getInstance((String)"com.intellij.ide.impl.TrustedHosts");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"com.\u2026j.ide.impl.TrustedHosts\")");
        LOG = logger;
    }
}

