/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.CompositeSelectInTarget;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.ProjectSubViewSelectInTarget;
import com.intellij.ide.impl.SelectInTargetPsiWrapper;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.SelectableTreeStructureProvider;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ProjectViewPane;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectViewSelectInTarget
extends SelectInTargetPsiWrapper
implements CompositeSelectInTarget {
    private String mySubId;

    protected ProjectViewSelectInTarget(Project project) {
        super(project);
    }

    @Override
    protected final void select(Object selector, VirtualFile virtualFile, boolean requestFocus) {
        ProjectViewSelectInTarget.select(this.myProject, selector, this.getMinorViewId(), this.mySubId, virtualFile, requestFocus);
    }

    @NotNull
    public static ActionCallback select(@NotNull Project project, Object toSelect2, @Nullable String viewId, @Nullable String subviewId, VirtualFile virtualFile, boolean requestFocus) {
        ProjectView projectView;
        if (project == null) {
            ProjectViewSelectInTarget.$$$reportNull$$$0(0);
        }
        if ((projectView = ProjectView.getInstance(project)) == null) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                ProjectViewSelectInTarget.$$$reportNull$$$0(1);
            }
            return actionCallback;
        }
        String id2 = (String)ObjectUtils.chooseNotNull((Object)viewId, (Object)projectView.getDefaultViewId());
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            AbstractProjectViewPane pane2 = projectView.getProjectViewPaneById(id2);
            pane2.select(toSelect2, virtualFile, requestFocus);
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                ProjectViewSelectInTarget.$$$reportNull$$$0(2);
            }
            return actionCallback;
        }
        Supplier<Object> toSelectSupplier = toSelect2 instanceof PsiElement ? () -> ((SmartPsiElementPointer)SmartPointerManager.createPointer((PsiElement)((PsiElement)toSelect2))).getElement() : () -> toSelect2;
        ToolWindow projectViewToolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Project");
        if (projectViewToolWindow == null) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                ProjectViewSelectInTarget.$$$reportNull$$$0(3);
            }
            return actionCallback;
        }
        ActionCallback result2 = new ActionCallback();
        Runnable runnable2 = () -> projectView.changeViewCB(id2, subviewId).doWhenProcessed(() -> ProjectViewSelectInTarget.lambda$select$1((Supplier)toSelectSupplier, requestFocus, projectView, id2, result2, virtualFile));
        if (requestFocus) {
            projectViewToolWindow.activate(runnable2, true);
        } else {
            projectViewToolWindow.show(runnable2);
        }
        ActionCallback actionCallback = result2;
        if (actionCallback == null) {
            ProjectViewSelectInTarget.$$$reportNull$$$0(4);
        }
        return actionCallback;
    }

    @NotNull
    public Collection<SelectInTarget> getSubTargets(@NotNull SelectInContext context) {
        if (context == null) {
            ProjectViewSelectInTarget.$$$reportNull$$$0(5);
        }
        ArrayList<SelectInTarget> result2 = new ArrayList<SelectInTarget>();
        AbstractProjectViewPane pane2 = ProjectView.getInstance(this.myProject).getProjectViewPaneById(this.getMinorViewId());
        int index2 = 0;
        for (String subId : pane2.getSubIds()) {
            result2.add(new ProjectSubViewSelectInTarget(this, subId, index2++));
        }
        ArrayList<SelectInTarget> arrayList = result2;
        if (arrayList == null) {
            ProjectViewSelectInTarget.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    public boolean isSubIdSelectable(String subId, SelectInContext context) {
        return false;
    }

    @Override
    protected boolean canSelect(PsiFileSystemItem file2) {
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)file2);
        VirtualFile virtualFile = vFile = vFile == null ? null : BackedVirtualFile.getOriginFileIfBacked((VirtualFile)vFile);
        if (vFile == null || !vFile.isValid()) {
            return false;
        }
        return ProjectViewPane.canBeSelectedInProjectView(this.myProject, vFile);
    }

    @Nls
    public String getSubIdPresentableName(String subId) {
        AbstractProjectViewPane pane2 = ProjectView.getInstance(this.myProject).getProjectViewPaneById(this.getMinorViewId());
        return pane2.getPresentableSubIdName(subId);
    }

    @Override
    public void select(PsiElement element2, boolean requestFocus) {
        PsiUtilCore.ensureValid((PsiElement)element2);
        PsiElement toSelect2 = null;
        for (TreeStructureProvider provider2 : this.getProvidersDumbAware()) {
            if (provider2 instanceof SelectableTreeStructureProvider) {
                toSelect2 = ((SelectableTreeStructureProvider)provider2).getTopLevelElement(element2);
            }
            if (toSelect2 == null) continue;
            if (toSelect2.isValid()) break;
            throw new PsiInvalidElementAccessException(toSelect2, "Returned by " + provider2);
        }
        if ((toSelect2 = ProjectViewSelectInTarget.findElementToSelect(element2, toSelect2)) != null) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)toSelect2);
            virtualFile = virtualFile == null ? null : BackedVirtualFile.getOriginFileIfBacked((VirtualFile)virtualFile);
            this.select(toSelect2, virtualFile, requestFocus);
        }
    }

    private TreeStructureProvider[] getProvidersDumbAware() {
        List dumbAware = DumbService.getInstance((Project)this.myProject).filterByDumbAwareness((Collection)TreeStructureProvider.EP.getExtensions((AreaInstance)this.myProject));
        return dumbAware.toArray(new TreeStructureProvider[0]);
    }

    public final String getToolWindowId() {
        return "Project";
    }

    public final void setSubId(String subId) {
        this.mySubId = subId;
    }

    public final String getSubId() {
        return this.mySubId;
    }

    private static /* synthetic */ void lambda$select$1(Supplier toSelectSupplier, boolean requestFocus, ProjectView projectView, String id2, ActionCallback result2, VirtualFile virtualFile) {
        AbstractProjectViewPane pane2;
        Object element2 = toSelectSupplier.get();
        AbstractProjectViewPane abstractProjectViewPane = pane2 = requestFocus ? null : projectView.getProjectViewPaneById(id2);
        if (pane2 != null && pane2.isVisibleAndSelected(element2)) {
            result2.setDone();
        } else {
            projectView.selectCB(element2, virtualFile, requestFocus).notify(result2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/impl/ProjectViewSelectInTarget";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/impl/ProjectViewSelectInTarget";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "select";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSubTargets";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

