/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ProhibitAWTEvents;
import com.intellij.ide.impl.DataValidator;
import com.intellij.ide.impl.TypeSafeDataProviderAdapter;
import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.BackgroundableDataProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.reference.SoftReference;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class DataManagerImpl
extends DataManager {
    private static final Logger LOG = Logger.getInstance(DataManagerImpl.class);
    private static final ThreadLocal<AtomicInteger> ourGetDataLevel = ThreadLocal.withInitial(AtomicInteger::new);
    private final KeyedExtensionCollector<GetDataRule, String> myDataRuleCollector = new KeyedExtensionCollector(GetDataRule.EP_NAME);
    private static final Set<String> ourSafeKeys = ContainerUtil.set((Object[])new String[]{CommonDataKeys.PROJECT.getName(), CommonDataKeys.EDITOR.getName(), PlatformDataKeys.IS_MODAL_CONTEXT.getName(), PlatformDataKeys.CONTEXT_COMPONENT.getName(), PlatformDataKeys.MODALITY_STATE.getName()});

    @Nullable
    private Object getData(@NotNull String dataId, Component focusedComponent) {
        if (dataId == null) {
            DataManagerImpl.$$$reportNull$$$0(0);
        }
        GetDataRule rule = this.getDataRule(dataId);
        try (AccessToken ignored = ProhibitAWTEvents.start("getData");){
            for (Component c = focusedComponent; c != null; c = c.getParent()) {
                Object data2;
                DataProvider dataProvider = DataManagerImpl.getDataProviderEx(c);
                if (dataProvider == null || (data2 = this.getDataFromProvider(dataProvider, dataId, null, rule)) == null) continue;
                Object object = data2;
                return object;
            }
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public Object getDataFromProvider(@NotNull DataProvider provider2, @NotNull String dataId, @Nullable Set<String> alreadyComputedIds) {
        if (provider2 == null) {
            DataManagerImpl.$$$reportNull$$$0(1);
        }
        if (dataId == null) {
            DataManagerImpl.$$$reportNull$$$0(2);
        }
        return this.getDataFromProvider(provider2, dataId, alreadyComputedIds, this.getDataRule(dataId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @Nullable
    public Object getDataFromProvider(@NotNull DataProvider provider2, @NotNull String dataId, @Nullable Set<String> alreadyComputedIds, @Nullable GetDataRule dataRule) {
        if (provider2 == null) {
            DataManagerImpl.$$$reportNull$$$0(3);
        }
        if (dataId == null) {
            DataManagerImpl.$$$reportNull$$$0(4);
        }
        ProgressManager.checkCanceled();
        if (alreadyComputedIds != null && alreadyComputedIds.contains(dataId)) {
            return null;
        }
        try {
            ourGetDataLevel.get().incrementAndGet();
            Object data2 = provider2.getData(dataId);
            if (data2 != null) {
                Object object = DataManagerImpl.validated(data2, dataId, provider2);
                return object;
            }
            if (dataRule != null) {
                HashSet<String> ids = alreadyComputedIds == null ? new HashSet<String>() : alreadyComputedIds;
                ids.add(dataId);
                data2 = dataRule.getData(id2 -> this.getDataFromProvider(provider2, id2, ids));
                if (data2 != null) {
                    Object object = DataManagerImpl.validated(data2, dataId, provider2);
                    return object;
                }
            }
            Object var6_7 = null;
            return var6_7;
        }
        finally {
            ourGetDataLevel.get().decrementAndGet();
            if (alreadyComputedIds != null) {
                alreadyComputedIds.remove(dataId);
            }
        }
    }

    @Nullable
    public static DataProvider getDataProviderEx(Object component2) {
        DataProvider dataProvider = null;
        if (component2 instanceof DataProvider) {
            dataProvider = (DataProvider)component2;
        } else if (component2 instanceof TypeSafeDataProvider) {
            dataProvider = new TypeSafeDataProviderAdapter((TypeSafeDataProvider)component2);
        } else if (component2 instanceof JComponent) {
            dataProvider = DataManagerImpl.getDataProvider((JComponent)((JComponent)component2));
        }
        if (dataProvider instanceof BackgroundableDataProvider) {
            dataProvider = ((BackgroundableDataProvider)dataProvider).createBackgroundDataProvider();
        }
        return dataProvider;
    }

    @Nullable
    public GetDataRule getDataRule(@NotNull String dataId) {
        GetDataRule rule;
        if (dataId == null) {
            DataManagerImpl.$$$reportNull$$$0(5);
        }
        if ((rule = this.getRuleFromMap(dataId)) != null) {
            return rule;
        }
        GetDataRule plainRule = this.getRuleFromMap(AnActionEvent.uninjectedId((String)dataId));
        if (plainRule != null) {
            return dataProvider -> plainRule.getData(id2 -> dataProvider.getData(AnActionEvent.injectedId((String)id2)));
        }
        return null;
    }

    @Nullable
    private GetDataRule getRuleFromMap(@NotNull String dataId) {
        List rules;
        if (dataId == null) {
            DataManagerImpl.$$$reportNull$$$0(6);
        }
        return (rules = this.myDataRuleCollector.forKey((Object)dataId)).isEmpty() ? null : (rules.size() == 1 ? (GetDataRule)rules.get(0) : dataProvider -> {
            for (GetDataRule rule : rules) {
                Object data2 = rule.getData(dataProvider);
                if (data2 == null) continue;
                return data2;
            }
            return null;
        });
    }

    @Nullable
    private static Object validated(@NotNull Object data2, @NotNull String dataId, @NotNull Object dataSource) {
        Object invalidData;
        if (data2 == null) {
            DataManagerImpl.$$$reportNull$$$0(7);
        }
        if (dataId == null) {
            DataManagerImpl.$$$reportNull$$$0(8);
        }
        if (dataSource == null) {
            DataManagerImpl.$$$reportNull$$$0(9);
        }
        if ((invalidData = DataValidator.findInvalidData(dataId, data2, dataSource)) != null) {
            return null;
        }
        return data2;
    }

    @NotNull
    public DataContext getDataContext(Component component2) {
        if (Registry.is((String)"actionSystem.dataContextAssertions")) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (ourGetDataLevel.get().get() > 0) {
                LOG.error("DataContext shall not be created and queried inside another getData() call.");
            }
        }
        return new MyDataContext(component2);
    }

    @NotNull
    public DataContext getDataContext(@NotNull Component component2, int x, int y) {
        if (component2 == null) {
            DataManagerImpl.$$$reportNull$$$0(10);
        }
        if (x < 0 || x >= component2.getWidth() || y < 0 || y >= component2.getHeight()) {
            throw new IllegalArgumentException("wrong point: x=" + x + "; y=" + y);
        }
        if (component2 instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)component2;
            int index2 = tabbedPane.getUI().tabForCoordinate(tabbedPane, x, y);
            DataContext dataContext = this.getDataContext(index2 != -1 ? tabbedPane.getComponentAt(index2) : tabbedPane);
            if (dataContext == null) {
                DataManagerImpl.$$$reportNull$$$0(11);
            }
            return dataContext;
        }
        DataContext dataContext = this.getDataContext(component2);
        if (dataContext == null) {
            DataManagerImpl.$$$reportNull$$$0(12);
        }
        return dataContext;
    }

    @NotNull
    public DataContext getDataContext() {
        Component component2 = null;
        if (Registry.is((String)"actionSystem.getContextByRecentMouseEvent")) {
            component2 = SwingHelper.getComponentFromRecentMouseEvent();
        }
        DataContext dataContext = this.getDataContext(component2 != null ? component2 : DataManagerImpl.getFocusedComponent());
        if (dataContext == null) {
            DataManagerImpl.$$$reportNull$$$0(13);
        }
        return dataContext;
    }

    @NotNull
    public Promise<DataContext> getDataContextFromFocusAsync() {
        AsyncPromise result2 = new AsyncPromise();
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> result2.setResult((Object)this.getDataContext()), ModalityState.any());
        AsyncPromise asyncPromise = result2;
        if (asyncPromise == null) {
            DataManagerImpl.$$$reportNull$$$0(14);
        }
        return asyncPromise;
    }

    @Nullable
    private static Component getFocusedComponent() {
        WindowManager windowManager = WindowManager.getInstance();
        if (!(windowManager instanceof WindowManagerEx)) {
            return null;
        }
        WindowManagerEx windowManagerEx = (WindowManagerEx)windowManager;
        Window activeWindow = windowManagerEx.getMostRecentFocusedWindow();
        if (activeWindow == null && (activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) == null && (activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow()) == null) {
            return null;
        }
        if (activeWindow instanceof FloatingDecorator) {
            boolean toolWindowIsNotFocused;
            IdeFocusManager ideFocusManager = IdeFocusManager.findInstanceByComponent((Component)activeWindow);
            IdeFrame lastFocusedFrame = ideFocusManager.getLastFocusedFrame();
            JComponent frameComponent = lastFocusedFrame != null ? lastFocusedFrame.getComponent() : null;
            Window lastFocusedWindow = frameComponent != null ? SwingUtilities.getWindowAncestor(frameComponent) : null;
            boolean bl = toolWindowIsNotFocused = windowManagerEx.getFocusedComponent(activeWindow) == null;
            if (toolWindowIsNotFocused && lastFocusedWindow != null) {
                activeWindow = lastFocusedWindow;
            }
        }
        Component focusedComponent = null;
        for (Window window = activeWindow; window != null && (focusedComponent = windowManagerEx.getFocusedComponent(window)) == null; window = window.getOwner()) {
        }
        if (focusedComponent == null) {
            focusedComponent = activeWindow;
        }
        return focusedComponent;
    }

    public <T> void saveInDataContext(DataContext dataContext, @NotNull Key<T> dataKey, @Nullable T data2) {
        if (dataKey == null) {
            DataManagerImpl.$$$reportNull$$$0(15);
        }
        if (dataContext instanceof UserDataHolder) {
            ((UserDataHolder)dataContext).putUserData(dataKey, data2);
        }
    }

    @Nullable
    public <T> T loadFromDataContext(@NotNull DataContext dataContext, @NotNull Key<T> dataKey) {
        if (dataContext == null) {
            DataManagerImpl.$$$reportNull$$$0(16);
        }
        if (dataKey == null) {
            DataManagerImpl.$$$reportNull$$$0(17);
        }
        return (T)(dataContext instanceof UserDataHolder ? ((UserDataHolder)dataContext).getUserData(dataKey) : null);
    }

    @Nullable
    public static Editor validateEditor(Editor editor, Component contextComponent) {
        JComponent jComponent;
        if (contextComponent instanceof JComponent && (jComponent = (JComponent)contextComponent).getClientProperty("AuxEditorComponent") != null) {
            return null;
        }
        return editor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/impl/DataManagerImpl";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKey";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/impl/DataManagerImpl";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataContext";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataContextFromFocusAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDataFromProvider";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDataRule";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRuleFromMap";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "validated";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDataContext";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "saveInDataContext";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "loadFromDataContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static class MyDataContext
    implements DataContext,
    UserDataHolder {
        private int myEventCount = -1;
        private final Reference<Component> myRef;
        private Map<Key<?>, Object> myUserData;
        private final Map<String, Object> myCachedData = ContainerUtil.createWeakValueMap();

        public MyDataContext(@Nullable Component component2) {
            this.myRef = component2 == null ? null : new WeakReference<Component>(component2);
        }

        public void setEventCount(int eventCount) {
            assert (ReflectionUtil.getCallerClass((int)3) == IdeKeyEventDispatcher.class) : "This method might be accessible from " + IdeKeyEventDispatcher.class.getName() + " only";
            this.myCachedData.clear();
            this.myEventCount = eventCount;
        }

        @Override
        public Object getData(@NotNull String dataId) {
            Object answer;
            boolean cacheable;
            if (dataId == null) {
                MyDataContext.$$$reportNull$$$0(0);
            }
            ProgressManager.checkCanceled();
            boolean bl = cacheable = Registry.is((String)"actionSystem.cache.data") || ourSafeKeys.contains(dataId);
            if (ApplicationManager.getApplication().isDispatchThread()) {
                int currentEventCount = IdeEventQueue.getInstance().getEventCount();
                if (this.myEventCount != -1 && this.myEventCount != currentEventCount) {
                    LOG.error("cannot share data context between Swing events; initial event count = " + this.myEventCount + "; current event count = " + currentEventCount);
                    cacheable = false;
                }
            }
            Object object = answer = cacheable ? this.myCachedData.get(dataId) : null;
            if (answer != null) {
                return answer != NullResult.INSTANCE ? answer : null;
            }
            answer = this.doGetData(dataId);
            if (cacheable && !(answer instanceof Stream)) {
                this.myCachedData.put(dataId, answer == null ? NullResult.INSTANCE : answer);
            }
            return answer;
        }

        @Nullable
        private Object doGetData(@NotNull String dataId) {
            if (dataId == null) {
                MyDataContext.$$$reportNull$$$0(1);
            }
            Component component2 = (Component)SoftReference.dereference(this.myRef);
            if (PlatformDataKeys.IS_MODAL_CONTEXT.is(dataId)) {
                if (component2 == null) {
                    return null;
                }
                return IdeKeyEventDispatcher.isModalContext(component2);
            }
            if (PlatformDataKeys.CONTEXT_COMPONENT.is(dataId)) {
                return component2;
            }
            if (PlatformDataKeys.MODALITY_STATE.is(dataId)) {
                return component2 != null ? ModalityState.stateForComponent((Component)component2) : ModalityState.NON_MODAL;
            }
            Object data2 = this.calcData(dataId, component2);
            if (CommonDataKeys.EDITOR.is(dataId) || CommonDataKeys.HOST_EDITOR.is(dataId)) {
                return DataManagerImpl.validateEditor((Editor)data2, component2);
            }
            return data2;
        }

        protected Object calcData(@NotNull String dataId, Component component2) {
            if (dataId == null) {
                MyDataContext.$$$reportNull$$$0(2);
            }
            return ((DataManagerImpl)DataManager.getInstance()).getData(dataId, component2);
        }

        @NonNls
        public String toString() {
            return "component=" + SoftReference.dereference(this.myRef);
        }

        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                MyDataContext.$$$reportNull$$$0(3);
            }
            return (T)this.getOrCreateMap().get(key);
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
            if (key == null) {
                MyDataContext.$$$reportNull$$$0(4);
            }
            this.getOrCreateMap().put(key, value2);
        }

        @NotNull
        private Map<Key<?>, Object> getOrCreateMap() {
            Map userData = this.myUserData;
            if (userData == null) {
                this.myUserData = userData = ContainerUtil.createWeakValueMap();
            }
            Map map2 = userData;
            if (map2 == null) {
                MyDataContext.$$$reportNull$$$0(5);
            }
            return map2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/impl/DataManagerImpl$MyDataContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/impl/DataManagerImpl$MyDataContext";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreateMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "doGetData";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "calcData";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getUserData";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "putUserData";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class NullResult {
        public static final NullResult INSTANCE = new NullResult();

        private NullResult() {
        }
    }
}

