/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.SmartElementDescriptor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.usageView.UsageTreeColors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HierarchyNodeDescriptor
extends SmartElementDescriptor {
    @NotNull
    protected CompositeAppearance myHighlightedText;
    private Object[] myCachedChildren;
    protected final boolean myIsBase;

    protected HierarchyNodeDescriptor(@NotNull Project project, @Nullable NodeDescriptor parentDescriptor, @NotNull PsiElement element2, boolean isBase) {
        if (project == null) {
            HierarchyNodeDescriptor.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            HierarchyNodeDescriptor.$$$reportNull$$$0(1);
        }
        super(project, parentDescriptor, element2);
        this.myHighlightedText = new CompositeAppearance();
        this.myName = "";
        this.myIsBase = isBase;
    }

    @Override
    public final Object getElement() {
        return this;
    }

    @Nullable
    public PsiFile getContainingFile() {
        PsiElement element2 = this.getPsiElement();
        return element2 != null ? element2.getContainingFile() : null;
    }

    public boolean isValid() {
        return this.getPsiElement() != null;
    }

    public final Object[] getCachedChildren() {
        return this.myCachedChildren;
    }

    public final void setCachedChildren(Object[] cachedChildren) {
        this.myCachedChildren = cachedChildren;
    }

    @Override
    protected final boolean isMarkReadOnly() {
        return true;
    }

    @Override
    protected final boolean isMarkModified() {
        return true;
    }

    @NotNull
    public final CompositeAppearance getHighlightedText() {
        CompositeAppearance compositeAppearance = this.myHighlightedText;
        if (compositeAppearance == null) {
            HierarchyNodeDescriptor.$$$reportNull$$$0(2);
        }
        return compositeAppearance;
    }

    protected static TextAttributes getInvalidPrefixAttributes() {
        return UsageTreeColors.INVALID_ATTRIBUTES.toTextAttributes();
    }

    protected static TextAttributes getUsageCountPrefixAttributes() {
        return UsageTreeColors.NUMBER_OF_USAGES_ATTRIBUTES.toTextAttributes();
    }

    protected static TextAttributes getPackageNameAttributes() {
        return HierarchyNodeDescriptor.getUsageCountPrefixAttributes();
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    protected final boolean invalidElement() {
        String invalidPrefix = IdeBundle.message((String)"node.hierarchy.invalid", (Object[])new Object[0]);
        if (!this.myHighlightedText.getText().startsWith(invalidPrefix)) {
            this.myHighlightedText.getBeginning().addText(invalidPrefix, HierarchyNodeDescriptor.getInvalidPrefixAttributes());
        }
        return true;
    }

    protected final void installIcon(@Nullable Icon elementIcon, boolean changes) {
        if (changes && this.myIsBase) {
            this.setIcon(this.getBaseMarkerIcon(elementIcon));
        } else {
            this.setIcon(elementIcon);
        }
    }

    @NotNull
    protected Icon getBaseMarkerIcon(@Nullable Icon sourceIcon) {
        LayeredIcon icon2 = new LayeredIcon(2);
        icon2.setIcon(sourceIcon, 0);
        icon2.setIcon(AllIcons.General.Modified, 1, -AllIcons.General.Modified.getIconWidth(), 0);
        LayeredIcon layeredIcon = icon2;
        if (layeredIcon == null) {
            HierarchyNodeDescriptor.$$$reportNull$$$0(3);
        }
        return layeredIcon;
    }

    protected final void installIcon(@NotNull PsiElement element2, boolean changes) {
        if (element2 == null) {
            HierarchyNodeDescriptor.$$$reportNull$$$0(4);
        }
        Icon icon2 = this.getIcon(element2);
        this.installIcon(icon2, changes);
    }

    protected final void installIcon(boolean changes) {
        this.installIcon(this.getIcon(), changes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/hierarchy/HierarchyNodeDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/hierarchy/HierarchyNodeDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightedText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseMarkerIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "installIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

