/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.ide.gdpr.ConfirmedConsent;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentAttributes;
import com.intellij.ide.gdpr.ConsentBase;
import com.intellij.ide.gdpr.Version;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConsentOptions {
    private static final Logger LOG = Logger.getInstance(ConsentOptions.class);
    private static final String CONSENTS_CONFIRMATION_PROPERTY = "jb.consents.confirmation.enabled";
    private static final String STATISTICS_OPTION_ID = "rsch.send.usage.stat";
    private final boolean myIsEAP;
    private final IOBackend myBackend;

    ConsentOptions(IOBackend backend, boolean isEap) {
        this.myBackend = backend;
        this.myIsEAP = isEap;
    }

    public static ConsentOptions getInstance() {
        return InstanceHolder.ourInstance;
    }

    public boolean isEAP() {
        return this.myIsEAP;
    }

    @Nullable
    public Consent getUsageStatsConsent() {
        return this.loadDefaultConsents().get(STATISTICS_OPTION_ID);
    }

    public Permission isSendingUsageStatsAllowed() {
        ConfirmedConsent confirmedConsent = this.getConfirmedConsent(STATISTICS_OPTION_ID);
        return confirmedConsent == null ? Permission.UNDEFINED : (confirmedConsent.isAccepted() ? Permission.YES : Permission.NO);
    }

    public boolean setSendingUsageStatsAllowed(boolean allowed) {
        Consent defConsent = this.loadDefaultConsents().get(STATISTICS_OPTION_ID);
        if (defConsent != null && !defConsent.isDeleted()) {
            this.saveConfirmedConsents(Collections.singleton(new ConfirmedConsent(defConsent.getId(), defConsent.getVersion(), allowed, 0L)));
            return true;
        }
        return false;
    }

    @Nullable
    public String getConfirmedConsentsString() {
        Map<String, Consent> defaults = this.loadDefaultConsents();
        if (!defaults.isEmpty()) {
            String str = ConsentOptions.confirmedConsentToExternalString(this.loadConfirmedConsents().values().stream().filter(c -> {
                Consent def = (Consent)defaults.get(c.getId());
                return def != null && !def.isDeleted();
            }));
            return StringUtilRt.isEmptyOrSpaces((CharSequence)str) ? null : str;
        }
        return null;
    }

    public void applyServerUpdates(@Nullable String json) {
        if (StringUtilRt.isEmptyOrSpaces((CharSequence)json)) {
            return;
        }
        try {
            Map<String, ConfirmedConsent> confirmed;
            Collection<ConsentAttributes> fromServer = ConsentOptions.fromJson(json);
            Map<String, Consent> defaults = this.loadDefaultConsents();
            if (ConsentOptions.applyServerChangesToDefaults(defaults, fromServer)) {
                this.myBackend.writeDefaultConsents(ConsentOptions.consentsToJson(defaults.values().stream()));
            }
            if (ConsentOptions.applyServerChangesToConfirmedConsents(confirmed = this.loadConfirmedConsents(), fromServer)) {
                this.myBackend.writeConfirmedConsents(ConsentOptions.confirmedConsentToExternalString(confirmed.values().stream()));
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
    }

    @NotNull
    public Pair<List<Consent>, Boolean> getConsents() {
        Map<String, Consent> allDefaults = this.loadDefaultConsents();
        if (this.myIsEAP) {
            allDefaults.remove(STATISTICS_OPTION_ID);
        }
        if (allDefaults.isEmpty()) {
            return new Pair(Collections.emptyList(), (Object)Boolean.FALSE);
        }
        Map<String, ConfirmedConsent> allConfirmed = this.loadConfirmedConsents();
        ArrayList<Consent> result2 = new ArrayList<Consent>();
        for (Map.Entry<String, Consent> entry : allDefaults.entrySet()) {
            Consent base = entry.getValue();
            if (base.isDeleted()) continue;
            ConfirmedConsent confirmed = allConfirmed.get(base.getId());
            result2.add(confirmed == null ? base : base.derive(confirmed.isAccepted()));
        }
        result2.sort(Comparator.comparing(ConsentBase::getId));
        boolean confirmationEnabled = Boolean.parseBoolean(System.getProperty(CONSENTS_CONFIRMATION_PROPERTY, "true"));
        return new Pair(result2, (Object)(confirmationEnabled && ConsentOptions.needReconfirm(allDefaults, allConfirmed) ? 1 : 0));
    }

    public void setConsents(@NotNull Collection<Consent> confirmedByUser) {
        List<ConfirmedConsent> result2;
        if (confirmedByUser == null) {
            ConsentOptions.$$$reportNull$$$0(0);
        }
        if (confirmedByUser.isEmpty()) {
            result2 = Collections.emptyList();
        } else {
            ArrayList<ConfirmedConsent> list2 = new ArrayList<ConfirmedConsent>(confirmedByUser.size());
            for (Consent t : confirmedByUser) {
                list2.add(new ConfirmedConsent(t.getId(), t.getVersion(), t.isAccepted(), 0L));
            }
            result2 = list2;
        }
        this.saveConfirmedConsents(result2);
    }

    @Nullable
    private ConfirmedConsent getConfirmedConsent(String consentId) {
        Consent defConsent = this.loadDefaultConsents().get(consentId);
        if (defConsent != null && defConsent.isDeleted()) {
            return null;
        }
        return this.loadConfirmedConsents().get(consentId);
    }

    private void saveConfirmedConsents(@NotNull Collection<ConfirmedConsent> updates2) {
        if (updates2 == null) {
            ConsentOptions.$$$reportNull$$$0(1);
        }
        if (!updates2.isEmpty()) {
            try {
                Map<String, ConfirmedConsent> allConfirmed = this.loadConfirmedConsents();
                long stamp = System.currentTimeMillis();
                for (ConfirmedConsent consent : updates2) {
                    consent.setAcceptanceTime(stamp);
                    allConfirmed.put(consent.getId(), consent);
                }
                this.myBackend.writeConfirmedConsents(ConsentOptions.confirmedConsentToExternalString(allConfirmed.values().stream()));
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    private static boolean needReconfirm(Map<String, Consent> defaults, Map<String, ConfirmedConsent> confirmed) {
        for (Consent defConsent : defaults.values()) {
            Version defaultVersion;
            if (defConsent.isDeleted()) continue;
            ConfirmedConsent confirmedConsent = confirmed.get(defConsent.getId());
            if (confirmedConsent == null) {
                return true;
            }
            Version confirmedVersion = confirmedConsent.getVersion();
            if (!confirmedVersion.isOlder(defaultVersion = defConsent.getVersion()) || confirmedVersion.getMajor() == defaultVersion.getMajor()) continue;
            return true;
        }
        return false;
    }

    private static boolean applyServerChangesToConfirmedConsents(Map<String, ConfirmedConsent> base, Collection<ConsentAttributes> fromServer) {
        boolean changes = false;
        for (ConsentAttributes update2 : fromServer) {
            ConfirmedConsent change;
            ConfirmedConsent current2 = base.get(update2.consentId);
            if (current2 == null || (change = new ConfirmedConsent(update2)).getVersion().isOlder(current2.getVersion()) || current2.getAcceptanceTime() >= update2.acceptanceTime) continue;
            base.put(change.getId(), change);
            changes = true;
        }
        return changes;
    }

    private static boolean applyServerChangesToDefaults(@NotNull Map<String, Consent> base, @NotNull Collection<ConsentAttributes> fromServer) {
        if (base == null) {
            ConsentOptions.$$$reportNull$$$0(2);
        }
        if (fromServer == null) {
            ConsentOptions.$$$reportNull$$$0(3);
        }
        boolean changes = false;
        for (ConsentAttributes update2 : fromServer) {
            Consent newConsent = new Consent(update2);
            Consent current2 = base.get(newConsent.getId());
            if (current2 != null && !newConsent.getVersion().isNewer(current2.getVersion()) && newConsent.isDeleted() == current2.isDeleted()) continue;
            base.put(newConsent.getId(), newConsent);
            changes = true;
        }
        return changes;
    }

    @NotNull
    private static Collection<ConsentAttributes> fromJson(@Nullable String json) {
        if (StringUtilRt.isEmptyOrSpaces((CharSequence)json)) {
            List<ConsentAttributes> list2 = Collections.emptyList();
            if (list2 == null) {
                ConsentOptions.$$$reportNull$$$0(4);
            }
            return list2;
        }
        ArrayList<ConsentAttributes> result2 = new ArrayList<ConsentAttributes>();
        try (JsonReader reader = new JsonReader((Reader)new StringReader(json));){
            reader.beginArray();
            while (reader.hasNext()) {
                result2.add(ConsentOptions.readConsentAttributes(reader));
            }
            reader.endArray();
        }
        catch (Throwable e) {
            LOG.info(e);
        }
        ArrayList<ConsentAttributes> arrayList = result2;
        if (arrayList == null) {
            ConsentOptions.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private static ConsentAttributes readConsentAttributes(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            ConsentOptions.$$$reportNull$$$0(6);
        }
        ConsentAttributes attributes = new ConsentAttributes();
        reader.beginObject();
        block18: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "consentId": {
                    attributes.consentId = reader.nextString();
                    continue block18;
                }
                case "version": {
                    attributes.version = reader.nextString();
                    continue block18;
                }
                case "text": {
                    attributes.text = reader.nextString();
                    continue block18;
                }
                case "printableName": {
                    attributes.printableName = reader.nextString();
                    continue block18;
                }
                case "accepted": {
                    attributes.accepted = reader.peek() == JsonToken.STRING ? Boolean.parseBoolean(reader.nextString()) : reader.nextBoolean();
                    continue block18;
                }
                case "deleted": {
                    attributes.deleted = reader.peek() == JsonToken.STRING ? Boolean.parseBoolean(reader.nextString()) : reader.nextBoolean();
                    continue block18;
                }
                case "acceptanceTime": {
                    attributes.acceptanceTime = reader.nextLong();
                    continue block18;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        ConsentAttributes consentAttributes = attributes;
        if (consentAttributes == null) {
            ConsentOptions.$$$reportNull$$$0(7);
        }
        return consentAttributes;
    }

    @NotNull
    private static String consentsToJson(@NotNull Stream<Consent> consents) {
        if (consents == null) {
            ConsentOptions.$$$reportNull$$$0(8);
        }
        Gson gson2 = new GsonBuilder().disableHtmlEscaping().create();
        String string = gson2.toJson((Object)consents.map(Consent::toConsentAttributes).toArray());
        if (string == null) {
            ConsentOptions.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static String confirmedConsentToExternalString(@NotNull Stream<ConfirmedConsent> consents) {
        if (consents == null) {
            ConsentOptions.$$$reportNull$$$0(10);
        }
        String string = consents.map(ConfirmedConsent::toExternalString).collect(Collectors.joining(";"));
        if (string == null) {
            ConsentOptions.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private Map<String, Consent> loadDefaultConsents() {
        HashMap<String, Consent> result2 = new HashMap<String, Consent>();
        for (ConsentAttributes attributes : ConsentOptions.fromJson(this.myBackend.readBundledConsents())) {
            result2.put(attributes.consentId, new Consent(attributes));
        }
        try {
            ConsentOptions.applyServerChangesToDefaults(result2, ConsentOptions.fromJson(this.myBackend.readDefaultConsents()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        HashMap<String, Consent> hashMap = result2;
        if (hashMap == null) {
            ConsentOptions.$$$reportNull$$$0(12);
        }
        return hashMap;
    }

    @NotNull
    private Map<String, ConfirmedConsent> loadConfirmedConsents() {
        HashMap<String, ConfirmedConsent> result2 = new HashMap<String, ConfirmedConsent>();
        try {
            StringTokenizer tokenizer = new StringTokenizer(this.myBackend.readConfirmedConsents(), ";", false);
            while (tokenizer.hasMoreTokens()) {
                ConfirmedConsent consent = ConfirmedConsent.fromString(tokenizer.nextToken());
                if (consent == null) continue;
                result2.put(consent.getId(), consent);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        HashMap<String, ConfirmedConsent> hashMap = result2;
        if (hashMap == null) {
            ConsentOptions.$$$reportNull$$$0(13);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "confirmedByUser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updates";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromServer";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/gdpr/ConsentOptions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/gdpr/ConsentOptions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "fromJson";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "readConsentAttributes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "consentsToJson";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "confirmedConsentToExternalString";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDefaultConsents";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "loadConfirmedConsents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setConsents";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "saveConfirmedConsents";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyServerChangesToDefaults";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readConsentAttributes";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "consentsToJson";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "confirmedConsentToExternalString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static interface IOBackend {
        public void writeDefaultConsents(@NotNull String var1) throws IOException;

        @NotNull
        public String readDefaultConsents() throws IOException;

        @NotNull
        public String readBundledConsents();

        public void writeConfirmedConsents(@NotNull String var1) throws IOException;

        @NotNull
        public String readConfirmedConsents() throws IOException;
    }

    public static enum Permission {
        YES,
        NO,
        UNDEFINED;

    }

    private static final class InstanceHolder {
        static final ConsentOptions ourInstance;

        private InstanceHolder() {
        }

        @NotNull
        @NonNls
        private static String getBundledResourcePath() {
            ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
            Object object = appInfo.isVendorJetBrains() ? "consents.json" : "consents-" + appInfo.getShortCompanyName() + ".json";
            if (object == null) {
                InstanceHolder.$$$reportNull$$$0(0);
            }
            return object;
        }

        static {
            ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
            ourInstance = new ConsentOptions(new IOBackend(){
                private final Path DEFAULT_CONSENTS_FILE = PathManager.getCommonDataPath().resolve(ApplicationNamesInfo.getInstance().getLowercaseProductName()).resolve("consentOptions/cached");
                private final Path CONFIRMED_CONSENTS_FILE = PathManager.getCommonDataPath().resolve("consentOptions").resolve("accepted");
                private final String BUNDLED_CONSENTS_PATH = InstanceHolder.getBundledResourcePath();

                @Override
                public void writeDefaultConsents(@NotNull String data2) throws IOException {
                    if (data2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Files.createDirectories(this.DEFAULT_CONSENTS_FILE.getParent(), new FileAttribute[0]);
                    Files.writeString(this.DEFAULT_CONSENTS_FILE, (CharSequence)data2, new OpenOption[0]);
                }

                @Override
                @NotNull
                public String readDefaultConsents() throws IOException {
                    String string = Files.readString(this.DEFAULT_CONSENTS_FILE);
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                @Override
                @NotNull
                public String readBundledConsents() {
                    return this.loadText(ConsentOptions.class.getClassLoader().getResourceAsStream(this.BUNDLED_CONSENTS_PATH));
                }

                @Override
                public void writeConfirmedConsents(@NotNull String data2) throws IOException {
                    if (data2 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    Files.createDirectories(this.CONFIRMED_CONSENTS_FILE.getParent(), new FileAttribute[0]);
                    Files.writeString(this.CONFIRMED_CONSENTS_FILE, (CharSequence)data2, new OpenOption[0]);
                }

                @Override
                @NotNull
                public String readConfirmedConsents() throws IOException {
                    String string = Files.readString(this.CONFIRMED_CONSENTS_FILE);
                    if (string == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return string;
                }

                /*
                 * Loose catch block
                 */
                @NotNull
                private String loadText(InputStream stream) {
                    if (stream != null) {
                        String string;
                        InputStream inputStream2;
                        block10: {
                            inputStream2 = CharsetToolkit.inputStreamSkippingBOM((InputStream)stream);
                            string = new String(inputStream2.readAllBytes(), StandardCharsets.UTF_8);
                            if (inputStream2 == null) break block10;
                            inputStream2.close();
                        }
                        String string2 = string;
                        if (string2 == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        return string2;
                        {
                            catch (Throwable throwable) {
                                try {
                                    if (inputStream2 != null) {
                                        try {
                                            inputStream2.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (IOException e) {
                                    LOG.info((Throwable)e);
                                }
                            }
                        }
                    }
                    return "";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 4: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 4: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "data";
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ide/gdpr/ConsentOptions$InstanceHolder$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ide/gdpr/ConsentOptions$InstanceHolder$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "readDefaultConsents";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "readConfirmedConsents";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[1] = "loadText";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "writeDefaultConsents";
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 4: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "writeConfirmedConsents";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 4: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }, appInfo.isEAP() && appInfo.isVendorJetBrains());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/gdpr/ConsentOptions$InstanceHolder", "getBundledResourcePath"));
        }
    }
}

