/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.impl.BundledFileTemplate;
import com.intellij.ide.fileTemplates.impl.CustomFileTemplate;
import com.intellij.ide.fileTemplates.impl.DefaultTemplate;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FTManager {
    private static final Logger LOG = Logger.getInstance(FTManager.class);
    private static final String DEFAULT_TEMPLATE_EXTENSION = "ft";
    static final String TEMPLATE_EXTENSION_SUFFIX = ".ft";
    private static final String ENCODED_NAME_EXT_DELIMITER = "\u0f0fext\u0f0f.";
    private final String myName;
    private final boolean myInternal;
    private final Path myTemplatesDir;
    @Nullable
    private final FTManager myOriginal;
    private final Map<String, FileTemplateBase> myTemplates;
    private volatile List<FileTemplateBase> mySortedTemplates;
    private final List<DefaultTemplate> myDefaultTemplates;

    FTManager(@NotNull @NonNls String name, @NotNull Path defaultTemplatesDirName) {
        if (name == null) {
            FTManager.$$$reportNull$$$0(0);
        }
        if (defaultTemplatesDirName == null) {
            FTManager.$$$reportNull$$$0(1);
        }
        this(name, defaultTemplatesDirName, false);
    }

    FTManager(@NotNull @NonNls String name, @NotNull Path defaultTemplatesDirName, boolean internal) {
        if (name == null) {
            FTManager.$$$reportNull$$$0(2);
        }
        if (defaultTemplatesDirName == null) {
            FTManager.$$$reportNull$$$0(3);
        }
        this.myTemplates = new HashMap<String, FileTemplateBase>();
        this.myDefaultTemplates = new ArrayList<DefaultTemplate>();
        this.myName = name;
        this.myInternal = internal;
        this.myTemplatesDir = defaultTemplatesDirName;
        this.myOriginal = null;
    }

    FTManager(@NotNull FTManager original) {
        if (original == null) {
            FTManager.$$$reportNull$$$0(4);
        }
        this.myTemplates = new HashMap<String, FileTemplateBase>();
        this.myDefaultTemplates = new ArrayList<DefaultTemplate>();
        this.myOriginal = original;
        this.myName = original.getName();
        this.myTemplatesDir = original.myTemplatesDir;
        this.myInternal = original.myInternal;
        this.myTemplates.putAll(original.myTemplates);
        this.myDefaultTemplates.addAll(original.myDefaultTemplates);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            FTManager.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    Collection<FileTemplateBase> getAllTemplates(boolean includeDisabled) {
        List<FileTemplateBase> sorted = this.mySortedTemplates;
        if (sorted == null) {
            sorted = new ArrayList<FileTemplateBase>(this.getTemplates().values());
            sorted.sort((t1, t2) -> t1.getName().compareToIgnoreCase(t2.getName()));
            this.mySortedTemplates = sorted;
        }
        if (includeDisabled) {
            Collection<FileTemplateBase> collection = Collections.unmodifiableCollection(sorted);
            if (collection == null) {
                FTManager.$$$reportNull$$$0(6);
            }
            return collection;
        }
        ArrayList<FileTemplateBase> list2 = new ArrayList<FileTemplateBase>(sorted.size());
        for (FileTemplateBase template : sorted) {
            if (template instanceof BundledFileTemplate && !((BundledFileTemplate)template).isEnabled()) continue;
            list2.add(template);
        }
        ArrayList<FileTemplateBase> arrayList = list2;
        if (arrayList == null) {
            FTManager.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    FileTemplateBase getTemplate(@NotNull String templateQname) {
        if (templateQname == null) {
            FTManager.$$$reportNull$$$0(8);
        }
        return this.getTemplates().get(templateQname);
    }

    @Nullable
    public FileTemplateBase findTemplateByName(@NotNull String templateName) {
        FileTemplateBase template;
        if (templateName == null) {
            FTManager.$$$reportNull$$$0(9);
        }
        if ((template = this.getTemplates().get(templateName)) != null) {
            boolean isEnabled;
            boolean bl = isEnabled = !(template instanceof BundledFileTemplate) || ((BundledFileTemplate)template).isEnabled();
            if (isEnabled) {
                return template;
            }
        }
        for (FileTemplateBase t : this.getAllTemplates(false)) {
            String remainder;
            String qName = t.getQualifiedName();
            if (!qName.startsWith(templateName) || qName.length() <= templateName.length() || !(remainder = qName.substring(templateName.length())).startsWith(ENCODED_NAME_EXT_DELIMITER) && remainder.charAt(0) != '.') continue;
            return t;
        }
        return null;
    }

    @NotNull
    public FileTemplateBase addTemplate(@NotNull String name, @NotNull String extension2) {
        String qName;
        FileTemplateBase template;
        if (name == null) {
            FTManager.$$$reportNull$$$0(10);
        }
        if (extension2 == null) {
            FTManager.$$$reportNull$$$0(11);
        }
        if ((template = this.getTemplate(qName = FileTemplateBase.getQualifiedName(name, extension2))) == null) {
            template = new CustomFileTemplate(name, extension2);
            this.getTemplates().put(qName, template);
            this.mySortedTemplates = null;
        } else if (template instanceof BundledFileTemplate && !((BundledFileTemplate)template).isEnabled()) {
            ((BundledFileTemplate)template).setEnabled(true);
        }
        FileTemplateBase fileTemplateBase = template;
        if (fileTemplateBase == null) {
            FTManager.$$$reportNull$$$0(12);
        }
        return fileTemplateBase;
    }

    public void removeTemplate(@NotNull String qName) {
        FileTemplateBase template;
        if (qName == null) {
            FTManager.$$$reportNull$$$0(13);
        }
        if ((template = this.getTemplates().get(qName)) instanceof CustomFileTemplate) {
            this.getTemplates().remove(qName);
            this.mySortedTemplates = null;
        } else if (template instanceof BundledFileTemplate) {
            ((BundledFileTemplate)template).setEnabled(false);
        }
    }

    void updateTemplates(@NotNull Collection<? extends FileTemplate> newTemplates) {
        if (newTemplates == null) {
            FTManager.$$$reportNull$$$0(14);
        }
        HashSet<String> toDisable = new HashSet<String>();
        for (DefaultTemplate defaultTemplate : this.myDefaultTemplates) {
            toDisable.add(defaultTemplate.getQualifiedName());
        }
        for (FileTemplate fileTemplate : newTemplates) {
            toDisable.remove(((FileTemplateBase)fileTemplate).getQualifiedName());
        }
        this.restoreDefaults(toDisable);
        MultiMap children2 = new MultiMap();
        for (FileTemplate fileTemplate : newTemplates) {
            FileTemplateBase _template = this.addTemplate(fileTemplate.getName(), fileTemplate.getExtension());
            _template.setText(fileTemplate.getText());
            _template.setFileName(fileTemplate.getFileName());
            _template.setReformatCode(fileTemplate.isReformatCode());
            _template.setLiveTemplateEnabled(fileTemplate.isLiveTemplateEnabled());
            if (!FileTemplateBase.isChild(_template)) continue;
            children2.putValue((Object)FTManager.getParentName(_template), (Object)_template);
        }
        for (String string : children2.keySet()) {
            FileTemplateBase template = this.getTemplate(string);
            if (template == null) continue;
            template.setChildren(children2.get((Object)string).toArray(FileTemplate.EMPTY_ARRAY));
        }
        this.saveTemplates(true);
    }

    private void restoreDefaults(@NotNull Set<String> toDisable) {
        if (toDisable == null) {
            FTManager.$$$reportNull$$$0(15);
        }
        this.getTemplates().clear();
        this.mySortedTemplates = null;
        for (DefaultTemplate template : this.myDefaultTemplates) {
            BundledFileTemplate bundled = this.createAndStoreBundledTemplate(template);
            if (!toDisable.contains(bundled.getQualifiedName())) continue;
            bundled.setEnabled(false);
        }
    }

    void setDefaultTemplates(@NotNull Collection<? extends DefaultTemplate> templates) {
        if (templates == null) {
            FTManager.$$$reportNull$$$0(16);
        }
        this.myDefaultTemplates.clear();
        this.myDefaultTemplates.addAll(templates);
        for (DefaultTemplate defaultTemplate : templates) {
            this.createAndStoreBundledTemplate(defaultTemplate);
        }
    }

    @NotNull
    private BundledFileTemplate createAndStoreBundledTemplate(@NotNull DefaultTemplate template) {
        if (template == null) {
            FTManager.$$$reportNull$$$0(17);
        }
        BundledFileTemplate bundled = new BundledFileTemplate(template, this.myInternal);
        String qName = bundled.getQualifiedName();
        FileTemplateBase previous = this.getTemplates().put(qName, bundled);
        this.mySortedTemplates = null;
        LOG.assertTrue(previous == null, (Object)("Duplicate bundled template " + qName + " [" + template.getTemplateURL() + ", " + previous + "]"));
        BundledFileTemplate bundledFileTemplate = bundled;
        if (bundledFileTemplate == null) {
            FTManager.$$$reportNull$$$0(18);
        }
        return bundledFileTemplate;
    }

    void loadCustomizedContent() {
        ArrayList<Path> templateWithDefaultExtension = new ArrayList<Path>();
        HashSet<String> processedNames = new HashSet<String>();
        ArrayList<FileTemplateBase> children2 = new ArrayList<FileTemplateBase>();
        try (DirectoryStream<Path> stream2 = Files.newDirectoryStream(this.getConfigRoot(), file2 -> !Files.isDirectory(file2, new LinkOption[0]) && !Files.isHidden(file2));){
            for (Path file3 : stream2) {
                String fileName = file3.getFileName().toString();
                if (FileTypeManager.getInstance().isFileIgnored(fileName)) continue;
                if (fileName.endsWith(TEMPLATE_EXTENSION_SUFFIX)) {
                    templateWithDefaultExtension.add(file3);
                    continue;
                }
                processedNames.add(fileName);
                FileTemplateBase template = this.addTemplateFromFile(fileName, file3);
                if (!fileName.contains(".child.")) continue;
                children2.add(template);
            }
        }
        catch (NoSuchFileException stream2) {
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return;
        }
        for (FileTemplateBase child2 : children2) {
            String qname = FTManager.getParentName(child2);
            FileTemplateBase parent = this.getTemplate(qname);
            if (parent == null) continue;
            parent.addChild(child2);
        }
        for (Path file4 : templateWithDefaultExtension) {
            String name = file4.getFileName().toString();
            if (!processedNames.contains(name = name.substring(0, name.length() - TEMPLATE_EXTENSION_SUFFIX.length()))) {
                this.addTemplateFromFile(name, file4);
            }
            try {
                Files.delete(file4);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @NotNull
    private static String getParentName(FileTemplateBase child2) {
        String name = child2.getQualifiedName();
        String string = name.substring(0, name.indexOf(".child."));
        if (string == null) {
            FTManager.$$$reportNull$$$0(19);
        }
        return string;
    }

    private FileTemplateBase addTemplateFromFile(@NotNull String fileName, @NotNull Path file2) {
        if (fileName == null) {
            FTManager.$$$reportNull$$$0(20);
        }
        if (file2 == null) {
            FTManager.$$$reportNull$$$0(21);
        }
        Pair<String, String> nameExt = FTManager.decodeFileName(fileName);
        String extension2 = (String)nameExt.second;
        String templateQName = (String)nameExt.first;
        if (templateQName.isEmpty()) {
            return null;
        }
        try {
            FileTemplateBase template = this.addTemplate(templateQName, extension2);
            template.setText(PathKt.readText((Path)file2));
            return template;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public void saveTemplates() {
        this.saveTemplates(false);
    }

    private void saveTemplates(boolean removeDeleted) {
        HashSet<String> allNames = new HashSet<String>();
        Path configRoot = this.getConfigRoot();
        HashMap<String, Path> templatesOnDisk = new HashMap<String, Path>();
        try (DirectoryStream<Path> stream22 = Files.newDirectoryStream(this.getConfigRoot(), file2 -> !Files.isDirectory(file2, new LinkOption[0]) && !Files.isHidden(file2));){
            for (Path file3 : stream22) {
                String string = file3.getFileName().toString();
                templatesOnDisk.put(string, file3);
                allNames.add(string);
            }
        }
        catch (NoSuchFileException stream22) {
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        HashMap<String, FileTemplateBase> templatesToSave = new HashMap<String, FileTemplateBase>();
        for (FileTemplateBase template : this.getAllTemplates(true)) {
            FTManager.processTemplate(allNames, templatesToSave, template);
            for (FileTemplate child2 : template.getChildren()) {
                FTManager.processTemplate(allNames, templatesToSave, (FileTemplateBase)child2);
            }
        }
        if (allNames.isEmpty()) {
            return;
        }
        try {
            Files.createDirectories(this.myTemplatesDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOG.info("Cannot create directory: " + this.myTemplatesDir);
        }
        String lineSeparator = CodeStyle.getDefaultSettings().getLineSeparator();
        for (String string : allNames) {
            Path customizedTemplateFile = (Path)templatesOnDisk.get(string);
            FileTemplateBase templateToSave = (FileTemplateBase)templatesToSave.get(string);
            if (customizedTemplateFile == null) {
                try {
                    FTManager.saveTemplate(configRoot, templateToSave, lineSeparator);
                }
                catch (IOException e) {
                    LOG.error("Unable to save template " + string, (Throwable)e);
                }
                continue;
            }
            if (templateToSave == null) {
                if (!removeDeleted) continue;
                try {
                    Files.delete(customizedTemplateFile);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
                continue;
            }
            try {
                String templateText;
                String diskText = StringUtilRt.convertLineSeparators((String)PathKt.readText((Path)customizedTemplateFile));
                if (diskText.equals(templateText = templateToSave.getText())) continue;
                FTManager.saveTemplate(configRoot, templateToSave, lineSeparator);
            }
            catch (IOException e) {
                LOG.error("Unable to save template " + string, (Throwable)e);
            }
        }
    }

    private static void processTemplate(Set<? super String> allNames, Map<String, FileTemplateBase> templatesToSave, FileTemplateBase template) {
        if (template instanceof BundledFileTemplate && !((BundledFileTemplate)template).isTextModified()) {
            return;
        }
        String name = template.getQualifiedName();
        templatesToSave.put(name, template);
        allNames.add(name);
    }

    private static void saveTemplate(@NotNull Path parentDir, @NotNull FileTemplate template, @NotNull String lineSeparator) throws IOException {
        if (parentDir == null) {
            FTManager.$$$reportNull$$$0(22);
        }
        if (template == null) {
            FTManager.$$$reportNull$$$0(23);
        }
        if (lineSeparator == null) {
            FTManager.$$$reportNull$$$0(24);
        }
        Path templateFile = parentDir.resolve(FTManager.encodeFileName(template.getName(), template.getExtension()));
        try (OutputStream fileOutputStream = FTManager.startWriteOrCreate(templateFile);
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream, StandardCharsets.UTF_8);){
            String content2 = template.getText();
            if (!lineSeparator.equals("\n")) {
                content2 = StringUtilRt.convertLineSeparators((String)content2, (String)lineSeparator);
            }
            outputStreamWriter.write(content2);
        }
    }

    @NotNull
    private static OutputStream startWriteOrCreate(@NotNull Path templateFile) throws IOException {
        OutputStream outputStream;
        if (templateFile == null) {
            FTManager.$$$reportNull$$$0(25);
        }
        try {
            outputStream = Files.newOutputStream(templateFile, new OpenOption[0]);
        }
        catch (NoSuchFileException e) {
            PathKt.delete((Path)templateFile);
            OutputStream outputStream2 = Files.newOutputStream(templateFile, new OpenOption[0]);
            if (outputStream2 == null) {
                FTManager.$$$reportNull$$$0(27);
            }
            return outputStream2;
        }
        if (outputStream == null) {
            FTManager.$$$reportNull$$$0(26);
        }
        return outputStream;
    }

    @NotNull
    Path getConfigRoot() {
        Path path = this.myTemplatesDir;
        if (path == null) {
            FTManager.$$$reportNull$$$0(28);
        }
        return path;
    }

    public String toString() {
        return this.myName + " file template manager";
    }

    @NotNull
    static String encodeFileName(@NotNull String templateName, @NotNull String extension2) {
        if (templateName == null) {
            FTManager.$$$reportNull$$$0(29);
        }
        if (extension2 == null) {
            FTManager.$$$reportNull$$$0(30);
        }
        String nameExtDelimiter = extension2.contains(".") ? ENCODED_NAME_EXT_DELIMITER : ".";
        String string = templateName + nameExtDelimiter + extension2;
        if (string == null) {
            FTManager.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    private static Pair<String, String> decodeFileName(@NotNull String fileName) {
        if (fileName == null) {
            FTManager.$$$reportNull$$$0(32);
        }
        String name = fileName;
        String ext = "";
        String nameExtDelimiter = fileName.contains(ENCODED_NAME_EXT_DELIMITER) ? ENCODED_NAME_EXT_DELIMITER : ".";
        int extIndex = fileName.lastIndexOf(nameExtDelimiter);
        if (extIndex >= 0) {
            name = fileName.substring(0, extIndex);
            ext = fileName.substring(extIndex + nameExtDelimiter.length());
        }
        Pair pair = Pair.create((Object)name, (Object)ext);
        if (pair == null) {
            FTManager.$$$reportNull$$$0(33);
        }
        return pair;
    }

    @NotNull
    public Map<String, FileTemplateBase> getTemplates() {
        Map<String, FileTemplateBase> map2 = this.myOriginal != null ? this.myOriginal.myTemplates : this.myTemplates;
        if (map2 == null) {
            FTManager.$$$reportNull$$$0(34);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 33: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 33: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultTemplatesDirName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/fileTemplates/impl/FTManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateQname";
                break;
            }
            case 9: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 11: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTemplates";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDisable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templates";
                break;
            }
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 20: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDir";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineSeparator";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/fileTemplates/impl/FTManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTemplates";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addTemplate";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndStoreBundledTemplate";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentName";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "startWriteOrCreate";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigRoot";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "encodeFileName";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "decodeFileName";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 33: 
            case 34: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTemplate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findTemplateByName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addTemplate";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeTemplate";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateTemplates";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "restoreDefaults";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultTemplates";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createAndStoreBundledTemplate";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addTemplateFromFile";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "saveTemplate";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "startWriteOrCreate";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "encodeFileName";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "decodeFileName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 33: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

