/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.CommonBundle;
import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.AbstractSchemesPanel;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.application.options.schemes.SimpleSchemesPanel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptorFactory;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.FileTemplatesScheme;
import com.intellij.ide.fileTemplates.InternalTemplateBean;
import com.intellij.ide.fileTemplates.impl.BundledFileTemplate;
import com.intellij.ide.fileTemplates.impl.CustomFileTemplate;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.ide.fileTemplates.impl.FileTemplateConfigurable;
import com.intellij.ide.fileTemplates.impl.FileTemplateManagerImpl;
import com.intellij.ide.fileTemplates.impl.FileTemplateTab;
import com.intellij.ide.fileTemplates.impl.FileTemplateTabAsList;
import com.intellij.ide.fileTemplates.impl.FileTemplateTabAsTree;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.IdeLanguageCustomization;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class AllFileTemplatesConfigurable
implements SearchableConfigurable,
Configurable.NoMargin,
Configurable.NoScroll,
Configurable.VariableProjectAppLevel,
Configurable.WithEpDependencies {
    private static final Logger LOG = Logger.getInstance(AllFileTemplatesConfigurable.class);
    private final Project myProject;
    private final FileTemplateManager myManager;
    private JPanel myMainPanel;
    private FileTemplateTab myCurrentTab;
    private FileTemplateTab myTemplatesList;
    private FileTemplateTab myIncludesList;
    private FileTemplateTab myCodeTemplatesList;
    @Nullable
    private FileTemplateTab myOtherTemplatesList;
    private JComponent myToolBar;
    private TabbedPaneWrapper myTabbedPane;
    private FileTemplateConfigurable myEditor;
    private boolean myModified;
    private JComponent myEditorComponent;
    private JPanel myLeftPanel;
    private SchemesPanel mySchemesPanel;
    private FileTemplateTab[] myTabs;
    private Disposable myUIDisposable;
    private final Set<String> myInternalTemplateNames;
    private FileTemplatesScheme myScheme;
    private final Map<FileTemplatesScheme, Map<String, FileTemplate[]>> myChangesCache = new HashMap<FileTemplatesScheme, Map<String, FileTemplate[]>>();
    private static final String CURRENT_TAB = "FileTemplates.CurrentTab";
    private static final String SELECTED_TEMPLATE = "FileTemplates.SelectedTemplate";

    public AllFileTemplatesConfigurable(Project project) {
        this.myProject = project;
        this.myManager = FileTemplateManager.getInstance(project);
        this.myScheme = this.myManager.getCurrentScheme();
        this.myInternalTemplateNames = ContainerUtil.map2Set((Object[])this.myManager.getInternalTemplates(), FileTemplate::getName);
    }

    private void onRemove() {
        this.myCurrentTab.removeSelected();
        this.myModified = true;
    }

    private void onAdd(boolean child2) {
        String ext = StringUtil.notNullize((String)((String)JBIterable.from((Iterable)IdeLanguageCustomization.getInstance().getPrimaryIdeLanguages()).filterMap(Language::getAssociatedFileType).filterMap(FileType::getDefaultExtension).first()), (String)"txt");
        FileTemplateBase selected2 = (FileTemplateBase)ObjectUtils.tryCast((Object)this.getSelectedTemplate(), FileTemplateBase.class);
        if (selected2 == null && child2) {
            return;
        }
        String name = child2 ? selected2.getChildName(selected2.getChildren().length) : IdeBundle.message((String)"template.unnamed", (Object[])new Object[0]);
        FileTemplate template = this.createTemplate(name, ext, "", child2);
        if (child2) {
            selected2.addChild(template);
        }
    }

    @NotNull
    FileTemplate createTemplate(@NotNull String prefName, @NotNull String extension2, @NotNull String content2, boolean child2) {
        if (prefName == null) {
            AllFileTemplatesConfigurable.$$$reportNull$$$0(0);
        }
        if (extension2 == null) {
            AllFileTemplatesConfigurable.$$$reportNull$$$0(1);
        }
        if (content2 == null) {
            AllFileTemplatesConfigurable.$$$reportNull$$$0(2);
        }
        FileTemplate[] templates = this.myCurrentTab.getTemplates();
        FileTemplate newTemplate = FileTemplateUtil.createTemplate(prefName, extension2, content2, templates);
        if (child2) {
            int index2 = ArrayUtil.indexOf((Object[])this.myCurrentTab.getTemplates(), (Object)this.getSelectedTemplate());
            this.myCurrentTab.insertTemplate(newTemplate, index2 + 1);
        } else {
            this.myCurrentTab.addTemplate(newTemplate);
        }
        this.myModified = true;
        this.myCurrentTab.selectTemplate(newTemplate);
        this.fireListChanged();
        this.myEditor.focusToNameField();
        FileTemplate fileTemplate = newTemplate;
        if (fileTemplate == null) {
            AllFileTemplatesConfigurable.$$$reportNull$$$0(3);
        }
        return fileTemplate;
    }

    private void onClone() {
        try {
            this.myEditor.apply();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        FileTemplate selected2 = this.getSelectedTemplate();
        if (selected2 == null) {
            return;
        }
        FileTemplate[] templates = this.myCurrentTab.getTemplates();
        HashSet<String> names2 = new HashSet<String>();
        for (FileTemplate template2 : templates) {
            names2.add(template2.getName());
        }
        String nameTemplate = IdeBundle.message((String)"template.copy.N.of.T", (Object[])new Object[0]);
        String name = MessageFormat.format(nameTemplate, "", selected2.getName());
        int i2 = 0;
        while (names2.contains(name)) {
            name = MessageFormat.format(nameTemplate, ++i2 + " ", selected2.getName());
        }
        CustomFileTemplate newTemplate = new CustomFileTemplate(name, selected2.getExtension());
        newTemplate.setText(selected2.getText());
        newTemplate.setFileName(selected2.getFileName());
        newTemplate.setReformatCode(selected2.isReformatCode());
        newTemplate.setLiveTemplateEnabled(selected2.isLiveTemplateEnabled());
        newTemplate.setChildren((FileTemplate[])ContainerUtil.map2Array((Object[])selected2.getChildren(), FileTemplate.class, template -> template.clone()));
        newTemplate.updateChildrenNames();
        this.myCurrentTab.addTemplate(newTemplate);
        for (FileTemplate child2 : newTemplate.getChildren()) {
            this.myCurrentTab.addTemplate(child2);
        }
        this.myModified = true;
        this.myCurrentTab.selectTemplate(newTemplate);
        this.fireListChanged();
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"title.file.templates", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        int index2 = this.myTabbedPane.getSelectedIndex();
        switch (index2) {
            case 0: {
                return "fileTemplates.templates";
            }
            case 1: {
                return "fileTemplates.includes";
            }
            case 2: {
                return "fileTemplates.code";
            }
            case 3: {
                return "fileTemplates.j2ee";
            }
        }
        throw new IllegalStateException("wrong index: " + index2);
    }

    public JComponent createComponent() {
        this.myUIDisposable = Disposer.newDisposable();
        this.myTemplatesList = new FileTemplateTabAsList(AllFileTemplatesConfigurable.getTemplatesTitle()){

            @Override
            public void onTemplateSelected() {
                AllFileTemplatesConfigurable.this.onListSelectionChanged();
            }
        };
        this.myIncludesList = new FileTemplateTabAsList(AllFileTemplatesConfigurable.getIncludesTitle()){

            @Override
            public void onTemplateSelected() {
                AllFileTemplatesConfigurable.this.onListSelectionChanged();
            }
        };
        this.myCodeTemplatesList = new FileTemplateTabAsList(AllFileTemplatesConfigurable.getCodeTitle()){

            @Override
            public void onTemplateSelected() {
                AllFileTemplatesConfigurable.this.onListSelectionChanged();
            }
        };
        this.myCurrentTab = this.myTemplatesList;
        ArrayList<FileTemplateTab> allTabs = new ArrayList<FileTemplateTab>(Arrays.asList(this.myTemplatesList, this.myIncludesList, this.myCodeTemplatesList));
        final List factories2 = FileTemplateGroupDescriptorFactory.EXTENSION_POINT_NAME.getExtensionList();
        if (!factories2.isEmpty()) {
            this.myOtherTemplatesList = new FileTemplateTabAsTree(AllFileTemplatesConfigurable.getOtherTitle()){

                @Override
                public void onTemplateSelected() {
                    AllFileTemplatesConfigurable.this.onListSelectionChanged();
                }

                @Override
                protected FileTemplateTabAsTree.FileTemplateNode initModel() {
                    TreeSet<FileTemplateGroupDescriptor> categories = new TreeSet<FileTemplateGroupDescriptor>(Comparator.comparing(FileTemplateGroupDescriptor::getTitle));
                    for (FileTemplateGroupDescriptorFactory templateGroupFactory : factories2) {
                        ContainerUtil.addIfNotNull(categories, (Object)templateGroupFactory.getFileTemplatesDescriptor());
                    }
                    return new FileTemplateTabAsTree.FileTemplateNode("ROOT", null, ContainerUtil.map2List(categories, FileTemplateTabAsTree.FileTemplateNode::new));
                }
            };
            allTabs.add(this.myOtherTemplatesList);
        }
        this.myEditor = new FileTemplateConfigurable(this.myProject);
        this.myEditor.addChangeListener(__ -> this.onEditorChanged());
        this.myEditorComponent = this.myEditor.createComponent();
        this.myEditorComponent.setBorder((Border)JBUI.Borders.empty((int)10, (int)0, (int)10, (int)10));
        this.myTabs = allTabs.toArray(new FileTemplateTab[0]);
        this.myTabbedPane = new TabbedPaneWrapper(this.myUIDisposable);
        this.myTabbedPane.setTabLayoutPolicy(1);
        this.myLeftPanel = new JPanel(new CardLayout());
        for (FileTemplateTab tab : this.myTabs) {
            this.myLeftPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)tab.getComponent()), tab.getTitle());
            JPanel fakePanel = new JPanel();
            fakePanel.setPreferredSize(new Dimension(0, 0));
            this.myTabbedPane.addTab(tab.getTitle(), fakePanel);
        }
        this.myTabbedPane.addChangeListener(__ -> this.onTabChanged());
        DefaultActionGroup group2 = new DefaultActionGroup();
        DumbAwareAction removeAction = new DumbAwareAction(IdeBundle.message((String)"action.remove.template", (Object[])new Object[0]), null, AllIcons.General.Remove){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                AllFileTemplatesConfigurable.this.onRemove();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (AllFileTemplatesConfigurable.this.myCurrentTab == null) {
                    e.getPresentation().setEnabled(false);
                    return;
                }
                FileTemplate selectedItem = AllFileTemplatesConfigurable.this.getSelectedTemplate();
                e.getPresentation().setEnabled(selectedItem != null && !AllFileTemplatesConfigurable.isInternalTemplate(selectedItem.getName(), AllFileTemplatesConfigurable.this.myCurrentTab.getTitle()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DumbAwareAction addAction = new DumbAwareAction(IdeBundle.message((String)"action.create.template", (Object[])new Object[0]), null, AllIcons.General.Add){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                AllFileTemplatesConfigurable.this.onAdd(false);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(AllFileTemplatesConfigurable.this.myCurrentTab != AllFileTemplatesConfigurable.this.myCodeTemplatesList && AllFileTemplatesConfigurable.this.myCurrentTab != AllFileTemplatesConfigurable.this.myOtherTemplatesList);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DumbAwareAction addChildAction = new DumbAwareAction(IdeBundle.message((String)"action.create.child.template", (Object[])new Object[0]), null, AllIcons.Actions.AddFile){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                AllFileTemplatesConfigurable.this.onAdd(true);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(AllFileTemplatesConfigurable.this.getSelectedTemplate() != null && AllFileTemplatesConfigurable.this.myCurrentTab != null && !AllFileTemplatesConfigurable.isInternalTemplate(AllFileTemplatesConfigurable.this.getSelectedTemplate().getName(), AllFileTemplatesConfigurable.this.myCurrentTab.getTitle()) && !FileTemplateBase.isChild(AllFileTemplatesConfigurable.this.getSelectedTemplate()) && AllFileTemplatesConfigurable.this.myCurrentTab == AllFileTemplatesConfigurable.this.myTemplatesList);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DumbAwareAction cloneAction = new DumbAwareAction(IdeBundle.message((String)"action.copy.template", (Object[])new Object[0]), null, PlatformIcons.COPY_ICON){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                AllFileTemplatesConfigurable.this.onClone();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(AllFileTemplatesConfigurable.this.myCurrentTab != AllFileTemplatesConfigurable.this.myCodeTemplatesList && AllFileTemplatesConfigurable.this.myCurrentTab != AllFileTemplatesConfigurable.this.myOtherTemplatesList && AllFileTemplatesConfigurable.this.getSelectedTemplate() != null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable$8";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DumbAwareAction resetAction = new DumbAwareAction(IdeBundle.message((String)"action.reset.to.default", (Object[])new Object[0]), null, AllIcons.Actions.Rollback){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                AllFileTemplatesConfigurable.this.onReset();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(1);
                }
                if (AllFileTemplatesConfigurable.this.myCurrentTab == null) {
                    e.getPresentation().setEnabled(false);
                    return;
                }
                FileTemplate selectedItem = AllFileTemplatesConfigurable.this.getSelectedTemplate();
                e.getPresentation().setEnabled(selectedItem instanceof BundledFileTemplate && !selectedItem.isDefault());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable$9";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        group2.add((AnAction)addAction);
        group2.add((AnAction)addChildAction);
        group2.add((AnAction)removeAction);
        group2.add((AnAction)cloneAction);
        group2.add((AnAction)resetAction);
        addAction.registerCustomShortcutSet(CommonShortcuts.INSERT, this.myCurrentTab.getComponent());
        removeAction.registerCustomShortcutSet(CommonShortcuts.getDelete(), this.myCurrentTab.getComponent());
        this.myToolBar = ActionManager.getInstance().createActionToolbar("FileTemplatesConfigurable", (ActionGroup)group2, true).getComponent();
        this.myToolBar.setBorder((Border)new CustomLineBorder(1, 1, 0, 1));
        this.mySchemesPanel = new SchemesPanel();
        this.mySchemesPanel.setBorder((Border)JBUI.Borders.empty((int)5, (int)10, (int)0, (int)10));
        this.mySchemesPanel.resetSchemes(Arrays.asList(FileTemplatesScheme.DEFAULT, this.myManager.getProjectScheme()));
        JPanel leftPanelWrapper = new JPanel(new BorderLayout());
        leftPanelWrapper.setBorder((Border)JBUI.Borders.empty((int)10, (int)10, (int)10, (int)0));
        leftPanelWrapper.add("North", this.myToolBar);
        leftPanelWrapper.add("Center", this.myLeftPanel);
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)this.myTabbedPane.getComponent(), "North");
        Splitter splitter = new Splitter(false, 0.3f);
        splitter.setDividerWidth(JBUIScale.scale((int)10));
        splitter.setFirstComponent((JComponent)leftPanelWrapper);
        splitter.setSecondComponent(this.myEditorComponent);
        centerPanel.add((Component)splitter, "Center");
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myMainPanel.add((Component)this.mySchemesPanel, "North");
        this.myMainPanel.add((Component)centerPanel, "Center");
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        String tabName = propertiesComponent.getValue(CURRENT_TAB);
        this.selectTab(tabName);
        return this.myMainPanel;
    }

    @Nullable
    private FileTemplate getSelectedTemplate() {
        return this.myCurrentTab.getSelectedTemplate();
    }

    private void onReset() {
        FileTemplate selected2 = this.getSelectedTemplate();
        if (selected2 instanceof BundledFileTemplate) {
            if (Messages.showOkCancelDialog((String)IdeBundle.message((String)"prompt.reset.to.original.template", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.reset.template", (Object[])new Object[0]), (String)LangBundle.message((String)"button.reset", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon()) != 0) {
                return;
            }
            ((BundledFileTemplate)selected2).revertToDefaults();
            this.myEditor.reset();
            this.myModified = true;
        }
    }

    private void onEditorChanged() {
        this.fireListChanged();
    }

    private void onTabChanged() {
        this.applyEditor(this.getSelectedTemplate());
        FileTemplateTab tab = this.myCurrentTab;
        int selectedIndex = this.myTabbedPane.getSelectedIndex();
        if (0 <= selectedIndex && selectedIndex < this.myTabs.length) {
            this.myCurrentTab = this.myTabs[selectedIndex];
        }
        ((CardLayout)this.myLeftPanel.getLayout()).show(this.myLeftPanel, this.myCurrentTab.getTitle());
        this.onListSelectionChanged();
        if (tab != this.myCurrentTab) {
            EventQueue.invokeLater(this.myCurrentTab.getComponent()::requestFocus);
        }
    }

    private void onListSelectionChanged() {
        FileTemplate prevTemplate;
        FileTemplate selectedValue = this.getSelectedTemplate();
        FileTemplate fileTemplate = prevTemplate = this.myEditor == null ? null : this.myEditor.getTemplate();
        if (prevTemplate != selectedValue) {
            LOG.assertTrue(this.myEditor != null, (Object)("selected:" + selectedValue + "; prev:" + prevTemplate));
            if (Arrays.asList(this.myCurrentTab.getTemplates()).contains(prevTemplate) && !this.applyEditor(prevTemplate)) {
                return;
            }
            if (selectedValue == null) {
                this.myEditor.setTemplate(null, FileTemplateManagerImpl.getInstanceImpl(this.myProject).getDefaultTemplateDescription());
                this.myEditorComponent.repaint();
            } else {
                this.selectTemplate(selectedValue);
            }
        }
    }

    private boolean applyEditor(FileTemplate prevTemplate) {
        if (this.myEditor.isModified()) {
            try {
                this.myModified = true;
                this.myEditor.apply();
                this.fireListChanged();
            }
            catch (ConfigurationException e) {
                if (Arrays.asList(this.myCurrentTab.getTemplates()).contains(prevTemplate)) {
                    this.myCurrentTab.selectTemplate(prevTemplate);
                }
                Messages.showErrorDialog((Component)this.myMainPanel, (String)e.getMessage(), (String)IdeBundle.message((String)"title.cannot.save.current.template", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private void selectTemplate(FileTemplate template) {
        URL defDesc = null;
        if (this.myCurrentTab == this.myTemplatesList) {
            defDesc = FileTemplateManagerImpl.getInstanceImpl(this.myProject).getDefaultTemplateDescription();
        } else if (this.myCurrentTab == this.myIncludesList) {
            defDesc = FileTemplateManagerImpl.getInstanceImpl(this.myProject).getDefaultIncludeDescription();
        }
        if (this.myEditor.getTemplate() != template) {
            boolean isInternal = template != null && AllFileTemplatesConfigurable.isInternalTemplate(template.getName(), this.myCurrentTab.getTitle());
            this.myEditor.setTemplate(template, defDesc, isInternal);
            this.myEditor.setShowAdjustCheckBox(this.myTemplatesList == this.myCurrentTab);
        }
    }

    public boolean isProjectLevel() {
        return this.myScheme != null && this.myScheme != FileTemplatesScheme.DEFAULT && !this.myScheme.getProject().isDefault();
    }

    static boolean isInternalTemplate(String templateName, String templateTabTitle) {
        if (templateName == null) {
            return false;
        }
        if (Comparing.strEqual((String)templateTabTitle, (String)AllFileTemplatesConfigurable.getTemplatesTitle())) {
            return AllFileTemplatesConfigurable.isInternalTemplateName(templateName);
        }
        if (Comparing.strEqual((String)templateTabTitle, (String)AllFileTemplatesConfigurable.getCodeTitle())) {
            return true;
        }
        if (Comparing.strEqual((String)templateTabTitle, (String)AllFileTemplatesConfigurable.getOtherTitle())) {
            return true;
        }
        if (Comparing.strEqual((String)templateTabTitle, (String)AllFileTemplatesConfigurable.getIncludesTitle())) {
            return Comparing.strEqual((String)templateName, (String)"File Header");
        }
        return false;
    }

    private static boolean isInternalTemplateName(String templateName) {
        for (InternalTemplateBean bean : InternalTemplateBean.EP_NAME.getExtensionList()) {
            if (!Comparing.strEqual((String)templateName, (String)bean.name)) continue;
            return true;
        }
        return false;
    }

    private void initLists() {
        FileTemplatesScheme scheme2 = this.myManager.getCurrentScheme();
        this.myManager.setCurrentScheme(this.myScheme);
        this.myTemplatesList.init(this.getTemplates("Default"));
        this.myIncludesList.init(this.getTemplates("Includes"));
        this.myCodeTemplatesList.init(this.getTemplates("Code"));
        this.myTabbedPane.setEnabledAt(2, !this.myCodeTemplatesList.myTemplates.isEmpty());
        if (this.myOtherTemplatesList != null) {
            this.myOtherTemplatesList.init(this.getTemplates("J2EE"));
        }
        this.myManager.setCurrentScheme(scheme2);
    }

    private FileTemplate[] getTemplates(String category) {
        Map<String, FileTemplate[]> templates = this.myChangesCache.get(this.myScheme);
        if (templates == null) {
            return this.myManager.getTemplates(category);
        }
        return templates.get(category);
    }

    public boolean isModified() {
        return this.myScheme != this.myManager.getCurrentScheme() || !this.myChangesCache.isEmpty() || this.isSchemeModified();
    }

    private boolean isSchemeModified() {
        return this.myModified || this.myEditor != null && this.myEditor.isModified();
    }

    private void checkCanApply(FileTemplateTab list2) throws ConfigurationException {
        FileTemplate[] templates = this.myCurrentTab.getTemplates();
        ArrayList<String> allNames = new ArrayList<String>();
        FileTemplate itemWithError = null;
        String errorString = null;
        for (FileTemplate template : templates) {
            String currName = template.getName();
            if (currName.isEmpty()) {
                itemWithError = template;
                errorString = IdeBundle.message((String)"error.please.specify.template.name", (Object[])new Object[0]);
                break;
            }
            if (allNames.contains(currName)) {
                itemWithError = template;
                errorString = LangBundle.message((String)"dialog.message.template.with.name.already.exists", (Object[])new Object[]{currName});
                break;
            }
            allNames.add(currName);
        }
        if (itemWithError != null) {
            this.myTabbedPane.setSelectedIndex(Arrays.asList(this.myTabs).indexOf(list2));
            this.selectTemplate(itemWithError);
            list2.selectTemplate(itemWithError);
            ApplicationManager.getApplication().invokeLater(this.myEditor::focusToNameField);
            throw new ConfigurationException(errorString);
        }
    }

    private void fireListChanged() {
        if (this.myCurrentTab != null) {
            this.myCurrentTab.fireDataChanged();
        }
        if (this.myMainPanel != null) {
            this.myMainPanel.revalidate();
        }
    }

    public void apply() throws ConfigurationException {
        if (this.myEditor != null && this.myEditor.isModified()) {
            this.myModified = true;
            this.myEditor.apply();
        }
        for (FileTemplateTab list2 : this.myTabs) {
            this.checkCanApply(list2);
        }
        this.updateCache();
        for (Map.Entry entry : this.myChangesCache.entrySet()) {
            this.myManager.setCurrentScheme((FileTemplatesScheme)entry.getKey());
            Map templates = (Map)entry.getValue();
            this.myManager.setTemplates("Default", Arrays.asList((FileTemplate[])templates.get("Default")));
            this.myManager.setTemplates("Internal", Arrays.asList((FileTemplate[])templates.get("Internal")));
            this.myManager.setTemplates("Includes", Arrays.asList((FileTemplate[])templates.get("Includes")));
            this.myManager.setTemplates("Code", Arrays.asList((FileTemplate[])templates.get("Code")));
            this.myManager.setTemplates("J2EE", Arrays.asList((FileTemplate[])templates.get("J2EE")));
        }
        this.myChangesCache.clear();
        this.myManager.setCurrentScheme(this.myScheme);
        if (this.myEditor != null) {
            this.myModified = false;
            this.fireListChanged();
        }
    }

    private boolean selectTab(String tabName) {
        int idx = 0;
        for (FileTemplateTab tab : this.myTabs) {
            if (Comparing.strEqual((String)tab.getTitle(), (String)tabName)) {
                this.myCurrentTab = tab;
                this.myTabbedPane.setSelectedIndex(idx);
                return true;
            }
            ++idx;
        }
        return false;
    }

    public void reset() {
        this.myEditor.reset();
        this.changeScheme(this.myManager.getCurrentScheme());
        this.mySchemesPanel.selectScheme(this.myScheme);
        this.myChangesCache.clear();
        this.myModified = false;
    }

    public void disposeUIResources() {
        if (this.myCurrentTab != null) {
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            propertiesComponent.setValue(CURRENT_TAB, this.myCurrentTab.getTitle(), AllFileTemplatesConfigurable.getTemplatesTitle());
            FileTemplate template = this.getSelectedTemplate();
            if (template != null) {
                propertiesComponent.setValue(SELECTED_TEMPLATE, template.getName());
            }
        }
        if (this.myEditor != null) {
            this.myEditor.disposeUIResources();
            this.myEditor = null;
            this.myEditorComponent = null;
        }
        this.myMainPanel = null;
        if (this.myUIDisposable != null) {
            Disposer.dispose((Disposable)this.myUIDisposable);
            this.myUIDisposable = null;
        }
        this.myTabbedPane = null;
        this.myToolBar = null;
        this.myTabs = null;
        this.myCurrentTab = null;
        this.myTemplatesList = null;
        this.myCodeTemplatesList = null;
        this.myIncludesList = null;
        this.myOtherTemplatesList = null;
    }

    @NotNull
    public String getId() {
        return "fileTemplates";
    }

    public static void editCodeTemplate(@NotNull String templateId, Project project) {
        if (templateId == null) {
            AllFileTemplatesConfigurable.$$$reportNull$$$0(4);
        }
        ShowSettingsUtil util = ShowSettingsUtil.getInstance();
        AllFileTemplatesConfigurable configurable2 = new AllFileTemplatesConfigurable(project);
        util.editConfigurable(project, (Configurable)configurable2, () -> {
            configurable2.myTabbedPane.setSelectedIndex(ArrayUtil.indexOf((Object[])configurable2.myTabs, (Object)configurable2.myCodeTemplatesList));
            for (FileTemplate template : configurable2.myCodeTemplatesList.getTemplates()) {
                if (!Objects.equals(templateId, template.getName())) continue;
                configurable2.myCodeTemplatesList.selectTemplate(template);
                break;
            }
        });
    }

    public static void editOtherTemplate(@NotNull String templateFileName, Project project) {
        if (templateFileName == null) {
            AllFileTemplatesConfigurable.$$$reportNull$$$0(5);
        }
        ShowSettingsUtil util = ShowSettingsUtil.getInstance();
        AllFileTemplatesConfigurable configurable2 = new AllFileTemplatesConfigurable(project);
        util.editConfigurable(project, (Configurable)configurable2, () -> {
            FileTemplateTab otherTemplatesList = configurable2.myOtherTemplatesList;
            if (otherTemplatesList == null) {
                return;
            }
            configurable2.myTabbedPane.setSelectedIndex(ArrayUtil.indexOf((Object[])configurable2.myTabs, (Object)otherTemplatesList));
            for (FileTemplate template : otherTemplatesList.getTemplates()) {
                Object fileName = template.getName();
                if (!template.getExtension().isEmpty()) {
                    fileName = (String)fileName + "." + template.getExtension();
                }
                if (!Objects.equals(templateFileName, fileName)) continue;
                otherTemplatesList.selectTemplate(template);
                break;
            }
        });
    }

    void changeScheme(@NotNull FileTemplatesScheme scheme2) {
        if (scheme2 == null) {
            AllFileTemplatesConfigurable.$$$reportNull$$$0(6);
        }
        if (this.myEditor != null && this.myEditor.isModified()) {
            this.myModified = true;
            try {
                this.myEditor.apply();
            }
            catch (ConfigurationException e) {
                Messages.showErrorDialog((Component)this.myEditorComponent, (String)e.getMessage(), (String)e.getTitle());
                return;
            }
        }
        this.updateCache();
        this.myScheme = scheme2;
        this.initLists();
    }

    private void updateCache() {
        if (this.isSchemeModified() && !this.myChangesCache.containsKey(this.myScheme)) {
            HashMap<String, FileTemplate[]> templates = new HashMap<String, FileTemplate[]>();
            Object[] allTemplates = this.myTemplatesList.getTemplates();
            templates.put("Default", ContainerUtil.filter((Object[])allTemplates, template -> !this.myInternalTemplateNames.contains(template.getName())).toArray(FileTemplate.EMPTY_ARRAY));
            templates.put("Internal", ContainerUtil.filter((Object[])allTemplates, template -> this.myInternalTemplateNames.contains(template.getName())).toArray(FileTemplate.EMPTY_ARRAY));
            templates.put("Includes", this.myIncludesList.getTemplates());
            templates.put("Code", this.myCodeTemplatesList.getTemplates());
            templates.put("J2EE", this.myOtherTemplatesList == null ? FileTemplate.EMPTY_ARRAY : this.myOtherTemplatesList.getTemplates());
            this.myChangesCache.put(this.myScheme, templates);
        }
    }

    @NotNull
    public FileTemplateManager getManager() {
        FileTemplateManager fileTemplateManager = this.myManager;
        if (fileTemplateManager == null) {
            AllFileTemplatesConfigurable.$$$reportNull$$$0(7);
        }
        return fileTemplateManager;
    }

    @TestOnly
    FileTemplateConfigurable getEditor() {
        return this.myEditor;
    }

    @TestOnly
    FileTemplateTab[] getTabs() {
        return this.myTabs;
    }

    @NlsContexts.TabTitle
    private static String getTemplatesTitle() {
        return IdeBundle.message((String)"tab.filetemplates.templates", (Object[])new Object[0]);
    }

    @NlsContexts.TabTitle
    private static String getIncludesTitle() {
        return IdeBundle.message((String)"tab.filetemplates.includes", (Object[])new Object[0]);
    }

    @NlsContexts.TabTitle
    private static String getCodeTitle() {
        return IdeBundle.message((String)"tab.filetemplates.code", (Object[])new Object[0]);
    }

    @NlsContexts.TabTitle
    private static String getOtherTitle() {
        return IdeBundle.message((String)"tab.filetemplates.j2ee", (Object[])new Object[0]);
    }

    @NotNull
    public Collection<BaseExtensionPointName<?>> getDependencies() {
        Set<ExtensionPointName<InternalTemplateBean>> set2 = Collections.singleton(InternalTemplateBean.EP_NAME);
        if (set2 == null) {
            AllFileTemplatesConfigurable.$$$reportNull$$$0(8);
        }
        return set2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateFileName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getManager";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTemplate";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "editCodeTemplate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "editOtherTemplate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "changeScheme";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class SchemesPanel
    extends SimpleSchemesPanel<FileTemplatesScheme>
    implements SchemesModel<FileTemplatesScheme> {
        private SchemesPanel() {
        }

        @Override
        @NotNull
        protected AbstractSchemeActions<FileTemplatesScheme> createSchemeActions() {
            return new AbstractSchemeActions<FileTemplatesScheme>((AbstractSchemesPanel)this){

                @Override
                protected void resetScheme(@NotNull FileTemplatesScheme scheme2) {
                    if (scheme2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    throw new UnsupportedOperationException();
                }

                @Override
                protected void duplicateScheme(@NotNull FileTemplatesScheme scheme2, @NotNull String newName2) {
                    if (scheme2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (newName2 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    throw new UnsupportedOperationException();
                }

                @Override
                protected void onSchemeChanged(@Nullable FileTemplatesScheme scheme2) {
                    if (scheme2 != null) {
                        AllFileTemplatesConfigurable.this.changeScheme(scheme2);
                    }
                }

                @Override
                protected void renameScheme(@NotNull FileTemplatesScheme scheme2, @NotNull String newName2) {
                    if (scheme2 == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if (newName2 == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    throw new UnsupportedOperationException();
                }

                @Override
                @NotNull
                protected Class<FileTemplatesScheme> getSchemeType() {
                    return FileTemplatesScheme.class;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "scheme";
                            break;
                        }
                        case 2: 
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "newName";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable$SchemesPanel$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "resetScheme";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "duplicateScheme";
                            break;
                        }
                        case 3: 
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "renameScheme";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }

        @Override
        @NotNull
        public SchemesModel<FileTemplatesScheme> getModel() {
            SchemesPanel schemesPanel = this;
            if (schemesPanel == null) {
                SchemesPanel.$$$reportNull$$$0(0);
            }
            return schemesPanel;
        }

        @Override
        protected boolean supportsProjectSchemes() {
            return false;
        }

        @Override
        protected boolean highlightNonDefaultSchemes() {
            return false;
        }

        @Override
        public boolean useBoldForNonRemovableSchemes() {
            return true;
        }

        @Override
        public boolean canDuplicateScheme(@NotNull FileTemplatesScheme scheme2) {
            if (scheme2 == null) {
                SchemesPanel.$$$reportNull$$$0(1);
            }
            return false;
        }

        @Override
        public boolean canResetScheme(@NotNull FileTemplatesScheme scheme2) {
            if (scheme2 == null) {
                SchemesPanel.$$$reportNull$$$0(2);
            }
            return false;
        }

        @Override
        public boolean canDeleteScheme(@NotNull FileTemplatesScheme scheme2) {
            if (scheme2 == null) {
                SchemesPanel.$$$reportNull$$$0(3);
            }
            return false;
        }

        @Override
        public boolean isProjectScheme(@NotNull FileTemplatesScheme scheme2) {
            if (scheme2 == null) {
                SchemesPanel.$$$reportNull$$$0(4);
            }
            return false;
        }

        @Override
        public boolean canRenameScheme(@NotNull FileTemplatesScheme scheme2) {
            if (scheme2 == null) {
                SchemesPanel.$$$reportNull$$$0(5);
            }
            return false;
        }

        @Override
        public boolean containsScheme(@NotNull String name, boolean projectScheme) {
            if (name == null) {
                SchemesPanel.$$$reportNull$$$0(6);
            }
            return false;
        }

        @Override
        public boolean differsFromDefault(@NotNull FileTemplatesScheme scheme2) {
            if (scheme2 == null) {
                SchemesPanel.$$$reportNull$$$0(7);
            }
            return false;
        }

        @Override
        public void removeScheme(@NotNull FileTemplatesScheme scheme2) {
            if (scheme2 == null) {
                SchemesPanel.$$$reportNull$$$0(8);
            }
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable$SchemesPanel";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheme";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModel";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable$SchemesPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "canDuplicateScheme";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "canResetScheme";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "canDeleteScheme";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isProjectScheme";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "canRenameScheme";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "containsScheme";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "differsFromDefault";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "removeScheme";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class Provider
    extends ConfigurableProvider {
        private final Project myProject;

        Provider(@NotNull Project project) {
            if (project == null) {
                Provider.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @NotNull
        public Configurable createConfigurable() {
            return new AllFileTemplatesConfigurable(this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable$Provider", "<init>"));
        }
    }
}

