/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.dnd;

import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDManagerImpl;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.DropActionHandler;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.dnd.FileFlavorProvider;
import com.intellij.ide.dnd.LinuxDragAndDropSupport;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class DnDEventImpl
extends UserDataHolderBase
implements Transferable,
DnDEvent {
    private static final Logger LOG = Logger.getInstance(DnDEventImpl.class);
    public static final DataFlavor ourDataFlavor = FileCopyPasteUtil.createDataFlavor("application/x-java-jvm-local-objectref");
    private DnDTarget myDelegatedTarget;
    private DnDManagerImpl myManager;
    private DnDAction myAction;
    private Object myAttachedObject;
    private boolean myDropPossible;
    private @NlsContexts.PopupContent String myExpectedDropResult;
    private Point myPoint;
    private Point myOrgPoint;
    private int myHighlighting;
    private DropActionHandler myDropHandler;
    private Component myHandlerComponent;
    private boolean myShouldRemoveHighlighter = true;
    private Point myLocalPoint;
    private Cursor myCursor;

    public DnDEventImpl(DnDManagerImpl manager2, DnDAction action2, Object attachedObject, Point point) {
        this.myManager = manager2;
        this.myAction = action2;
        this.myAttachedObject = attachedObject;
        this.myPoint = point;
    }

    public DnDAction getAction() {
        return this.myAction;
    }

    public void updateAction(DnDAction action2) {
        this.myAction = action2;
    }

    public Object getAttachedObject() {
        return this.myAttachedObject;
    }

    public void setDropPossible(boolean possible, @Nullable @NlsContexts.PopupContent String aExpectedResult) {
        this.myDropPossible = possible;
        this.myExpectedDropResult = aExpectedResult;
        this.clearDropHandler();
    }

    public void setDropPossible(boolean possible) {
        this.setDropPossible(possible, null);
    }

    public void setDropPossible(@NlsContexts.PopupContent String aExpectedResult, DropActionHandler aHandler) {
        this.myDropPossible = true;
        this.myExpectedDropResult = aExpectedResult;
        this.myDropHandler = aHandler;
    }

    public String getExpectedDropResult() {
        return this.myExpectedDropResult;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        if (this.myAttachedObject instanceof Transferable) {
            return ((Transferable)this.myAttachedObject).getTransferDataFlavors();
        }
        if (this.myAttachedObject instanceof FileFlavorProvider) {
            return new DataFlavor[]{ourDataFlavor, DataFlavor.javaFileListFlavor, LinuxDragAndDropSupport.uriListFlavor};
        }
        if (this.myAttachedObject instanceof DnDNativeTarget.EventInfo) {
            return ((DnDNativeTarget.EventInfo)this.myAttachedObject).getFlavors();
        }
        if (this.myAttachedObject instanceof GutterIconRenderer) {
            return GutterDraggableObject.getFlavors();
        }
        return new DataFlavor[]{ourDataFlavor};
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        List<File> files2;
        if (this.myAttachedObject instanceof Transferable) {
            return ((Transferable)this.myAttachedObject).getTransferData(flavor);
        }
        if (this.myAttachedObject instanceof FileFlavorProvider && flavor == DataFlavor.javaFileListFlavor) {
            List<File> files3 = ((FileFlavorProvider)this.myAttachedObject).asFileList();
            if (files3 != null) {
                return files3;
            }
        } else if (this.myAttachedObject instanceof FileFlavorProvider && flavor == LinuxDragAndDropSupport.uriListFlavor && (files2 = ((FileFlavorProvider)this.myAttachedObject).asFileList()) != null) {
            return LinuxDragAndDropSupport.toUriList(files2);
        }
        return this.getAttachedObject();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        Object[] flavors = this.getTransferDataFlavors();
        return ArrayUtil.find((Object[])flavors, (Object)flavor) != -1;
    }

    public boolean isDropPossible() {
        return this.myDropPossible;
    }

    public Point getOrgPoint() {
        return this.myOrgPoint;
    }

    public void setOrgPoint(Point orgPoint) {
        this.myOrgPoint = orgPoint;
    }

    void setPoint(Point aPoint) {
        this.myPoint = aPoint;
    }

    public Point getPoint() {
        return this.myPoint;
    }

    public Point getPointOn(Component aComponent) {
        return SwingUtilities.convertPoint(this.myHandlerComponent, this.getPoint(), aComponent);
    }

    void clearDropHandler() {
        this.myDropHandler = null;
    }

    public boolean canHandleDrop() {
        LOG.debug("canHandleDrop:" + this.myDropHandler);
        return this.myDropHandler != null;
    }

    protected void handleDrop() {
        this.myDropHandler.performDrop((DnDEvent)this);
    }

    void setHandlerComponent(Component aOverComponent) {
        this.myHandlerComponent = aOverComponent;
    }

    public Component getHandlerComponent() {
        return this.myHandlerComponent;
    }

    public Component getCurrentOverComponent() {
        return this.getHandlerComponent().getComponentAt(this.getPoint());
    }

    public void setHighlighting(Component aComponent, int aType) {
        this.myManager.showHighlighter(aComponent, aType, (DnDEvent)this);
        this.myHighlighting = aType;
    }

    public void setHighlighting(RelativeRectangle rectangle, int aType) {
        this.getHandlerComponent();
        this.myManager.showHighlighter(rectangle, aType, (DnDEvent)this);
        this.myHighlighting = aType;
    }

    public void setHighlighting(JLayeredPane layeredPane, RelativeRectangle rectangle, int aType) {
        this.myManager.showHighlighter(layeredPane, rectangle, aType, this);
    }

    boolean shouldRemoveHighlighting() {
        return this.myShouldRemoveHighlighter;
    }

    public void setAutoHideHighlighterInDrop(boolean aValue) {
        this.myShouldRemoveHighlighter = aValue;
    }

    public void hideHighlighter() {
        this.myManager.hideCurrentHighlighter();
        this.myHighlighting = 0;
    }

    public void setLocalPoint(Point localPoint) {
        this.myLocalPoint = localPoint;
    }

    public Point getLocalPoint() {
        return this.myLocalPoint;
    }

    public RelativePoint getRelativePoint() {
        return new RelativePoint(this.getCurrentOverComponent(), this.getPoint());
    }

    public void clearDelegatedTarget() {
        this.myDelegatedTarget = null;
    }

    public boolean wasDelegated() {
        return this.myDelegatedTarget != null;
    }

    public DnDTarget getDelegatedTarget() {
        return this.myDelegatedTarget;
    }

    public boolean delegateUpdateTo(DnDTarget target2) {
        this.myDelegatedTarget = target2;
        return this.myDelegatedTarget.update((DnDEvent)this);
    }

    public void delegateDropTo(DnDTarget target2) {
        this.myDelegatedTarget = target2;
        target2.drop((DnDEvent)this);
    }

    protected Object clone() {
        DnDEventImpl result2 = new DnDEventImpl(this.myManager, this.myAction, this.myAttachedObject, this.myPoint);
        result2.myDropHandler = this.myDropHandler;
        result2.myDropPossible = this.myDropPossible;
        result2.myExpectedDropResult = this.myExpectedDropResult;
        result2.myHighlighting = this.myHighlighting;
        return result2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DnDEventImpl)) {
            return false;
        }
        DnDEventImpl event = (DnDEventImpl)o;
        if (this.myDropPossible != event.myDropPossible) {
            return false;
        }
        if (this.myHighlighting != event.myHighlighting) {
            return false;
        }
        if (this.myAttachedObject != null ? !this.myAttachedObject.equals(event.myAttachedObject) : event.myAttachedObject != null) {
            return false;
        }
        return !(this.myExpectedDropResult != null ? !this.myExpectedDropResult.equals(event.myExpectedDropResult) : event.myExpectedDropResult != null);
    }

    public int hashCode() {
        int result2 = this.myAttachedObject != null ? this.myAttachedObject.hashCode() : 0;
        result2 = 29 * result2 + (this.myDropPossible ? 1 : 0);
        result2 = 29 * result2 + (this.myExpectedDropResult != null ? this.myExpectedDropResult.hashCode() : 0);
        result2 = 29 * result2 + this.myHighlighting;
        return result2;
    }

    public Cursor getCursor() {
        return this.myCursor;
    }

    @NonNls
    public String toString() {
        return "DnDEvent[attachedObject: " + this.myAttachedObject + ", delegatedTarget: " + this.myDelegatedTarget + ", dropHandler: " + this.myDropHandler + "]";
    }

    public void setCursor(Cursor cursor) {
        this.myCursor = cursor;
    }

    public void cleanUp() {
        this.myAttachedObject = null;
        this.myDelegatedTarget = null;
        this.myDropHandler = null;
        this.myHandlerComponent = null;
        this.myManager = null;
    }
}

