/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.customize;

import com.intellij.ide.customize.PluginGroups;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public final class IdSet {
    private static final List<@NonNls String> BLACK_LIST = Arrays.asList("Support", "support", "Integration", "integration");
    @Nls
    String myTitle;
    List<PluginId> myIds;

    IdSet(PluginGroups pluginGroups, @NonNls String description) {
        int i2 = description.indexOf(":");
        if (i2 > 0) {
            this.myTitle = description.substring(0, i2);
            description = description.substring(i2 + 1);
        }
        this.myIds = ContainerUtil.map((Object[])description.split(","), PluginId::getId);
        this.myIds = ContainerUtil.filter(this.myIds, id2 -> pluginGroups.findPlugin((PluginId)id2) != null);
        if (this.myIds.size() > 1 && this.myTitle == null) {
            throw new IllegalArgumentException("There is no common title for " + this.myIds.size() + " ids: " + description);
        }
        if (this.myTitle == null && this.myIds.size() > 0) {
            this.myTitle = pluginGroups.findPlugin(this.myIds.get(0)).getName();
        }
        if (this.myIds.isEmpty() && this.myTitle != null) {
            this.myTitle = null;
        }
        if (this.myTitle != null) {
            for (String skipWord : BLACK_LIST) {
                this.myTitle = this.myTitle.replaceAll(skipWord, "");
            }
            this.myTitle = this.myTitle.replaceAll("  ", " ").trim();
        }
    }

    public String toString() {
        return this.myTitle + ": " + (this.myIds != null ? this.myIds.size() : 0);
    }

    @Nullable
    @Nls
    public String getTitle() {
        return this.myTitle;
    }

    public List<PluginId> getIds() {
        return this.myIds;
    }
}

