/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.customize;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.customize.AbstractCustomizeWizardStep;
import com.intellij.ide.customize.CustomizeIDEWizardDialog;
import com.intellij.ide.customize.CustomizeIDEWizardInteractionType;
import com.intellij.ide.customize.CustomizeIDEWizardInteractions;
import com.intellij.ide.customize.IdSet;
import com.intellij.ide.customize.PluginGroups;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.JBColor;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class CustomizePluginsStepPanel
extends AbstractCustomizeWizardStep {
    @NonNls
    private static final String MAIN = "main";
    @NonNls
    private static final String CUSTOMIZE = "customize";
    private static final int COLS = 3;
    private static final TextProvider CUSTOMIZE_TEXT_PROVIDER = new TextProvider(){

        @Override
        public String getText() {
            return IdeBundle.message((String)"link.label.wizard.step.plugin.customize", (Object[])new Object[0]);
        }
    };
    @NonNls
    private static final String SWITCH_COMMAND = "Switch";
    @NonNls
    private static final String CUSTOMIZE_COMMAND = "Customize";
    private final JBCardLayout myCardLayout;
    private final IdSetPanel myCustomizePanel;
    private final PluginGroups myPluginGroups;

    public CustomizePluginsStepPanel(@NotNull PluginGroups pluginGroups) {
        if (pluginGroups == null) {
            CustomizePluginsStepPanel.$$$reportNull$$$0(0);
        }
        this.myPluginGroups = pluginGroups;
        this.myCardLayout = new JBCardLayout();
        this.setLayout((LayoutManager)this.myCardLayout);
        JPanel gridPanel = new JPanel(new GridLayout(0, 3));
        this.myCustomizePanel = new IdSetPanel();
        JBScrollPane scrollPane = CustomizePluginsStepPanel.createScrollPane(gridPanel);
        this.add((Component)scrollPane, MAIN);
        this.add((Component)this.myCustomizePanel, CUSTOMIZE);
        List<PluginGroups.Group> groups2 = pluginGroups.getTree();
        for (PluginGroups.Group g : groups2) {
            final String groupId2 = g.getId();
            if ("Core".equals(groupId2) || this.myPluginGroups.getSets(groupId2).isEmpty()) continue;
            JPanel groupPanel = new JPanel(new GridBagLayout()){

                @Override
                public Color getBackground() {
                    Color color = UIManager.getColor("Panel.background");
                    return CustomizePluginsStepPanel.this.isGroupEnabled(groupId2) ? color : ColorUtil.darker((Color)color, (int)1);
                }
            };
            gridPanel.setOpaque(true);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 1;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            HtmlBuilder titleHtml = new HtmlBuilder().append((HtmlChunk)HtmlChunk.html().child((HtmlChunk)HtmlChunk.body().child((HtmlChunk)HtmlChunk.tag((String)"h2").attr("style", "text-align:center;").addText(g.getName()))));
            JLabel titleLabel = new JLabel(titleHtml.toString(), 0){

                @Override
                public boolean isEnabled() {
                    return CustomizePluginsStepPanel.this.isGroupEnabled(groupId2);
                }
            };
            groupPanel.add((Component)new JLabel(g.getIcon()), gbc);
            groupPanel.add((Component)titleLabel, gbc);
            JLabel descriptionLabel = new JLabel(pluginGroups.getDescription(groupId2), 0){

                @Override
                public Dimension getPreferredSize() {
                    Dimension size = super.getPreferredSize();
                    size.width = Math.min(size.width, 200);
                    return size;
                }

                @Override
                public boolean isEnabled() {
                    return CustomizePluginsStepPanel.this.isGroupEnabled(groupId2);
                }

                @Override
                public Color getForeground() {
                    return ColorUtil.withAlpha((Color)UIManager.getColor("Label.foreground"), (double)0.75);
                }
            };
            groupPanel.add((Component)descriptionLabel, gbc);
            gbc.weighty = 1.0;
            groupPanel.add(Box.createVerticalGlue(), gbc);
            gbc.weighty = 0.0;
            JPanel buttonsPanel = new JPanel(new FlowLayout(1, 10, 5));
            buttonsPanel.setOpaque(false);
            if (pluginGroups.getSets(groupId2).size() != 1) {
                buttonsPanel.add((Component)this.createLink(new LinkDescription(CUSTOMIZE_COMMAND, g), CUSTOMIZE_TEXT_PROVIDER));
            }
            buttonsPanel.add((Component)this.createLink(new LinkDescription(SWITCH_COMMAND, g), this.getGroupSwitchTextProvider(groupId2)));
            groupPanel.add((Component)buttonsPanel, gbc);
            gridPanel.add(groupPanel);
        }
        int cursor = 0;
        Component[] components = gridPanel.getComponents();
        int rowCount = components.length / 3;
        if (components.length % 3 == 0) {
            --rowCount;
        }
        for (Component component2 : components) {
            ((JComponent)component2).setBorder(new CompoundBorder((Border)new CustomLineBorder(ColorUtil.withAlpha((Color)JBColor.foreground(), (double)0.2), 0, 0, cursor / 3 <= rowCount - 1 ? 1 : 0, cursor % 3 != 2 ? 1 : 0){

                protected Color getColor() {
                    return ColorUtil.withAlpha((Color)JBColor.foreground(), (double)0.2);
                }
            }, BorderFactory.createEmptyBorder(10, 20, 10, 20)));
            ++cursor;
        }
    }

    static JBScrollPane createScrollPane(JPanel gridPanel) {
        JBScrollPane scrollPane = new JBScrollPane((Component)gridPanel, 20, 31);
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        return scrollPane;
    }

    private void setButtonsVisible(boolean visible) {
        DialogWrapper window = DialogWrapper.findInstance((Component)this);
        if (window instanceof CustomizeIDEWizardDialog) {
            ((CustomizeIDEWizardDialog)window).setButtonsVisible(visible);
        }
    }

    @NotNull
    private LinkLabel<LinkDescription> createLink(LinkDescription command, final TextProvider provider2) {
        LinkListener<LinkDescription> listener2 = new LinkListener<LinkDescription>(){

            public void linkSelected(LinkLabel<LinkDescription> aSource, @NonNls LinkDescription description) {
                String groupId2 = description.groupId;
                if (CustomizePluginsStepPanel.SWITCH_COMMAND.equals(description.command)) {
                    boolean enabled = CustomizePluginsStepPanel.this.isGroupEnabled(description.groupId);
                    CustomizeIDEWizardInteractions.INSTANCE.record(enabled ? CustomizeIDEWizardInteractionType.BundledPluginGroupDisabled : CustomizeIDEWizardInteractionType.BundledPluginGroupEnabled, null, groupId2);
                    List<IdSet> sets = CustomizePluginsStepPanel.this.myPluginGroups.getSets(groupId2);
                    for (IdSet idSet : sets) {
                        for (PluginId id2 : idSet.getIds()) {
                            CustomizePluginsStepPanel.this.myPluginGroups.setPluginEnabledWithDependencies(id2, !enabled);
                        }
                    }
                    CustomizePluginsStepPanel.this.repaint();
                    return;
                }
                if (CustomizePluginsStepPanel.CUSTOMIZE_COMMAND.equals(description.command)) {
                    CustomizeIDEWizardInteractions.INSTANCE.record(CustomizeIDEWizardInteractionType.BundledPluginGroupCustomized, null, groupId2);
                    CustomizePluginsStepPanel.this.myCustomizePanel.update(description.groupId, description.groupName);
                    CustomizePluginsStepPanel.this.myCardLayout.show((Container)CustomizePluginsStepPanel.this, CustomizePluginsStepPanel.CUSTOMIZE);
                    CustomizePluginsStepPanel.this.setButtonsVisible(false);
                }
            }
        };
        return new LinkLabel<LinkDescription>("", null, (LinkListener)listener2, command){

            public String getText() {
                return provider2.getText();
            }
        };
    }

    TextProvider getGroupSwitchTextProvider(final String groupId2) {
        return new TextProvider(){

            @Override
            public String getText() {
                return IdeBundle.message((String)"link.label.choice.disable.enable.choice.all", (Object[])new Object[]{CustomizePluginsStepPanel.this.isGroupEnabled(groupId2) ? 0 : 1, CustomizePluginsStepPanel.this.myPluginGroups.getSets(groupId2).size() > 1 ? 0 : 1});
            }
        };
    }

    private boolean isGroupEnabled(String group2) {
        List<IdSet> sets = this.myPluginGroups.getSets(group2);
        for (IdSet idSet : sets) {
            for (PluginId id2 : idSet.getIds()) {
                if (!this.myPluginGroups.isPluginEnabled(id2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getTitle() {
        return IdeBundle.message((String)"step.title.default.plugins", (Object[])new Object[0]);
    }

    @Override
    public String getHTMLHeader() {
        return IdeBundle.message((String)"label.tune.0.to.your.tasks", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName(), ApplicationNamesInfo.getInstance().getFullProductName()});
    }

    @Override
    public boolean beforeOkAction() {
        DisabledPluginsState.trySaveDisabledPlugins(this.myPluginGroups.getDisabledPluginIds());
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginGroups", "com/intellij/ide/customize/CustomizePluginsStepPanel", "<init>"));
    }

    private static interface TextProvider {
        @NlsContexts.LinkLabel
        public String getText();
    }

    private static class LinkDescription {
        @NonNls
        @NotNull
        final String command;
        @NonNls
        @NotNull
        final String groupId;
        @Nls
        @NotNull
        final String groupName;

        private LinkDescription(@NonNls @NotNull String command, @NotNull PluginGroups.Group group2) {
            if (command == null) {
                LinkDescription.$$$reportNull$$$0(0);
            }
            if (group2 == null) {
                LinkDescription.$$$reportNull$$$0(1);
            }
            this.command = command;
            this.groupId = group2.getId();
            this.groupName = group2.getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "command";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "group";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/customize/CustomizePluginsStepPanel$LinkDescription";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class IdSetPanel
    extends JPanel
    implements LinkListener<String> {
        private final JLabel myTitleLabel = new JLabel();
        private final JPanel myContentPanel = new JPanel(new GridLayout(0, 3, 5, 5));
        private String myGroup;

        private IdSetPanel() {
            this.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 20, true, false));
            this.add(this.myTitleLabel);
            this.add(this.myContentPanel);
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets.right = 25;
            gbc.gridy = 0;
            JButton saveButton = new JButton(IdeBundle.message((String)"button.save.changes.and.go.back", (Object[])new Object[0]));
            buttonPanel.add((Component)saveButton, gbc);
            buttonPanel.add((Component)new LinkLabel(IdeBundle.message((String)"link.enable.all", (Object[])new Object[0]), null, (LinkListener)this, (Object)"enable"), gbc);
            buttonPanel.add((Component)new LinkLabel(IdeBundle.message((String)"link.disable.all", (Object[])new Object[0]), null, (LinkListener)this, (Object)"disable"), gbc);
            gbc.weightx = 1.0;
            buttonPanel.add(Box.createHorizontalGlue(), gbc);
            this.add(buttonPanel);
            saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomizePluginsStepPanel.this.myCardLayout.show((Container)CustomizePluginsStepPanel.this, CustomizePluginsStepPanel.MAIN);
                    CustomizePluginsStepPanel.this.setButtonsVisible(true);
                }
            });
        }

        public void linkSelected(LinkLabel<String> aSource, String command) {
            if (this.myGroup == null) {
                return;
            }
            boolean enable = "enable".equals(command);
            List<IdSet> idSets = CustomizePluginsStepPanel.this.myPluginGroups.getSets(this.myGroup);
            for (IdSet set2 : idSets) {
                CustomizePluginsStepPanel.this.myPluginGroups.setIdSetEnabled(set2, enable);
            }
            CustomizePluginsStepPanel.this.repaint();
        }

        void update(@NonNls String groupId2, @Nls String groupName) {
            this.myGroup = groupId2;
            HtmlChunk.Element titleHtml = HtmlChunk.text((String)groupName).bold().wrapWith(HtmlChunk.html());
            this.myTitleLabel.setText(titleHtml.toString());
            this.myContentPanel.removeAll();
            List<IdSet> idSets = CustomizePluginsStepPanel.this.myPluginGroups.getSets(groupId2);
            for (final IdSet set2 : idSets) {
                final JCheckBox checkBox2 = new JCheckBox(set2.getTitle(), CustomizePluginsStepPanel.this.myPluginGroups.isIdSetAllEnabled(set2));
                checkBox2.setModel(new JToggleButton.ToggleButtonModel(){

                    @Override
                    public boolean isSelected() {
                        return CustomizePluginsStepPanel.this.myPluginGroups.isIdSetAllEnabled(set2);
                    }
                });
                checkBox2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CustomizePluginsStepPanel.this.myPluginGroups.setIdSetEnabled(set2, !checkBox2.isSelected());
                        CustomizePluginsStepPanel.this.repaint();
                    }
                });
                this.myContentPanel.add(checkBox2);
            }
        }
    }
}

