/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.actions.WebPreviewVirtualFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.ui.jcef.JCEFHtmlPanel;
import com.intellij.util.Alarm;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebPreviewFileEditor
extends UserDataHolderBase
implements FileEditor {
    private final VirtualFile myFile;
    private final JCEFHtmlPanel myPanel;
    private String myUrl;

    public WebPreviewFileEditor(final @NotNull Project project, @NotNull WebPreviewVirtualFile file2) {
        if (project == null) {
            WebPreviewFileEditor.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            WebPreviewFileEditor.$$$reportNull$$$0(1);
        }
        this.myFile = file2.getOriginalFile();
        this.myPanel = new JCEFHtmlPanel(file2.getPreviewUrl().toExternalForm());
        final Alarm alarm2 = new Alarm((Disposable)this);
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(this.myFile);
        if (psiFile != null) {
            this.myUrl = file2.getPreviewUrl().toExternalForm();
            this.reloadPage();
            project.getMessageBus().connect((Disposable)alarm2).subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, (Object)new AnyPsiChangeListener(){

                @Override
                public void afterPsiChanged(boolean isPhysical) {
                    PsiFile psi = PsiManager.getInstance((Project)project).findFile(WebPreviewFileEditor.this.myFile);
                    if (psi != null) {
                        alarm2.cancelAllRequests();
                        alarm2.addRequest(() -> WebPreviewFileEditor.this.reloadPage(), 100);
                    }
                }
            });
        }
    }

    private void reloadPage() {
        FileDocumentManager.getInstance().saveAllDocuments();
        ApplicationManager.getApplication().saveAll();
        this.myPanel.loadURL(this.myUrl);
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myPanel.getComponent();
        if (jComponent == null) {
            WebPreviewFileEditor.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getComponent();
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    public String getName() {
        String string = IdeBundle.message((String)"web.preview.file.editor.name", (Object[])new Object[]{this.myFile.getName()});
        if (string == null) {
            WebPreviewFileEditor.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            WebPreviewFileEditor.$$$reportNull$$$0(4);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            WebPreviewFileEditor.$$$reportNull$$$0(5);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            WebPreviewFileEditor.$$$reportNull$$$0(6);
        }
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/browsers/actions/WebPreviewFileEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/browsers/actions/WebPreviewFileEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

