/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks.actions;

import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.bookmarks.BookmarkType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.Point;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010 \u001a\u00020\tH\u00c6\u0003J3\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0014\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0002J\u0019\u0010)\u001a\u0004\u0018\u00010*2\b\u0010'\u001a\u0004\u0018\u00010(H\u0000\u00a2\u0006\u0002\b+J\t\u0010,\u001a\u00020\tH\u00d6\u0001J\u000e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200J\t\u00101\u001a\u000202H\u00d6\u0001R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0015\u001a\u00020\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00063"}, d2={"Lcom/intellij/ide/bookmarks/actions/BookmarkContext;", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "line", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/editor/Editor;I)V", "bookmark", "Lcom/intellij/ide/bookmarks/Bookmark;", "getBookmark", "()Lcom/intellij/ide/bookmarks/Bookmark;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getLine", "()I", "manager", "Lcom/intellij/ide/bookmarks/BookmarkManager;", "getManager", "()Lcom/intellij/ide/bookmarks/BookmarkManager;", "manager$delegate", "Lkotlin/Lazy;", "getProject", "()Lcom/intellij/openapi/project/Project;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "getGutter", "Lcom/intellij/openapi/editor/ex/EditorGutterComponentEx;", "component", "Ljava/awt/Component;", "getPointOnGutter", "Lcom/intellij/ui/awt/RelativePoint;", "getPointOnGutter$intellij_platform_lang_impl", "hashCode", "setType", "", "type", "Lcom/intellij/ide/bookmarks/BookmarkType;", "toString", "", "intellij.platform.lang.impl"})
public final class BookmarkContext {
    @NotNull
    private final Lazy manager$delegate;
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile file;
    @Nullable
    private final Editor editor;
    private final int line;

    @NotNull
    public final BookmarkManager getManager() {
        Lazy lazy = this.manager$delegate;
        BookmarkContext bookmarkContext = this;
        Object var3_3 = null;
        boolean bl = false;
        return (BookmarkManager)lazy.getValue();
    }

    @Nullable
    public final Bookmark getBookmark() {
        return this.getManager().findBookmark(this.file, this.line);
    }

    public final void setType(@NotNull BookmarkType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Bookmark bookmark = this.getManager().findBookmark(this.file, this.line);
        if (bookmark == null) {
            boolean bl;
            boolean bl2 = bl = this.editor != null;
            if (bl) {
                this.getManager().addEditorBookmark(this.editor, this.line);
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)this.getManager().addTextBookmark(this.file, this.line, ""), (String)"manager.addTextBookmark(file, line, \"\")");
            }
            Bookmark bookmark2 = this.getManager().findBookmark(this.file, this.line);
            if (bookmark2 != null) {
                Bookmark bookmark3 = bookmark2;
                boolean bl3 = false;
                boolean bl4 = false;
                Bookmark it = bookmark3;
                boolean bl5 = false;
                if (BookmarkType.DEFAULT != type) {
                    this.getManager().setMnemonic(it, type.getMnemonic());
                }
            }
        } else if (bookmark.getMnemonic() == type.getMnemonic()) {
            this.getManager().removeBookmark(bookmark);
        } else {
            this.getManager().setMnemonic(bookmark, type.getMnemonic());
        }
    }

    @Nullable
    public final RelativePoint getPointOnGutter$intellij_platform_lang_impl(@Nullable Component component2) {
        RelativePoint relativePoint;
        if (this.editor == null || this.line < 0) {
            relativePoint = null;
        } else {
            EditorGutterComponentEx editorGutterComponentEx = this.getGutter(component2);
            if (editorGutterComponentEx != null) {
                EditorGutterComponentEx editorGutterComponentEx2 = editorGutterComponentEx;
                boolean bl = false;
                boolean bl2 = false;
                EditorGutterComponentEx it = editorGutterComponentEx2;
                boolean bl3 = false;
                Point point = this.editor.logicalPositionToXY(new LogicalPosition(this.line, 0));
                boolean bl4 = false;
                boolean bl5 = false;
                Point point2 = point;
                Component component3 = it;
                boolean bl6 = false;
                $this$apply.x = it.getIconAreaOffset();
                $this$apply.y += this.editor.getLineHeight();
                Unit unit = Unit.INSTANCE;
                Point point3 = point;
                Component component4 = component3;
                relativePoint = new RelativePoint(component4, point3);
            } else {
                relativePoint = null;
            }
        }
        return relativePoint;
    }

    private final EditorGutterComponentEx getGutter(Component component2) {
        EditorGutterComponentEx editorGutterComponentEx;
        Component component3 = component2;
        if (!(component3 instanceof EditorGutterComponentEx)) {
            component3 = null;
        }
        if ((editorGutterComponentEx = (EditorGutterComponentEx)component3) == null) {
            boolean bl = Registry.is((String)"ide.bookmark.mnemonic.chooser.always.above.gutter");
            if (bl) {
                Editor editor = this.editor;
                Object object = editor != null ? editor.getGutter() : null;
                if (!(object instanceof EditorGutterComponentEx)) {
                    object = null;
                }
                editorGutterComponentEx = (EditorGutterComponentEx)object;
            } else {
                editorGutterComponentEx = null;
            }
        }
        return editorGutterComponentEx;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @Nullable
    public final Editor getEditor() {
        return this.editor;
    }

    public final int getLine() {
        return this.line;
    }

    public BookmarkContext(@NotNull Project project, @NotNull VirtualFile file2, @Nullable Editor editor, int line) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.project = project;
        this.file = file2;
        this.editor = editor;
        this.line = line;
        this.manager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BookmarkManager>(this){
            final /* synthetic */ BookmarkContext this$0;

            public final BookmarkManager invoke() {
                return BookmarkManager.getInstance(this.this$0.getProject());
            }
            {
                this.this$0 = bookmarkContext;
                super(0);
            }
        }));
    }

    @NotNull
    public final Project component1() {
        return this.project;
    }

    @NotNull
    public final VirtualFile component2() {
        return this.file;
    }

    @Nullable
    public final Editor component3() {
        return this.editor;
    }

    public final int component4() {
        return this.line;
    }

    @NotNull
    public final BookmarkContext copy(@NotNull Project project, @NotNull VirtualFile file2, @Nullable Editor editor, int line) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return new BookmarkContext(project, file2, editor, line);
    }

    public static /* synthetic */ BookmarkContext copy$default(BookmarkContext bookmarkContext, Project project, VirtualFile virtualFile, Editor editor, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            project = bookmarkContext.project;
        }
        if ((n2 & 2) != 0) {
            virtualFile = bookmarkContext.file;
        }
        if ((n2 & 4) != 0) {
            editor = bookmarkContext.editor;
        }
        if ((n2 & 8) != 0) {
            n = bookmarkContext.line;
        }
        return bookmarkContext.copy(project, virtualFile, editor, n);
    }

    @NotNull
    public String toString() {
        return "BookmarkContext(project=" + this.project + ", file=" + this.file + ", editor=" + this.editor + ", line=" + this.line + ")";
    }

    public int hashCode() {
        Project project = this.project;
        VirtualFile virtualFile = this.file;
        Editor editor = this.editor;
        return (((project != null ? project.hashCode() : 0) * 31 + (virtualFile != null ? virtualFile.hashCode() : 0)) * 31 + (editor != null ? editor.hashCode() : 0)) * 31 + Integer.hashCode(this.line);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof BookmarkContext)) break block3;
                BookmarkContext bookmarkContext = (BookmarkContext)object;
                if (!Intrinsics.areEqual((Object)this.project, (Object)bookmarkContext.project) || !Intrinsics.areEqual((Object)this.file, (Object)bookmarkContext.file) || !Intrinsics.areEqual((Object)this.editor, (Object)bookmarkContext.editor) || this.line != bookmarkContext.line) break block3;
            }
            return true;
        }
        return false;
    }
}

