/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks;

import com.intellij.ide.bookmarks.BookmarkTypeKt;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.util.ui.RegionPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016J:\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010\u0017\u001a\u00020\u0004H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ide/bookmarks/MnemonicPainter;", "Lcom/intellij/util/ui/RegionPainter;", "Ljava/awt/Component;", "mnemonic", "", "(Ljava/lang/String;)V", "getMnemonic", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "paint", "", "g", "Ljava/awt/Graphics2D;", "x", "y", "width", "height", "c", "toString", "intellij.platform.lang.impl"})
final class MnemonicPainter
implements RegionPainter<Component> {
    @NotNull
    private final String mnemonic;

    @NotNull
    public String toString() {
        return "MnemonicIcon:" + this.mnemonic;
    }

    public int hashCode() {
        return this.mnemonic.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        Object object = other;
        if (!(object instanceof MnemonicPainter)) {
            object = null;
        }
        MnemonicPainter mnemonicPainter = (MnemonicPainter)object;
        if (mnemonicPainter == null) {
            return false;
        }
        MnemonicPainter painter = mnemonicPainter;
        return Intrinsics.areEqual((Object)painter.mnemonic, (Object)this.mnemonic);
    }

    public void paint(@NotNull Graphics2D g, int x, int y, int width, int height, @Nullable Component c) {
        Integer round;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Color foreground = EditorColorsUtil.getColor((Component)c, (ColorKey)BookmarkTypeKt.access$getMNEMONIC_ICON_FOREGROUND$p());
        Color background = EditorColorsUtil.getColor((Component)c, (ColorKey)BookmarkTypeKt.access$getMNEMONIC_ICON_BACKGROUND$p());
        Color borderColor = EditorColorsUtil.getColor((Component)c, (ColorKey)BookmarkTypeKt.access$getMNEMONIC_ICON_BORDER_COLOR$p());
        int divisor = Registry.intValue((String)"ide.mnemonic.icon.round", (int)0);
        Integer n = round = divisor > 0 ? Integer.valueOf(RangesKt.coerceAtLeast((int)width, (int)height) / divisor) : null;
        if (background != null) {
            g.setPaint(background);
            RectanglePainter.FILL.paint(g, x, y, width, height, (Object)round);
        }
        if (foreground != null) {
            GlyphVector vector2;
            Rectangle2D bounds1;
            GlyphVector vector1;
            g.setPaint(foreground);
            UISettings.Companion.setupAntialiasing((Graphics)g);
            FontRenderContext frc = g.getFontRenderContext();
            Font font = EditorFontType.PLAIN.getGlobalFont();
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"EditorFontType.PLAIN.globalFont");
            Font font2 = font;
            float size1 = 0.8f * (float)height;
            GlyphVector glyphVector = vector1 = font2.deriveFont(size1).createGlyphVector(frc, this.mnemonic);
            Intrinsics.checkNotNullExpressionValue((Object)glyphVector, (String)"vector1");
            Rectangle2D rectangle2D = bounds1 = glyphVector.getVisualBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"bounds1");
            float size2 = 0.8f * size1 * size1 / (float)rectangle2D.getHeight();
            GlyphVector glyphVector2 = vector2 = font2.deriveFont(size2).createGlyphVector(frc, this.mnemonic);
            Intrinsics.checkNotNullExpressionValue((Object)glyphVector2, (String)"vector2");
            Rectangle2D bounds2 = glyphVector2.getVisualBounds();
            double d = x;
            Rectangle2D rectangle2D2 = bounds2;
            Intrinsics.checkNotNullExpressionValue((Object)rectangle2D2, (String)"bounds2");
            double dx = d - rectangle2D2.getX() + 0.5 * ((double)width - bounds2.getWidth());
            double dy = (double)y - bounds2.getY() + 0.5 * ((double)height - bounds2.getHeight());
            g.drawGlyphVector(vector2, (float)dx, (float)dy);
        }
        if (borderColor != null && Intrinsics.areEqual((Object)borderColor, (Object)background) ^ true) {
            g.setPaint(borderColor);
            RectanglePainter.DRAW.paint(g, x, y, width, height, (Object)round);
        }
    }

    @NotNull
    public final String getMnemonic() {
        return this.mnemonic;
    }

    public MnemonicPainter(@NotNull String mnemonic) {
        Intrinsics.checkNotNullParameter((Object)mnemonic, (String)"mnemonic");
        this.mnemonic = mnemonic;
    }
}

