/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks;

import com.intellij.ide.bookmarks.BookmarkTypeKt;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.util.ui.RegionPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0096\u0002J\b\u0010\b\u001a\u00020\tH\u0016J:\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ide/bookmarks/BookmarkPainter;", "Lcom/intellij/util/ui/RegionPainter;", "Ljava/awt/Component;", "()V", "equals", "", "other", "", "hashCode", "", "paint", "", "g", "Ljava/awt/Graphics2D;", "x", "y", "width", "height", "c", "toString", "", "intellij.platform.lang.impl"})
final class BookmarkPainter
implements RegionPainter<Component> {
    @NotNull
    public String toString() {
        return "BookmarkIcon";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof BookmarkPainter;
    }

    public void paint(@NotNull Graphics2D g, int x, int y, int width, int height, @Nullable Component c) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Color background = EditorColorsUtil.getColor((Component)c, (ColorKey)BookmarkTypeKt.access$getBOOKMARK_ICON_BACKGROUND$p());
        if (background != null) {
            float xL = (float)width / 6.0f;
            float xR = (float)width - xL;
            float xC = (float)width / 2.0f;
            float yT = (float)height / 24.0f;
            float yB = (float)height - yT;
            float yC = yB + xL - xC;
            Path2D.Float path = new Path2D.Float();
            path.moveTo((float)x + xL, (float)y + yT);
            path.lineTo((float)x + xL, (float)y + yB);
            path.lineTo((float)x + xC, (float)y + yC);
            path.lineTo((float)x + xR, (float)y + yB);
            path.lineTo((float)x + xR, (float)y + yT);
            path.closePath();
            g.setPaint(background);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.fill(path);
        }
    }
}

