/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.actions.OpenInRightSplitAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.IconUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBListWithOpenInRightSplit<T>
extends JBList<T> {
    @Nullable
    private Point myMousePoint;
    @Nullable
    private final HelpTooltip myTooltip;
    @Nullable
    private final Condition<? super T> myCheckRightSplitter;
    private final boolean myShowIconInVisibleArea;

    @NotNull
    public static <T> JBList<T> createListWithOpenInRightSplitter(@NotNull Condition<? super T> isSplitterAvailable) {
        if (isSplitterAvailable == null) {
            JBListWithOpenInRightSplit.$$$reportNull$$$0(0);
        }
        return JBListWithOpenInRightSplit.createListWithOpenInRightSplitter(JBListWithOpenInRightSplit.createDefaultListModel((Object[])new Object[0]), isSplitterAvailable);
    }

    @NotNull
    public static <T> JBList<T> createListWithOpenInRightSplitter(@NotNull ListModel<T> dataModel, @Nullable Condition<? super T> checkRightSplitter) {
        if (dataModel == null) {
            JBListWithOpenInRightSplit.$$$reportNull$$$0(1);
        }
        return JBListWithOpenInRightSplit.createListWithOpenInRightSplitter(dataModel, checkRightSplitter, false);
    }

    @NotNull
    public static <T> JBList<T> createListWithOpenInRightSplitter(@NotNull ListModel<T> dataModel, @Nullable Condition<? super T> checkRightSplitter, boolean showIconInVisibleArea) {
        if (dataModel == null) {
            JBListWithOpenInRightSplit.$$$reportNull$$$0(2);
        }
        return Registry.is((String)"lists.use.open.in.right.splitter") ? new JBListWithOpenInRightSplit<T>(dataModel, checkRightSplitter, showIconInVisibleArea) : new JBList(dataModel);
    }

    private boolean isHovered() {
        int index2;
        int n = index2 = this.myMousePoint == null ? -1 : this.locationToIndex(this.myMousePoint);
        if (index2 == -1) {
            return false;
        }
        Object at = this.getModel().getElementAt(index2);
        if (!this.canOpenInSplitter(at)) {
            return false;
        }
        return this.getIconRectangle(index2).contains(this.myMousePoint);
    }

    public JBListWithOpenInRightSplit(@NotNull ListModel<T> dataModel, @Nullable Condition<? super T> checkRightSplitter, boolean showIconInVisibleArea) {
        if (dataModel == null) {
            JBListWithOpenInRightSplit.$$$reportNull$$$0(3);
        }
        super(dataModel);
        this.myCheckRightSplitter = checkRightSplitter;
        this.myShowIconInVisibleArea = showIconInVisibleArea;
        JBFileMouseHandler handler2 = new JBFileMouseHandler();
        AnAction action2 = ActionManager.getInstance().getAction(this.getActionId());
        if (action2 != null) {
            String text2 = KeymapUtil.getFirstKeyboardShortcutText((AnAction)action2);
            this.myTooltip = new HelpTooltip().setTitle(StringUtil.notNullize((String)action2.getTemplatePresentation().getText())).setShortcut(text2);
            this.myTooltip.installOn((JComponent)((Object)this));
            HelpTooltip.setMasterPopupOpenCondition((Component)((Object)this), () -> this.isHovered());
        } else {
            this.myTooltip = null;
        }
        if (action2 != null) {
            OpenInRightSplitAction.Companion.overrideDoubleClickWithOneClick((JComponent)((Object)this));
        }
        this.addMouseListener(handler2);
        this.addMouseMotionListener(handler2);
    }

    public void repaint(long tm, int x, int y, int width, int height) {
        super.repaint(tm, x, y, width, height);
    }

    public void paint(Graphics g) {
        Rectangle iconRect;
        int index2;
        super.paint(g);
        boolean isSelectedUnderMouse = false;
        if (this.myMousePoint != null && (index2 = this.locationToIndex(this.myMousePoint)) != -1 && this.canOpenInSplitter(this.getModel().getElementAt(index2))) {
            isSelectedUnderMouse = this.getSelectedIndex() == index2;
            iconRect = this.getIconRectangle(index2);
            boolean isIconHover = this.myMousePoint != null && iconRect.contains(this.myMousePoint);
            Icon icon2 = this.getIcon();
            if (isSelectedUnderMouse) {
                icon2 = IconLoader.getDarkIcon((Icon)icon2, (boolean)true);
            }
            if (!isIconHover && !isSelectedUnderMouse) {
                icon2 = IconLoader.getTransparentIcon((Icon)icon2);
            }
            icon2 = JBListWithOpenInRightSplit.toSize(icon2);
            icon2.paintIcon((Component)((Object)this), g, iconRect.x, iconRect.y);
        }
        if ((index2 = this.getSelectedIndex()) != -1 && !isSelectedUnderMouse && this.canOpenInSplitter(this.getModel().getElementAt(index2))) {
            iconRect = this.getIconRectangle(index2);
            Icon icon3 = this.getIcon();
            icon3 = IconLoader.getDarkIcon((Icon)icon3, (boolean)true);
            icon3 = JBListWithOpenInRightSplit.toSize(icon3);
            icon3.paintIcon((Component)((Object)this), g, iconRect.x, iconRect.y);
        }
    }

    protected boolean canOpenInSplitter(@NotNull T item) {
        if (item == null) {
            JBListWithOpenInRightSplit.$$$reportNull$$$0(4);
        }
        return this.myCheckRightSplitter == null || this.myCheckRightSplitter.value(item);
    }

    @NotNull
    protected Rectangle getIconRectangle(int index2) {
        Rectangle bounds2 = this.getCellBounds(index2, index2);
        if (this.myShowIconInVisibleArea) {
            Rectangle visibleRect = this.getVisibleRect();
            visibleRect.setSize(visibleRect.width - this.getInsets().right, visibleRect.height);
            bounds2 = bounds2.intersection(visibleRect);
        }
        Icon icon2 = JBListWithOpenInRightSplit.toSize(this.getIcon());
        return new Rectangle((int)bounds2.getMaxX() - icon2.getIconWidth(), bounds2.y + (bounds2.height - icon2.getIconHeight()) / 2, icon2.getIconWidth(), icon2.getIconHeight());
    }

    @NotNull
    private static Icon toSize(@NotNull Icon icon2) {
        if (icon2 == null) {
            JBListWithOpenInRightSplit.$$$reportNull$$$0(5);
        }
        Dimension defaultSize = ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE;
        Icon icon3 = IconUtil.toSize(icon2, (int)defaultSize.getWidth(), (int)defaultSize.getHeight());
        if (icon3 == null) {
            JBListWithOpenInRightSplit.$$$reportNull$$$0(6);
        }
        return icon3;
    }

    protected void invokeAction() {
        HelpTooltip.dispose((Component)((Object)this));
        AnAction action2 = ActionManager.getInstance().getAction(this.getActionId());
        DataContext context = DataManager.getInstance().getDataContext((Component)((Object)this));
        action2.actionPerformed(AnActionEvent.createFromDataContext((String)((Object)((Object)this)).getClass().getName(), null, (DataContext)context));
    }

    public Dimension getPreferredSize() {
        Dimension size = new Dimension(super.getPreferredSize());
        size.width += ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.width;
        return size;
    }

    @NotNull
    @NonNls
    protected String getActionId() {
        return "OpenInRightSplit";
    }

    @NotNull
    protected Icon getIcon() {
        Icon icon2 = AllIcons.Actions.SplitVertically;
        if (icon2 == null) {
            JBListWithOpenInRightSplit.$$$reportNull$$$0(7);
        }
        return icon2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isSplitterAvailable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ui/JBListWithOpenInRightSplit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ui/JBListWithOpenInRightSplit";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toSize";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createListWithOpenInRightSplitter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canOpenInSplitter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toSize";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class JBFileMouseHandler
    extends MouseAdapter {
        private JBFileMouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JBListWithOpenInRightSplit.this.myMousePoint = e != null ? e.getPoint() : null;
            this.updateHover();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JBListWithOpenInRightSplit.this.myMousePoint = null;
            this.updateHover();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JBListWithOpenInRightSplit.this.myMousePoint = e != null ? e.getPoint() : null;
            this.updateHover();
        }

        private void updateHover() {
            boolean isHovered = JBListWithOpenInRightSplit.this.isHovered();
            JBListWithOpenInRightSplit.this.setCursor(isHovered ? Cursor.getPredefinedCursor(12) : null);
            if (JBListWithOpenInRightSplit.this.myTooltip != null && !isHovered) {
                HelpTooltip.hide((Component)((Object)JBListWithOpenInRightSplit.this));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Point point = e.getPoint();
            int index2 = JBListWithOpenInRightSplit.this.locationToIndex(point);
            if (index2 != -1 && JBListWithOpenInRightSplit.this.getIconRectangle(index2).contains(point)) {
                JBListWithOpenInRightSplit.this.invokeAction();
                e.consume();
            }
        }
    }
}

