/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere.statistics;

import com.intellij.ide.actions.searcheverywhere.statistics.SearchEverywhereUsageTriggerCollector;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;

public final class SearchFieldStatisticsCollector
implements Disposable {
    private final Project myProject;
    private final JTextField myTextField;
    private int mySymbolKeysTyped;
    private int myNavKeysTyped;

    private SearchFieldStatisticsCollector(JTextField field, Project project) {
        this.myProject = project;
        this.myTextField = field;
    }

    public static SearchFieldStatisticsCollector createAndStart(JTextField field, Project project) {
        SearchFieldStatisticsCollector res2 = new SearchFieldStatisticsCollector(field, project);
        res2.initListeners();
        return res2;
    }

    public void dispose() {
        this.saveStat();
    }

    private void initListeners() {
        this.myTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                ++SearchFieldStatisticsCollector.this.mySymbolKeysTyped;
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int code = e.getKeyCode();
                if (code == 38 || code == 224 || code == 33 || code == 40 || code == 225 || code == 34) {
                    ++SearchFieldStatisticsCollector.this.myNavKeysTyped;
                }
            }
        });
    }

    private void saveStat() {
        FeatureUsageData data2 = new FeatureUsageData().addData("typedNavigationKeys", this.myNavKeysTyped).addData("typedSymbolKeys", this.mySymbolKeysTyped);
        SearchEverywhereUsageTriggerCollector.trigger(this.myProject, "sessionFinished", data2);
    }
}

