/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.ide.actions.searcheverywhere.SearchListModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class MixedSearchListModel
extends SearchListModel {
    private static final Logger LOG = Logger.getInstance(MixedSearchListModel.class);
    private final Map<SearchEverywhereContributor<?>, Boolean> hasMoreContributors = new HashMap();
    private Comparator<? super SearchEverywhereFoundElementInfo> myElementsComparator = SearchEverywhereFoundElementInfo.COMPARATOR.reversed();
    private int myMaxFrozenIndex;

    MixedSearchListModel() {
    }

    public void setElementsComparator(Comparator<? super SearchEverywhereFoundElementInfo> elementsComparator) {
        this.myElementsComparator = elementsComparator;
    }

    @Override
    public boolean hasMoreElements(SearchEverywhereContributor<?> contributor) {
        return Boolean.TRUE.equals(this.hasMoreContributors.get(contributor));
    }

    @Override
    public int getIndexToScroll(int currentIndex, boolean scrollDown) {
        return scrollDown ? this.getSize() - 1 : 0;
    }

    @Override
    public void addElements(List<? extends SearchEverywhereFoundElementInfo> items) {
        if (items.isEmpty()) {
            return;
        }
        items = items.stream().sorted(this.myElementsComparator).collect(Collectors.toList());
        if (this.resultsExpired) {
            this.clearMoreItems();
            Object[] oldItems = ArrayUtil.toObjectArray(this.getItems());
            Object[] newItems = items.stream().map(SearchEverywhereFoundElementInfo::getElement).toArray();
            try {
                Diff.Change change = Diff.buildChanges((Object[])oldItems, (Object[])newItems);
                this.applyChange(change, items);
            }
            catch (FilesTooBigForDiffException e) {
                LOG.error("Cannot calculate diff for updated search results");
            }
            this.resultsExpired = false;
        } else {
            int startIndex = this.listElements.size();
            this.listElements.addAll(items);
            int endIndex = this.listElements.size() - 1;
            this.fireIntervalAdded(this, startIndex, endIndex);
            if (startIndex > 0) {
                List<? super SearchEverywhereFoundElementInfo> lst = this.myMaxFrozenIndex >= 0 ? this.listElements.subList(this.myMaxFrozenIndex + 1, this.listElements.size()) : this.listElements;
                lst.sort(this.myElementsComparator);
                this.fireContentsChanged(this, 0, endIndex);
            }
        }
    }

    @Override
    public void clearMoreItems() {
        if (this.listElements.isEmpty()) {
            return;
        }
        int lastItemIndex = this.listElements.size() - 1;
        SearchEverywhereFoundElementInfo lastItem = (SearchEverywhereFoundElementInfo)this.listElements.get(lastItemIndex);
        if (lastItem.getElement() == MORE_ELEMENT) {
            this.listElements.remove(lastItemIndex);
            this.fireIntervalRemoved(this, lastItemIndex, lastItemIndex);
        }
    }

    private void applyChange(Diff.Change change, List<? extends SearchEverywhereFoundElementInfo> newItems) {
        for (Diff.Change ch : MixedSearchListModel.toRevertedList(change)) {
            if (ch.deleted > 0) {
                this.listElements.subList(ch.line0, ch.line0 + ch.deleted).clear();
                this.fireIntervalRemoved(this, ch.line0, ch.line0 + ch.deleted - 1);
            }
            if (ch.inserted <= 0) continue;
            List<? extends SearchEverywhereFoundElementInfo> addedItems = newItems.subList(ch.line1, ch.line1 + ch.inserted);
            this.listElements.addAll(ch.line0, addedItems);
            this.fireIntervalAdded(this, ch.line0, ch.line0 + ch.inserted - 1);
        }
    }

    private static List<Diff.Change> toRevertedList(Diff.Change change) {
        ArrayList<Diff.Change> res2 = new ArrayList<Diff.Change>();
        while (change != null) {
            res2.add(0, change);
            change = change.link;
        }
        return res2;
    }

    @Override
    public void removeElement(@NotNull Object item, SearchEverywhereContributor<?> contributor) {
        if (item == null) {
            MixedSearchListModel.$$$reportNull$$$0(0);
        }
        if (this.listElements.isEmpty()) {
            return;
        }
        for (int i2 = 0; i2 < this.listElements.size(); ++i2) {
            SearchEverywhereFoundElementInfo info = (SearchEverywhereFoundElementInfo)this.listElements.get(i2);
            if (info.getContributor() != contributor || !info.getElement().equals(item)) continue;
            this.listElements.remove(i2);
            this.fireIntervalRemoved(this, i2, i2);
            return;
        }
        if (this.myMaxFrozenIndex >= this.getSize()) {
            this.myMaxFrozenIndex = this.getSize() - 1;
        }
    }

    @Override
    public void setHasMore(SearchEverywhereContributor<?> contributor, boolean contributorHasMore) {
        this.hasMoreContributors.put(contributor, contributorHasMore);
        int lasItemIndex = this.listElements.size() - 1;
        if (lasItemIndex < 0) {
            return;
        }
        boolean hasMore = this.hasMoreContributors.values().stream().anyMatch(val -> val);
        boolean alreadyHas = this.isMoreElement(lasItemIndex);
        if (alreadyHas && !hasMore) {
            this.listElements.remove(lasItemIndex);
            this.fireIntervalRemoved(this, lasItemIndex, lasItemIndex);
        }
        if (!alreadyHas && hasMore) {
            this.myMaxFrozenIndex = lasItemIndex++;
            this.listElements.add(new SearchEverywhereFoundElementInfo(MORE_ELEMENT, 0, null));
            this.fireIntervalAdded(this, lasItemIndex, lasItemIndex);
        }
    }

    @Override
    public void clear() {
        this.hasMoreContributors.clear();
        this.myMaxFrozenIndex = -1;
        super.clear();
    }

    @Override
    public void expireResults() {
        super.expireResults();
        this.myMaxFrozenIndex = -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/ide/actions/searcheverywhere/MixedSearchListModel", "removeElement"));
    }
}

