/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.SearchEverywhereClassifier;
import com.intellij.ide.actions.searcheverywhere.CalculatorSEContributor;
import com.intellij.ide.actions.searcheverywhere.MixedSearchListModel;
import com.intellij.ide.actions.searcheverywhere.RecentFilesSEContributor;
import com.intellij.ide.actions.searcheverywhere.SEResultsListFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereHeader;
import com.intellij.ide.actions.searcheverywhere.SearchListModel;
import com.intellij.ide.actions.searcheverywhere.TopHitSEContributor;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.SlowOperations;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;

class MixedListFactory
extends SEResultsListFactory {
    private final List<String> prioritizedContributors = new ArrayList<String>();

    MixedListFactory() {
        this.prioritizedContributors.add(CalculatorSEContributor.class.getName());
        this.prioritizedContributors.add("CommandsContributor");
        this.prioritizedContributors.add(TopHitSEContributor.class.getSimpleName());
        if (Registry.is((String)"search.everywhere.recent.at.top")) {
            this.prioritizedContributors.add(RecentFilesSEContributor.class.getSimpleName());
        }
    }

    @Override
    public SearchListModel createModel() {
        MixedSearchListModel mixedModel = new MixedSearchListModel();
        HashMap<String, Integer> priorities = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < this.prioritizedContributors.size(); ++i2) {
            priorities.put(this.prioritizedContributors.get(i2), this.prioritizedContributors.size() - i2);
        }
        Comparator prioritizedContributorsComparator = (element1, element2) -> {
            int firstElementPriority = priorities.getOrDefault(element1.getContributor().getSearchProviderId(), 0);
            int secondElementPriority = priorities.getOrDefault(element2.getContributor().getSearchProviderId(), 0);
            return Integer.compare(firstElementPriority, secondElementPriority);
        };
        Comparator<SearchEverywhereFoundElementInfo> comparator2 = prioritizedContributorsComparator.thenComparing(SearchEverywhereFoundElementInfo.COMPARATOR).reversed();
        mixedModel.setElementsComparator(comparator2);
        return mixedModel;
    }

    @Override
    public JBList<Object> createList(SearchListModel model2) {
        return new JBList((ListModel)model2);
    }

    @Override
    ListCellRenderer<Object> createListRenderer(final SearchListModel model2, SearchEverywhereHeader header2) {
        return new ListCellRenderer<Object>(){

            @Override
            public Component getListCellRendererComponent(JList<?> list2, Object value2, int index2, boolean isSelected, boolean cellHasFocus) {
                Border border;
                if (value2 == SearchListModel.MORE_ELEMENT) {
                    Component component2 = SEResultsListFactory.myMoreRenderer.getListCellRendererComponent(list2, value2, index2, isSelected, cellHasFocus);
                    component2.setPreferredSize(UIUtil.updateListRowHeight((Dimension)component2.getPreferredSize()));
                    return component2;
                }
                SearchEverywhereContributor contributor = model2.getContributorForIndex(index2);
                Component component3 = SearchEverywhereClassifier.EP_Manager.getListCellRendererComponent(list2, value2, index2, isSelected, cellHasFocus);
                if (component3 == null) {
                    ListCellRenderer renderer = contributor.getElementsRenderer();
                    component3 = (Component)SlowOperations.allowSlowOperations(() -> renderer.getListCellRendererComponent(list2, value2, index2, isSelected, true));
                }
                if (component3 instanceof JComponent && (border = ((JComponent)component3).getBorder()) != GotoActionModel.GotoActionListCellRenderer.TOGGLE_BUTTON_BORDER) {
                    ((JComponent)component3).setBorder((Border)JBUI.Borders.empty((int)1, (int)2));
                }
                AppUIUtil.targetToDevice(component3, list2);
                component3.setPreferredSize(UIUtil.updateListRowHeight((Dimension)component3.getPreferredSize()));
                return component3;
            }
        };
    }
}

