/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import java.awt.Dialog;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class WindowAction
extends AnAction
implements DumbAware {
    public static final String NO_WINDOW_ACTIONS = "no.window.actions";
    protected Window myWindow;
    private static JLabel mySizeHelper = null;

    public WindowAction() {
        this.setEnabledInModalContext(true);
    }

    public static void setEnabledFor(Window window, boolean enabled) {
        JRootPane root = WindowAction.getRootPane(window);
        if (root != null) {
            root.putClientProperty(NO_WINDOW_ACTIONS, !enabled);
        }
    }

    private static boolean isEnabledFor(Window window) {
        if (window == null || window instanceof IdeFrame) {
            return false;
        }
        if (window instanceof Dialog && !((Dialog)window).isResizable()) {
            return false;
        }
        JRootPane root = WindowAction.getRootPane(window);
        if (root == null) {
            return true;
        }
        Object property = root.getClientProperty(NO_WINDOW_ACTIONS);
        return property == null || !property.toString().equals("true");
    }

    private static JRootPane getRootPane(Window window) {
        if (window instanceof RootPaneContainer) {
            RootPaneContainer container = (RootPaneContainer)((Object)window);
            return container.getRootPane();
        }
        return null;
    }

    public final void update(@NotNull AnActionEvent event) {
        Window window;
        boolean enabled;
        if (event == null) {
            WindowAction.$$$reportNull$$$0(0);
        }
        if ((enabled = WindowAction.isEnabledFor(window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow())) && Registry.is((String)"no.window.actions.in.editor")) {
            Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
            enabled = editor == null || !editor.getContentComponent().hasFocus();
        }
        event.getPresentation().setEnabled(enabled);
        this.myWindow = enabled ? window : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/actions/WindowAction", "update"));
    }

    public static class DecrementHeight
    extends BaseSizeAction {
        public DecrementHeight() {
            super(false, false);
        }
    }

    public static class IncrementHeight
    extends BaseSizeAction {
        public IncrementHeight() {
            super(false, true);
        }
    }

    public static class DecrementWidth
    extends BaseSizeAction {
        public DecrementWidth() {
            super(true, false);
        }
    }

    public static class IncrementWidth
    extends BaseSizeAction {
        public IncrementWidth() {
            super(true, true);
        }
    }

    public static abstract class BaseSizeAction
    extends WindowAction {
        private final boolean myHorizontal;
        private final boolean myPositive;

        protected BaseSizeAction(boolean horizontal, boolean positive) {
            this.myHorizontal = horizontal;
            this.myPositive = positive;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                BaseSizeAction.$$$reportNull$$$0(0);
            }
            if (mySizeHelper == null) {
                @NonNls String helperText = "W";
                mySizeHelper = new JLabel(helperText);
            }
            int baseValue = this.myHorizontal ? WindowAction.mySizeHelper.getPreferredSize().width : WindowAction.mySizeHelper.getPreferredSize().height;
            int inc = baseValue * Registry.intValue((String)(this.myHorizontal ? "ide.windowSystem.hScrollChars" : "ide.windowSystem.vScrollChars"));
            if (!this.myPositive) {
                inc = -inc;
            }
            Rectangle bounds2 = this.myWindow.getBounds();
            if (this.myHorizontal) {
                bounds2.width += inc;
            } else {
                bounds2.height += inc;
            }
            this.myWindow.setBounds(bounds2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/WindowAction$BaseSizeAction", "actionPerformed"));
        }
    }
}

