/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginStateListener;
import com.intellij.ide.plugins.PluginStateManager;
import com.intellij.ide.plugins.newui.PluginUpdatesService;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.TooltipDescriptionProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.updateSettings.impl.CheckForUpdateResult;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.PluginUpdateDialog;
import com.intellij.openapi.updateSettings.impl.UpdateInfoDialog;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.ui.AnActionButton;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SettingsEntryPointAction
extends DumbAwareAction
implements RightAlignedToolbarAction,
TooltipDescriptionProvider {
    private boolean myShowPopup = true;
    private static PluginUpdatesService myUpdatesService;
    private static PluginStateListener myPluginStateListener;
    @Nullable
    private static CheckForUpdateResult myPlatformUpdateInfo;
    @Nullable
    private static Collection<? extends IdeaPluginDescriptor> myIncompatiblePlugins;
    private static boolean myShowPlatformUpdateIcon;
    @Nullable
    private static Collection<PluginDownloader> myUpdatedPlugins;
    @Nullable
    private static Collection<? extends IdeaPluginDescriptor> myCustomRepositoryPlugins;
    private static boolean myShowPluginsUpdateIcon;
    private static boolean myEnableUpdateAction;
    private static UISettingsListener mySettingsListener;
    private static final String WIDGET_ID = "settingsEntryPointWidget";

    public SettingsEntryPointAction() {
        SettingsEntryPointAction.initPluginsListeners();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(0);
        }
        SettingsEntryPointAction.resetActionIcon();
        if (!this.myShowPopup) {
            return;
        }
        this.myShowPopup = false;
        ListPopup popup2 = SettingsEntryPointAction.createMainPopup(e.getDataContext(), () -> {
            this.myShowPopup = true;
        });
        InputEvent inputEvent = e.getInputEvent();
        if (inputEvent == null) {
            popup2.showInFocusCenter();
        } else {
            Component component2 = inputEvent.getComponent();
            if (component2 instanceof ActionButtonComponent) {
                popup2.showUnderneathOf(component2);
            } else {
                popup2.showInCenterOf(component2);
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(1);
        }
        Presentation presentation2 = e.getPresentation();
        presentation2.setText("");
        presentation2.setDescription(SettingsEntryPointAction.getActionTooltip());
        presentation2.setIcon(SettingsEntryPointAction.getActionIcon());
        for (AnAction child2 : SettingsEntryPointAction.getTemplateActions()) {
            child2.update(e);
        }
    }

    private static AnAction @NotNull [] getTemplateActions() {
        ActionGroup templateGroup = (ActionGroup)ActionManager.getInstance().getAction("SettingsEntryPointGroup");
        AnAction[] anActionArray = templateGroup == null ? EMPTY_ARRAY : templateGroup.getChildren(null);
        if (anActionArray == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(2);
        }
        return anActionArray;
    }

    @NotNull
    private static ListPopup createMainPopup(@NotNull DataContext context, @NotNull Runnable disposeCallback) {
        if (context == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(3);
        }
        if (disposeCallback == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(4);
        }
        DefaultActionGroup group2 = new DefaultActionGroup();
        if (myPlatformUpdateInfo != null) {
            group2.add((AnAction)new DumbAwareAction(IdeBundle.message((String)"settings.entry.point.update.ide.action", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName(), Objects.requireNonNull(myPlatformUpdateInfo.getNewBuild()).getVersion()}), null, AllIcons.Ide.Notification.IdeUpdate){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    boolean updateStarted;
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (updateStarted = new UpdateInfoDialog(e.getProject(), Objects.requireNonNull(myPlatformUpdateInfo.getUpdatedChannel()), myPlatformUpdateInfo.getNewBuild(), myPlatformUpdateInfo.getPatches(), true, myUpdatedPlugins, myIncompatiblePlugins).showAndGet()) {
                        SettingsEntryPointAction.newPlatformUpdate(null, null, null);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/SettingsEntryPointAction$1", "actionPerformed"));
                }
            });
        } else if (myUpdatedPlugins != null) {
            int size = myUpdatedPlugins.size();
            String name = size == 1 ? IdeBundle.message((String)"settings.entry.point.update.plugin.action", (Object[])new Object[]{myUpdatedPlugins.iterator().next().getPluginName()}) : IdeBundle.message((String)"settings.entry.point.update.plugins.action", (Object[])new Object[]{size});
            group2.add((AnAction)new DumbAwareAction(name, null, AllIcons.Ide.Notification.PluginUpdate){

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    e.getPresentation().setEnabled(myEnableUpdateAction);
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    PluginUpdateDialog dialog2 = new PluginUpdateDialog(e.getProject(), myUpdatedPlugins, myCustomRepositoryPlugins);
                    dialog2.setFinishCallback(() -> SettingsEntryPointAction.setEnableUpdateAction(true));
                    SettingsEntryPointAction.setEnableUpdateAction(false);
                    if (!dialog2.showAndGet()) {
                        SettingsEntryPointAction.setEnableUpdateAction(true);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/ide/actions/SettingsEntryPointAction$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "update";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "actionPerformed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        group2.addSeparator();
        for (AnAction child2 : SettingsEntryPointAction.getTemplateActions()) {
            if (child2 instanceof Separator) {
                group2.add(child2);
                continue;
            }
            String text2 = child2.getTemplateText();
            if (text2 != null && !text2.endsWith("...")) {
                AnActionButton.AnActionButtonWrapper button2 = new AnActionButton.AnActionButtonWrapper(child2.getTemplatePresentation(), child2){

                    public void updateButton(@NotNull AnActionEvent e) {
                        if (e == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        this.getDelegate().update(e);
                        e.getPresentation().setText(e.getPresentation().getText() + "...");
                    }

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            3.$$$reportNull$$$0(1);
                        }
                        super.actionPerformed(new AnActionEvent(e.getInputEvent(), e.getDataContext(), e.getPlace(), this.getDelegate().getTemplatePresentation(), e.getActionManager(), e.getModifiers()));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "e";
                        objectArray2[1] = "com/intellij/ide/actions/SettingsEntryPointAction$3";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "updateButton";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "actionPerformed";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                button2.setShortcut(child2.getShortcutSet());
                group2.add((AnAction)button2);
                continue;
            }
            group2.add(child2);
        }
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group2, context, JBPopupFactory.ActionSelectionAid.MNEMONICS, true, () -> AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> ApplicationManager.getApplication().invokeLater(disposeCallback, ModalityState.any()), 250L, TimeUnit.MILLISECONDS), -1);
        if (listPopup == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(5);
        }
        return listPopup;
    }

    private static void initPluginsListeners() {
        if (myUpdatesService == null) {
            myUpdatesService = PluginUpdatesService.connectWithUpdates(descriptors2 -> {
                if (ContainerUtil.isEmpty((Collection)descriptors2)) {
                    SettingsEntryPointAction.newPluginUpdates(null, null);
                    return;
                }
                if (!UpdateSettings.getInstance().isPluginsCheckNeeded()) {
                    return;
                }
                ArrayList<PluginDownloader> downloaders = new ArrayList<PluginDownloader>();
                try {
                    for (IdeaPluginDescriptor descriptor2 : descriptors2) {
                        if (PluginUpdateDialog.isIgnored(descriptor2)) continue;
                        downloaders.add(PluginDownloader.createDownloader(descriptor2));
                    }
                }
                catch (IOException e) {
                    PluginManagerCore.getLogger().error((Throwable)e);
                }
                SettingsEntryPointAction.newPluginUpdates(downloaders.isEmpty() ? null : downloaders, null);
            });
        }
        if (myPluginStateListener == null) {
            myPluginStateListener = new PluginStateListener(){

                @Override
                public void install(@NotNull IdeaPluginDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    SettingsEntryPointAction.removePluginsUpdate(Collections.singleton(descriptor2));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/actions/SettingsEntryPointAction$4", "install"));
                }
            };
            PluginStateManager.addStateListener(myPluginStateListener);
        }
    }

    private static void setEnableUpdateAction(boolean value2) {
        myEnableUpdateAction = value2;
    }

    public static void newPlatformUpdate(@Nullable CheckForUpdateResult platformUpdateInfo, @Nullable List<PluginDownloader> updatedPlugins, @Nullable Collection<? extends IdeaPluginDescriptor> incompatiblePlugins) {
        myPlatformUpdateInfo = platformUpdateInfo;
        myUpdatedPlugins = updatedPlugins;
        myIncompatiblePlugins = incompatiblePlugins;
        myShowPlatformUpdateIcon = platformUpdateInfo != null;
        SettingsEntryPointAction.updateAction();
    }

    public static void newPluginUpdates(@Nullable Collection<PluginDownloader> updatedPlugins, @Nullable Collection<? extends IdeaPluginDescriptor> customRepositoryPlugins) {
        myUpdatedPlugins = updatedPlugins;
        myCustomRepositoryPlugins = customRepositoryPlugins;
        myShowPluginsUpdateIcon = updatedPlugins != null;
        SettingsEntryPointAction.updateAction();
    }

    public static void removePluginsUpdate(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors2) {
        if (descriptors2 == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(6);
        }
        if (myUpdatedPlugins != null) {
            List updatedPlugins = ContainerUtil.filter(myUpdatedPlugins, downloader -> {
                PluginId pluginId = downloader.getId();
                return ContainerUtil.find((Iterable)descriptors2, descriptor2 -> descriptor2.getPluginId().equals(pluginId)) == null;
            });
            if (myUpdatedPlugins.size() != updatedPlugins.size()) {
                SettingsEntryPointAction.newPluginUpdates(updatedPlugins.isEmpty() ? null : updatedPlugins, myCustomRepositoryPlugins);
            }
        }
    }

    private static void updateAction() {
        if (SettingsEntryPointAction.isAvailableInStatusBar()) {
            SettingsEntryPointAction.updateWidgets();
        }
    }

    @NotNull
    @Nls
    private static String getActionTooltip() {
        String string = IdeBundle.message((String)"settings.entry.point.tooltip", (Object[])new Object[0]);
        if (string == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static void resetActionIcon() {
        myShowPluginsUpdateIcon = false;
        myShowPlatformUpdateIcon = false;
    }

    @NotNull
    private static Icon getActionIcon() {
        if (myShowPlatformUpdateIcon) {
            Icon icon2 = AllIcons.Ide.Notification.IdeUpdate;
            if (icon2 == null) {
                SettingsEntryPointAction.$$$reportNull$$$0(8);
            }
            return icon2;
        }
        if (myShowPluginsUpdateIcon) {
            Icon icon3 = AllIcons.Ide.Notification.PluginUpdate;
            if (icon3 == null) {
                SettingsEntryPointAction.$$$reportNull$$$0(9);
            }
            return icon3;
        }
        Icon icon4 = AllIcons.General.GearPlain;
        if (icon4 == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(10);
        }
        return icon4;
    }

    private static void initUISettingsListener() {
        if (mySettingsListener == null) {
            mySettingsListener = uiSettings -> SettingsEntryPointAction.updateWidgets();
            ApplicationManager.getApplication().getMessageBus().connect().subscribe(UISettingsListener.TOPIC, (Object)mySettingsListener);
        }
    }

    private static void updateWidgets() {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            StatusBar statusBar;
            ((StatusBarWidgetsManager)((Object)project.getService(StatusBarWidgetsManager.class))).updateWidget(StatusBarManager.class);
            IdeFrame frame = WindowManager.getInstance().getIdeFrame(project);
            if (frame == null || (statusBar = frame.getStatusBar()) == null) continue;
            statusBar.updateWidget(WIDGET_ID);
        }
    }

    private static boolean isAvailableInStatusBar() {
        SettingsEntryPointAction.initUISettingsListener();
        UISettings settings = UISettings.getInstance();
        return !settings.getShowMainToolbar() && !settings.getShowToolbarInNavigationBar() && !Registry.is((String)"ide.new.navbar");
    }

    static {
        myEnableUpdateAction = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/SettingsEntryPointAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposeCallback";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/SettingsEntryPointAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateActions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createMainPopup";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTooltip";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createMainPopup";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removePluginsUpdate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyStatusBarWidget
    implements StatusBarWidget,
    StatusBarWidget.IconPresentation {
        private StatusBar myStatusBar;
        private boolean myShowPopup = true;

        private MyStatusBarWidget() {
            SettingsEntryPointAction.initPluginsListeners();
        }

        @NonNls
        @NotNull
        public String ID() {
            return SettingsEntryPointAction.WIDGET_ID;
        }

        public void install(@NotNull StatusBar statusBar) {
            if (statusBar == null) {
                MyStatusBarWidget.$$$reportNull$$$0(0);
            }
            this.myStatusBar = statusBar;
        }

        @Nullable
        public StatusBarWidget.WidgetPresentation getPresentation() {
            return this;
        }

        @Nullable
        @NlsContexts.Tooltip
        public String getTooltipText() {
            return SettingsEntryPointAction.getActionTooltip();
        }

        @Nullable
        public Consumer<MouseEvent> getClickConsumer() {
            return event -> {
                SettingsEntryPointAction.resetActionIcon();
                this.myStatusBar.updateWidget(SettingsEntryPointAction.WIDGET_ID);
                if (!this.myShowPopup) {
                    return;
                }
                this.myShowPopup = false;
                final Component component2 = event.getComponent();
                final ListPopup popup2 = SettingsEntryPointAction.createMainPopup(DataManager.getInstance().getDataContext(component2), () -> {
                    this.myShowPopup = true;
                });
                popup2.addListener(new JBPopupListener(){

                    public void beforeShown(@NotNull LightweightWindowEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        Point location = component2.getLocationOnScreen();
                        Dimension size = popup2.getSize();
                        popup2.setLocation(new Point(location.x + component2.getWidth() - size.width, location.y - size.height));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/actions/SettingsEntryPointAction$MyStatusBarWidget$1", "beforeShown"));
                    }
                });
                popup2.show(component2);
            };
        }

        @Nullable
        public Icon getIcon() {
            return SettingsEntryPointAction.getActionIcon();
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusBar", "com/intellij/ide/actions/SettingsEntryPointAction$MyStatusBarWidget", "install"));
        }
    }

    public static class StatusBarManager
    implements StatusBarWidgetFactory {
        @NonNls
        @NotNull
        public String getId() {
            return SettingsEntryPointAction.WIDGET_ID;
        }

        @Nls
        @NotNull
        public String getDisplayName() {
            String string = IdeBundle.message((String)"settings.entry.point.tooltip", (Object[])new Object[0]);
            if (string == null) {
                StatusBarManager.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project) {
            if (project == null) {
                StatusBarManager.$$$reportNull$$$0(1);
            }
            return SettingsEntryPointAction.isAvailableInStatusBar();
        }

        @NotNull
        public StatusBarWidget createWidget(@NotNull Project project) {
            if (project == null) {
                StatusBarManager.$$$reportNull$$$0(2);
            }
            return new MyStatusBarWidget();
        }

        public void disposeWidget(@NotNull StatusBarWidget widget) {
            if (widget == null) {
                StatusBarManager.$$$reportNull$$$0(3);
            }
            Disposer.dispose((Disposable)widget);
        }

        public boolean canBeEnabledOn(@NotNull StatusBar statusBar) {
            if (statusBar == null) {
                StatusBarManager.$$$reportNull$$$0(4);
            }
            return SettingsEntryPointAction.isAvailableInStatusBar();
        }

        public boolean isConfigurable() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/SettingsEntryPointAction$StatusBarManager";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "widget";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statusBar";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/SettingsEntryPointAction$StatusBarManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createWidget";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "disposeWidget";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "canBeEnabledOn";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

