/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.FeedbackDescriptionProvider;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.LicensingFacade;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SendFeedbackAction
extends AnAction
implements DumbAware {
    private static final ExtensionPointName<FeedbackDescriptionProvider> EP_NAME = new ExtensionPointName("com.intellij.feedbackDescriptionProvider");

    public void update(@NotNull AnActionEvent e) {
        boolean isSupportedOS;
        if (e == null) {
            SendFeedbackAction.$$$reportNull$$$0(0);
        }
        ApplicationInfoEx info = ApplicationInfoEx.getInstanceEx();
        boolean bl = isSupportedOS = SystemInfo.isMac || SystemInfo.isLinux || SystemInfo.isWindows;
        if (info != null && info.getFeedbackUrl() != null && isSupportedOS) {
            String feedbackSite = SendFeedbackAction.getFeedbackHost(info.getFeedbackUrl(), info.getCompanyName());
            e.getPresentation().setDescription(ActionsBundle.messagePointer((String)"action.SendFeedback.detailed.description", (Object[])new Object[]{feedbackSite}));
            e.getPresentation().setEnabledAndVisible(true);
        } else {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    private static String getFeedbackHost(String feedbackUrl, String companyName) {
        Pattern uriPattern = Pattern.compile("[^:/?#]+://(?:www\\.)?([^/?#]*).*", 32);
        Matcher matcher = uriPattern.matcher(feedbackUrl);
        return matcher.matches() ? matcher.group(1) : companyName;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SendFeedbackAction.$$$reportNull$$$0(1);
        }
        SendFeedbackAction.submit(e.getProject());
    }

    public static void submit(@Nullable Project project) {
        SendFeedbackAction.submit(project, ApplicationInfoEx.getInstanceEx().getFeedbackUrl(), SendFeedbackAction.getDescription(project));
    }

    public static void submit(@Nullable Project project, @NotNull String description) {
        if (description == null) {
            SendFeedbackAction.$$$reportNull$$$0(2);
        }
        SendFeedbackAction.submit(project, ApplicationInfoEx.getInstanceEx().getFeedbackUrl(), description);
    }

    static void submit(@Nullable Project project, @NotNull String urlTemplate, @NotNull String description) {
        if (urlTemplate == null) {
            SendFeedbackAction.$$$reportNull$$$0(3);
        }
        if (description == null) {
            SendFeedbackAction.$$$reportNull$$$0(4);
        }
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        boolean eap = appInfo.isEAP();
        LicensingFacade la = LicensingFacade.getInstance();
        String url = urlTemplate.replace("$BUILD", URLUtil.encodeURIComponent((String)(eap ? appInfo.getBuild().asStringWithoutProductCode() : appInfo.getBuild().asString()))).replace("$TIMEZONE", URLUtil.encodeURIComponent((String)System.getProperty("user.timezone", ""))).replace("$VERSION", URLUtil.encodeURIComponent((String)appInfo.getFullVersion())).replace("$EVAL", URLUtil.encodeURIComponent((String)(la != null && la.isEvaluationLicense() ? "true" : "false"))).replace("$DESCR", URLUtil.encodeURIComponent((String)description));
        BrowserUtil.browse((String)url, (Project)project);
    }

    @NotNull
    public static String getDescription(@Nullable Project project) {
        String javaVendor;
        @NonNls StringBuilder sb = new StringBuilder("\n\n");
        sb.append(ApplicationInfoEx.getInstanceEx().getBuild().asString()).append(", ");
        String javaVersion = System.getProperty("java.runtime.version", System.getProperty("java.version", "unknown"));
        sb.append("JRE ");
        sb.append(javaVersion);
        String archDataModel = System.getProperty("sun.arch.data.model");
        if (archDataModel != null) {
            sb.append("x").append(archDataModel);
        }
        if ((javaVendor = System.getProperty("java.vm.vendor")) != null) {
            sb.append(" ").append(javaVendor);
        }
        sb.append(", OS ").append(System.getProperty("os.name"));
        String osArch = System.getProperty("os.arch");
        if (osArch != null) {
            sb.append("(").append(osArch).append(")");
        }
        String osVersion = System.getProperty("os.version");
        String osPatchLevel = System.getProperty("sun.os.patch.level");
        if (osVersion != null) {
            sb.append(" v").append(osVersion);
            if (osPatchLevel != null && !"unknown".equals(osPatchLevel)) {
                sb.append(" ").append(osPatchLevel);
            }
        }
        if (!GraphicsEnvironment.isHeadless()) {
            sb.append(", screens ");
            GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            for (int i2 = 0; i2 < devices.length; ++i2) {
                if (i2 > 0) {
                    sb.append(", ");
                }
                GraphicsDevice device = devices[i2];
                DisplayMode displayMode = device.getDisplayMode();
                float scale = JBUIScale.sysScale((GraphicsConfiguration)device.getDefaultConfiguration());
                sb.append((float)displayMode.getWidth() * scale).append("x").append((float)displayMode.getHeight() * scale);
            }
            if (UIUtil.isRetina()) {
                sb.append(SystemInfo.isMac ? "; Retina" : "; HiDPI");
            }
        }
        for (FeedbackDescriptionProvider ext : (FeedbackDescriptionProvider[])EP_NAME.getExtensions()) {
            String pluginDescription = ext.getDescription(project);
            if (pluginDescription == null || pluginDescription.length() <= 0) continue;
            sb.append("\n").append(pluginDescription);
        }
        String string = sb.toString();
        if (string == null) {
            SendFeedbackAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlTemplate";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/SendFeedbackAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/SendFeedbackAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "submit";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

