/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.RecentLocationItem;
import com.intellij.ide.actions.RecentLocationsDataModel;
import com.intellij.ide.actions.RecentLocationsRenderer;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.laf.darcula.DarculaLookAndFeelInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.LightEditActionFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.FocusManagerImpl;
import com.intellij.ui.CaptionPanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class RecentLocationsAction
extends DumbAwareAction
implements LightEditCompatible {
    @NonNls
    public static final String RECENT_LOCATIONS_ACTION_ID = "RecentLocations";
    private static final String LOCATION_SETTINGS_KEY = "recent.locations.popup";
    private static final int DEFAULT_WIDTH = JBUIScale.scale((int)700);
    private static final int DEFAULT_HEIGHT = JBUIScale.scale((int)530);
    private static final int MINIMUM_WIDTH = JBUIScale.scale((int)600);
    private static final int MINIMUM_HEIGHT = JBUIScale.scale((int)450);

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RecentLocationsAction.$$$reportNull$$$0(0);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed(RECENT_LOCATIONS_ACTION_ID);
        Project project = RecentLocationsAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return;
        }
        RecentLocationsAction.showPopup(project, false);
    }

    public static void showPopup(final @NotNull Project project, boolean showChanged) {
        if (project == null) {
            RecentLocationsAction.$$$reportNull$$$0(1);
        }
        final RecentLocationsDataModel model2 = new RecentLocationsDataModel(project, new ArrayList<Editor>());
        final JBList list2 = new JBList((ListModel)JBList.createDefaultListModel(model2.getPlaces(showChanged)));
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)list2, (int)20, (int)31);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        ShortcutSet showChangedOnlyShortcutSet = KeymapUtil.getActiveKeymapShortcuts((String)RECENT_LOCATIONS_ACTION_ID);
        final JBCheckBox checkBox2 = RecentLocationsAction.createCheckbox(showChangedOnlyShortcutSet, showChanged);
        final ListWithFilter listWithFilter = (ListWithFilter)ListWithFilter.wrap((JList)list2, (JScrollPane)scrollPane, RecentLocationsAction.getNamer(model2, checkBox2), (boolean)true);
        listWithFilter.setAutoPackHeight(false);
        listWithFilter.setBorder(BorderFactory.createEmptyBorder());
        SpeedSearch speedSearch2 = listWithFilter.getSpeedSearch();
        speedSearch2.addChangeListener(evt -> {
            if (evt.getPropertyName().equals("enteredPrefix") && StringUtil.isEmpty((String)speedSearch2.getFilter())) {
                model2.getEditorsToRelease().forEach(editor -> RecentLocationsAction.clearSelectionInEditor(editor));
            }
        });
        list2.setCellRenderer((ListCellRenderer)((Object)new RecentLocationsRenderer(project, speedSearch2, model2, checkBox2)));
        list2.setEmptyText(IdeBundle.message((String)"recent.locations.popup.empty.text", (Object[])new Object[0]));
        list2.setBackground(EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground());
        ScrollingUtil.installActions((JList)list2);
        ScrollingUtil.ensureSelectionExists((JList)list2);
        final JLabel title = RecentLocationsAction.createTitle(showChanged);
        JPanel topPanel = RecentLocationsAction.createHeaderPanel(title, (JComponent)checkBox2);
        JPanel mainPanel = RecentLocationsAction.createMainPanel(listWithFilter, topPanel);
        Color borderColor = SystemInfo.isMac && LafManager.getInstance().getCurrentLookAndFeel() instanceof DarculaLookAndFeelInfo ? topPanel.getBackground() : null;
        final JBPopup popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)mainPanel, (JComponent)list2).setProject(project).setCancelOnClickOutside(true).setRequestFocus(true).setResizable(true).setMovable(true).setBorderColor(borderColor).setDimensionServiceKey(project, LOCATION_SETTINGS_KEY, true).setMinSize(new Dimension(MINIMUM_WIDTH, MINIMUM_HEIGHT)).setLocateWithinScreenBounds(false).createPopup();
        LightEditActionFactory.create(event -> {
            checkBox2.setSelected(!checkBox2.isSelected());
            RecentLocationsAction.updateItems(model2, (ListWithFilter<RecentLocationItem>)listWithFilter, title, checkBox2, popup2);
        }).registerCustomShortcutSet(showChangedOnlyShortcutSet, (JComponent)list2, (Disposable)popup2);
        checkBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecentLocationsAction.updateItems(model2, (ListWithFilter<RecentLocationItem>)listWithFilter, title, checkBox2, popup2);
            }
        });
        if (DimensionService.getInstance().getSize(LOCATION_SETTINGS_KEY, project) == null) {
            popup2.setSize(new Dimension(DEFAULT_WIDTH, DEFAULT_HEIGHT));
        }
        list2.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                int clickCount = event.getClickCount();
                if (clickCount > 1 && clickCount % 2 == 0) {
                    event.consume();
                    int i2 = list2.locationToIndex(event.getPoint());
                    if (i2 != -1) {
                        list2.setSelectedIndex(i2);
                        RecentLocationsAction.navigateToSelected(project, (JBList<RecentLocationItem>)list2, popup2);
                    }
                }
            }
        });
        popup2.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                model2.getEditorsToRelease().forEach(editor -> EditorFactory.getInstance().releaseEditor(editor));
                model2.getProjectConnection().disconnect();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/actions/RecentLocationsAction$3", "onClosed"));
            }
        });
        RecentLocationsAction.initSearchActions(project, model2, (ListWithFilter<RecentLocationItem>)listWithFilter, (JBList<RecentLocationItem>)list2, checkBox2, popup2);
        IdeEventQueue.getInstance().getPopupManager().closeAllPopups(false);
        list2.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!(e.getOppositeComponent() instanceof JCheckBox)) {
                    popup2.cancel();
                }
            }
        });
        RecentLocationsAction.showPopup(project, popup2);
    }

    private static void updateItems(@NotNull RecentLocationsDataModel data2, @NotNull ListWithFilter<RecentLocationItem> listWithFilter, @NotNull JLabel title, @NotNull JBCheckBox checkBox2, @NotNull JBPopup popup2) {
        if (data2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(2);
        }
        if (listWithFilter == null) {
            RecentLocationsAction.$$$reportNull$$$0(3);
        }
        if (title == null) {
            RecentLocationsAction.$$$reportNull$$$0(4);
        }
        if (checkBox2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(5);
        }
        if (popup2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(6);
        }
        boolean state = checkBox2.isSelected();
        RecentLocationsAction.updateModel(listWithFilter, data2, state);
        RecentLocationsAction.updateTitleText(title, state);
        FocusManagerImpl.getInstance().requestFocus(listWithFilter, false);
        popup2.pack(false, false);
    }

    @NotNull
    private static JBCheckBox createCheckbox(@NotNull ShortcutSet checkboxShortcutSet, boolean showChanged) {
        if (checkboxShortcutSet == null) {
            RecentLocationsAction.$$$reportNull$$$0(7);
        }
        String text2 = "<html>" + IdeBundle.message((String)"recent.locations.title.text", (Object[])new Object[0]) + " <font color=\"" + Holder.SHORTCUT_HEX_COLOR + "\">" + KeymapUtil.getShortcutsText((Shortcut[])checkboxShortcutSet.getShortcuts()) + "</font></html>";
        JBCheckBox checkBox2 = new JBCheckBox(text2);
        checkBox2.setBorder((Border)JBUI.Borders.empty());
        checkBox2.setOpaque(false);
        checkBox2.setSelected(showChanged);
        JBCheckBox jBCheckBox = checkBox2;
        if (jBCheckBox == null) {
            RecentLocationsAction.$$$reportNull$$$0(8);
        }
        return jBCheckBox;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RecentLocationsAction.$$$reportNull$$$0(9);
        }
        e.getPresentation().setEnabled(RecentLocationsAction.getEventProject((AnActionEvent)e) != null);
    }

    static void clearSelectionInEditor(@NotNull Editor editor) {
        if (editor == null) {
            RecentLocationsAction.$$$reportNull$$$0(10);
        }
        editor.getSelectionModel().removeSelection(true);
    }

    private static void showPopup(@NotNull Project project, @NotNull JBPopup popup2) {
        if (project == null) {
            RecentLocationsAction.$$$reportNull$$$0(11);
        }
        if (popup2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(12);
        }
        Point savedLocation = DimensionService.getInstance().getLocation(LOCATION_SETTINGS_KEY, project);
        Window recentFocusedWindow = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        if (savedLocation != null && recentFocusedWindow != null) {
            popup2.showInScreenCoordinates((Component)recentFocusedWindow, savedLocation);
        } else {
            popup2.showCenteredInCurrentWindow(project);
        }
    }

    private static void updateModel(@NotNull ListWithFilter<RecentLocationItem> listWithFilter, @NotNull RecentLocationsDataModel data2, boolean changed2) {
        if (listWithFilter == null) {
            RecentLocationsAction.$$$reportNull$$$0(13);
        }
        if (data2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(14);
        }
        NameFilteringListModel model2 = (NameFilteringListModel)listWithFilter.getList().getModel();
        DefaultListModel originalModel = (DefaultListModel)model2.getOriginalModel();
        originalModel.removeAllElements();
        data2.getPlaces(changed2).forEach(item -> originalModel.addElement(item));
        listWithFilter.getSpeedSearch().reset();
    }

    @NotNull
    private static JPanel createMainPanel(@NotNull ListWithFilter listWithFilter, @NotNull JPanel topPanel) {
        if (listWithFilter == null) {
            RecentLocationsAction.$$$reportNull$$$0(15);
        }
        if (topPanel == null) {
            RecentLocationsAction.$$$reportNull$$$0(16);
        }
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)topPanel, "North");
        mainPanel.add((Component)listWithFilter, "Center");
        JPanel jPanel2 = mainPanel;
        if (jPanel2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(17);
        }
        return jPanel2;
    }

    @NotNull
    private static JPanel createHeaderPanel(@NotNull JLabel title, @NotNull JComponent checkbox) {
        if (title == null) {
            RecentLocationsAction.$$$reportNull$$$0(18);
        }
        if (checkbox == null) {
            RecentLocationsAction.$$$reportNull$$$0(19);
        }
        CaptionPanel topPanel = new CaptionPanel();
        topPanel.add((Component)title, "West");
        topPanel.add((Component)checkbox, "East");
        Dimension size = topPanel.getPreferredSize();
        size.height = JBUIScale.scale((int)29);
        topPanel.setPreferredSize(size);
        topPanel.setBorder((Border)JBUI.Borders.empty((int)5, (int)8));
        WindowMoveListener moveListener = new WindowMoveListener((Component)topPanel);
        topPanel.addMouseListener(moveListener);
        topPanel.addMouseMotionListener(moveListener);
        CaptionPanel captionPanel = topPanel;
        if (captionPanel == null) {
            RecentLocationsAction.$$$reportNull$$$0(20);
        }
        return captionPanel;
    }

    @NotNull
    private static JLabel createTitle(boolean showChanged) {
        JBLabel title = new JBLabel();
        title.setFont(title.getFont().deriveFont(1));
        RecentLocationsAction.updateTitleText((JLabel)title, showChanged);
        JBLabel jBLabel = title;
        if (jBLabel == null) {
            RecentLocationsAction.$$$reportNull$$$0(21);
        }
        return jBLabel;
    }

    private static void updateTitleText(@NotNull JLabel title, boolean showChanged) {
        if (title == null) {
            RecentLocationsAction.$$$reportNull$$$0(22);
        }
        title.setText(showChanged ? IdeBundle.message((String)"recent.locations.changed.locations", (Object[])new Object[0]) : IdeBundle.message((String)"recent.locations.popup.title", (Object[])new Object[0]));
    }

    @NotNull
    private static Function<RecentLocationItem, String> getNamer(@NotNull RecentLocationsDataModel data2, @NotNull JBCheckBox checkBox2) {
        if (data2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(23);
        }
        if (checkBox2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(24);
        }
        Function function = value2 -> {
            String breadcrumb = data2.getBreadcrumbsMap(checkBox2.isSelected()).get(value2.getInfo());
            EditorEx editor = value2.getEditor();
            return breadcrumb + " " + value2.getInfo().getFile().getName() + " " + editor.getDocument().getText();
        };
        if (function == null) {
            RecentLocationsAction.$$$reportNull$$$0(25);
        }
        return function;
    }

    private static void initSearchActions(final @NotNull Project project, @NotNull RecentLocationsDataModel data2, @NotNull ListWithFilter<RecentLocationItem> listWithFilter, final @NotNull JBList<RecentLocationItem> list2, @NotNull JBCheckBox checkBox2, final @NotNull JBPopup popup2) {
        if (project == null) {
            RecentLocationsAction.$$$reportNull$$$0(26);
        }
        if (data2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(27);
        }
        if (listWithFilter == null) {
            RecentLocationsAction.$$$reportNull$$$0(28);
        }
        if (list2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(29);
        }
        if (checkBox2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(30);
        }
        if (popup2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(31);
        }
        listWithFilter.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                int clickCount = event.getClickCount();
                if (clickCount > 1 && clickCount % 2 == 0) {
                    event.consume();
                    RecentLocationsAction.navigateToSelected(project, (JBList<RecentLocationItem>)list2, popup2);
                }
            }
        });
        LightEditActionFactory.create(e -> RecentLocationsAction.navigateToSelected(project, list2, popup2)).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ENTER"}), listWithFilter, (Disposable)popup2);
        LightEditActionFactory.create(e -> RecentLocationsAction.removePlaces(project, listWithFilter, list2, data2, checkBox2.isSelected())).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"DELETE", "BACK_SPACE"}), listWithFilter, (Disposable)popup2);
    }

    private static void removePlaces(@NotNull Project project, @NotNull ListWithFilter<RecentLocationItem> listWithFilter, @NotNull JBList<RecentLocationItem> list2, @NotNull RecentLocationsDataModel data2, boolean showChanged) {
        List selectedValue;
        if (project == null) {
            RecentLocationsAction.$$$reportNull$$$0(32);
        }
        if (listWithFilter == null) {
            RecentLocationsAction.$$$reportNull$$$0(33);
        }
        if (list2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(34);
        }
        if (data2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(35);
        }
        if ((selectedValue = list2.getSelectedValuesList()).isEmpty()) {
            return;
        }
        int index2 = list2.getSelectedIndex();
        IdeDocumentHistory ideDocumentHistory = IdeDocumentHistory.getInstance(project);
        for (RecentLocationItem item : selectedValue) {
            if (showChanged) {
                ContainerUtil.filter(ideDocumentHistory.getChangePlaces(), info -> IdeDocumentHistoryImpl.isSame(info, item.getInfo())).forEach(info -> ideDocumentHistory.removeChangePlace((IdeDocumentHistoryImpl.PlaceInfo)info));
                continue;
            }
            ContainerUtil.filter(ideDocumentHistory.getBackPlaces(), info -> IdeDocumentHistoryImpl.isSame(info, item.getInfo())).forEach(info -> ideDocumentHistory.removeBackPlace((IdeDocumentHistoryImpl.PlaceInfo)info));
        }
        RecentLocationsAction.updateModel(listWithFilter, data2, showChanged);
        if (list2.getModel().getSize() > 0) {
            ScrollingUtil.selectItem(list2, (int)(index2 < list2.getModel().getSize() ? index2 : index2 - 1));
        }
    }

    private static void navigateToSelected(@NotNull Project project, @NotNull JBList<RecentLocationItem> list2, @NotNull JBPopup popup2) {
        if (project == null) {
            RecentLocationsAction.$$$reportNull$$$0(36);
        }
        if (list2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(37);
        }
        if (popup2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(38);
        }
        ContainerUtil.reverse((List)list2.getSelectedValuesList()).forEach(item -> IdeDocumentHistory.getInstance(project).gotoPlaceInfo(item.getInfo(), true));
        popup2.closeOk(null);
    }

    static String getEmptyFileText() {
        return IdeBundle.message((String)"recent.locations.popup.empty.file.text", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 17: 
            case 20: 
            case 21: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 17: 
            case 20: 
            case 21: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 11: 
            case 26: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 14: 
            case 23: 
            case 27: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: 
            case 13: 
            case 15: 
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listWithFilter";
                break;
            }
            case 4: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 5: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkBox";
                break;
            }
            case 6: 
            case 12: 
            case 31: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkboxShortcutSet";
                break;
            }
            case 8: 
            case 17: 
            case 20: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/RecentLocationsAction";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topPanel";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkbox";
                break;
            }
            case 29: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/RecentLocationsAction";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCheckbox";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createMainPanel";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createHeaderPanel";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createTitle";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showPopup";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateItems";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCheckbox";
                break;
            }
            case 8: 
            case 17: 
            case 20: 
            case 21: 
            case 25: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "clearSelectionInEditor";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateModel";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createMainPanel";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createHeaderPanel";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateTitleText";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getNamer";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "initSearchActions";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "removePlaces";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "navigateToSelected";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 17: 
            case 20: 
            case 21: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class Holder {
        private static final Color SHORTCUT_FOREGROUND_COLOR = UIUtil.getContextHelpForeground();
        public static final String SHORTCUT_HEX_COLOR = String.format("#%02x%02x%02x", SHORTCUT_FOREGROUND_COLOR.getRed(), SHORTCUT_FOREGROUND_COLOR.getGreen(), SHORTCUT_FOREGROUND_COLOR.getBlue());

        Holder() {
        }
    }
}

