/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.ide.actions.QualifiedNameProviderUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actions.PasteAction;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Producer;
import java.awt.datatransfer.Transferable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PasteReferenceProvider
implements PasteProvider {
    public void performPaste(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PasteReferenceProvider.$$$reportNull$$$0(0);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (project == null || editor == null) {
            return;
        }
        String fqn = PasteReferenceProvider.getCopiedFqn(dataContext);
        QualifiedNameProvider theProvider = null;
        PsiElement element2 = null;
        for (QualifiedNameProvider provider2 : QualifiedNameProvider.EP_NAME.getExtensionList()) {
            element2 = provider2.qualifiedNameToElement(fqn, project);
            if (element2 == null) continue;
            theProvider = provider2;
            break;
        }
        if (theProvider != null) {
            PasteReferenceProvider.insert(fqn, element2, editor, theProvider);
        }
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PasteReferenceProvider.$$$reportNull$$$0(1);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        return project != null && editor != null && PasteReferenceProvider.getCopiedFqn(dataContext) != null;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PasteReferenceProvider.$$$reportNull$$$0(2);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        String fqn = PasteReferenceProvider.getCopiedFqn(dataContext);
        return project != null && fqn != null && QualifiedNameProviderUtil.qualifiedNameToElement(fqn, project) != null;
    }

    private static void insert(String fqn, PsiElement element2, Editor editor, QualifiedNameProvider provider2) {
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        documentManager.commitDocument(editor.getDocument());
        PsiFile file2 = documentManager.getPsiFile(editor.getDocument());
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            Document document = editor.getDocument();
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            documentManager.commitDocument(document);
            EditorModificationUtil.deleteSelectedText((Editor)editor);
            provider2.insertQualifiedName(fqn, element2, editor, project);
        }), IdeBundle.message((String)"command.pasting.reference", (Object[])new Object[0]), null);
    }

    @Nullable
    private static String getCopiedFqn(DataContext context) {
        Producer<Transferable> producer = PasteAction.TRANSFERABLE_PROVIDER.getData(context);
        if (producer != null) {
            Transferable transferable = (Transferable)producer.produce();
            if (transferable != null) {
                try {
                    return (String)transferable.getTransferData(CopyReferenceAction.ourFlavor);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
        return (String)CopyPasteManager.getInstance().getContents(CopyReferenceAction.ourFlavor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "dataContext";
        objectArray2[1] = "com/intellij/ide/actions/PasteReferenceProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "performPaste";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isPastePossible";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isPasteEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

