/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.daemon.impl.IdentifierUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.ide.actions.QualifiedNameProviderUtil;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CopyReferenceUtil {
    static void highlight(Editor editor, Project project, List<? extends PsiElement> elements) {
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        if (elements.size() == 1 && editor != null && project != null) {
            PsiElement element2 = elements.get(0);
            PsiElement nameIdentifier = IdentifierUtil.getNameIdentifier(element2);
            if (nameIdentifier != null) {
                highlightManager.addOccurrenceHighlights(editor, new PsiElement[]{nameIdentifier}, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
            } else {
                PsiReference reference2 = TargetElementUtil.findReference(editor, editor.getCaretModel().getOffset());
                if (reference2 != null) {
                    highlightManager.addOccurrenceHighlights(editor, new PsiReference[]{reference2}, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
                } else if (element2 != PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(editor.getDocument())) {
                    highlightManager.addOccurrenceHighlights(editor, new PsiElement[]{element2}, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
                }
            }
        }
    }

    @NotNull
    static List<PsiElement> getElementsToCopy(@Nullable Editor editor, DataContext dataContext) {
        PsiElement[] psiElements;
        PsiReference reference2;
        ArrayList elements = new ArrayList();
        if (editor != null && (reference2 = TargetElementUtil.findReference(editor)) != null) {
            ContainerUtil.addIfNotNull(elements, (Object)reference2.getElement());
        }
        if (elements.isEmpty() && (psiElements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext)) != null) {
            Collections.addAll(elements, psiElements);
        }
        if (elements.isEmpty()) {
            ContainerUtil.addIfNotNull(elements, (Object)((PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)));
        }
        if (elements.isEmpty() && editor == null) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
            if (project != null && files2 != null) {
                for (VirtualFile file2 : files2) {
                    ContainerUtil.addIfNotNull(elements, (Object)PsiManager.getInstance((Project)project).findFile(file2));
                }
            }
        }
        List list2 = ContainerUtil.mapNotNull(elements, element2 -> element2 instanceof PsiFile && !((PsiFile)element2).getViewProvider().isPhysical() ? null : CopyReferenceUtil.adjustElement(element2));
        if (list2 == null) {
            CopyReferenceUtil.$$$reportNull$$$0(0);
        }
        return list2;
    }

    static PsiElement adjustElement(PsiElement element2) {
        PsiElement adjustedElement = QualifiedNameProviderUtil.adjustElementToCopy(element2);
        return adjustedElement != null ? adjustedElement : element2;
    }

    static void setStatusBarText(Project project, @NlsContexts.StatusBarText String message2) {
        StatusBarEx statusBar;
        if (project != null && (statusBar = (StatusBarEx)WindowManager.getInstance().getStatusBar(project)) != null) {
            statusBar.setInfo(message2);
        }
    }

    @Nullable
    static String getQualifiedNameFromProviders(@Nullable PsiElement element2) {
        if (element2 == null) {
            return null;
        }
        return (String)DumbService.getInstance((Project)element2.getProject()).computeWithAlternativeResolveEnabled(() -> QualifiedNameProviderUtil.getQualifiedName(element2));
    }

    static String doCopy(List<? extends PsiElement> elements, @Nullable Editor editor) {
        if (elements.isEmpty()) {
            return null;
        }
        ArrayList<String> fqns = new ArrayList<String>();
        for (PsiElement psiElement : elements) {
            String fqn = CopyReferenceUtil.elementToFqn(psiElement, editor);
            if (fqn == null) {
                return null;
            }
            fqns.add(fqn);
        }
        return StringUtil.join(fqns, (String)"\n");
    }

    @Nullable
    static String elementToFqn(@Nullable PsiElement element2, @Nullable Editor editor) {
        PsiReference reference2;
        String result2 = CopyReferenceUtil.getQualifiedNameFromProviders(element2);
        if (result2 != null) {
            return result2;
        }
        if (editor != null && (reference2 = TargetElementUtil.findReference(editor, editor.getCaretModel().getOffset())) != null && (result2 = CopyReferenceUtil.getQualifiedNameFromProviders(reference2.resolve())) != null) {
            return result2;
        }
        if (element2 instanceof PsiFile) {
            return FileUtil.toSystemIndependentName((String)CopyReferenceUtil.getFileFqn((PsiFile)element2));
        }
        if (element2 instanceof PsiDirectory) {
            return FileUtil.toSystemIndependentName((String)CopyReferenceUtil.getVirtualFileFqn(((PsiDirectory)element2).getVirtualFile(), element2.getProject()));
        }
        return null;
    }

    @NotNull
    @NlsSafe
    static String getFileFqn(PsiFile file2) {
        VirtualFile virtualFile = file2.getVirtualFile();
        return virtualFile == null ? file2.getName() : CopyReferenceUtil.getVirtualFileFqn(virtualFile, file2.getProject());
    }

    @NotNull
    public static String getVirtualFileFqn(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        String scratchRelativePath;
        VirtualFile scratchRootVirtualFile;
        VirtualFile dir;
        if (virtualFile == null) {
            CopyReferenceUtil.$$$reportNull$$$0(1);
        }
        if (project == null) {
            CopyReferenceUtil.$$$reportNull$$$0(2);
        }
        for (VirtualFile[] provider2 : CopyReferenceAction.VirtualFileQualifiedNameProvider.EP_NAME.getExtensionList()) {
            String qualifiedName = provider2.getQualifiedName(project, virtualFile);
            if (qualifiedName == null) continue;
            String string = qualifiedName;
            if (string == null) {
                CopyReferenceUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        Module module = ProjectFileIndex.getInstance((Project)project).getModuleForFile(virtualFile, false);
        if (module != null) {
            for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                String relativePath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)root);
                if (relativePath == null) continue;
                String string = relativePath;
                if (string == null) {
                    CopyReferenceUtil.$$$reportNull$$$0(4);
                }
                return string;
            }
        }
        if ((dir = project.getBaseDir()) == null) {
            String string = virtualFile.getPath();
            if (string == null) {
                CopyReferenceUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)dir);
        if (relativePath != null) {
            String string = relativePath;
            if (string == null) {
                CopyReferenceUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        RootType rootType = RootType.forFile((VirtualFile)virtualFile);
        if (rootType != null && (scratchRootVirtualFile = VfsUtil.findFileByIoFile((File)new File(ScratchFileService.getInstance().getRootPath(rootType)), (boolean)false)) != null && (scratchRelativePath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)scratchRootVirtualFile)) != null) {
            String string = scratchRelativePath;
            if (string == null) {
                CopyReferenceUtil.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = virtualFile.getPath();
        if (string == null) {
            CopyReferenceUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CopyReferenceUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToCopy";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CopyReferenceUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFileFqn";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFileFqn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

