/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CloseProjectsActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.ui.IdeUICustomization;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0014J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/actions/CloseProjectAction;", "Lcom/intellij/ide/actions/CloseProjectsActionBase;", "()V", "canClose", "", "project", "Lcom/intellij/openapi/project/Project;", "currentProject", "shouldShow", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "", "intellij.platform.ide.impl"})
public final class CloseProjectAction
extends CloseProjectsActionBase {
    @Override
    protected boolean canClose(@NotNull Project project, @NotNull Project currentProject) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)currentProject, (String)"currentProject");
        return project == currentProject;
    }

    @Override
    protected boolean shouldShow(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e.getProject() != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        if (ProjectAttachProcessor.canAttachToProject() && e.getProject() != null) {
            Project project = e.getProject();
            Intrinsics.checkNotNull((Object)project);
            ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(e.project!!)");
            if (moduleManager.getModules().length > 1) {
                e.getPresentation().setText(IdeBundle.messagePointer((String)"action.close.projects.in.current.window", (Object[])new Object[0]));
                return;
            }
        }
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        presentation2.setText(IdeUICustomization.getInstance().projectMessage("action.close.project.text", new Object[0]));
        Presentation presentation3 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"e.presentation");
        presentation3.setDescription(IdeUICustomization.getInstance().projectMessage("action.close.project.description", new Object[0]));
    }

    public CloseProjectAction() {
        this.getTemplatePresentation().setText((Supplier)1.INSTANCE);
        this.getTemplatePresentation().setDescription((Supplier)2.INSTANCE);
    }
}

