/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.diagnostic.VMOptions;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.EditCustomVmOptionsAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.jna.JnaLoader;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.notification.impl.NotificationFullContent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.PreloadingActivity;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.MathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.system.CpuArch;
import com.sun.jna.Callback;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.jps.model.java.JdkVersionDetector;

final class SystemHealthMonitor
extends PreloadingActivity {
    private static final Logger LOG = Logger.getInstance(SystemHealthMonitor.class);
    private static final String DISPLAY_ID = "System Health";

    SystemHealthMonitor() {
    }

    @Override
    public void preload(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            SystemHealthMonitor.$$$reportNull$$$0(0);
        }
        SystemHealthMonitor.checkInstallationIntegrity();
        SystemHealthMonitor.checkIdeDirectories();
        SystemHealthMonitor.checkRuntime();
        SystemHealthMonitor.checkReservedCodeCacheSize();
        SystemHealthMonitor.checkEnvironment();
        SystemHealthMonitor.checkSignalBlocking();
        SystemHealthMonitor.startDiskSpaceMonitoring();
    }

    private static void checkInstallationIntegrity() {
        if (SystemInfo.isUnix && !SystemInfo.isMac) {
            try (Stream<Path> stream = Files.list(Path.of(PathManager.getLibPath(), new String[0]));){
                long markers = stream.filter(p -> p.getFileName().toString().startsWith("build-marker-")).count();
                if (markers > 1L) {
                    SystemHealthMonitor.showNotification("mixed.bag.installation", false, null, ApplicationNamesInfo.getInstance().getFullProductName());
                }
            }
            catch (IOException e) {
                LOG.warn(e.getClass().getName() + ": " + e.getMessage());
            }
        }
    }

    private static void checkIdeDirectories() {
        if (System.getProperty("idea.paths.selector") != null) {
            if (System.getProperty("idea.config.path") != null && System.getProperty("idea.plugins.path") == null) {
                SystemHealthMonitor.showNotification("implicit.plugin.directory.path", null, SystemHealthMonitor.shorten(PathManager.getPluginsPath()));
            }
            if (System.getProperty("idea.system.path") != null && System.getProperty("idea.log.path") == null) {
                SystemHealthMonitor.showNotification("implicit.log.directory.path", null, SystemHealthMonitor.shorten(PathManager.getLogPath()));
            }
        }
    }

    private static String shorten(String pathStr) {
        Path userHome;
        Path path = Paths.get(pathStr, new String[0]).toAbsolutePath();
        if (path.startsWith(userHome = Paths.get(SystemProperties.getUserHome(), new String[0]))) {
            Path relative = userHome.relativize(path);
            return SystemInfo.isWindows ? "%USERPROFILE%\\" + relative : "~/" + relative;
        }
        return pathStr;
    }

    private static void checkRuntime() {
        String jreHome = SystemProperties.getJavaHome();
        if (!PathManager.isUnderHomeDirectory((String)jreHome) && !SystemHealthMonitor.isModernJBR()) {
            String scriptName;
            String configName;
            Path configFile;
            NotificationAction switchAction = null;
            String directory = PathManager.getCustomOptionsDirectory();
            if (directory != null && (SystemInfo.isWindows || SystemInfo.isMac || SystemInfo.isLinux) && SystemHealthMonitor.isJbrOperational() && Files.isRegularFile(configFile = Path.of(directory, configName = (scriptName = ApplicationNamesInfo.getInstance().getScriptName()) + (!SystemInfo.isWindows ? "" : (CpuArch.isIntel64() ? "64.exe" : ".exe")) + ".jdk"), new LinkOption[0])) {
                switchAction = new NotificationAction(IdeBundle.message((String)"action.SwitchToJBR.text", (Object[])new Object[0])){

                    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (notification == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        notification.expire();
                        try {
                            Files.delete(configFile);
                        }
                        catch (IOException x) {
                            LOG.warn("Can't delete JDK configuration file: " + configFile, (Throwable)x);
                        }
                        ApplicationManager.getApplication().restart();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "e";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "notification";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/ide/SystemHealthMonitor$1";
                        objectArray[2] = "actionPerformed";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }
            jreHome = StringUtil.trimEnd((String)jreHome, (String)"/Contents/Home");
            SystemHealthMonitor.showNotification("bundled.jre.version.message", switchAction, JavaVersion.current(), SystemInfo.JAVA_VENDOR, jreHome);
        }
    }

    private static boolean isModernJBR() {
        if (!SystemInfo.isJetBrainsJvm) {
            return false;
        }
        JdkVersionDetector.JdkVersionInfo jbrVersion = JdkVersionDetector.getInstance().detectJdkVersionInfo(PathManager.getBundledRuntimePath());
        return jbrVersion == null || JavaVersion.current().compareTo(jbrVersion.version) >= 0;
    }

    private static boolean isJbrOperational() {
        Path bin = Path.of(PathManager.getBundledRuntimePath(), SystemInfo.isWindows ? "bin/java.exe" : "bin/java");
        if (Files.isRegularFile(bin, new LinkOption[0]) && (SystemInfo.isWindows || Files.isExecutable(bin))) {
            try {
                return new CapturingProcessHandler(new GeneralCommandLine(new String[]{bin.toString(), "-version"})).runProcess(30000).getExitCode() == 0;
            }
            catch (ExecutionException e) {
                LOG.debug((Throwable)e);
            }
        }
        return false;
    }

    private static void checkReservedCodeCacheSize() {
        int reservedCodeCacheSize = VMOptions.readOption(VMOptions.MemoryKind.CODE_CACHE, true);
        int minReservedCodeCacheSize = 240;
        if (reservedCodeCacheSize > 0 && reservedCodeCacheSize < minReservedCodeCacheSize) {
            final EditCustomVmOptionsAction vmEditAction = new EditCustomVmOptionsAction();
            NotificationAction action2 = new NotificationAction(IdeBundle.message((String)"vm.options.edit.action.cap", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (notification == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    notification.expire();
                    ActionUtil.performActionDumbAware((AnAction)vmEditAction, (AnActionEvent)e);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/ide/SystemHealthMonitor$2";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            SystemHealthMonitor.showNotification("code.cache.warn.message", (NotificationAction)(vmEditAction.isEnabled() ? action2 : null), reservedCodeCacheSize, minReservedCodeCacheSize);
        }
    }

    private static void checkEnvironment() {
        List usedVars = Stream.of("_JAVA_OPTIONS", "JDK_JAVA_OPTIONS", "JAVA_TOOL_OPTIONS").filter(var -> Strings.isNotEmpty((String)System.getenv(var))).collect(Collectors.toList());
        if (!usedVars.isEmpty()) {
            SystemHealthMonitor.showNotification("vm.options.env.vars", null, String.join((CharSequence)", ", usedVars));
        }
    }

    private static void checkSignalBlocking() {
        if (SystemInfo.isUnix & JnaLoader.isLoaded()) {
            try {
                Memory sa = new Memory(256L);
                LibC libC = (LibC)Native.load((String)"c", LibC.class);
                if (libC.sigaction(2, Pointer.NULL, (Pointer)sa) == 0 && LibC.SIG_IGN.equals((Object)sa.getPointer(0L))) {
                    libC.signal(2, LibC.Handler.TERMINATE);
                    LOG.info("restored ignored INT handler");
                }
            }
            catch (Throwable t) {
                LOG.warn(t);
            }
        }
    }

    private static void showNotification(@PropertyKey(resourceBundle="messages.IdeBundle") @PropertyKey(resourceBundle="messages.IdeBundle") String key, @Nullable NotificationAction action2, Object ... params) {
        SystemHealthMonitor.showNotification(key, true, action2, params);
    }

    private static void showNotification(final @PropertyKey(resourceBundle="messages.IdeBundle") @PropertyKey(resourceBundle="messages.IdeBundle") String key, boolean suppressable, @Nullable NotificationAction action2, Object ... params) {
        if (suppressable) {
            boolean ignored = PropertiesComponent.getInstance().isValueSet("ignore." + key);
            LOG.warn("issue detected: " + key + (ignored ? " (ignored)" : ""));
            if (ignored) {
                return;
            }
        }
        MyNotification notification = new MyNotification(IdeBundle.message((String)key, (Object[])params));
        if (action2 != null) {
            notification.addAction((AnAction)action2);
        }
        if (suppressable) {
            notification.addAction((AnAction)new NotificationAction(IdeBundle.message((String)"sys.health.acknowledge.action", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (notification == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    notification.expire();
                    PropertiesComponent.getInstance().setValue("ignore." + key, "true");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/ide/SystemHealthMonitor$3";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        notification.setImportant(true);
        Notifications.Bus.notify((Notification)notification);
    }

    private static void startDiskSpaceMonitoring() {
        if (SystemProperties.getBooleanProperty((String)"idea.no.system.path.space.monitoring", (boolean)false)) {
            return;
        }
        final File file2 = new File(PathManager.getSystemPath());
        final AtomicBoolean reported = new AtomicBoolean();
        final ThreadLocal ourFreeSpaceCalculation = new ThreadLocal();
        AppExecutorUtil.getAppScheduledExecutorService().schedule(new Runnable(){
            private static final long LOW_DISK_SPACE_THRESHOLD = 0x3200000L;
            private static final long MAX_WRITE_SPEED_IN_BPS = 524288000L;

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @Override
            public void run() {
                if (!reported.get()) {
                    @Nullable Future future2 = (Future)ourFreeSpaceCalculation.get();
                    if (future2 == null) {
                        future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                            long fileUsableSpace = file2.getUsableSpace();
                            while (fileUsableSpace == 0L) {
                                TimeoutUtil.sleep((long)5000L);
                                fileUsableSpace = file2.getUsableSpace();
                            }
                            return fileUsableSpace;
                        });
                        ourFreeSpaceCalculation.set(future2);
                    }
                    if (!future2.isDone() || future2.isCancelled()) {
                        this.restart(1L);
                        return;
                    }
                    try {
                        Long result2 = (Long)future2.get();
                        if (result2 == null) {
                            return;
                        }
                        ourFreeSpaceCalculation.set(null);
                        long usableSpace = result2;
                        long timeout = MathUtil.clamp((long)((usableSpace - 0x3200000L) / 524288000L), (long)5L, (long)3600L);
                        if (usableSpace < 0x3200000L) {
                            if (ReadAction.compute(() -> NotificationsConfiguration.getNotificationsConfiguration()) == null) {
                                ourFreeSpaceCalculation.set(future2);
                                this.restart(1L);
                                return;
                            }
                            reported.compareAndSet(false, true);
                            SwingUtilities.invokeLater(() -> {
                                String productName = ApplicationNamesInfo.getInstance().getFullProductName();
                                String message2 = IdeBundle.message((String)"low.disk.space.message", (Object[])new Object[]{productName});
                                if (usableSpace < 102400L) {
                                    LOG.warn(message2 + " (" + usableSpace + ")");
                                    Messages.showErrorDialog((String)message2, (String)IdeBundle.message((String)"dialog.title.fatal.configuration.problem", (Object[])new Object[0]));
                                    reported.compareAndSet(true, false);
                                    this.restart(timeout);
                                } else {
                                    NotificationGroupManager.getInstance().getNotificationGroup(SystemHealthMonitor.DISPLAY_ID).createNotification(message2, file2.getPath(), NotificationType.ERROR, null).whenExpired(() -> {
                                        reported.compareAndSet(true, false);
                                        this.restart(timeout);
                                    }).notify(null);
                                }
                            });
                        } else {
                            this.restart(timeout);
                        }
                    }
                    catch (Exception ex) {
                        LOG.error((Throwable)ex);
                    }
                }
            }

            private void restart(long timeout) {
                AppExecutorUtil.getAppScheduledExecutorService().schedule(this, timeout, TimeUnit.SECONDS);
            }
        }, 1L, TimeUnit.SECONDS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/SystemHealthMonitor", "preload"));
    }

    private static interface LibC
    extends Library {
        public static final Pointer SIG_IGN = new Pointer(1L);

        public int sigaction(int var1, Pointer var2, Pointer var3);

        public Pointer signal(int var1, Handler var2);

        public static interface Handler
        extends Callback {
            public static final Handler TERMINATE = sig -> System.exit(128 + sig);

            public void callback(int var1);
        }
    }

    private static final class MyNotification
    extends Notification
    implements NotificationFullContent {
        MyNotification(@NotNull @NlsContexts.NotificationContent String content2) {
            if (content2 == null) {
                MyNotification.$$$reportNull$$$0(0);
            }
            super(SystemHealthMonitor.DISPLAY_ID, "", content2, NotificationType.WARNING);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/SystemHealthMonitor$MyNotification", "<init>"));
        }
    }
}

