/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.AWTEvent;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ProhibitAWTEvents
implements IdeEventQueue.EventDispatcher {
    private static final Logger LOG = Logger.getInstance(ProhibitAWTEvents.class);
    private static long ourUseCount;
    private final String myActivityName;
    private boolean myReported;

    private ProhibitAWTEvents(@NotNull String activityName) {
        if (activityName == null) {
            ProhibitAWTEvents.$$$reportNull$$$0(0);
        }
        this.myActivityName = activityName;
    }

    @Override
    public boolean dispatch(@NotNull AWTEvent e) {
        if (e == null) {
            ProhibitAWTEvents.$$$reportNull$$$0(1);
        }
        if (!this.myReported) {
            this.myReported = true;
            LOG.error("AWT events are prohibited inside " + this.myActivityName + "; got " + e);
        }
        return true;
    }

    @NotNull
    public static AccessToken start(@NotNull @NonNls String activityName) {
        if (activityName == null) {
            ProhibitAWTEvents.$$$reportNull$$$0(2);
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            if (accessToken == null) {
                ProhibitAWTEvents.$$$reportNull$$$0(3);
            }
            return accessToken;
        }
        final ProhibitAWTEvents dispatcher = new ProhibitAWTEvents(activityName);
        IdeEventQueue.getInstance().addPostprocessor(dispatcher, null);
        ++ourUseCount;
        return new AccessToken(){

            public void finish() {
                --ourUseCount;
                IdeEventQueue.getInstance().removePostprocessor(dispatcher);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T prohibitEventsInside(@NonNls @NotNull String activityName, @NotNull Supplier<? extends T> supplier2) {
        if (activityName == null) {
            ProhibitAWTEvents.$$$reportNull$$$0(4);
        }
        if (supplier2 == null) {
            ProhibitAWTEvents.$$$reportNull$$$0(5);
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            return supplier2.get();
        }
        ProhibitAWTEvents dispatcher = new ProhibitAWTEvents(activityName);
        IdeEventQueue.getInstance().addPostprocessor(dispatcher, null);
        try {
            ++ourUseCount;
            T t = supplier2.get();
            return t;
        }
        finally {
            --ourUseCount;
            IdeEventQueue.getInstance().removePostprocessor(dispatcher);
        }
    }

    public static boolean areEventsProhibited() {
        if (!SwingUtilities.isEventDispatchThread()) {
            return false;
        }
        return ourUseCount != 0L;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ProhibitAWTEvents";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ProhibitAWTEvents";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "start";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "dispatch";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prohibitEventsInside";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

