/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.LanguageDetector;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.marketplace.FeatureImpl;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/LanguageDetector;", "Lcom/intellij/openapi/startup/StartupActivity$Background;", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.platform.ide.impl"})
public final class LanguageDetector
implements StartupActivity.Background {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void runActivity(@NotNull Project project) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!Experiments.getInstance().isFeatureEnabled("language.detect.notification")) {
                return;
            }
            PluginNode pluginNode = LanguageDetector.Companion.findPlugin();
            if (pluginNode == null) break block1;
            PluginNode pluginNode2 = pluginNode;
            boolean bl = false;
            boolean bl2 = false;
            PluginNode it = pluginNode2;
            boolean bl3 = false;
            LanguageDetector.Companion.notify(project, it);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0002J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J%\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ide/LanguageDetector$Companion;", "", "()V", "findPlugin", "Lcom/intellij/ide/plugins/PluginNode;", "getFeatures", "", "Lcom/intellij/ide/plugins/marketplace/FeatureImpl;", "languageTag", "", "installAction", "Lcom/intellij/notification/NotificationAction;", "Lorg/jetbrains/annotations/NotNull;", "project", "Lcom/intellij/openapi/project/Project;", "matchedVerifiedPlugin", "notification", "Lcom/intellij/notification/Notification;", "matchedLanguagePlugins", "notify", "", "plugin", "verifiedLanguagePlugins", "intellij.platform.ide.impl"})
    public static final class Companion {
        private final List<FeatureImpl> matchedLanguagePlugins() {
            String string = Locale.getDefault().toLanguageTag();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Locale.getDefault().toLanguageTag()");
            List<FeatureImpl> features = this.getFeatures(string);
            Collection collection = features;
            boolean bl = false;
            if (!collection.isEmpty()) {
                return features;
            }
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.getDefault()");
            String string2 = locale.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Locale.getDefault().language");
            return this.getFeatures(string2);
        }

        private final List<FeatureImpl> getFeatures(String languageTag) {
            String build2 = MarketplaceRequests.Companion.getInstance().getBuildForPluginRepositoryRequests();
            Map params = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"featureType", (Object)"com.intellij.locale"), TuplesKt.to((Object)"implementationName", (Object)languageTag), TuplesKt.to((Object)"build", (Object)build2)});
            return MarketplaceRequests.Companion.getInstance().getFeatures(params);
        }

        private final List<PluginNode> verifiedLanguagePlugins() {
            return MarketplaceRequests.Companion.getInstance().searchPlugins("tags=Language%20Pack", 10);
        }

        private final NotificationAction installAction(Project project, PluginNode matchedVerifiedPlugin, Notification notification) {
            NotificationAction notificationAction = NotificationAction.create((String)ApplicationBundle.message((String)"notification.action.language.plugin.install.and.enable", (Object[])new Object[0]), (BiConsumer)new BiConsumer<AnActionEvent, Notification>(project, matchedVerifiedPlugin, notification){
                final /* synthetic */ Project $project;
                final /* synthetic */ PluginNode $matchedVerifiedPlugin;
                final /* synthetic */ Notification $notification;

                public final void accept(AnActionEvent $noName_0, Notification $noName_1) {
                    PluginsAdvertiser.installAndEnable(this.$project, SetsKt.setOf((Object)this.$matchedVerifiedPlugin.getPluginId()), false, new Runnable(this){
                        final /* synthetic */ installAction.1 this$0;

                        public final void run() {
                            this.this$0.$notification.expire();
                            ApplicationManagerEx.getApplicationEx().restart(true);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.$project = project;
                    this.$matchedVerifiedPlugin = pluginNode;
                    this.$notification = notification;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"NotificationAction.creat\u2026(true)\n        })\n      }");
            return notificationAction;
        }

        private final PluginNode findPlugin() {
            Object v3;
            block5: {
                Iterable $this$firstOrNull$iv = this.verifiedLanguagePlugins();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    boolean bl;
                    PluginNode it;
                    block4: {
                        it = (PluginNode)element$iv;
                        boolean bl2 = false;
                        Iterable $this$any$iv = Companion.matchedLanguagePlugins();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                FeatureImpl matched = (FeatureImpl)element$iv2;
                                boolean bl3 = false;
                                String string = matched.getPluginId();
                                PluginId pluginId = it.getPluginId();
                                Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"it.pluginId");
                                if (!Intrinsics.areEqual((Object)string, (Object)pluginId.getIdString())) continue;
                                bl = true;
                                break block4;
                            }
                            bl = false;
                        }
                    }
                    if (!(bl && !PluginManagerCore.isPluginInstalled(it.getPluginId()))) continue;
                    v3 = element$iv;
                    break block5;
                }
                v3 = null;
            }
            return v3;
        }

        private final void notify(Project project, PluginNode plugin2) {
            Object[] objectArray = new Object[1];
            ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
            objectArray[0] = applicationInfo.getFullApplicationName();
            String string = ApplicationBundle.message((String)"notification.title.language.plugin.enable", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ApplicationBundle.messag\u2026ce().fullApplicationName)");
            String notificationTitle = string;
            Notification notification = NotificationGroup.createNotification$default((NotificationGroup)NotificationGroupManager.getInstance().getNotificationGroup("Language Plugins Notifications"), (String)notificationTitle, null, null, null, null, (int)24, null);
            boolean bl = false;
            boolean bl2 = false;
            Notification it = notification;
            boolean bl3 = false;
            it.addAction((AnAction)Companion.installAction(project, plugin2, it));
            notification.notify(project);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

