/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.history.ByteContent;
import com.intellij.history.FileRevisionTimestampComparator;
import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.history.LocalHistoryException;
import com.intellij.history.core.ByteContentRetriever;
import com.intellij.history.core.ChangeList;
import com.intellij.history.core.ChangeListStorage;
import com.intellij.history.core.ChangeListStorageImpl;
import com.intellij.history.core.InMemoryChangeListStorage;
import com.intellij.history.core.LabelImpl;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryActionImpl;
import com.intellij.history.integration.LocalHistoryEventDispatcher;
import com.intellij.history.integration.LocalHistoryUtil;
import com.intellij.history.integration.ui.models.DirectoryHistoryDialogModel;
import com.intellij.history.integration.ui.models.EntireFileHistoryDialogModel;
import com.intellij.history.integration.ui.models.HistoryDialogModel;
import com.intellij.history.utils.LocalHistoryLog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class LocalHistoryImpl
extends LocalHistory
implements Disposable {
    private ChangeList myChangeList;
    private LocalHistoryFacade myVcs;
    private IdeaGateway myGateway;
    @Nullable
    private LocalHistoryEventDispatcher myEventDispatcher;
    private final AtomicBoolean isInitialized = new AtomicBoolean();

    @NotNull
    public static LocalHistoryImpl getInstanceImpl() {
        LocalHistoryImpl localHistoryImpl = (LocalHistoryImpl)LocalHistoryImpl.getInstance();
        if (localHistoryImpl == null) {
            LocalHistoryImpl.$$$reportNull$$$0(0);
        }
        return localHistoryImpl;
    }

    public LocalHistoryImpl() {
        this.init();
    }

    private void init() {
        Application app = ApplicationManager.getApplication();
        if (!app.isUnitTestMode() && app.isHeadlessEnvironment()) {
            return;
        }
        PersistentFS instance = PersistentFS.getInstance();
        ShutDownTracker.getInstance().registerShutdownTask(() -> this.doDispose());
        this.initHistory();
        this.isInitialized.set(true);
    }

    private void initHistory() {
        ChangeListStorage storage2;
        try {
            storage2 = new ChangeListStorageImpl(LocalHistoryImpl.getStorageDir());
        }
        catch (Throwable e) {
            LocalHistoryLog.LOG.warn("cannot create storage, in-memory  implementation will be used", e);
            storage2 = new InMemoryChangeListStorage();
        }
        this.myChangeList = new ChangeList(storage2);
        this.myVcs = new LocalHistoryFacade(this.myChangeList);
        this.myGateway = new IdeaGateway();
        this.myEventDispatcher = new LocalHistoryEventDispatcher(this.myVcs, this.myGateway);
    }

    @Nullable
    LocalHistoryEventDispatcher getEventDispatcher() {
        return this.myEventDispatcher;
    }

    @NotNull
    public static Path getStorageDir() {
        Path path = Paths.get(PathManager.getSystemPath(), "LocalHistory");
        if (path == null) {
            LocalHistoryImpl.$$$reportNull$$$0(1);
        }
        return path;
    }

    public void dispose() {
        this.doDispose();
    }

    private void doDispose() {
        if (!this.isInitialized.getAndSet(false)) {
            return;
        }
        long period = (long)Registry.intValue((String)"localHistory.daysToKeep") * 1000L * 60L * 60L * 24L;
        LocalHistoryLog.LOG.debug("Purging local history...");
        this.myChangeList.purgeObsolete(period);
        this.myChangeList.close();
        LocalHistoryLog.LOG.debug("Local history storage successfully closed.");
    }

    @TestOnly
    public void cleanupForNextTest() {
        this.doDispose();
        PathKt.delete((Path)LocalHistoryImpl.getStorageDir());
        this.init();
    }

    public LocalHistoryAction startAction(@NlsContexts.Label String name) {
        if (!this.isInitialized()) {
            return LocalHistoryAction.NULL;
        }
        LocalHistoryActionImpl a = new LocalHistoryActionImpl(this.myEventDispatcher, name);
        a.start();
        return a;
    }

    public Label putUserLabel(@NotNull Project p, @NotNull @NlsContexts.Label String name) {
        if (p == null) {
            LocalHistoryImpl.$$$reportNull$$$0(2);
        }
        if (name == null) {
            LocalHistoryImpl.$$$reportNull$$$0(3);
        }
        if (!this.isInitialized()) {
            return Label.NULL_INSTANCE;
        }
        this.myGateway.registerUnsavedDocuments(this.myVcs);
        return this.label(this.myVcs.putUserLabel(name, LocalHistoryImpl.getProjectId(p)));
    }

    private static String getProjectId(Project p) {
        return p.getLocationHash();
    }

    public Label putSystemLabel(@NotNull Project p, @NotNull @NlsContexts.Label String name, int color) {
        if (p == null) {
            LocalHistoryImpl.$$$reportNull$$$0(4);
        }
        if (name == null) {
            LocalHistoryImpl.$$$reportNull$$$0(5);
        }
        if (!this.isInitialized()) {
            return Label.NULL_INSTANCE;
        }
        this.myGateway.registerUnsavedDocuments(this.myVcs);
        return this.label(this.myVcs.putSystemLabel(name, LocalHistoryImpl.getProjectId(p), color));
    }

    @ApiStatus.Internal
    public void addVFSListenerAfterLocalHistoryOne(BulkFileListener virtualFileListener, Disposable disposable2) {
        this.myEventDispatcher.addVirtualFileListener(virtualFileListener, disposable2);
    }

    private Label label(final LabelImpl impl) {
        return new Label(){

            public void revert(@NotNull Project project, @NotNull VirtualFile file2) throws LocalHistoryException {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                LocalHistoryImpl.this.revertToLabel(project, file2, impl);
            }

            public ByteContent getByteContent(String path) {
                return (ByteContent)ReadAction.compute(() -> impl.getByteContent(LocalHistoryImpl.this.myGateway.createTransientRootEntryForPathOnly(path), path));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/history/integration/LocalHistoryImpl$1";
                objectArray[2] = "revert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public byte @Nullable [] getByteContent(@NotNull VirtualFile f, @NotNull FileRevisionTimestampComparator c) {
        if (f == null) {
            LocalHistoryImpl.$$$reportNull$$$0(6);
        }
        if (c == null) {
            LocalHistoryImpl.$$$reportNull$$$0(7);
        }
        if (!this.isInitialized()) {
            return null;
        }
        if (!this.myGateway.areContentChangesVersioned(f)) {
            return null;
        }
        return (byte[])ReadAction.compute(() -> new ByteContentRetriever(this.myGateway, this.myVcs, f, c).getResult());
    }

    public boolean isUnderControl(@NotNull VirtualFile f) {
        if (f == null) {
            LocalHistoryImpl.$$$reportNull$$$0(8);
        }
        return this.isInitialized() && this.myGateway.isVersioned(f);
    }

    private boolean isInitialized() {
        return this.isInitialized.get();
    }

    @Nullable
    public LocalHistoryFacade getFacade() {
        return this.myVcs;
    }

    @Nullable
    public IdeaGateway getGateway() {
        return this.myGateway;
    }

    private void revertToLabel(@NotNull Project project, @NotNull VirtualFile f, @NotNull LabelImpl impl) throws LocalHistoryException {
        HistoryDialogModel dirHistoryModel;
        int leftRev;
        if (project == null) {
            LocalHistoryImpl.$$$reportNull$$$0(9);
        }
        if (f == null) {
            LocalHistoryImpl.$$$reportNull$$$0(10);
        }
        if (impl == null) {
            LocalHistoryImpl.$$$reportNull$$$0(11);
        }
        if ((leftRev = LocalHistoryUtil.findRevisionIndexToRevert(dirHistoryModel = f.isDirectory() ? new DirectoryHistoryDialogModel(project, this.myGateway, this.myVcs, f) : new EntireFileHistoryDialogModel(project, this.myGateway, this.myVcs, f), impl)) < 0) {
            throw new LocalHistoryException("Couldn't find label revision");
        }
        if (leftRev == 0) {
            return;
        }
        try {
            dirHistoryModel.selectRevisions(-1, leftRev - 1);
            dirHistoryModel.createReverter().revert();
        }
        catch (Exception e) {
            throw new LocalHistoryException(String.format("Couldn't revert %s to local history label.", f.getName()), (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/history/integration/LocalHistoryImpl";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "impl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageDir";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/history/integration/LocalHistoryImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putUserLabel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "putSystemLabel";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getByteContent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isUnderControl";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "revertToLabel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

