/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.history.core.Content;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.Paths;
import com.intellij.history.core.StoredContent;
import com.intellij.history.core.tree.DirectoryEntry;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.FileEntry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaGateway {
    private static final Key<ContentAndTimestamps> SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY = Key.create((String)"LocalHistory.SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY");
    private static final ThreadLocal<VfsEventDispatchContext> ourCurrentEventDispatchContext = new ThreadLocal();

    public boolean isVersioned(@NotNull VirtualFile f) {
        if (f == null) {
            IdeaGateway.$$$reportNull$$$0(0);
        }
        return this.isVersioned(f, false);
    }

    public boolean isVersioned(@NotNull VirtualFile f, boolean shouldBeInContent) {
        CharSequence fileName;
        if (f == null) {
            IdeaGateway.$$$reportNull$$$0(1);
        }
        if (!f.isInLocalFileSystem()) {
            return false;
        }
        if (!f.isDirectory() && (StringUtil.equals((CharSequence)(fileName = f.getNameSequence()), (CharSequence)"workspace.xml") || StringUtil.endsWith((CharSequence)fileName, (CharSequence)".iws") || StringUtil.endsWith((CharSequence)fileName, (CharSequence)".class"))) {
            return false;
        }
        VersionedFilterData versionedFilterData = IdeaGateway.getVersionedFilterData();
        int numberOfOpenProjects = versionedFilterData.myOpenedProjects.size();
        if (numberOfOpenProjects == 0) {
            if (shouldBeInContent) {
                return false;
            }
            return !FileTypeManager.getInstance().isFileIgnored(f);
        }
        boolean isExcludedFromAll = true;
        boolean isInContent = false;
        for (int i2 = 0; i2 < numberOfOpenProjects; ++i2) {
            ProjectFileIndex index2 = versionedFilterData.myProjectFileIndices.get(i2);
            if (index2.isUnderIgnored(f)) {
                return false;
            }
            isInContent |= index2.isInContent(f);
            isExcludedFromAll &= index2.isExcluded(f);
        }
        if (isExcludedFromAll) {
            return false;
        }
        return !shouldBeInContent || isInContent;
    }

    @NotNull
    protected static VersionedFilterData getVersionedFilterData() {
        VersionedFilterData versionedFilterData;
        VfsEventDispatchContext vfsEventDispatchContext = ourCurrentEventDispatchContext.get();
        if (vfsEventDispatchContext != null) {
            versionedFilterData = vfsEventDispatchContext.myFilterData;
            if (versionedFilterData == null) {
                versionedFilterData = vfsEventDispatchContext.myFilterData = new VersionedFilterData();
            }
        } else {
            versionedFilterData = new VersionedFilterData();
        }
        VersionedFilterData versionedFilterData2 = versionedFilterData;
        if (versionedFilterData2 == null) {
            IdeaGateway.$$$reportNull$$$0(2);
        }
        return versionedFilterData2;
    }

    public void runWithVfsEventsDispatchContext(List<? extends VFileEvent> events, boolean beforeEvents, Runnable action2) {
        try (VfsEventDispatchContext ignored = new VfsEventDispatchContext(events, beforeEvents);){
            action2.run();
        }
    }

    public boolean areContentChangesVersioned(@NotNull VirtualFile f) {
        if (f == null) {
            IdeaGateway.$$$reportNull$$$0(3);
        }
        return this.isVersioned(f) && !f.isDirectory() && (this.areContentChangesVersioned(f.getName()) || ScratchFileService.findRootType((VirtualFile)f) != null);
    }

    public boolean areContentChangesVersioned(@NotNull String fileName) {
        if (fileName == null) {
            IdeaGateway.$$$reportNull$$$0(4);
        }
        return !FileTypeManager.getInstance().getFileTypeByFileName(fileName).isBinary();
    }

    public boolean ensureFilesAreWritable(@NotNull Project p, @NotNull List<? extends VirtualFile> ff) {
        ReadonlyStatusHandler h;
        if (p == null) {
            IdeaGateway.$$$reportNull$$$0(5);
        }
        if (ff == null) {
            IdeaGateway.$$$reportNull$$$0(6);
        }
        return !(h = ReadonlyStatusHandler.getInstance((Project)p)).ensureFilesWritable(ff).hasReadonlyFiles();
    }

    @Nullable
    public VirtualFile findVirtualFile(@NotNull String path) {
        VirtualFile file2;
        if (path == null) {
            IdeaGateway.$$$reportNull$$$0(7);
        }
        if ((file2 = LocalFileSystem.getInstance().findFileByPath(path)) == null && ApplicationManager.getApplication().isUnitTestMode()) {
            return TempFileSystem.getInstance().findFileByPath(path);
        }
        return file2;
    }

    @NotNull
    public VirtualFile findOrCreateFileSafely(@NotNull VirtualFile parent, @NotNull String name, boolean isDirectory) throws IOException {
        VirtualFile f;
        if (parent == null) {
            IdeaGateway.$$$reportNull$$$0(8);
        }
        if (name == null) {
            IdeaGateway.$$$reportNull$$$0(9);
        }
        if ((f = parent.findChild(name)) != null && f.isDirectory() != isDirectory) {
            f.delete((Object)this);
            f = null;
        }
        if (f == null) {
            f = isDirectory ? parent.createChildDirectory((Object)this, name) : parent.createChildData((Object)this, name);
        }
        VirtualFile virtualFile = f;
        if (virtualFile == null) {
            IdeaGateway.$$$reportNull$$$0(10);
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile findOrCreateFileSafely(@NotNull String path, boolean isDirectory) throws IOException {
        VirtualFile f;
        if (path == null) {
            IdeaGateway.$$$reportNull$$$0(11);
        }
        if ((f = this.findVirtualFile(path)) != null && f.isDirectory() != isDirectory) {
            f.delete((Object)this);
            f = null;
        }
        if (f == null) {
            VirtualFile parent = this.findOrCreateFileSafely(Paths.getParentOf(path), true);
            String name = Paths.getNameOf(path);
            f = isDirectory ? parent.createChildDirectory((Object)this, name) : parent.createChildData((Object)this, name);
        }
        VirtualFile virtualFile = f;
        if (virtualFile == null) {
            IdeaGateway.$$$reportNull$$$0(12);
        }
        return virtualFile;
    }

    public List<VirtualFile> getAllFilesFrom(@NotNull String path) {
        VirtualFile f;
        if (path == null) {
            IdeaGateway.$$$reportNull$$$0(13);
        }
        if ((f = this.findVirtualFile(path)) == null) {
            return Collections.emptyList();
        }
        return IdeaGateway.collectFiles(f, new ArrayList<VirtualFile>());
    }

    @NotNull
    private static List<VirtualFile> collectFiles(@NotNull VirtualFile f, @NotNull List<VirtualFile> result2) {
        if (f == null) {
            IdeaGateway.$$$reportNull$$$0(14);
        }
        if (result2 == null) {
            IdeaGateway.$$$reportNull$$$0(15);
        }
        if (f.isDirectory()) {
            for (VirtualFile child2 : IdeaGateway.iterateDBChildren(f)) {
                IdeaGateway.collectFiles(child2, result2);
            }
        } else {
            result2.add(f);
        }
        List<VirtualFile> list2 = result2;
        if (list2 == null) {
            IdeaGateway.$$$reportNull$$$0(16);
        }
        return list2;
    }

    @NotNull
    public static Iterable<VirtualFile> iterateDBChildren(VirtualFile f) {
        if (!(f instanceof NewVirtualFile)) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                IdeaGateway.$$$reportNull$$$0(17);
            }
            return list2;
        }
        NewVirtualFile nf = (NewVirtualFile)f;
        Iterable iterable = nf.iterInDbChildrenWithoutLoadingVfsFromOtherProjects();
        if (iterable == null) {
            IdeaGateway.$$$reportNull$$$0(18);
        }
        return iterable;
    }

    @NotNull
    public static Iterable<VirtualFile> loadAndIterateChildren(VirtualFile f) {
        if (!(f instanceof NewVirtualFile)) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                IdeaGateway.$$$reportNull$$$0(19);
            }
            return list2;
        }
        NewVirtualFile nf = (NewVirtualFile)f;
        List<VirtualFile> list3 = Arrays.asList(nf.getChildren());
        if (list3 == null) {
            IdeaGateway.$$$reportNull$$$0(20);
        }
        return list3;
    }

    @NotNull
    public RootEntry createTransientRootEntry() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        RootEntry root = new RootEntry();
        this.doCreateChildren(root, IdeaGateway.getLocalRoots(), false);
        RootEntry rootEntry = root;
        if (rootEntry == null) {
            IdeaGateway.$$$reportNull$$$0(21);
        }
        return rootEntry;
    }

    @NotNull
    public RootEntry createTransientRootEntryForPathOnly(@NotNull String path) {
        if (path == null) {
            IdeaGateway.$$$reportNull$$$0(22);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        RootEntry root = new RootEntry();
        this.doCreateChildrenForPathOnly(root, path, IdeaGateway.getLocalRoots());
        RootEntry rootEntry = root;
        if (rootEntry == null) {
            IdeaGateway.$$$reportNull$$$0(23);
        }
        return rootEntry;
    }

    private static List<VirtualFile> getLocalRoots() {
        return Arrays.asList(ManagingFS.getInstance().getLocalRoots());
    }

    private void doCreateChildrenForPathOnly(@NotNull DirectoryEntry parent, @NotNull String path, @NotNull Iterable<? extends VirtualFile> children2) {
        if (parent == null) {
            IdeaGateway.$$$reportNull$$$0(24);
        }
        if (path == null) {
            IdeaGateway.$$$reportNull$$$0(25);
        }
        if (children2 == null) {
            IdeaGateway.$$$reportNull$$$0(26);
        }
        for (VirtualFile virtualFile : children2) {
            Entry e;
            String rest;
            String name = StringUtil.trimStart((String)virtualFile.getName(), (String)"/");
            if (!path.startsWith(name) || !(rest = path.substring(name.length())).isEmpty() && rest.charAt(0) != '/') continue;
            if (!rest.isEmpty() && rest.charAt(0) == '/') {
                rest = rest.substring(1);
            }
            if ((e = this.doCreateEntryForPathOnly(virtualFile, rest)) == null) continue;
            parent.addChild(e);
        }
    }

    @Nullable
    private Entry doCreateEntryForPathOnly(@NotNull VirtualFile file2, @NotNull String path) {
        if (file2 == null) {
            IdeaGateway.$$$reportNull$$$0(27);
        }
        if (path == null) {
            IdeaGateway.$$$reportNull$$$0(28);
        }
        if (!file2.isDirectory()) {
            if (!this.isVersioned(file2)) {
                return null;
            }
            return this.doCreateFileEntry(file2, IdeaGateway.getActualContentNoAcquire(file2));
        }
        DirectoryEntry newDir = new DirectoryEntry(file2.getName());
        this.doCreateChildrenForPathOnly(newDir, path, IdeaGateway.iterateDBChildren(file2));
        if (!this.isVersioned(file2) && newDir.getChildren().isEmpty()) {
            return null;
        }
        return newDir;
    }

    @Nullable
    public Entry createTransientEntry(@NotNull VirtualFile file2) {
        if (file2 == null) {
            IdeaGateway.$$$reportNull$$$0(29);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.doCreateEntry(file2, false);
    }

    @Nullable
    public Entry createEntryForDeletion(@NotNull VirtualFile file2) {
        if (file2 == null) {
            IdeaGateway.$$$reportNull$$$0(30);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.doCreateEntry(file2, true);
    }

    @Nullable
    private Entry doCreateEntry(@NotNull VirtualFile file2, boolean forDeletion) {
        int nameId;
        if (file2 == null) {
            IdeaGateway.$$$reportNull$$$0(31);
        }
        if (!file2.isDirectory()) {
            Pair<StoredContent, Long> contentAndStamps;
            if (!this.isVersioned(file2)) {
                return null;
            }
            if (forDeletion) {
                FileDocumentManager m = FileDocumentManager.getInstance();
                Document d = m.isFileModified(file2) ? m.getCachedDocument(file2) : null;
                contentAndStamps = this.acquireAndClearCurrentContent(file2, d);
            } else {
                contentAndStamps = IdeaGateway.getActualContentNoAcquire(file2);
            }
            return this.doCreateFileEntry(file2, contentAndStamps);
        }
        DirectoryEntry newDir = null;
        if (file2 instanceof VirtualFileSystemEntry && (nameId = ((VirtualFileSystemEntry)file2).getNameId()) > 0) {
            newDir = new DirectoryEntry(nameId);
        }
        if (newDir == null) {
            newDir = new DirectoryEntry(file2.getName());
        }
        this.doCreateChildren(newDir, IdeaGateway.iterateDBChildren(file2), forDeletion);
        if (!this.isVersioned(file2) && newDir.getChildren().isEmpty()) {
            return null;
        }
        return newDir;
    }

    @NotNull
    private Entry doCreateFileEntry(@NotNull VirtualFile file2, Pair<StoredContent, Long> contentAndStamps) {
        if (file2 == null) {
            IdeaGateway.$$$reportNull$$$0(32);
        }
        if (file2 instanceof VirtualFileSystemEntry) {
            return new FileEntry(((VirtualFileSystemEntry)file2).getNameId(), (Content)contentAndStamps.first, (long)((Long)contentAndStamps.second), !file2.isWritable());
        }
        return new FileEntry(file2.getName(), (Content)contentAndStamps.first, (long)((Long)contentAndStamps.second), !file2.isWritable());
    }

    private void doCreateChildren(@NotNull DirectoryEntry parent, Iterable<? extends VirtualFile> children2, boolean forDeletion) {
        if (parent == null) {
            IdeaGateway.$$$reportNull$$$0(33);
        }
        List entries2 = ContainerUtil.mapNotNull(children2, each -> this.doCreateEntry((VirtualFile)each, forDeletion));
        parent.addChildren(entries2);
    }

    public void registerUnsavedDocuments(@NotNull LocalHistoryFacade vcs) {
        if (vcs == null) {
            IdeaGateway.$$$reportNull$$$0(34);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            vcs.beginChangeSet();
            for (Document d : FileDocumentManager.getInstance().getUnsavedDocuments()) {
                VirtualFile f = IdeaGateway.getFile(d);
                if (!this.shouldRegisterDocument(f)) continue;
                this.registerDocumentContents(vcs, f, d);
            }
            vcs.endChangeSet(null);
        });
    }

    private boolean shouldRegisterDocument(@Nullable VirtualFile f) {
        return f != null && f.isValid() && this.areContentChangesVersioned(f);
    }

    private void registerDocumentContents(@NotNull LocalHistoryFacade vcs, @NotNull VirtualFile f, Document d) {
        Pair<StoredContent, Long> contentAndStamp;
        if (vcs == null) {
            IdeaGateway.$$$reportNull$$$0(35);
        }
        if (f == null) {
            IdeaGateway.$$$reportNull$$$0(36);
        }
        if ((contentAndStamp = this.acquireAndUpdateActualContent(f, d)) != null) {
            vcs.contentChanged(f.getPath(), (Content)contentAndStamp.first, (Long)contentAndStamp.second);
        }
    }

    @Nullable
    public Pair<StoredContent, Long> acquireAndUpdateActualContent(@NotNull VirtualFile f, @Nullable Document d) {
        ContentAndTimestamps contentAndStamp;
        if (f == null) {
            IdeaGateway.$$$reportNull$$$0(37);
        }
        if ((contentAndStamp = (ContentAndTimestamps)f.getUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY)) == null) {
            if (d != null) {
                IdeaGateway.saveDocumentContent(f, d);
            }
            return Pair.create((Object)StoredContent.acquireContent(f), (Object)f.getTimeStamp());
        }
        if (d == null) {
            f.putUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY, null);
            return Pair.create((Object)contentAndStamp.content, (Object)contentAndStamp.registeredTimestamp);
        }
        if (d.getModificationStamp() == contentAndStamp.documentModificationStamp) {
            return null;
        }
        IdeaGateway.saveDocumentContent(f, d);
        return Pair.create((Object)contentAndStamp.content, (Object)contentAndStamp.registeredTimestamp);
    }

    private static void saveDocumentContent(@NotNull VirtualFile f, @NotNull Document d) {
        if (f == null) {
            IdeaGateway.$$$reportNull$$$0(38);
        }
        if (d == null) {
            IdeaGateway.$$$reportNull$$$0(39);
        }
        f.putUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY, (Object)new ContentAndTimestamps(Clock.getTime(), StoredContent.acquireContent(IdeaGateway.bytesFromDocument(d)), d.getModificationStamp()));
    }

    @NotNull
    public Pair<StoredContent, Long> acquireAndClearCurrentContent(@NotNull VirtualFile f, @Nullable Document d) {
        if (f == null) {
            IdeaGateway.$$$reportNull$$$0(40);
        }
        ContentAndTimestamps contentAndStamp = (ContentAndTimestamps)f.getUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY);
        f.putUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY, null);
        if (d != null && contentAndStamp != null && d.getModificationStamp() == contentAndStamp.documentModificationStamp) {
            Pair pair = Pair.create((Object)contentAndStamp.content, (Object)contentAndStamp.registeredTimestamp);
            if (pair == null) {
                IdeaGateway.$$$reportNull$$$0(41);
            }
            return pair;
        }
        if (contentAndStamp != null) {
            contentAndStamp.content.release();
        }
        if (d != null) {
            Pair pair = Pair.create((Object)StoredContent.acquireContent(IdeaGateway.bytesFromDocument(d)), (Object)Clock.getTime());
            if (pair == null) {
                IdeaGateway.$$$reportNull$$$0(42);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)StoredContent.acquireContent(f), (Object)f.getTimeStamp());
        if (pair == null) {
            IdeaGateway.$$$reportNull$$$0(43);
        }
        return pair;
    }

    @NotNull
    private static Pair<StoredContent, Long> getActualContentNoAcquire(@NotNull VirtualFile f) {
        ContentAndTimestamps result2;
        if (f == null) {
            IdeaGateway.$$$reportNull$$$0(44);
        }
        if ((result2 = (ContentAndTimestamps)f.getUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY)) == null) {
            Pair pair = Pair.create((Object)StoredContent.transientContent(f), (Object)f.getTimeStamp());
            if (pair == null) {
                IdeaGateway.$$$reportNull$$$0(45);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)result2.content, (Object)result2.registeredTimestamp);
        if (pair == null) {
            IdeaGateway.$$$reportNull$$$0(46);
        }
        return pair;
    }

    private static byte[] bytesFromDocument(@NotNull Document d) {
        VirtualFile file2;
        if (d == null) {
            IdeaGateway.$$$reportNull$$$0(47);
        }
        Charset charset = (file2 = IdeaGateway.getFile(d)) != null ? file2.getCharset() : EncodingRegistry.getInstance().getDefaultCharset();
        return d.getText().getBytes(charset);
    }

    public String stringFromBytes(byte @NotNull [] bytes, @NotNull String path) {
        VirtualFile file2;
        if (path == null) {
            IdeaGateway.$$$reportNull$$$0(48);
        }
        if (bytes == null) {
            IdeaGateway.$$$reportNull$$$0(49);
        }
        Charset charset = (file2 = this.findVirtualFile(path)) != null ? file2.getCharset() : EncodingRegistry.getInstance().getDefaultCharset();
        return CharsetToolkit.bytesToString((byte[])bytes, (Charset)charset);
    }

    public void saveAllUnsavedDocuments() {
        FileDocumentManager.getInstance().saveAllDocuments();
    }

    @Nullable
    private static VirtualFile getFile(@NotNull Document d) {
        if (d == null) {
            IdeaGateway.$$$reportNull$$$0(50);
        }
        return FileDocumentManager.getInstance().getFile(d);
    }

    @Nullable
    public Document getDocument(@NotNull String path) {
        if (path == null) {
            IdeaGateway.$$$reportNull$$$0(51);
        }
        return FileDocumentManager.getInstance().getDocument(this.findVirtualFile(path));
    }

    @NotNull
    public FileType getFileType(@NotNull String fileName) {
        if (fileName == null) {
            IdeaGateway.$$$reportNull$$$0(52);
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        if (fileType == null) {
            IdeaGateway.$$$reportNull$$$0(53);
        }
        return fileType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 53: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 2: 
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/history/integration/IdeaGateway";
                break;
            }
            case 4: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ff";
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 22: 
            case 25: 
            case 28: 
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: 
            case 24: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 39: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/history/integration/IdeaGateway";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionedFilterData";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateFileSafely";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFiles";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateDBChildren";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAndIterateChildren";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createTransientRootEntry";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createTransientRootEntryForPathOnly";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "acquireAndClearCurrentContent";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualContentNoAcquire";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isVersioned";
                break;
            }
            case 2: 
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 53: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "areContentChangesVersioned";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "ensureFilesAreWritable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findVirtualFile";
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateFileSafely";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAllFilesFrom";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectFiles";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createTransientRootEntryForPathOnly";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "doCreateChildrenForPathOnly";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "doCreateEntryForPathOnly";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createTransientEntry";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createEntryForDeletion";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "doCreateEntry";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "doCreateFileEntry";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "doCreateChildren";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "registerUnsavedDocuments";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "registerDocumentContents";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "acquireAndUpdateActualContent";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "saveDocumentContent";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "acquireAndClearCurrentContent";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getActualContentNoAcquire";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "bytesFromDocument";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "stringFromBytes";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getFileType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 53: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ContentAndTimestamps {
        long registeredTimestamp;
        StoredContent content;
        long documentModificationStamp;

        private ContentAndTimestamps(long registeredTimestamp, StoredContent content2, long documentModificationStamp) {
            this.registeredTimestamp = registeredTimestamp;
            this.content = content2;
            this.documentModificationStamp = documentModificationStamp;
        }
    }

    private static class VersionedFilterData {
        final List<Project> myOpenedProjects = new ArrayList<Project>();
        final List<ProjectFileIndex> myProjectFileIndices = new ArrayList<ProjectFileIndex>();

        VersionedFilterData() {
            Project[] openProjects;
            for (Project each : openProjects = ProjectManager.getInstance().getOpenProjects()) {
                if (each.isDefault() || !each.isInitialized()) continue;
                this.myOpenedProjects.add(each);
                this.myProjectFileIndices.add(ProjectRootManager.getInstance((Project)each).getFileIndex());
            }
        }
    }

    private static class VfsEventDispatchContext
    implements AutoCloseable {
        final List<? extends VFileEvent> myEvents;
        final boolean myBeforeEvents;
        final VfsEventDispatchContext myPreviousContext;
        VersionedFilterData myFilterData;

        VfsEventDispatchContext(List<? extends VFileEvent> events, boolean beforeEvents) {
            this.myEvents = events;
            this.myBeforeEvents = beforeEvents;
            this.myPreviousContext = ourCurrentEventDispatchContext.get();
            if (this.myPreviousContext != null) {
                this.myFilterData = this.myPreviousContext.myFilterData;
            }
            ourCurrentEventDispatchContext.set(this);
        }

        @Override
        public void close() {
            ourCurrentEventDispatchContext.set(this.myPreviousContext);
            if (this.myPreviousContext != null && this.myPreviousContext.myFilterData == null && this.myFilterData != null) {
                this.myPreviousContext.myFilterData = this.myFilterData;
            }
        }
    }
}

