/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.core.ChangeListStorage;
import com.intellij.history.core.ChangeSetHolder;
import com.intellij.history.core.LocalHistoryStorage;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.utils.LocalHistoryLog;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.util.Consumer;
import com.intellij.util.io.storage.AbstractStorage;
import gnu.trove.TIntHashSet;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.MessageFormat;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChangeListStorageImpl
implements ChangeListStorage {
    private static final int VERSION = 6;
    @NonNls
    private static final String STORAGE_FILE = "changes";
    private final Path myStorageDir;
    private LocalHistoryStorage myStorage;
    private long myLastId;
    private boolean isCompletelyBroken;

    public ChangeListStorageImpl(@NotNull Path storageDir) throws IOException {
        if (storageDir == null) {
            ChangeListStorageImpl.$$$reportNull$$$0(0);
        }
        this.myStorageDir = storageDir;
        this.initStorage(this.myStorageDir);
    }

    private synchronized void initStorage(@NotNull Path storageDir) throws IOException {
        boolean timestampMismatch;
        if (storageDir == null) {
            ChangeListStorageImpl.$$$reportNull$$$0(1);
        }
        Path path = storageDir.resolve(STORAGE_FILE);
        boolean fromScratch = ApplicationManager.getApplication().isUnitTestMode() && !Files.exists(path, new LinkOption[0]);
        LocalHistoryStorage result2 = new LocalHistoryStorage(path);
        long fsTimestamp = ChangeListStorageImpl.getVFSTimestamp();
        int storedVersion = result2.getVersion();
        boolean versionMismatch = storedVersion != 6;
        boolean bl = timestampMismatch = result2.getFSTimestamp() != fsTimestamp;
        if (versionMismatch || timestampMismatch) {
            if (!fromScratch) {
                if (versionMismatch) {
                    LocalHistoryLog.LOG.info(MessageFormat.format("local history version mismatch (was: {0}, expected: {1}), rebuilding...", storedVersion, 6));
                }
                if (timestampMismatch) {
                    LocalHistoryLog.LOG.info("FS has been rebuild, rebuilding local history...");
                }
                Disposer.dispose((Disposable)result2);
                FileUtil.delete((Path)storageDir);
                result2 = new LocalHistoryStorage(path);
            }
            result2.setVersion(6);
            result2.setFSTimestamp(fsTimestamp);
        }
        this.myLastId = result2.getLastId();
        this.myStorage = result2;
    }

    private static long getVFSTimestamp() {
        return ManagingFS.getInstance().getCreationTimestamp();
    }

    private void handleError(Throwable e, @Nullable @NonNls String message2) {
        long storageTimestamp = -1L;
        long vfsTimestamp = ChangeListStorageImpl.getVFSTimestamp();
        long timestamp = System.currentTimeMillis();
        try {
            storageTimestamp = this.myStorage.getFSTimestamp();
        }
        catch (Exception ex) {
            LocalHistoryLog.LOG.warn("cannot read storage timestamp", (Throwable)ex);
        }
        LocalHistoryLog.LOG.error("Local history is broken(version:6, current timestamp: " + DateFormat.getDateTimeInstance().format(timestamp) + ", storage timestamp: " + DateFormat.getDateTimeInstance().format(storageTimestamp) + ", vfs timestamp: " + DateFormat.getDateTimeInstance().format(vfsTimestamp) + ", path: " + this.myStorageDir + ")\n" + message2, e);
        Disposer.dispose((Disposable)this.myStorage);
        try {
            FileUtil.delete((Path)this.myStorageDir);
            this.initStorage(this.myStorageDir);
        }
        catch (Throwable ex) {
            LocalHistoryLog.LOG.error("cannot recreate storage", ex);
            this.isCompletelyBroken = true;
        }
        ChangeListStorageImpl.notifyUser();
    }

    private static void notifyUser() {
        new Notification("System Messages", LocalHistoryBundle.message("notification.title.local.history.broken", new Object[0]), LocalHistoryBundle.message("notification.content.local.history.broken", new Object[0]), NotificationType.ERROR).notify(null);
    }

    @Override
    public synchronized void close() {
        Disposer.dispose((Disposable)this.myStorage);
    }

    @Override
    public synchronized long nextId() {
        return ++this.myLastId;
    }

    @Override
    @Nullable
    public synchronized ChangeSetHolder readPrevious(int id2, TIntHashSet recursionGuard) {
        if (this.isCompletelyBroken) {
            return null;
        }
        int prevId = 0;
        try {
            int n = prevId = id2 == -1 ? this.myStorage.getLastRecord() : this.doReadPrevSafely(id2, recursionGuard);
            if (prevId == 0) {
                return null;
            }
            return this.doReadBlock(prevId);
        }
        catch (Throwable e) {
            String message2 = null;
            if (prevId != 0) {
                try {
                    Pair<Long, Integer> prevOS = this.myStorage.getOffsetAndSize(prevId);
                    long prevRecordTimestamp = this.myStorage.getTimestamp(prevId);
                    int lastRecord = this.myStorage.getLastRecord();
                    Pair<Long, Integer> lastOS = this.myStorage.getOffsetAndSize(lastRecord);
                    long lastRecordTimestamp = this.myStorage.getTimestamp(lastRecord);
                    message2 = "invalid record is: " + prevId + " offset: " + prevOS.first + " size: " + prevOS.second + " (created " + DateFormat.getDateTimeInstance().format(prevRecordTimestamp) + ") last record is: " + lastRecord + " offset: " + lastOS.first + " size: " + lastOS.second + " (created " + DateFormat.getDateTimeInstance().format(lastRecordTimestamp) + ")";
                }
                catch (Exception e1) {
                    message2 = "cannot retrieve more debug info: " + e1.getMessage();
                }
            }
            this.handleError(e, message2);
            return null;
        }
    }

    @NotNull
    private ChangeSetHolder doReadBlock(int id2) throws IOException {
        DataInputStream in = this.myStorage.readStream(id2);
        ChangeSetHolder changeSetHolder = new ChangeSetHolder(id2, new ChangeSet(in));
        ChangeSetHolder changeSetHolder2 = changeSetHolder;
        if (changeSetHolder2 == null) {
            ChangeListStorageImpl.$$$reportNull$$$0(2);
        }
        return changeSetHolder2;
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    @Override
    public synchronized void writeNextSet(ChangeSet changeSet) {
        if (this.isCompletelyBroken) {
            return;
        }
        try {
            try (AbstractStorage.StorageDataOutput out = this.myStorage.writeStream(this.myStorage.createNextRecord(), true);){
                changeSet.write((DataOutput)out);
            }
            this.myStorage.setLastId(this.myLastId);
            this.myStorage.force();
        }
        catch (IOException e) {
            this.handleError(e, null);
        }
    }

    @Override
    public synchronized void purge(long period, int intervalBetweenActivities, Consumer<? super ChangeSet> processor2) {
        if (this.isCompletelyBroken) {
            return;
        }
        TIntHashSet recursionGuard = new TIntHashSet(1000);
        try {
            int firstObsoleteId = this.findFirstObsoleteBlock(period, intervalBetweenActivities, recursionGuard);
            if (firstObsoleteId == 0) {
                return;
            }
            int eachBlockId = firstObsoleteId;
            while (eachBlockId != 0) {
                processor2.consume((Object)this.doReadBlock((int)eachBlockId).changeSet);
                eachBlockId = this.doReadPrevSafely(eachBlockId, recursionGuard);
            }
            this.myStorage.deleteRecordsUpTo(firstObsoleteId);
            this.myStorage.force();
        }
        catch (IOException e) {
            this.handleError(e, null);
        }
    }

    private int findFirstObsoleteBlock(long period, int intervalBetweenActivities, TIntHashSet recursionGuard) throws IOException {
        long prevTimestamp = 0L;
        long length = 0L;
        int last = this.myStorage.getLastRecord();
        while (last != 0) {
            long t = this.myStorage.getTimestamp(last);
            if (prevTimestamp == 0L) {
                prevTimestamp = t;
            }
            long delta = prevTimestamp - t;
            prevTimestamp = t;
            if ((length += delta < (long)intervalBetweenActivities ? delta : 1L) >= period) {
                return last;
            }
            last = this.doReadPrevSafely(last, recursionGuard);
        }
        return 0;
    }

    private int doReadPrevSafely(int id2, TIntHashSet recursionGuard) throws IOException {
        recursionGuard.add(id2);
        int prev2 = this.myStorage.getPrevRecord(id2);
        if (!recursionGuard.add(prev2)) {
            throw new IOException("Recursive records found");
        }
        return prev2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/history/core/ChangeListStorageImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/history/core/ChangeListStorageImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doReadBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initStorage";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

