/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.core.ChangeListStorage;
import com.intellij.history.core.ChangeSetHolder;
import com.intellij.history.core.Content;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.utils.LocalHistoryLog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.Consumer;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.TestOnly;

public class ChangeList {
    private final ChangeListStorage myStorage;
    private int myChangeSetDepth;
    private ChangeSet myCurrentChangeSet;
    private int myIntervalBetweenActivities = 43200000;

    public ChangeList(ChangeListStorage storage2) {
        this.myStorage = storage2;
    }

    public synchronized void close() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            LocalHistoryLog.LOG.assertTrue(this.myCurrentChangeSet == null || this.myCurrentChangeSet.isEmpty(), (Object)("current changes won't be saved: " + this.myCurrentChangeSet));
        }
        this.myStorage.close();
    }

    public synchronized long nextId() {
        return this.myStorage.nextId();
    }

    public synchronized void addChange(Change c) {
        assert (this.myChangeSetDepth != 0);
        this.myCurrentChangeSet.addChange(c);
    }

    public synchronized void beginChangeSet() {
        ++this.myChangeSetDepth;
        if (this.myChangeSetDepth > 1) {
            return;
        }
        this.doBeginChangeSet();
    }

    private void doBeginChangeSet() {
        this.myCurrentChangeSet = new ChangeSet(this.nextId(), Clock.getTime());
    }

    public synchronized boolean forceBeginChangeSet() {
        boolean split2;
        boolean bl = split2 = this.myChangeSetDepth > 0;
        if (split2) {
            this.doEndChangeSet(null);
        }
        ++this.myChangeSetDepth;
        this.doBeginChangeSet();
        return split2;
    }

    public synchronized boolean endChangeSet(@NlsContexts.Label String name) {
        LocalHistoryLog.LOG.assertTrue(this.myChangeSetDepth > 0, (Object)"not balanced 'begin/end-change set' calls");
        --this.myChangeSetDepth;
        if (this.myChangeSetDepth > 0) {
            return false;
        }
        return this.doEndChangeSet(name);
    }

    private boolean doEndChangeSet(@NlsContexts.Label String name) {
        if (this.myCurrentChangeSet.isEmpty()) {
            this.myCurrentChangeSet = null;
            return false;
        }
        this.myCurrentChangeSet.setName(name);
        this.myCurrentChangeSet.lock();
        this.myStorage.writeNextSet(this.myCurrentChangeSet);
        this.myCurrentChangeSet = null;
        return true;
    }

    @TestOnly
    public List<ChangeSet> getChangesInTests() {
        ArrayList<ChangeSet> result2 = new ArrayList<ChangeSet>();
        for (ChangeSet each : this.iterChanges()) {
            result2.add(each);
        }
        return result2;
    }

    public synchronized Iterable<ChangeSet> iterChanges() {
        return new Iterable<ChangeSet>(){

            @Override
            public Iterator<ChangeSet> iterator() {
                return new Iterator<ChangeSet>(){
                    private final TIntHashSet recursionGuard = new TIntHashSet(1000);
                    private ChangeSetHolder currentBlock;
                    private ChangeSet next = this.fetchNext();

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public ChangeSet next() {
                        ChangeSet result2 = this.next;
                        this.next = this.fetchNext();
                        return result2;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private ChangeSet fetchNext() {
                        if (this.currentBlock == null) {
                            ChangeList changeList = ChangeList.this;
                            synchronized (changeList) {
                                this.currentBlock = ChangeList.this.myCurrentChangeSet != null ? new ChangeSetHolder(-1, ChangeList.this.myCurrentChangeSet) : ChangeList.this.myStorage.readPrevious(-1, this.recursionGuard);
                            }
                        }
                        ChangeList changeList = ChangeList.this;
                        synchronized (changeList) {
                            this.currentBlock = ChangeList.this.myStorage.readPrevious(this.currentBlock.id, this.recursionGuard);
                        }
                        if (this.currentBlock == null) {
                            return null;
                        }
                        return this.currentBlock.changeSet;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public void accept(ChangeVisitor v) {
        try {
            for (ChangeSet change : this.iterChanges()) {
                change.accept(v);
            }
        }
        catch (ChangeVisitor.StopVisitingException stopVisitingException) {
            // empty catch block
        }
        v.finished();
    }

    public synchronized void purgeObsolete(long period) {
        this.myStorage.purge(period, this.myIntervalBetweenActivities, (Consumer<? super ChangeSet>)((Consumer)changeSet -> {
            for (Content each : changeSet.getContentsToPurge()) {
                each.release();
            }
        }));
    }

    @TestOnly
    public void setIntervalBetweenActivities(int value2) {
        this.myIntervalBetweenActivities = value2;
    }
}

