/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.facet.impl.DefaultFacetsProvider;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.impl.FacetBasedDetectedFrameworkDescriptionImpl;
import com.intellij.framework.detection.impl.FrameworkDetectionContextBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkDetectionContextImpl
extends FrameworkDetectionContextBase {
    private final Project myProject;

    public FrameworkDetectionContextImpl(@NotNull Project project) {
        if (project == null) {
            FrameworkDetectionContextImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public <F extends Facet, C extends FacetConfiguration> List<? extends DetectedFrameworkDescription> createDetectedFacetDescriptions(@NotNull FacetBasedFrameworkDetector<F, C> detector, @NotNull Collection<? extends VirtualFile> files2) {
        if (detector == null) {
            FrameworkDetectionContextImpl.$$$reportNull$$$0(1);
        }
        if (files2 == null) {
            FrameworkDetectionContextImpl.$$$reportNull$$$0(2);
        }
        MultiMap filesByModule = MultiMap.createSet();
        for (VirtualFile virtualFile : files2) {
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)this.myProject);
            if (module == null) continue;
            filesByModule.putValue((Object)module, (Object)virtualFile);
        }
        ArrayList<FacetBasedDetectedFrameworkDescriptionImpl<F, FacetConfiguration>> result2 = new ArrayList<FacetBasedDetectedFrameworkDescriptionImpl<F, FacetConfiguration>>();
        FacetType facetType = detector.getFacetType();
        FacetsProvider provider2 = DefaultFacetsProvider.INSTANCE;
        for (Module module : filesByModule.keySet()) {
            Collection facets2 = provider2.getFacetsByType(module, facetType.getId());
            if (!facetType.isSuitableModuleType(ModuleType.get((Module)module)) || facetType.isOnlyOneFacetAllowed() && !facets2.isEmpty()) continue;
            ArrayList<FacetConfiguration> existentConfigurations = new ArrayList<FacetConfiguration>();
            for (Facet facet : facets2) {
                existentConfigurations.add(facet.getConfiguration());
            }
            Collection moduleFiles = filesByModule.get((Object)module);
            List pairs = detector.createConfigurations(moduleFiles, existentConfigurations);
            for (Pair pair : pairs) {
                result2.add(new FacetBasedDetectedFrameworkDescriptionImpl<F, FacetConfiguration>(module, detector, (FacetConfiguration)pair.getFirst(), new HashSet<VirtualFile>((Collection)pair.getSecond())));
            }
        }
        ArrayList<FacetBasedDetectedFrameworkDescriptionImpl<F, FacetConfiguration>> arrayList = result2;
        if (arrayList == null) {
            FrameworkDetectionContextImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public VirtualFile getBaseDir() {
        return this.myProject.getBaseDir();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/framework/detection/impl/FrameworkDetectionContextImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/framework/detection/impl/FrameworkDetectionContextImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDetectedFacetDescriptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createDetectedFacetDescriptions";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

