/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.engine;

import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.SpacingImpl;
import com.intellij.formatting.WhiteSpace;
import com.intellij.formatting.WrapImpl;
import com.intellij.formatting.engine.BlockRangesMap;
import com.intellij.formatting.engine.IndentAdjuster;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class WrapProcessor {
    private LeafBlockWrapper myFirstWrappedBlockOnLine = null;
    private final BlockRangesMap myBlockRangesMap;
    private LeafBlockWrapper myWrapCandidate = null;
    private final IndentAdjuster myIndentAdjuster;
    private final int myRightMargin;

    public WrapProcessor(BlockRangesMap blockHelper, IndentAdjuster indentAdjuster, int rightMargin) {
        this.myIndentAdjuster = indentAdjuster;
        this.myBlockRangesMap = blockHelper;
        this.myRightMargin = rightMargin;
    }

    private boolean isSuitableInTheCurrentPosition(WrapImpl wrap, LeafBlockWrapper currentBlock) {
        if (wrap.getWrapOffset() < currentBlock.getStartOffset()) {
            return true;
        }
        if (wrap.isWrapFirstElement()) {
            return true;
        }
        if (wrap.getType() == WrapImpl.Type.WRAP_AS_NEEDED) {
            return this.positionAfterWrappingIsSuitable(currentBlock);
        }
        return wrap.getType() == WrapImpl.Type.CHOP_IF_NEEDED && this.lineOver(currentBlock) && this.positionAfterWrappingIsSuitable(currentBlock);
    }

    private boolean lineOver(LeafBlockWrapper currentBlock) {
        return !currentBlock.containsLineFeeds() && CoreFormatterUtil.getStartColumn(currentBlock) + currentBlock.getLength() > this.myRightMargin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean positionAfterWrappingIsSuitable(LeafBlockWrapper currentBlock) {
        WhiteSpace whiteSpace = currentBlock.getWhiteSpace();
        if (whiteSpace.containsLineFeeds()) {
            return true;
        }
        int spaces = whiteSpace.getSpaces();
        int indentSpaces = whiteSpace.getIndentSpaces();
        try {
            int startColumnNow = CoreFormatterUtil.getStartColumn(currentBlock);
            whiteSpace.ensureLineFeed();
            this.myIndentAdjuster.adjustLineIndent(currentBlock);
            int startColumnAfterWrap = CoreFormatterUtil.getStartColumn(currentBlock);
            boolean bl = startColumnNow > startColumnAfterWrap;
            return bl;
        }
        finally {
            whiteSpace.removeLineFeeds(currentBlock.getSpaceProperty(), this.myBlockRangesMap);
            whiteSpace.setSpaces(spaces, indentSpaces);
        }
    }

    @Nullable
    private WrapImpl getWrapToBeUsed(List<? extends WrapImpl> wraps, LeafBlockWrapper currentBlock) {
        if (wraps.isEmpty()) {
            return null;
        }
        if (this.myWrapCandidate == currentBlock) {
            return wraps.get(0);
        }
        for (WrapImpl wrapImpl : wraps) {
            if (!this.isSuitableInTheCurrentPosition(wrapImpl, currentBlock)) continue;
            if (wrapImpl.isActive()) {
                return wrapImpl;
            }
            WrapImpl.Type type = wrapImpl.getType();
            if (type == WrapImpl.Type.WRAP_ALWAYS) {
                return wrapImpl;
            }
            if (type != WrapImpl.Type.WRAP_AS_NEEDED && type != WrapImpl.Type.CHOP_IF_NEEDED || !this.lineOver(currentBlock)) continue;
            return wrapImpl;
        }
        return null;
    }

    private boolean isCandidateToBeWrapped(WrapImpl wrap, LeafBlockWrapper currentBlock) {
        return this.isSuitableInTheCurrentPosition(wrap, currentBlock) && (wrap.getType() == WrapImpl.Type.WRAP_AS_NEEDED || wrap.getType() == WrapImpl.Type.CHOP_IF_NEEDED) && !currentBlock.getWhiteSpace().isReadOnly();
    }

    private boolean canReplaceWrapCandidate(WrapImpl wrap, LeafBlockWrapper currentBlock) {
        if (this.myWrapCandidate == null) {
            return true;
        }
        WrapImpl.Type type = wrap.getType();
        if (wrap.isActive() && (type == WrapImpl.Type.CHOP_IF_NEEDED || type == WrapImpl.Type.WRAP_ALWAYS)) {
            return true;
        }
        WrapImpl currentWrap = this.myWrapCandidate.getWrap();
        return wrap == currentWrap || !wrap.isChildOf(currentWrap, currentBlock);
    }

    LeafBlockWrapper processWrap(LeafBlockWrapper currentBlock) {
        SpacingImpl spacing = currentBlock.getSpaceProperty();
        WhiteSpace whiteSpace = currentBlock.getWhiteSpace();
        boolean wrapWasPresent = whiteSpace.containsLineFeeds();
        if (wrapWasPresent) {
            this.myFirstWrappedBlockOnLine = null;
            if (!whiteSpace.containsLineFeedsInitially()) {
                whiteSpace.removeLineFeeds(spacing, this.myBlockRangesMap);
            }
        }
        boolean wrapIsPresent = whiteSpace.containsLineFeeds();
        ArrayList<WrapImpl> wraps = currentBlock.getWraps();
        for (WrapImpl wrap : wraps) {
            wrap.setWrapOffset(currentBlock.getStartOffset());
        }
        WrapImpl wrap = this.getWrapToBeUsed(wraps, currentBlock);
        if (wrap != null || wrapIsPresent) {
            if (!wrapIsPresent && !this.canReplaceWrapCandidate(wrap, currentBlock)) {
                return this.myWrapCandidate;
            }
            if (wrap != null && wrap.getChopStartBlock() != null) {
                LeafBlockWrapper newCurrentBlock = wrap.getChopStartBlock();
                wrap.setActive();
                return newCurrentBlock;
            }
            if (wrap != null && this.isChopNeeded(wrap, currentBlock)) {
                wrap.setActive();
            }
            if (!wrapIsPresent) {
                whiteSpace.ensureLineFeed();
                if (!wrapWasPresent) {
                    if (this.myFirstWrappedBlockOnLine != null && wrap.isChildOf(this.myFirstWrappedBlockOnLine.getWrap(), currentBlock)) {
                        wrap.ignoreParentWrap(this.myFirstWrappedBlockOnLine.getWrap(), currentBlock);
                        return this.myFirstWrappedBlockOnLine;
                    }
                    this.myFirstWrappedBlockOnLine = currentBlock;
                }
            }
            this.myWrapCandidate = null;
        } else {
            for (WrapImpl wrap1 : wraps) {
                if (this.isCandidateToBeWrapped(wrap1, currentBlock) && this.canReplaceWrapCandidate(wrap1, currentBlock)) {
                    this.myWrapCandidate = currentBlock;
                }
                if (!this.isChopNeeded(wrap1, currentBlock)) continue;
                wrap1.saveChopBlock(currentBlock);
            }
        }
        if (!whiteSpace.containsLineFeeds() && this.myWrapCandidate != null && !whiteSpace.isReadOnly() && this.lineOver(currentBlock)) {
            return this.myWrapCandidate;
        }
        return null;
    }

    private boolean isChopNeeded(WrapImpl wrap, LeafBlockWrapper currentBlock) {
        return wrap != null && wrap.getType() == WrapImpl.Type.CHOP_IF_NEEDED && this.isSuitableInTheCurrentPosition(wrap, currentBlock);
    }

    void onCurrentLineChanged() {
        this.myWrapCandidate = null;
    }
}

