/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.find.FindBundle;
import com.intellij.find.FindModel;
import com.intellij.find.FindSettings;
import com.intellij.find.impl.FindInProjectSettingsBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="FindSettings", storages={@Storage(value="find.xml")})
public class FindSettingsImpl
extends FindSettings
implements PersistentStateComponent<FindSettingsImpl> {
    @NonNls
    private static final String FIND_DIRECTION_FORWARD = "forward";
    @NonNls
    private static final String FIND_DIRECTION_BACKWARD = "backward";
    @NonNls
    private static final String FIND_ORIGIN_FROM_CURSOR = "from_cursor";
    @NonNls
    private static final String FIND_ORIGIN_ENTIRE_SCOPE = "entire_scope";
    @NonNls
    private static final String FIND_SCOPE_GLOBAL = "global";
    @NonNls
    private static final String FIND_SCOPE_SELECTED = "selected";
    public boolean SEARCH_OVERLOADED_METHODS;
    public boolean SKIP_RESULTS_WHEN_ONE_USAGE;
    public String FIND_DIRECTION = "forward";
    public String FIND_ORIGIN = "from_cursor";
    public String FIND_SCOPE = "global";
    public boolean CASE_SENSITIVE_SEARCH;
    public boolean LOCAL_CASE_SENSITIVE_SEARCH;
    public boolean PRESERVE_CASE_REPLACE;
    public boolean WHOLE_WORDS_ONLY;
    public boolean COMMENTS_ONLY;
    public boolean STRING_LITERALS_ONLY;
    public boolean EXCEPT_COMMENTS;
    public boolean EXCEPT_COMMENTS_AND_STRING_LITERALS;
    public boolean EXCEPT_STRING_LITERALS;
    public boolean LOCAL_WHOLE_WORDS_ONLY;
    public boolean REGULAR_EXPRESSIONS;
    public boolean LOCAL_REGULAR_EXPRESSIONS;
    public boolean WITH_SUBDIRECTORIES = true;
    public boolean SHOW_RESULTS_IN_SEPARATE_VIEW;
    public String SEARCH_SCOPE = FindSettingsImpl.getDefaultSearchScope();
    public String FILE_MASK;
    @Property(surroundWithTag=false)
    @XCollection(propertyElementName="recentFileMasks", elementName="mask", valueAttributeName="")
    public List<String> recentFileMasks = new ArrayList<String>();

    @Override
    public boolean isSearchOverloadedMethods() {
        return this.SEARCH_OVERLOADED_METHODS;
    }

    @Override
    public void setSearchOverloadedMethods(boolean search2) {
        this.SEARCH_OVERLOADED_METHODS = search2;
    }

    public void loadState(@NotNull FindSettingsImpl state) {
        if (state == null) {
            FindSettingsImpl.$$$reportNull$$$0(0);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public FindSettingsImpl getState() {
        return this;
    }

    @Override
    public boolean isSkipResultsWithOneUsage() {
        return this.SKIP_RESULTS_WHEN_ONE_USAGE;
    }

    @Override
    public void setSkipResultsWithOneUsage(boolean skip) {
        this.SKIP_RESULTS_WHEN_ONE_USAGE = skip;
    }

    @Override
    public String getDefaultScopeName() {
        return this.SEARCH_SCOPE;
    }

    @Override
    public void setDefaultScopeName(String scope) {
        this.SEARCH_SCOPE = scope;
    }

    @Override
    public boolean isForward() {
        return FIND_DIRECTION_FORWARD.equals(this.FIND_DIRECTION);
    }

    @Override
    public void setForward(boolean findDirectionForward) {
        this.FIND_DIRECTION = findDirectionForward ? FIND_DIRECTION_FORWARD : FIND_DIRECTION_BACKWARD;
    }

    @Override
    public boolean isFromCursor() {
        return FIND_ORIGIN_FROM_CURSOR.equals(this.FIND_ORIGIN);
    }

    @Override
    public void setFromCursor(boolean findFromCursor) {
        this.FIND_ORIGIN = findFromCursor ? FIND_ORIGIN_FROM_CURSOR : FIND_ORIGIN_ENTIRE_SCOPE;
    }

    @Override
    public boolean isGlobal() {
        return FIND_SCOPE_GLOBAL.equals(this.FIND_SCOPE);
    }

    @Override
    public void setGlobal(boolean findGlobalScope) {
        this.FIND_SCOPE = findGlobalScope ? FIND_SCOPE_GLOBAL : FIND_SCOPE_SELECTED;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.CASE_SENSITIVE_SEARCH;
    }

    @Override
    public void setCaseSensitive(boolean caseSensitiveSearch) {
        this.CASE_SENSITIVE_SEARCH = caseSensitiveSearch;
    }

    @Override
    public boolean isLocalCaseSensitive() {
        return this.LOCAL_CASE_SENSITIVE_SEARCH;
    }

    @Override
    public boolean isLocalWholeWordsOnly() {
        return this.LOCAL_WHOLE_WORDS_ONLY;
    }

    @Override
    public void setLocalCaseSensitive(boolean caseSensitiveSearch) {
        this.LOCAL_CASE_SENSITIVE_SEARCH = caseSensitiveSearch;
    }

    @Override
    public void setLocalWholeWordsOnly(boolean wholeWordsOnly) {
        this.LOCAL_WHOLE_WORDS_ONLY = wholeWordsOnly;
    }

    @Override
    public boolean isPreserveCase() {
        return this.PRESERVE_CASE_REPLACE;
    }

    @Override
    public void setPreserveCase(boolean preserveCase) {
        this.PRESERVE_CASE_REPLACE = preserveCase;
    }

    @Override
    public boolean isWholeWordsOnly() {
        return this.WHOLE_WORDS_ONLY;
    }

    @Override
    public void setWholeWordsOnly(boolean wholeWordsOnly) {
        this.WHOLE_WORDS_ONLY = wholeWordsOnly;
    }

    @Override
    public boolean isRegularExpressions() {
        return this.REGULAR_EXPRESSIONS;
    }

    @Override
    public void setRegularExpressions(boolean regularExpressions) {
        this.REGULAR_EXPRESSIONS = regularExpressions;
    }

    @Override
    public boolean isLocalRegularExpressions() {
        return this.LOCAL_REGULAR_EXPRESSIONS;
    }

    @Override
    public void setLocalRegularExpressions(boolean regularExpressions) {
        this.LOCAL_REGULAR_EXPRESSIONS = regularExpressions;
    }

    @Override
    public void setWithSubdirectories(boolean b) {
        this.WITH_SUBDIRECTORIES = b;
    }

    private boolean isWithSubdirectories() {
        return this.WITH_SUBDIRECTORIES;
    }

    @Override
    public void initModelBySetings(@NotNull FindModel model2) {
        if (model2 == null) {
            FindSettingsImpl.$$$reportNull$$$0(1);
        }
        model2.setCaseSensitive(this.isCaseSensitive());
        model2.setForward(this.isForward());
        model2.setFromCursor(this.isFromCursor());
        model2.setGlobal(this.isGlobal());
        model2.setRegularExpressions(this.isRegularExpressions());
        model2.setWholeWordsOnly(this.isWholeWordsOnly());
        FindModel.SearchContext searchContext = this.isInCommentsOnly() ? FindModel.SearchContext.IN_COMMENTS : (this.isInStringLiteralsOnly() ? FindModel.SearchContext.IN_STRING_LITERALS : (this.isExceptComments() ? FindModel.SearchContext.EXCEPT_COMMENTS : (this.isExceptStringLiterals() ? FindModel.SearchContext.EXCEPT_STRING_LITERALS : (this.isExceptCommentsAndLiterals() ? FindModel.SearchContext.EXCEPT_COMMENTS_AND_STRING_LITERALS : FindModel.SearchContext.ANY))));
        model2.setSearchContext(searchContext);
        model2.setWithSubdirectories(this.isWithSubdirectories());
        model2.setFileFilter(this.FILE_MASK);
    }

    @Override
    public void addStringToFind(@NotNull String s) {
        if (s == null) {
            FindSettingsImpl.$$$reportNull$$$0(2);
        }
        FindRecents.getInstance().addStringToFind(s);
    }

    @Override
    public void addStringToReplace(@NotNull String s) {
        if (s == null) {
            FindSettingsImpl.$$$reportNull$$$0(3);
        }
        FindRecents.getInstance().addStringToReplace(s);
    }

    @Override
    public String @NotNull [] getRecentFindStrings() {
        String[] stringArray = FindRecents.getInstance().getRecentFindStrings();
        if (stringArray == null) {
            FindSettingsImpl.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    @Override
    public String @NotNull [] getRecentReplaceStrings() {
        String[] stringArray = FindRecents.getInstance().getRecentReplaceStrings();
        if (stringArray == null) {
            FindSettingsImpl.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    @Override
    public String @NotNull [] getRecentFileMasks() {
        String[] stringArray = ArrayUtilRt.toStringArray(this.recentFileMasks);
        if (stringArray == null) {
            FindSettingsImpl.$$$reportNull$$$0(6);
        }
        return stringArray;
    }

    @Override
    @Transient
    public String getFileMask() {
        return this.FILE_MASK;
    }

    @Override
    public void setFileMask(String _fileMask) {
        this.FILE_MASK = _fileMask;
        if (!StringUtil.isEmptyOrSpaces((String)_fileMask)) {
            FindInProjectSettingsBase.addRecentStringToList(_fileMask, this.recentFileMasks);
        }
    }

    @Override
    public String getCustomScope() {
        return this.SEARCH_SCOPE;
    }

    @Override
    public boolean isInStringLiteralsOnly() {
        return this.STRING_LITERALS_ONLY;
    }

    @Override
    public boolean isInCommentsOnly() {
        return this.COMMENTS_ONLY;
    }

    @Override
    public void setInCommentsOnly(boolean selected2) {
        this.COMMENTS_ONLY = selected2;
    }

    @Override
    public void setInStringLiteralsOnly(boolean selected2) {
        this.STRING_LITERALS_ONLY = selected2;
    }

    @Override
    public void setCustomScope(String SEARCH_SCOPE) {
        this.SEARCH_SCOPE = SEARCH_SCOPE;
    }

    @Override
    public boolean isExceptComments() {
        return this.EXCEPT_COMMENTS;
    }

    @Override
    public void setExceptCommentsAndLiterals(boolean selected2) {
        this.EXCEPT_COMMENTS_AND_STRING_LITERALS = selected2;
    }

    @Override
    public boolean isShowResultsInSeparateView() {
        return this.SHOW_RESULTS_IN_SEPARATE_VIEW;
    }

    @Override
    public void setShowResultsInSeparateView(boolean optionValue) {
        this.SHOW_RESULTS_IN_SEPARATE_VIEW = optionValue;
    }

    @Override
    public boolean isExceptCommentsAndLiterals() {
        return this.EXCEPT_COMMENTS_AND_STRING_LITERALS;
    }

    @Override
    public void setExceptComments(boolean selected2) {
        this.EXCEPT_COMMENTS = selected2;
    }

    @Override
    public boolean isExceptStringLiterals() {
        return this.EXCEPT_STRING_LITERALS;
    }

    @Override
    public void setExceptStringLiterals(boolean selected2) {
        this.EXCEPT_STRING_LITERALS = selected2;
    }

    private static String getDefaultSearchScope() {
        return FindBundle.message("find.scope.all.project.classes", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/impl/FindSettingsImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/impl/FindSettingsImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentFindStrings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentReplaceStrings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentFileMasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initModelBySetings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addStringToFind";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addStringToReplace";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @State(name="FindRecents", storages={@Storage(value="find.recents.xml", roamingType=RoamingType.DISABLED)})
    static final class FindRecents
    extends FindInProjectSettingsBase {
        FindRecents() {
        }

        public static FindRecents getInstance() {
            return (FindRecents)ApplicationManager.getApplication().getService(FindRecents.class);
        }
    }
}

