/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.CommonBundle;
import com.intellij.accessibility.TextFieldWithListAccessibleContext;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindSettings;
import com.intellij.find.FindUtil;
import com.intellij.find.SearchTextArea;
import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.find.impl.FindInProjectExecutor;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.impl.FindPopupScopeUI;
import com.intellij.find.impl.FindPopupScopeUIImpl;
import com.intellij.find.impl.FindPopupScopeUIProvider;
import com.intellij.find.impl.FindUI;
import com.intellij.find.impl.FindUIHelper;
import com.intellij.find.impl.RegExHelpPopup;
import com.intellij.find.impl.RegExReplacementBuilder;
import com.intellij.find.replaceInProject.ReplaceInProjectManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.scratch.ScratchImplUtil;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.TooltipDescriptionProvider;
import com.intellij.openapi.actionSystem.ex.TooltipLinkProvider;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.pom.Navigatable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.reference.SoftReference;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ListFocusTraversalPolicy;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupBorder;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.StateRestoringCheckBox;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.WindowResizeListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.hover.TableHoverListener;
import com.intellij.ui.mac.TouchbarDataKeys;
import com.intellij.ui.popup.PopupState;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageInfoAdapter;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsagePreviewPanel;
import com.intellij.usages.rules.MergeableUsage;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.FontUtil;
import com.intellij.util.MathUtil;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.PatternUtil;
import com.intellij.util.Producer;
import com.intellij.util.SlowOperations;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import kotlin.jvm.functions.Function1;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promises;

public class FindPopupPanel
extends JBPanel<FindPopupPanel>
implements FindUI {
    private static final KeyStroke ENTER = KeyStroke.getKeyStroke(10, 0);
    private static final KeyStroke ENTER_WITH_MODIFIERS = KeyStroke.getKeyStroke(10, SystemInfo.isMac ? 256 : 128);
    private static final KeyStroke REPLACE_ALL = KeyStroke.getKeyStroke(10, 576);
    private static final KeyStroke RESET_FILTERS = KeyStroke.getKeyStroke(65, 512);
    private static final String FIND_TYPE = "FindInPath";
    private static final String SERVICE_KEY = "find.popup";
    private static final String SPLITTER_SERVICE_KEY = "find.popup.splitter";
    @NotNull
    private final FindUIHelper myHelper;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Disposable myDisposable;
    private final Alarm myPreviewUpdater;
    @NotNull
    private final FindPopupScopeUI myScopeUI;
    private JComponent myCodePreviewComponent;
    private SearchTextArea mySearchTextArea;
    private SearchTextArea myReplaceTextArea;
    private ActionListener myOkActionListener;
    private final AtomicBoolean myCanClose;
    private final AtomicBoolean myIsPinned;
    private JBLabel myOKHintLabel;
    private JBLabel myNavigationHintLabel;
    private Alarm mySearchRescheduleOnCancellationsAlarm;
    private volatile ProgressIndicatorBase myResultsPreviewSearchProgress;
    private JLabel myTitleLabel;
    private JLabel myInfoLabel;
    private final AtomicBoolean myCaseSensitiveState;
    private final AtomicBoolean myPreserveCaseState;
    private final AtomicBoolean myWholeWordsState;
    private final AtomicBoolean myRegexState;
    private StateRestoringCheckBox myCbFileFilter;
    private JCheckBox myNewTabCheckbox;
    private ActionToolbarImpl myScopeSelectionToolbar;
    private ComboBox<String> myFileMaskField;
    private ActionButton myFilterContextButton;
    private JButton myOKButton;
    private JButton myReplaceAllButton;
    private JButton myReplaceSelectedButton;
    private JTextArea mySearchComponent;
    private JTextArea myReplaceComponent;
    private String mySelectedContextName;
    private FindPopupScopeUI.ScopeType mySelectedScope;
    private JPanel myScopeDetailsPanel;
    private JBTable myResultsPreviewTable;
    private DefaultTableModel myResultsPreviewTableModel;
    private SimpleColoredComponent myUsagePreviewTitle;
    private UsagePreviewPanel myUsagePreviewPanel;
    private DialogWrapper myDialog;
    private JLabel myLoadingIcon;
    private int myLoadingHash;
    private final AtomicBoolean myNeedReset;
    private JPanel myTitlePanel;
    private String myUsagesCount;
    private String myFilesCount;
    private UsageViewPresentation myUsageViewPresentation;
    private final ComponentValidator myComponentValidator;
    private AnAction myCaseSensitiveAction;
    private AnAction myWholeWordsAction;
    private AnAction myRegexAction;
    private AnAction myResetFiltersAction;
    private boolean mySuggestRegexHintForEmptyResults;
    private JBSplitter myPreviewSplitter;

    FindPopupPanel(@NotNull FindUIHelper helper) {
        if (helper == null) {
            FindPopupPanel.$$$reportNull$$$0(0);
        }
        this.myCanClose = new AtomicBoolean(true);
        this.myIsPinned = new AtomicBoolean(false);
        this.myCaseSensitiveState = new AtomicBoolean();
        this.myPreserveCaseState = new AtomicBoolean();
        this.myWholeWordsState = new AtomicBoolean();
        this.myRegexState = new AtomicBoolean();
        this.mySelectedContextName = FindBundle.message("find.context.anywhere.scope.label", new Object[0]);
        this.myNeedReset = new AtomicBoolean(true);
        this.mySuggestRegexHintForEmptyResults = true;
        this.myHelper = helper;
        this.myProject = this.myHelper.getProject();
        this.myDisposable = Disposer.newDisposable();
        this.myPreviewUpdater = new Alarm(this.myDisposable);
        this.myScopeUI = FindPopupScopeUIProvider.getInstance().create(this);
        this.myComponentValidator = new ComponentValidator(this.myDisposable){

            public void updateInfo(@Nullable ValidationInfo info) {
                if (info != null && info.component == FindPopupPanel.this.mySearchComponent) {
                    super.updateInfo(null);
                } else {
                    super.updateInfo(info);
                }
            }
        };
        Disposer.register((Disposable)this.myDisposable, () -> {
            this.finishPreviousPreviewSearch();
            if (this.mySearchRescheduleOnCancellationsAlarm != null) {
                Disposer.dispose((Disposable)this.mySearchRescheduleOnCancellationsAlarm);
            }
            if (this.myUsagePreviewPanel != null) {
                Disposer.dispose((Disposable)this.myUsagePreviewPanel);
            }
        });
        this.initComponents();
        this.initByModel();
        FindUtil.triggerUsedOptionsStats(this.myProject, FIND_TYPE, this.myHelper.getModel());
    }

    @Override
    public void showUI() {
        if (this.myDialog != null && this.myDialog.isVisible()) {
            return;
        }
        if (this.myDialog != null && !Disposer.isDisposed((Disposable)this.myDialog.getDisposable())) {
            this.myDialog.doCancelAction();
        }
        if (this.myDialog == null || Disposer.isDisposed((Disposable)this.myDialog.getDisposable())) {
            this.myDialog = new DialogWrapper(this.myHelper.getProject(), null, true, DialogWrapper.IdeModalityType.MODELESS, false){
                {
                    this.init();
                    this.getRootPane().setDefaultButton(null);
                }

                protected void doOKAction() {
                    FindPopupPanel.this.processCtrlEnter();
                }

                protected void dispose() {
                    FindPopupPanel.this.saveSettings();
                    super.dispose();
                }

                @Nullable
                protected Border createContentPaneBorder() {
                    return null;
                }

                protected JComponent createCenterPanel() {
                    return FindPopupPanel.this;
                }

                protected String getDimensionServiceKey() {
                    return FindPopupPanel.SERVICE_KEY;
                }
            };
            this.myDialog.setUndecorated(!Registry.is((String)"ide.find.as.popup.decorated"));
            ApplicationManager.getApplication().getMessageBus().connect(this.myDialog.getDisposable()).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectClosed(@NotNull Project project) {
                    if (project == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    FindPopupPanel.this.closeImmediately();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/impl/FindPopupPanel$3", "projectClosed"));
                }
            });
            Disposer.register((Disposable)this.myDialog.getDisposable(), (Disposable)this.myDisposable);
            Window window = WindowManager.getInstance().suggestParentWindow(this.myProject);
            Component parent = UIUtil.findUltimateParent((Component)window);
            RelativePoint showPoint = null;
            Point screenPoint = DimensionService.getInstance().getLocation(SERVICE_KEY);
            if (screenPoint != null) {
                if (parent != null) {
                    SwingUtilities.convertPointFromScreen(screenPoint, parent);
                    showPoint = new RelativePoint(parent, screenPoint);
                } else {
                    showPoint = new RelativePoint(screenPoint);
                }
            }
            if (parent != null && showPoint == null) {
                int height;
                int n = height = UISettings.getInstance().getShowNavigationBar() ? 135 : 115;
                if (parent instanceof IdeFrameImpl && ((IdeFrameImpl)parent).isInFullScreen()) {
                    height -= 20;
                }
                showPoint = new RelativePoint(parent, new Point((parent.getSize().width - this.getPreferredSize().width) / 2, height));
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.mySearchComponent.getCaret() != null) {
                    this.mySearchComponent.selectAll();
                }
            });
            WindowMoveListener windowListener2 = new WindowMoveListener((Component)((Object)this));
            this.myTitlePanel.addMouseListener(windowListener2);
            this.myTitlePanel.addMouseMotionListener(windowListener2);
            this.addMouseListener(windowListener2);
            this.addMouseMotionListener(windowListener2);
            Dimension panelSize = this.getPreferredSize();
            Dimension prev2 = DimensionService.getInstance().getSize(SERVICE_KEY);
            panelSize.width += JBUIScale.scale((int)24);
            panelSize.height *= 2;
            if (prev2 != null && prev2.height < panelSize.height) {
                prev2.height = panelSize.height;
            }
            final Window dialogWindow = this.myDialog.getPeer().getWindow();
            AnAction escape = ActionManager.getInstance().getAction("EditorEscape");
            JRootPane root = ((RootPaneContainer)((Object)dialogWindow)).getRootPane();
            final IdeGlassPaneImpl glass = (IdeGlassPaneImpl)this.myDialog.getRootPane().getGlassPane();
            int i2 = Registry.intValue((String)"ide.popup.resizable.border.sensitivity", (int)4);
            WindowResizeListener resizeListener = new WindowResizeListener(root, (Insets)JBUI.insets((int)i2), null){
                private Cursor myCursor;

                @Override
                protected void setCursor(@NotNull Component content2, Cursor cursor) {
                    if (content2 == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (this.myCursor != cursor || this.myCursor != Cursor.getDefaultCursor()) {
                        glass.setCursor(cursor, this);
                        this.myCursor = cursor;
                        if (content2 instanceof JComponent) {
                            IdeGlassPaneImpl.savePreProcessedCursor((JComponent)content2, content2.getCursor());
                        }
                        super.setCursor(content2, cursor);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/find/impl/FindPopupPanel$4", "setCursor"));
                }
            };
            glass.addMousePreprocessor(resizeListener, this.myDisposable);
            glass.addMouseMotionPreprocessor(resizeListener, this.myDisposable);
            DumbAwareAction.create(e -> this.closeImmediately()).registerCustomShortcutSet(escape == null ? CommonShortcuts.ESCAPE : escape.getShortcutSet(), (JComponent)root, this.myDisposable);
            root.setWindowDecorationStyle(0);
            root.setBorder((Border)PopupBorder.Factory.create((boolean)true, (boolean)true));
            UIUtil.markAsPossibleOwner((Dialog)((Dialog)dialogWindow));
            dialogWindow.setBackground(UIUtil.getPanelBackground());
            dialogWindow.setMinimumSize(panelSize);
            if (prev2 == null) {
                panelSize.height = (int)((double)panelSize.height * 1.5);
                panelSize.width = (int)((double)panelSize.width * 1.15);
            }
            dialogWindow.setSize(prev2 != null ? prev2 : panelSize);
            IdeEventQueue.getInstance().getPopupManager().closeAllPopups(false);
            if (showPoint != null) {
                this.myDialog.setLocation(showPoint.getScreenPoint());
            } else {
                dialogWindow.setLocationRelativeTo(null);
            }
            this.mySuggestRegexHintForEmptyResults = true;
            this.myDialog.show();
            final WindowAdapter focusListener2 = new WindowAdapter(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    super.windowGainedFocus(e);
                    if (FindPopupPanel.this.canBeClosed() && !FindPopupPanel.this.myIsPinned.get()) {
                        FindPopupPanel.this.myDialog.doCancelAction();
                    }
                }
            };
            dialogWindow.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    Arrays.stream(Frame.getFrames()).filter(f -> f != null && f != dialogWindow && f.getOwner() != dialogWindow && f instanceof IdeFrame && ((IdeFrame)f).getProject() == FindPopupPanel.this.myProject).forEach(win -> {
                        win.addWindowFocusListener(focusListener2);
                        Disposer.register((Disposable)FindPopupPanel.this.myDisposable, () -> win.removeWindowFocusListener(focusListener2));
                    });
                }
            });
            JRootPane rootPane = this.getRootPane();
            if (rootPane != null) {
                if (this.myHelper.isReplaceState()) {
                    rootPane.setDefaultButton(this.myReplaceSelectedButton);
                }
                rootPane.getInputMap(2).put(ENTER_WITH_MODIFIERS, "openInFindWindow");
                rootPane.getActionMap().put("openInFindWindow", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FindPopupPanel.this.processCtrlEnter();
                    }
                });
            }
            ApplicationManager.getApplication().invokeLater(this::scheduleResultsUpdate, ModalityState.any());
        }
    }

    protected boolean canBeClosed() {
        if (this.myProject.isDisposed()) {
            return true;
        }
        if (!this.myCanClose.get()) {
            return false;
        }
        if (this.myIsPinned.get()) {
            return false;
        }
        if (!ApplicationManager.getApplication().isActive()) {
            return false;
        }
        if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow() == null) {
            return false;
        }
        if (this.myFileMaskField.isPopupVisible()) {
            this.myFileMaskField.setPopupVisible(false);
            return false;
        }
        List popups = ContainerUtil.filter((Collection)JBPopupFactory.getInstance().getChildPopups((Component)((Object)this)), popup2 -> !popup2.isDisposed());
        if (!popups.isEmpty()) {
            for (JBPopup popup3 : popups) {
                popup3.cancel();
            }
            return false;
        }
        return !this.myScopeUI.hideAllPopups();
    }

    @Override
    public void saveSettings() {
        Window window = this.myDialog.getWindow();
        if (!window.isShowing()) {
            return;
        }
        DimensionService.getInstance().setSize(SERVICE_KEY, this.myDialog.getSize(), this.myHelper.getProject());
        DimensionService.getInstance().setLocation(SERVICE_KEY, window.getLocationOnScreen(), this.myHelper.getProject());
        FindSettings findSettings = FindSettings.getInstance();
        this.myScopeUI.applyTo(findSettings, this.mySelectedScope);
        this.myHelper.updateFindSettings();
        this.applyTo(FindManager.getInstance((Project)this.myProject).getFindInProjectModel());
    }

    @Override
    @NotNull
    public Disposable getDisposable() {
        Disposable disposable2 = this.myDisposable;
        if (disposable2 == null) {
            FindPopupPanel.$$$reportNull$$$0(1);
        }
        return disposable2;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            FindPopupPanel.$$$reportNull$$$0(2);
        }
        return project;
    }

    @NotNull
    public FindUIHelper getHelper() {
        FindUIHelper findUIHelper = this.myHelper;
        if (findUIHelper == null) {
            FindPopupPanel.$$$reportNull$$$0(3);
        }
        return findUIHelper;
    }

    @NotNull
    public AtomicBoolean getCanClose() {
        AtomicBoolean atomicBoolean = this.myCanClose;
        if (atomicBoolean == null) {
            FindPopupPanel.$$$reportNull$$$0(4);
        }
        return atomicBoolean;
    }

    private void initComponents() {
        Keymap activeKeymap;
        JComponent[] tableAware;
        KeyStroke editSourceKeyStroke;
        this.myTitleLabel = new JBLabel(FindBundle.message("find.in.path.dialog.title", new Object[0]), UIUtil.ComponentStyle.REGULAR);
        RelativeFont.BOLD.install((Component)this.myTitleLabel);
        this.myInfoLabel = new JBLabel("", UIUtil.ComponentStyle.SMALL);
        this.myLoadingIcon = new JLabel(EmptyIcon.ICON_16);
        ItemListener liveResultsPreviewUpdateListener = __ -> this.scheduleResultsUpdate();
        this.myCbFileFilter = FindPopupPanel.createCheckBox(this.myProject);
        this.myCbFileFilter.addItemListener(__ -> {
            if (this.myCbFileFilter.isSelected()) {
                this.myFileMaskField.setEnabled(true);
                if (this.myCbFileFilter.getClientProperty("dontRequestFocus") == null) {
                    IdeFocusManager.getInstance((Project)this.myProject).requestFocus(this.myFileMaskField, true);
                    this.myFileMaskField.getEditor().selectAll();
                }
            } else {
                this.myFileMaskField.setEnabled(false);
                if (this.myCbFileFilter.getClientProperty("dontRequestFocus") == null) {
                    IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.mySearchComponent, true);
                }
            }
        });
        this.myCbFileFilter.addItemListener(liveResultsPreviewUpdateListener);
        this.myFileMaskField = new ComboBox<String>(){

            public Dimension getPreferredSize() {
                Component editorComponent;
                Component[] components;
                int width = 0;
                int buttonWidth = 0;
                for (Component component2 : components = this.getComponents()) {
                    int w;
                    Dimension size = component2.getPreferredSize();
                    int n = w = size != null ? size.width : 0;
                    if (component2 instanceof JButton) {
                        buttonWidth = w;
                    }
                    width += w;
                }
                ComboBoxEditor editor = this.getEditor();
                if (editor != null && (editorComponent = editor.getEditorComponent()) != null) {
                    FontMetrics fontMetrics = editorComponent.getFontMetrics(editorComponent.getFont());
                    width = Math.max(width, fontMetrics.stringWidth(String.valueOf(this.getSelectedItem())) + buttonWidth);
                    width += fontMetrics.stringWidth("m");
                }
                Dimension size = super.getPreferredSize();
                Insets insets = this.getInsets();
                size.width = MathUtil.clamp((int)(width += insets.left + insets.right), (int)JBUIScale.scale((int)80), (int)JBUIScale.scale((int)500));
                return size;
            }
        };
        this.myFileMaskField.setEditable(true);
        this.myFileMaskField.setMaximumRowCount(8);
        this.myFileMaskField.addActionListener(__ -> this.scheduleResultsUpdate());
        Component editorComponent = this.myFileMaskField.getEditor().getEditorComponent();
        if (editorComponent instanceof EditorTextField) {
            EditorTextField etf = (EditorTextField)((Object)editorComponent);
            etf.addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull com.intellij.openapi.editor.event.DocumentEvent event) {
                    if (event == null) {
                        9.$$$reportNull$$$0(0);
                    }
                    FindPopupPanel.this.onFileMaskChanged();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/find/impl/FindPopupPanel$9", "documentChanged"));
                }
            });
        } else if (editorComponent instanceof JTextComponent) {
            ((JTextComponent)editorComponent).getDocument().addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        10.$$$reportNull$$$0(0);
                    }
                    FindPopupPanel.this.onFileMaskChanged();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/impl/FindPopupPanel$10", "textChanged"));
                }
            });
        } else assert (false);
        MyShowFilterPopupAction myShowFilterPopupAction = new MyShowFilterPopupAction();
        this.myFilterContextButton = new ActionButton((AnAction)myShowFilterPopupAction, myShowFilterPopupAction.getTemplatePresentation(), "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE, (AnAction)myShowFilterPopupAction){
            final /* synthetic */ AnAction val$myShowFilterPopupAction;
            {
                this.val$myShowFilterPopupAction = anAction;
                super(arg0, arg1, arg2, arg3);
            }

            @Override
            public Icon getIcon() {
                Icon icon2 = this.val$myShowFilterPopupAction.getTemplatePresentation().getIcon();
                return FindPopupPanel.this.mySelectedContextName.equals(FindInProjectUtil.getPresentableName(FindModel.SearchContext.ANY)) ? icon2 : ExecutionUtil.getLiveIndicator((Icon)icon2);
            }
        };
        myShowFilterPopupAction.registerCustomShortcutSet(myShowFilterPopupAction.getShortcutSet(), (JComponent)((Object)this));
        MyPinAction pinAction = new MyPinAction();
        ActionButton pinButton = new ActionButton((AnAction)pinAction, pinAction.getTemplatePresentation(), "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        this.myResetFiltersAction = DumbAwareAction.create(event -> this.resetAllFilters());
        this.myResetFiltersAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(RESET_FILTERS), (JComponent)((Object)this));
        this.myOKButton = new JButton(FindBundle.message("find.popup.find.button", new Object[0]));
        this.myReplaceAllButton = new JButton(FindBundle.message("find.popup.replace.all.button", new Object[0]));
        this.myReplaceSelectedButton = new JButton(FindBundle.message("find.popup.replace.selected.button", 0));
        this.myOkActionListener = __ -> this.doOK(true);
        this.myReplaceAllButton.addActionListener(__ -> this.doOK(false));
        this.myReplaceSelectedButton.addActionListener(e -> {
            int rowToSelect = this.myResultsPreviewTable.getSelectionModel().getMinSelectionIndex();
            Map<Integer, Usage> usages = this.getSelectedUsages();
            if (usages == null) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
                for (Map.Entry entry : usages.entrySet()) {
                    try {
                        ReplaceInProjectManager.getInstance(this.myProject).replaceUsage((Usage)entry.getValue(), this.myHelper.getModel(), Collections.emptySet(), false);
                        ((DefaultTableModel)this.myResultsPreviewTable.getModel()).removeRow((Integer)entry.getKey());
                    }
                    catch (FindManager.MalformedReplacementStringException ex) {
                        if (ApplicationManager.getApplication().isUnitTestMode()) break;
                        Messages.showErrorDialog((Component)((Object)this), (String)ex.getMessage(), (String)FindBundle.message("find.replace.invalid.replacement.string.title", new Object[0]));
                        break;
                    }
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (this.myResultsPreviewTable.getRowCount() > rowToSelect) {
                        this.myResultsPreviewTable.getSelectionModel().setSelectionInterval(rowToSelect, rowToSelect);
                    }
                    ScrollingUtil.ensureSelectionExists((JTable)this.myResultsPreviewTable);
                });
            }, FindBundle.message("find.replace.command", new Object[0]), null);
        });
        this.myOKButton.addActionListener(this.myOkActionListener);
        TouchbarDataKeys.putDialogButtonDescriptor((JButton)this.myOKButton, (int)0, (boolean)true);
        boolean enterAsOK = Registry.is((String)"ide.find.enter.as.ok", (boolean)false);
        AnAction openInRightSplit2 = ActionManager.getInstance().getAction("OpenInRightSplit");
        if (openInRightSplit2 != null) {
            ShortcutSet set2 = openInRightSplit2.getShortcutSet();
            new MyEnterAction(false).registerCustomShortcutSet(set2, (JComponent)((Object)this));
        }
        new MyEnterAction(enterAsOK).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(ENTER), (JComponent)((Object)this));
        DumbAwareAction.create(__ -> this.processCtrlEnter()).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(ENTER_WITH_MODIFIERS), (JComponent)((Object)this));
        DumbAwareAction.create(__ -> this.myReplaceAllButton.doClick()).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(REPLACE_ALL), (JComponent)((Object)this));
        this.myReplaceAllButton.setToolTipText(KeymapUtil.getKeystrokeText((KeyStroke)REPLACE_ALL));
        ArrayList<KeyboardShortcut> navigationKeyStrokes = new ArrayList<KeyboardShortcut>();
        KeyStroke viewSourceKeyStroke = KeymapUtil.getKeyStroke((ShortcutSet)CommonShortcuts.getViewSource());
        if (viewSourceKeyStroke != null && !Comparing.equal((Object)viewSourceKeyStroke, (Object)ENTER_WITH_MODIFIERS) && !Comparing.equal((Object)viewSourceKeyStroke, (Object)ENTER)) {
            navigationKeyStrokes.add(new KeyboardShortcut(viewSourceKeyStroke, null));
        }
        if ((editSourceKeyStroke = KeymapUtil.getKeyStroke((ShortcutSet)CommonShortcuts.getEditSource())) != null && !Comparing.equal((Object)editSourceKeyStroke, (Object)ENTER_WITH_MODIFIERS) && !Comparing.equal((Object)editSourceKeyStroke, (Object)ENTER)) {
            navigationKeyStrokes.add(new KeyboardShortcut(editSourceKeyStroke, null));
        }
        if (!navigationKeyStrokes.isEmpty()) {
            DumbAwareAction.create(e -> this.navigateToSelectedUsage((AnActionEvent)e)).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(navigationKeyStrokes.toArray(Shortcut.EMPTY_ARRAY)), (JComponent)((Object)this));
        }
        this.myResultsPreviewTableModel = this.createTableModel();
        this.myResultsPreviewTable = new JBTable(this.myResultsPreviewTableModel){

            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(this.getWidth(), 1 + this.getRowHeight() * 4);
            }
        };
        this.myResultsPreviewTable.setFocusable(false);
        this.myResultsPreviewTable.getEmptyText().setShowAboveCenter(false);
        this.myResultsPreviewTable.setShowColumns(false);
        this.myResultsPreviewTable.getSelectionModel().setSelectionMode(2);
        this.myResultsPreviewTable.setShowGrid(false);
        this.myResultsPreviewTable.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.mySearchComponent = new JBTextAreaWithMixedAccessibleContext(this.myResultsPreviewTable.getAccessibleContext());
        this.mySearchComponent.setColumns(25);
        this.mySearchComponent.setRows(1);
        this.mySearchComponent.getAccessibleContext().setAccessibleName(FindBundle.message("find.search.accessible.name", new Object[0]));
        this.myReplaceComponent = new JBTextAreaWithMixedAccessibleContext(this.myResultsPreviewTable.getAccessibleContext());
        this.myReplaceComponent.setColumns(25);
        this.myReplaceComponent.setRows(1);
        this.myReplaceComponent.getAccessibleContext().setAccessibleName(FindBundle.message("find.replace.accessible.name", new Object[0]));
        this.mySearchTextArea = new SearchTextArea(this.mySearchComponent, true);
        this.myReplaceTextArea = new SearchTextArea(this.myReplaceComponent, false);
        this.mySearchTextArea.setMultilineEnabled(Registry.is((String)"ide.find.as.popup.allow.multiline"));
        this.myReplaceTextArea.setMultilineEnabled(Registry.is((String)"ide.find.as.popup.allow.multiline"));
        this.myCaseSensitiveAction = new MySwitchStateToggleAction(this, "find.popup.case.sensitive", "CaseSensitive", AllIcons.Actions.MatchCase, AllIcons.Actions.MatchCaseHovered, AllIcons.Actions.MatchCaseSelected, this.myCaseSensitiveState, (Producer<Boolean>)((Producer)() -> !this.myHelper.getModel().isReplaceState() || !this.myPreserveCaseState.get()));
        this.myWholeWordsAction = new MySwitchStateToggleAction(this, "find.whole.words", "WholeWords", AllIcons.Actions.Words, AllIcons.Actions.WordsHovered, AllIcons.Actions.WordsSelected, this.myWholeWordsState, (Producer<Boolean>)((Producer)() -> !this.myRegexState.get()));
        this.myRegexAction = new MySwitchStateToggleAction(this, "find.regex", "Regex", AllIcons.Actions.Regex, AllIcons.Actions.RegexHovered, AllIcons.Actions.RegexSelected, this.myRegexState, (Producer<Boolean>)((Producer)() -> !this.myHelper.getModel().isReplaceState() || !this.myPreserveCaseState.get()), new TooltipLinkProvider.TooltipLink(FindBundle.message("find.regex.help.link", new Object[0]), RegExHelpPopup.createRegExLinkRunnable(this.mySearchTextArea)));
        List<Component> searchExtraButtons = this.mySearchTextArea.setExtraActions(this.myCaseSensitiveAction, this.myWholeWordsAction, this.myRegexAction);
        MySwitchStateToggleAction preserveCaseAction = new MySwitchStateToggleAction(this, "find.options.replace.preserve.case", "PreserveCase", AllIcons.Actions.PreserveCase, AllIcons.Actions.PreserveCaseHover, AllIcons.Actions.PreserveCaseSelected, this.myPreserveCaseState, (Producer<Boolean>)((Producer)() -> !this.myRegexState.get() && !this.myCaseSensitiveState.get()));
        List<Component> replaceExtraButtons = this.myReplaceTextArea.setExtraActions(new AnAction[]{preserveCaseAction});
        Pair<FindPopupScopeUI.ScopeType, JComponent>[] scopeComponents = this.myScopeUI.getComponents();
        this.myScopeDetailsPanel = new JPanel(new CardLayout());
        this.myScopeDetailsPanel.setBorder((Border)JBUI.Borders.emptyBottom((int)(UIUtil.isUnderDefaultMacTheme() ? 0 : 3)));
        ArrayList<MySelectScopeToggleAction> scopeActions = new ArrayList<MySelectScopeToggleAction>(scopeComponents.length);
        for (Pair<FindPopupScopeUI.ScopeType, JComponent> scopeComponent : scopeComponents) {
            FindPopupScopeUI.ScopeType scopeType2 = (FindPopupScopeUI.ScopeType)scopeComponent.first;
            scopeActions.add(new MySelectScopeToggleAction(scopeType2));
            this.myScopeDetailsPanel.add(scopeType2.name, (Component)scopeComponent.second);
        }
        this.myScopeSelectionToolbar = FindPopupPanel.createToolbar(scopeActions.toArray(AnAction.EMPTY_ARRAY));
        this.myScopeSelectionToolbar.setMinimumButtonSize(ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        this.mySelectedScope = (FindPopupScopeUI.ScopeType)scopeComponents[0].first;
        TableHoverListener.DEFAULT.removeFrom((JComponent)this.myResultsPreviewTable);
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                if (event == null) {
                    13.$$$reportNull$$$0(0);
                }
                if (event.getSource() != FindPopupPanel.this.myResultsPreviewTable) {
                    return false;
                }
                FindPopupPanel.this.navigateToSelectedUsage(null);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/find/impl/FindPopupPanel$13", "onDoubleClick"));
            }
        }.installOn((Component)this.myResultsPreviewTable);
        this.myResultsPreviewTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FindPopupPanel.this.myResultsPreviewTable.transferFocus();
            }
        });
        FindPopupPanel.applyFont(JBFont.label(), new Component[]{this.myResultsPreviewTable});
        for (JComponent component2 : tableAware = new JComponent[]{this.mySearchComponent, this.myReplaceComponent, this.myReplaceSelectedButton}) {
            ScrollingUtil.installActions((JTable)this.myResultsPreviewTable, (boolean)false, (JComponent)component2);
        }
        ActionListener helpAction = __ -> HelpManager.getInstance().invokeHelp("reference.dialogs.findinpath");
        this.registerKeyboardAction(helpAction, KeyStroke.getKeyStroke(112, 0), 2);
        this.registerKeyboardAction(helpAction, KeyStroke.getKeyStroke(156, 0), 2);
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        Keymap keymap2 = activeKeymap = keymapManager2 != null ? keymapManager2.getActiveKeymap() : null;
        if (activeKeymap != null) {
            CustomShortcutSet findNextShortcutSet = new CustomShortcutSet(activeKeymap.getShortcuts("FindNext"));
            CustomShortcutSet findPreviousShortcutSet = new CustomShortcutSet(activeKeymap.getShortcuts("FindPrevious"));
            DumbAwareAction findNextAction = DumbAwareAction.create(event -> {
                int selectedRow = this.myResultsPreviewTable.getSelectedRow();
                if (selectedRow >= 0 && selectedRow < this.myResultsPreviewTable.getRowCount() - 1) {
                    this.myResultsPreviewTable.setRowSelectionInterval(selectedRow + 1, selectedRow + 1);
                    ScrollingUtil.ensureIndexIsVisible((JTable)this.myResultsPreviewTable, (int)(selectedRow + 1), (int)1);
                }
            });
            DumbAwareAction findPreviousAction = DumbAwareAction.create(event -> {
                int selectedRow = this.myResultsPreviewTable.getSelectedRow();
                if (selectedRow > 0 && selectedRow <= this.myResultsPreviewTable.getRowCount() - 1) {
                    this.myResultsPreviewTable.setRowSelectionInterval(selectedRow - 1, selectedRow - 1);
                    ScrollingUtil.ensureIndexIsVisible((JTable)this.myResultsPreviewTable, (int)(selectedRow - 1), (int)1);
                }
            });
            for (JComponent component3 : tableAware) {
                findNextAction.registerCustomShortcutSet((ShortcutSet)findNextShortcutSet, component3);
                findPreviousAction.registerCustomShortcutSet((ShortcutSet)findPreviousShortcutSet, component3);
            }
        }
        this.myUsagePreviewTitle = new SimpleColoredComponent();
        this.myUsagePreviewTitle.setBorder((Border)JBUI.Borders.empty((int)3, (int)8, (int)4, (int)8));
        this.myUsageViewPresentation = new UsageViewPresentation();
        this.myUsagePreviewPanel = new UsagePreviewPanel(this.myProject, this.myUsageViewPresentation, Registry.is((String)"ide.find.as.popup.editable.code")){

            public Dimension getPreferredSize() {
                return new Dimension(FindPopupPanel.this.myResultsPreviewTable.getWidth(), Math.max(this.getHeight(), this.getLineHeight() * 15));
            }
        };
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myUsagePreviewPanel);
        final Runnable updatePreviewRunnable = () -> {
            if (Disposer.isDisposed((Disposable)this.myDisposable)) {
                return;
            }
            int[] selectedRows = this.myResultsPreviewTable.getSelectedRows();
            SmartList selectedUsagePromises = new SmartList();
            String file2 = null;
            for (int row : selectedRows) {
                Object value2 = this.myResultsPreviewTable.getModel().getValueAt(row, 0);
                UsageInfoAdapter adapter2 = (UsageInfoAdapter)value2;
                file2 = adapter2.getPath();
                if (!adapter2.isValid()) continue;
                selectedUsagePromises.add(adapter2.getMergedInfosAsync());
            }
            String selectedFile = file2;
            Promises.collectResults((Collection)selectedUsagePromises).onSuccess(data2 -> {
                SmartList selectedUsages = new SmartList();
                for (UsageInfo[] usageInfos : data2) {
                    Collections.addAll(selectedUsages, usageInfos);
                }
                this.myReplaceSelectedButton.setText(FindBundle.message("find.popup.replace.selected.button", selectedUsages.size()));
                FindInProjectUtil.setupViewPresentation(this.myUsageViewPresentation, this.myHelper.getModel().clone());
                this.myUsagePreviewPanel.updateLayout((List)selectedUsages);
                this.myUsagePreviewTitle.clear();
                if (this.myUsagePreviewPanel.getCannotPreviewMessage((List)selectedUsages) == null && selectedFile != null) {
                    String locationPath;
                    this.myUsagePreviewTitle.append(PathUtil.getFileName((String)selectedFile), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)new File(selectedFile), (boolean)true);
                    String string = locationPath = virtualFile == null ? null : FindPopupPanel.getPresentablePath(this.myProject, virtualFile.getParent(), 120);
                    if (locationPath != null) {
                        this.myUsagePreviewTitle.append(FontUtil.spaceAndThinSpace() + locationPath, new SimpleTextAttributes(0, UIUtil.getContextHelpForeground()));
                    }
                }
            });
        };
        this.myResultsPreviewTable.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting() || Disposer.isDisposed((Disposable)this.myPreviewUpdater)) {
                return;
            }
            this.myPreviewUpdater.addRequest(updatePreviewRunnable, 50);
        });
        DocumentAdapter documentAdapter = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    16.$$$reportNull$$$0(0);
                }
                if (FindPopupPanel.this.myDialog == null) {
                    return;
                }
                if (e.getDocument() == FindPopupPanel.this.mySearchComponent.getDocument()) {
                    FindPopupPanel.this.scheduleResultsUpdate();
                }
                if (e.getDocument() == FindPopupPanel.this.myReplaceComponent.getDocument()) {
                    FindPopupPanel.this.applyTo(FindPopupPanel.this.myHelper.getModel());
                    if (FindPopupPanel.this.myHelper.getModel().isRegularExpressions()) {
                        FindPopupPanel.this.myComponentValidator.updateInfo(FindPopupPanel.this.getValidationInfo(FindPopupPanel.this.myHelper.getModel()));
                    }
                    ApplicationManager.getApplication().invokeLater(updatePreviewRunnable);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/impl/FindPopupPanel$16", "textChanged"));
            }
        };
        this.mySearchComponent.getDocument().addDocumentListener((javax.swing.event.DocumentListener)documentAdapter);
        this.myReplaceComponent.getDocument().addDocumentListener((javax.swing.event.DocumentListener)documentAdapter);
        this.mySearchRescheduleOnCancellationsAlarm = new Alarm();
        this.myPreviewSplitter = new OnePixelSplitter(true, 0.33f);
        this.myPreviewSplitter.setSplitterProportionKey(SPLITTER_SERVICE_KEY);
        this.myPreviewSplitter.getDivider().setBackground(OnePixelDivider.BACKGROUND);
        JBScrollPane scrollPane = new JBScrollPane((Component)this.myResultsPreviewTable){

            public Dimension getMinimumSize() {
                Dimension size = super.getMinimumSize();
                size.height = FindPopupPanel.this.myResultsPreviewTable.getPreferredScrollableViewportSize().height;
                return size;
            }
        };
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myPreviewSplitter.setFirstComponent((JComponent)scrollPane);
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("flowx, ins 4 4 4 4, fillx, hidemode 3, gap 0"));
        this.myNewTabCheckbox = new JBCheckBox(FindBundle.message("find.open.in.new.tab.checkbox", new Object[0]), FindSettings.getInstance().isShowResultsInSeparateView());
        bottomPanel.add(this.myNewTabCheckbox);
        this.myNewTabCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindSettings.getInstance().setShowResultsInSeparateView(FindPopupPanel.this.myNewTabCheckbox.isSelected());
            }
        });
        this.myOKHintLabel = new JBLabel("");
        this.myOKHintLabel.setEnabled(false);
        this.myNavigationHintLabel = new JBLabel("");
        this.myNavigationHintLabel.setEnabled(false);
        this.myNavigationHintLabel.setFont((Font)JBUI.Fonts.smallFont());
        Insets insets = this.myOKButton.getInsets();
        String btnGapLeft = "gapleft " + Math.max(0, JBUIScale.scale((int)12) - insets.left - insets.right);
        bottomPanel.add((Component)this.myNavigationHintLabel, btnGapLeft);
        bottomPanel.add(Box.createHorizontalGlue(), "growx, pushx");
        bottomPanel.add((Component)this.myOKHintLabel);
        bottomPanel.add((Component)this.myOKButton, btnGapLeft);
        bottomPanel.add((Component)this.myReplaceAllButton, btnGapLeft);
        bottomPanel.add((Component)this.myReplaceSelectedButton, btnGapLeft);
        this.myCodePreviewComponent = this.myUsagePreviewPanel.createComponent();
        JPanel previewPanel = new JPanel(new BorderLayout());
        previewPanel.add((Component)this.myUsagePreviewTitle, "North");
        previewPanel.add((Component)this.myCodePreviewComponent, "Center");
        this.myPreviewSplitter.setSecondComponent((JComponent)previewPanel);
        JPanel scopesPanel = new JPanel((LayoutManager)new MigLayout("flowx, gap 26, ins 0"));
        scopesPanel.add(this.myScopeSelectionToolbar.getComponent());
        scopesPanel.add((Component)this.myScopeDetailsPanel, "growx, pushx");
        this.setLayout((LayoutManager)new MigLayout("flowx, ins 4, gap 0, fillx, hidemode 3"));
        this.myTitlePanel = new JPanel((LayoutManager)new MigLayout("flowx, ins 0, gap 0, fillx, filly"));
        this.myTitlePanel.add((Component)this.myTitleLabel, "gapright 4");
        this.myTitlePanel.add(this.myInfoLabel);
        this.myTitlePanel.add((Component)this.myLoadingIcon, "w 24, wmin 24");
        this.myTitlePanel.add(Box.createHorizontalGlue(), "growx, pushx");
        this.add(this.myTitlePanel, "sx 2, growx, growx, growy");
        this.add(this.myCbFileFilter);
        this.add((Component)this.myFileMaskField, "gapleft 4, gapright 16");
        if (Registry.is((String)"ide.find.as.popup.allow.pin") || ApplicationManager.getApplication().isInternal()) {
            this.myIsPinned.set(UISettings.getInstance().getPinFindInPath());
            JPanel twoButtons = new JPanel((LayoutManager)new MigLayout("flowx, ins 0, gap 4, fillx, hidemode 3"));
            twoButtons.add(this.myFilterContextButton);
            JComponent separatorComponent = (JComponent)Box.createRigidArea((Dimension)new JBDimension(1, 24));
            separatorComponent.setOpaque(true);
            separatorComponent.setBackground(JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground());
            twoButtons.add(separatorComponent);
            twoButtons.add(pinButton);
            this.add(twoButtons, "wrap");
        } else {
            this.add(this.myFilterContextButton, "wrap");
        }
        this.mySearchTextArea.setBorder(new CompoundBorder(JBUI.Borders.customLine((Color)JBUI.CurrentTheme.BigPopup.searchFieldBorderColor(), (int)1, (int)0, (int)1, (int)0), (Border)JBUI.Borders.empty((int)1, (int)0, (int)2, (int)0)));
        this.add(this.mySearchTextArea, "pushx, growx, sx 10, pad 0 -4 0 4, gaptop 4, wrap");
        this.myReplaceTextArea.setBorder(new CompoundBorder(JBUI.Borders.customLine((Color)JBUI.CurrentTheme.BigPopup.searchFieldBorderColor(), (int)0, (int)0, (int)1, (int)0), (Border)JBUI.Borders.empty((int)1, (int)0, (int)2, (int)0)));
        this.add(this.myReplaceTextArea, "pushx, growx, sx 10, pad 0 -4 0 4, wrap");
        this.add(scopesPanel, "sx 10, pushx, growx, ax left, wrap, gaptop 4, gapbottom 4");
        this.add((Component)this.myPreviewSplitter, "pushx, growx, growy, pushy, sx 10, wrap, pad -4 -4 4 4");
        this.add(bottomPanel, "pushx, growx, dock south, sx 10");
        ArrayList<Component> focusOrder = new ArrayList<Component>();
        focusOrder.add(this.mySearchComponent);
        focusOrder.add(this.myReplaceComponent);
        focusOrder.addAll(searchExtraButtons);
        focusOrder.addAll(replaceExtraButtons);
        focusOrder.add(this.myCbFileFilter);
        ContainerUtil.addAll(focusOrder, FindPopupPanel.focusableComponents(this.myScopeDetailsPanel));
        focusOrder.add(editorComponent);
        ContainerUtil.addAll(focusOrder, FindPopupPanel.focusableComponents(bottomPanel));
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)new ListFocusTraversalPolicy(focusOrder));
    }

    @Contract(value="_,!null,_->!null")
    @NlsSafe
    private static String getPresentablePath(@NotNull Project project, @Nullable VirtualFile virtualFile, int maxChars) {
        String path;
        if (project == null) {
            FindPopupPanel.$$$reportNull$$$0(5);
        }
        if (virtualFile == null) {
            return null;
        }
        String string = ScratchUtil.isScratch((VirtualFile)virtualFile) ? ScratchImplUtil.getRelativePath(project, virtualFile) : (path = VfsUtilCore.isAncestor((VirtualFile)project.getBaseDir(), (VirtualFile)virtualFile, (boolean)true) ? VfsUtilCore.getRelativeLocation((VirtualFile)virtualFile, (VirtualFile)project.getBaseDir()) : FileUtil.getLocationRelativeToUserHome((String)virtualFile.getPath()));
        return path == null ? null : (maxChars < 0 ? path : StringUtil.trimMiddle((String)path, (int)maxChars));
    }

    @NotNull
    private DefaultTableModel createTableModel() {
        DefaultTableModel model2 = new DefaultTableModel(){
            private String firstResultPath;
            private final Comparator<Vector<UsageInfoAdapter>> COMPARATOR = (v1, v2) -> {
                UsageInfoAdapter u1 = (UsageInfoAdapter)v1.get(0);
                UsageInfoAdapter u2 = (UsageInfoAdapter)v2.get(0);
                String u2Path = u2.getPath();
                String u1Path = u1.getPath();
                if (u1Path.equals(this.firstResultPath) && !u2Path.equals(this.firstResultPath)) {
                    return -1;
                }
                if (!u1Path.equals(this.firstResultPath) && u2Path.equals(this.firstResultPath)) {
                    return 1;
                }
                int c = u1Path.compareTo(u2Path);
                if (c != 0) {
                    return c;
                }
                c = Integer.compare(u1.getLine(), u2.getLine());
                if (c != 0) {
                    return c;
                }
                return Integer.compare(u1.getNavigationOffset(), u2.getNavigationOffset());
            };

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }

            @Override
            public void addRow(Object[] rowData) {
                if (FindPopupPanel.this.myNeedReset.compareAndSet(true, false)) {
                    this.dataVector.clear();
                    this.fireTableDataChanged();
                }
                Vector<Object> v = 19.convertToVector(rowData);
                if (this.dataVector.isEmpty()) {
                    this.addRow(v);
                    FindPopupPanel.this.myResultsPreviewTable.getSelectionModel().setSelectionInterval(0, 0);
                    this.firstResultPath = ((UsageInfoAdapter)v.get(0)).getPath();
                } else {
                    int p = Collections.binarySearch(this.dataVector, v, this.COMPARATOR);
                    if (p < 0) {
                        int row = -(p + 1);
                        this.insertRow(row, v);
                    }
                }
            }
        };
        model2.addColumn("Usages");
        DefaultTableModel defaultTableModel = model2;
        if (defaultTableModel == null) {
            FindPopupPanel.$$$reportNull$$$0(6);
        }
        return defaultTableModel;
    }

    private void processCtrlEnter() {
        if (Registry.is((String)"ide.find.enter.as.ok", (boolean)false)) {
            this.navigateToSelectedUsage(null);
        } else {
            this.myOkActionListener.actionPerformed(null);
        }
    }

    private void onFileMaskChanged() {
        Object item = this.myFileMaskField.getEditor().getItem();
        if (item != null && !item.equals(this.myFileMaskField.getSelectedItem())) {
            this.myFileMaskField.setSelectedItem(item);
        }
        this.scheduleResultsUpdate();
    }

    private void closeImmediately() {
        if (this.canBeClosedImmediately() && this.myDialog != null && this.myDialog.isVisible()) {
            this.myIsPinned.set(false);
            this.myDialog.doCancelAction();
        }
    }

    private boolean canBeClosedImmediately() {
        boolean state = this.myIsPinned.get();
        this.myIsPinned.set(false);
        try {
            boolean bl = this.myDialog != null && this.canBeClosed();
            return bl;
        }
        finally {
            this.myIsPinned.set(state);
        }
    }

    private void doOK(boolean openInFindWindow) {
        if (!this.canBeClosedImmediately()) {
            return;
        }
        FindModel validateModel = this.myHelper.getModel().clone();
        this.applyTo(validateModel);
        ValidationInfo validationInfo = this.getValidationInfo(validateModel);
        if (validationInfo == null) {
            if (validateModel.isReplaceState() && !openInFindWindow && this.myResultsPreviewTable.getRowCount() > 1 && !ReplaceInProjectManager.getInstance(this.myProject).showReplaceAllConfirmDialog(this.myUsagesCount, this.getStringToFind(), this.myFilesCount, this.getStringToReplace())) {
                return;
            }
        } else {
            String message2 = validationInfo.message;
            Messages.showMessageDialog((Component)((Object)this), (String)message2, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        this.myHelper.getModel().copyFrom(validateModel);
        this.myHelper.getModel().setPromptOnReplace(openInFindWindow);
        this.myHelper.doOKAction();
        this.myIsPinned.set(false);
        this.myDialog.doCancelAction();
    }

    @NotNull
    private static StateRestoringCheckBox createCheckBox(@NotNull Project project) {
        if (project == null) {
            FindPopupPanel.$$$reportNull$$$0(7);
        }
        StateRestoringCheckBox checkBox2 = new StateRestoringCheckBox(FindBundle.message("find.popup.filemask", new Object[0]));
        checkBox2.addActionListener(__ -> FUCounterUsageLogger.getInstance().logEvent(project, "find", "check.box.toggled", new FeatureUsageData().addData("type", FIND_TYPE).addData("option_name", "FileFilter").addData("option_value", checkBox2.isSelected())));
        StateRestoringCheckBox stateRestoringCheckBox = checkBox2;
        if (stateRestoringCheckBox == null) {
            FindPopupPanel.$$$reportNull$$$0(8);
        }
        return stateRestoringCheckBox;
    }

    public void addNotify() {
        super.addNotify();
        ApplicationManager.getApplication().invokeLater(() -> ScrollingUtil.ensureSelectionExists((JTable)this.myResultsPreviewTable), ModalityState.any());
        this.myScopeSelectionToolbar.updateActionsImmediately();
    }

    @Override
    public void initByModel() {
        FindModel myModel = this.myHelper.getModel();
        this.myCaseSensitiveState.set(myModel.isCaseSensitive());
        this.myWholeWordsState.set(myModel.isWholeWordsOnly());
        this.myRegexState.set(myModel.isRegularExpressions());
        this.mySelectedContextName = FindPopupPanel.getSearchContextName(myModel);
        if (myModel.isReplaceState()) {
            this.myPreserveCaseState.set(myModel.isPreserveCase());
        }
        this.mySelectedScope = this.myScopeUI.initByModel(myModel);
        boolean isThereFileFilter = myModel.getFileFilter() != null && !myModel.getFileFilter().isEmpty();
        try {
            this.myCbFileFilter.putClientProperty("dontRequestFocus", Boolean.TRUE);
            this.myCbFileFilter.setSelected(isThereFileFilter);
        }
        finally {
            this.myCbFileFilter.putClientProperty("dontRequestFocus", null);
        }
        this.myFileMaskField.removeAllItems();
        List<@NlsSafe String> variants = Arrays.asList((String[])ArrayUtil.reverseArray((Object[])FindSettings.getInstance().getRecentFileMasks()));
        for (String variant : variants) {
            this.myFileMaskField.addItem((Object)variant);
        }
        if (!variants.isEmpty()) {
            this.myFileMaskField.setSelectedItem((Object)variants.get(0));
        }
        this.myFileMaskField.setEnabled(isThereFileFilter);
        String toSearch = myModel.getStringToFind();
        FindInProjectSettings findInProjectSettings = FindInProjectSettings.getInstance((Project)this.myProject);
        if (StringUtil.isEmpty((String)toSearch)) {
            String[] history = findInProjectSettings.getRecentFindStrings();
            toSearch = history.length > 0 ? history[history.length - 1] : "";
        }
        this.mySearchComponent.setText(toSearch);
        String toReplace = myModel.getStringToReplace();
        if (StringUtil.isEmpty((String)toReplace)) {
            String[] history = findInProjectSettings.getRecentReplaceStrings();
            toReplace = history.length > 0 ? history[history.length - 1] : "";
        }
        this.myReplaceComponent.setText(toReplace);
        this.updateControls();
        this.updateScopeDetailsPanel();
        boolean isReplaceState = this.myHelper.isReplaceState();
        this.myTitleLabel.setText(this.myHelper.getTitle());
        this.myReplaceTextArea.setVisible(isReplaceState);
        if (Registry.is((String)"ide.find.enter.as.ok", (boolean)false)) {
            this.myOKHintLabel.setText(KeymapUtil.getKeystrokeText((KeyStroke)ENTER));
        } else {
            this.myOKHintLabel.setText(KeymapUtil.getKeystrokeText((KeyStroke)ENTER_WITH_MODIFIERS));
        }
        this.myOKButton.setText(FindBundle.message("find.popup.find.button", new Object[0]));
        this.myReplaceAllButton.setVisible(isReplaceState);
        this.myReplaceSelectedButton.setVisible(isReplaceState);
    }

    private void updateControls() {
        this.myReplaceAllButton.setVisible(this.myHelper.isReplaceState());
        this.myReplaceSelectedButton.setVisible(this.myHelper.isReplaceState());
        this.myNavigationHintLabel.setVisible(this.mySearchComponent.getText().contains("\n"));
        this.mySearchTextArea.updateExtraActions();
        this.myReplaceTextArea.updateExtraActions();
        if (this.myNavigationHintLabel.isVisible()) {
            Keymap activeKeymap;
            this.myNavigationHintLabel.setText("");
            KeymapManager keymapManager2 = KeymapManager.getInstance();
            Keymap keymap2 = activeKeymap = keymapManager2 != null ? keymapManager2.getActiveKeymap() : null;
            if (activeKeymap != null) {
                String findNextText = KeymapUtil.getFirstKeyboardShortcutText((String)"FindNext");
                String findPreviousText = KeymapUtil.getFirstKeyboardShortcutText((String)"FindPrevious");
                if (!StringUtil.isEmpty((String)findNextText) && !StringUtil.isEmpty((String)findPreviousText)) {
                    this.myNavigationHintLabel.setText(FindBundle.message("label.use.0.and.1.to.select.usages", findNextText, findPreviousText));
                }
            }
        }
    }

    private void updateScopeDetailsPanel() {
        ((CardLayout)this.myScopeDetailsPanel.getLayout()).show(this.myScopeDetailsPanel, this.mySelectedScope.name);
        Component firstFocusableComponent = (Component)FindPopupPanel.focusableComponents(this.myScopeDetailsPanel).find(c -> c.isFocusable() && c.isEnabled() && c.isShowing());
        this.myScopeDetailsPanel.revalidate();
        this.myScopeDetailsPanel.repaint();
        if (firstFocusableComponent != null) {
            ApplicationManager.getApplication().invokeLater(() -> IdeFocusManager.getInstance((Project)this.myProject).requestFocus(firstFocusableComponent, true));
        }
        if (firstFocusableComponent == null && !this.mySearchComponent.isFocusOwner() && !this.myReplaceComponent.isFocusOwner()) {
            ApplicationManager.getApplication().invokeLater(() -> IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.mySearchComponent, true));
        }
    }

    public void scheduleResultsUpdate() {
        if (this.myDialog == null || !this.myDialog.isVisible()) {
            return;
        }
        if (this.mySearchRescheduleOnCancellationsAlarm == null || this.mySearchRescheduleOnCancellationsAlarm.isDisposed()) {
            return;
        }
        this.updateControls();
        this.mySearchRescheduleOnCancellationsAlarm.cancelAllRequests();
        this.mySearchRescheduleOnCancellationsAlarm.addRequest(this::findSettingsChanged, 100);
    }

    private void finishPreviousPreviewSearch() {
        if (this.myResultsPreviewSearchProgress != null && !this.myResultsPreviewSearchProgress.isCanceled()) {
            this.myResultsPreviewSearchProgress.cancel();
        }
    }

    private void findSettingsChanged() {
        ProgressIndicatorBase progressIndicatorWhenSearchStarted;
        if (this.isShowing()) {
            ScrollingUtil.ensureSelectionExists((JTable)this.myResultsPreviewTable);
        }
        final ModalityState state = ModalityState.current();
        this.finishPreviousPreviewSearch();
        this.mySearchRescheduleOnCancellationsAlarm.cancelAllRequests();
        this.applyTo(this.myHelper.getModel());
        final FindModel findModel = new FindModel();
        findModel.copyFrom(this.myHelper.getModel());
        if (findModel.getStringToFind().contains("\n") && Registry.is((String)"ide.find.ignores.leading.whitespace.in.multiline.search")) {
            findModel.setMultiline(true);
        }
        ValidationInfo result2 = this.getValidationInfo(this.myHelper.getModel());
        this.myComponentValidator.updateInfo(result2);
        this.myResultsPreviewSearchProgress = progressIndicatorWhenSearchStarted = new ProgressIndicatorBase(){

            @Override
            public void stop() {
                super.stop();
                FindPopupPanel.this.onStop(System.identityHashCode(this));
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (FindPopupPanel.this.myNeedReset.compareAndSet(true, false)) {
                        FindPopupPanel.this.reset();
                    }
                });
            }
        };
        final int hash = System.identityHashCode(this.myResultsPreviewSearchProgress);
        final LinkedHashSet<VirtualFile> filesToScanInitially = new LinkedHashSet<VirtualFile>();
        if (this.myHelper.myPreviousModel != null && this.myHelper.myPreviousModel.getStringToFind().length() < this.myHelper.getModel().getStringToFind().length()) {
            DefaultTableModel previousModel = (DefaultTableModel)this.myResultsPreviewTable.getModel();
            int len = previousModel.getRowCount();
            for (int i2 = 0; i2 < len; ++i2) {
                UsageInfo2UsageAdapter usage;
                VirtualFile file2;
                Object value2 = previousModel.getValueAt(i2, 0);
                if (!(value2 instanceof UsageInfo2UsageAdapter) || (file2 = (usage = (UsageInfo2UsageAdapter)value2).getFile()) == null) continue;
                filesToScanInitially.add(file2);
            }
        }
        this.myHelper.myPreviousModel = this.myHelper.getModel().clone();
        this.myReplaceAllButton.setEnabled(false);
        this.myReplaceSelectedButton.setEnabled(false);
        this.myReplaceSelectedButton.setText(FindBundle.message("find.popup.replace.selected.button", 0));
        this.onStart(hash);
        if (result2 != null && result2.component != this.myReplaceComponent) {
            this.onStop(hash, result2.message);
            this.reset();
            return;
        }
        final FindInProjectExecutor projectExecutor = FindInProjectExecutor.Companion.getInstance();
        GlobalSearchScope scope = GlobalSearchScopeUtil.toGlobalSearchScope((SearchScope)FindInProjectUtil.getScopeFromModel(this.myProject, this.myHelper.myPreviousModel), (Project)this.myProject);
        TableCellRenderer renderer = projectExecutor.createTableCellRenderer();
        if (renderer == null) {
            renderer = new UsageTableCellRenderer(scope);
        }
        this.myResultsPreviewTable.getColumnModel().getColumn(0).setCellRenderer(renderer);
        final Ref resultsCount = Ref.create((Object)0);
        final AtomicInteger resultsFilesCount = new AtomicInteger();
        FindInProjectUtil.setupViewPresentation(this.myUsageViewPresentation, findModel);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(new Task.Backgroundable(this.myProject, FindBundle.message("find.usages.progress.title", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    21.$$$reportNull$$$0(0);
                }
                FindUsagesProcessPresentation processPresentation = FindInProjectUtil.setupProcessPresentation(this.myProject, FindPopupPanel.this.myUsageViewPresentation);
                ThreadLocal lastUsageFileRef = new ThreadLocal();
                ThreadLocal recentUsageRef = new ThreadLocal();
                projectExecutor.findUsages(this.myProject, FindPopupPanel.this.myResultsPreviewSearchProgress, processPresentation, findModel, filesToScanInitially, (Function1<? super UsageInfoAdapter, Boolean>)((Function1)usage -> {
                    boolean merged;
                    Usage recent;
                    if (this.isCancelled()) {
                        FindPopupPanel.this.onStop(hash);
                        return false;
                    }
                    Ref ref = resultsCount;
                    synchronized (ref) {
                        if ((Integer)resultsCount.get() >= ShowUsagesAction.getUsagesPageSize()) {
                            FindPopupPanel.this.onStop(hash);
                            return false;
                        }
                        resultsCount.set((Object)((Integer)resultsCount.get() + 1));
                    }
                    String file2 = (String)lastUsageFileRef.get();
                    String usageFile = PathUtil.toSystemIndependentName((String)usage.getPath());
                    if (!usageFile.equals(file2)) {
                        resultsFilesCount.incrementAndGet();
                        lastUsageFileRef.set(usageFile);
                    }
                    UsageInfoAdapter recentAdapter = (recent = (Usage)SoftReference.dereference((Reference)((Reference)recentUsageRef.get()))) instanceof UsageInfoAdapter ? (UsageInfoAdapter)recent : null;
                    boolean bl = merged = !FindPopupPanel.this.myHelper.isReplaceState() && recentAdapter != null && recentAdapter.merge((MergeableUsage)usage);
                    if (!merged) {
                        recentUsageRef.set(new WeakReference<UsageInfoAdapter>((UsageInfoAdapter)usage));
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        int occurrences;
                        if (this.isCancelled()) {
                            FindPopupPanel.this.onStop(hash);
                            return;
                        }
                        FindPopupPanel.this.myPreviewSplitter.getSecondComponent().setVisible(true);
                        DefaultTableModel model2 = (DefaultTableModel)FindPopupPanel.this.myResultsPreviewTable.getModel();
                        if (!merged) {
                            model2.addRow(new Object[]{usage});
                        } else {
                            model2.fireTableRowsUpdated(model2.getRowCount() - 1, model2.getRowCount() - 1);
                        }
                        FindPopupPanel.this.myCodePreviewComponent.setVisible(true);
                        if (model2.getRowCount() == 1) {
                            FindPopupPanel.this.myResultsPreviewTable.setRowSelectionInterval(0, 0);
                        }
                        Ref ref = resultsCount;
                        synchronized (ref) {
                            occurrences = (Integer)resultsCount.get();
                        }
                        int filesWithOccurrences = resultsFilesCount.get();
                        FindPopupPanel.this.myCodePreviewComponent.setVisible(occurrences > 0);
                        FindPopupPanel.this.myReplaceAllButton.setEnabled(occurrences > 0);
                        FindPopupPanel.this.myReplaceSelectedButton.setEnabled(occurrences > 0);
                        if (occurrences > 0) {
                            if (occurrences < ShowUsagesAction.getUsagesPageSize()) {
                                FindPopupPanel.this.myUsagesCount = String.valueOf(occurrences);
                                FindPopupPanel.this.myFilesCount = String.valueOf(filesWithOccurrences);
                                FindPopupPanel.this.myInfoLabel.setText(FindBundle.message("message.matches.in.files", occurrences, filesWithOccurrences));
                            } else {
                                FindPopupPanel.this.myUsagesCount = occurrences + "+";
                                FindPopupPanel.this.myFilesCount = filesWithOccurrences + "+";
                                FindPopupPanel.this.myInfoLabel.setText(FindBundle.message("message.matches.in.files.incomplete", occurrences, filesWithOccurrences));
                            }
                        } else {
                            FindPopupPanel.this.myInfoLabel.setText("");
                        }
                    }, state);
                    return true;
                }));
            }

            public void onCancel() {
                if (FindPopupPanel.this.isShowing() && progressIndicatorWhenSearchStarted == FindPopupPanel.this.myResultsPreviewSearchProgress) {
                    FindPopupPanel.this.scheduleResultsUpdate();
                }
            }

            boolean isCancelled() {
                return progressIndicatorWhenSearchStarted != FindPopupPanel.this.myResultsPreviewSearchProgress || progressIndicatorWhenSearchStarted.isCanceled();
            }

            public void onFinished() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!this.isCancelled()) {
                        boolean isEmpty;
                        Ref ref = resultsCount;
                        synchronized (ref) {
                            isEmpty = (Integer)resultsCount.get() == 0;
                        }
                        if (isEmpty) {
                            FindPopupPanel.this.showEmptyText(null);
                        }
                    }
                    FindPopupPanel.this.onStop(hash);
                }, state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/find/impl/FindPopupPanel$21", "run"));
            }
        }, (ProgressIndicator)this.myResultsPreviewSearchProgress);
    }

    private void reset() {
        ((DefaultTableModel)this.myResultsPreviewTable.getModel()).getDataVector().clear();
        ((DefaultTableModel)this.myResultsPreviewTable.getModel()).fireTableDataChanged();
        this.myResultsPreviewTable.getSelectionModel().clearSelection();
        this.myPreviewSplitter.getSecondComponent().setVisible(false);
        this.myInfoLabel.setText(null);
    }

    private void showEmptyText(@Nullable @NlsContexts.StatusText String message2) {
        String fileTypeMask;
        StatusText emptyText = this.myResultsPreviewTable.getEmptyText();
        emptyText.clear();
        FindModel model2 = this.myHelper.getModel();
        if (StringUtil.isEmpty((String)model2.getStringToFind())) {
            emptyText.setText(FindBundle.message("message.type.search.query", new Object[0]));
        } else {
            emptyText.setText((String)(message2 != null ? message2 + "." : FindBundle.message("message.nothingFound", new Object[0])));
        }
        if (this.mySelectedScope == FindPopupScopeUIImpl.DIRECTORY && !model2.isWithSubdirectories()) {
            emptyText.appendSecondaryText(FindBundle.message("find.recursively.hint", new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, e -> {
                model2.setWithSubdirectories(true);
                this.scheduleResultsUpdate();
            });
        }
        SmartList usedOptions = new SmartList();
        if (model2.isCaseSensitive() && this.isEnabled(this.myCaseSensitiveAction)) {
            usedOptions.add(this.myCaseSensitiveAction);
        }
        if (model2.isWholeWordsOnly() && this.isEnabled(this.myWholeWordsAction)) {
            usedOptions.add(this.myWholeWordsAction);
        }
        if (model2.isRegularExpressions() && this.isEnabled(this.myRegexAction)) {
            usedOptions.add(this.myRegexAction);
        }
        boolean couldBeRegexp = false;
        if (this.mySuggestRegexHintForEmptyResults) {
            String stringToFind = model2.getStringToFind();
            if (!model2.isRegularExpressions() && this.isEnabled(this.myRegexAction)) {
                String regexSymbols = ".$|()[]{}^?*+\\";
                for (int i2 = 0; i2 < stringToFind.length(); ++i2) {
                    if (regexSymbols.indexOf(stringToFind.charAt(i2)) == -1) continue;
                    couldBeRegexp = true;
                    break;
                }
            }
            if (couldBeRegexp) {
                try {
                    Pattern.compile(stringToFind);
                    usedOptions.add(this.myRegexAction);
                }
                catch (Exception e2) {
                    couldBeRegexp = false;
                }
            }
        }
        if ((fileTypeMask = this.getFileTypeMask()) != null && FindInProjectUtil.createFileMaskCondition(fileTypeMask) != Conditions.alwaysTrue()) {
            usedOptions.add(this.myCbFileFilter);
        }
        if (model2.isInCommentsOnly() || model2.isInStringLiteralsOnly() || model2.isExceptComments() || model2.isExceptStringLiterals() || model2.isExceptCommentsAndStringLiterals()) {
            usedOptions.add(model2);
        }
        if (!usedOptions.isEmpty()) {
            emptyText.appendLine(" ");
            if (couldBeRegexp) {
                emptyText.appendLine(FindBundle.message("message.nothingFound.search.with.regex", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, __ -> {
                    this.toggleOption(this.myRegexAction);
                    this.mySuggestRegexHintForEmptyResults = false;
                }).appendText(" " + KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)this.myRegexAction.getShortcutSet()));
            } else if (usedOptions.size() > 1) {
                emptyText.appendLine(FindBundle.message("message.nothingFound.used.options", new Object[0]));
                @NlsSafe StringBuilder sb = new StringBuilder();
                for (Object option2 : usedOptions) {
                    String optionText;
                    if (sb.length() > 0) {
                        sb.append("  ");
                    }
                    if ((optionText = FindPopupPanel.getOptionText(option2, true)) == null) continue;
                    sb.append(optionText);
                }
                emptyText.appendLine(sb.toString());
                emptyText.appendLine(FindBundle.message("message.nothingFound.clearAll", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, __ -> this.resetAllFilters()).appendText(" " + FindPopupPanel.getOptionText(this.myResetFiltersAction, true));
            } else {
                Object option3 = usedOptions.get(0);
                emptyText.appendLine(FindBundle.message("message.nothingFound.used.option", FindPopupPanel.getOptionText(option3, false)));
                emptyText.appendLine(FindBundle.message("message.nothingFound.clearOption", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, __ -> this.resetAllFilters()).appendText(" " + FindPopupPanel.getOptionText(this.myResetFiltersAction, true));
            }
        } else {
            emptyText.appendLine(" ");
            emptyText.appendLine(FindBundle.message("message.nothingFound.default.hint", new Object[0]));
        }
    }

    private void resetAllFilters() {
        this.myCbFileFilter.setSelected(false);
        this.mySelectedContextName = FindInProjectUtil.getPresentableName(FindModel.SearchContext.ANY);
        this.myFilterContextButton.repaint();
        this.myCaseSensitiveState.set(false);
        this.myWholeWordsState.set(false);
        this.myRegexState.set(false);
        this.scheduleResultsUpdate();
    }

    private boolean isEnabled(@NotNull AnAction action2) {
        if (action2 == null) {
            FindPopupPanel.$$$reportNull$$$0(9);
        }
        Presentation presentation2 = new Presentation();
        action2.update(new AnActionEvent(null, DataManager.getInstance().getDataContext((Component)((Object)this)), "unknown", presentation2, ActionManager.getInstance(), 0));
        return presentation2.isEnabled();
    }

    @Nullable
    @NlsContexts.StatusText
    private static String getOptionText(Object option2, boolean full) {
        if (option2 instanceof AnAction) {
            String text2 = ((AnAction)option2).getTemplateText();
            if (text2 == null) {
                text2 = "";
            }
            return (text2 + (String)(full ? " " + KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)((AnAction)option2).getShortcutSet()) : "")).trim();
        }
        if (option2 instanceof JToggleButton) {
            CustomShortcutSet shortcutSet = KeymapUtil.getMnemonicAsShortcut((int)((JToggleButton)option2).getMnemonic());
            return (((JToggleButton)option2).getText().replace(":", "") + (String)(shortcutSet != null && full ? " " + KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)shortcutSet) : "")).trim();
        }
        if (option2 instanceof FindModel) {
            return FindBundle.message("message.nothingFound.context.filter", new Object[0]);
        }
        return null;
    }

    private void toggleOption(@NotNull Object option2) {
        if (option2 == null) {
            FindPopupPanel.$$$reportNull$$$0(10);
        }
        if (option2 instanceof AnAction) {
            ((AnAction)option2).actionPerformed(new AnActionEvent(null, DataManager.getInstance().getDataContext((Component)((Object)this)), "unknown", new Presentation(), ActionManager.getInstance(), 0));
        } else if (option2 instanceof JToggleButton) {
            ((JToggleButton)option2).doClick();
        } else if (option2 instanceof FindModel) {
            this.mySelectedContextName = FindInProjectUtil.getPresentableName(FindModel.SearchContext.ANY);
            this.myFilterContextButton.repaint();
            this.scheduleResultsUpdate();
        }
    }

    private void onStart(int hash) {
        this.myNeedReset.set(true);
        this.myLoadingHash = hash;
        this.myLoadingIcon.setIcon((Icon)AnimatedIcon.Default.INSTANCE);
        this.myResultsPreviewTable.getEmptyText().setText(FindBundle.message("empty.text.searching", new Object[0]));
    }

    private void onStop(int hash) {
        this.onStop(hash, null);
    }

    private void onStop(int hash, String message2) {
        if (hash != this.myLoadingHash) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            this.showEmptyText(message2);
            this.myLoadingIcon.setIcon(EmptyIcon.ICON_16);
        });
    }

    @Override
    @Nullable
    public String getFileTypeMask() {
        String mask = null;
        if (this.myCbFileFilter != null && this.myCbFileFilter.isSelected()) {
            mask = (String)this.myFileMaskField.getSelectedItem();
        }
        return mask;
    }

    @Nullable(value="null means OK")
    private @Nullable(value="null means OK") ValidationInfo getValidationInfo(@NotNull FindModel model2) {
        String mask;
        ValidationInfo scopeValidationInfo;
        if (model2 == null) {
            FindPopupPanel.$$$reportNull$$$0(11);
        }
        if ((scopeValidationInfo = this.myScopeUI.validate(model2, this.mySelectedScope)) != null) {
            return scopeValidationInfo;
        }
        if (!this.myHelper.canSearchThisString()) {
            return new ValidationInfo(FindBundle.message("find.empty.search.text.error", new Object[0]), (JComponent)this.mySearchComponent);
        }
        if (model2.isRegularExpressions()) {
            Pattern pattern;
            String toFind = model2.getStringToFind();
            try {
                pattern = Pattern.compile(toFind, model2.isCaseSensitive() ? 8 : 10);
                if (pattern.matcher("").matches() && !toFind.endsWith("$") && !toFind.startsWith("^")) {
                    return new ValidationInfo(FindBundle.message("find.empty.match.regular.expression.error", new Object[0]), (JComponent)this.mySearchComponent);
                }
            }
            catch (PatternSyntaxException e) {
                return new ValidationInfo(FindBundle.message("find.invalid.regular.expression.error", toFind, e.getDescription()), (JComponent)this.mySearchComponent);
            }
            if (model2.isReplaceState()) {
                Object value2;
                if (this.myResultsPreviewTable.getRowCount() > 0 && (value2 = this.myResultsPreviewTable.getModel().getValueAt(0, 0)) instanceof Usage) {
                    try {
                        ReplaceInProjectManager.getInstance(this.myProject).replaceUsage((Usage)value2, model2, Collections.emptySet(), true);
                    }
                    catch (FindManager.MalformedReplacementStringException e) {
                        return new ValidationInfo(e.getMessage(), (JComponent)this.myReplaceComponent);
                    }
                }
                try {
                    RegExReplacementBuilder.validate(pattern, this.getStringToReplace());
                }
                catch (IllegalArgumentException e) {
                    return new ValidationInfo(FindBundle.message("find.replace.invalid.replacement.string", e.getMessage()), (JComponent)this.myReplaceComponent);
                }
            }
        }
        if ((mask = this.getFileTypeMask()) != null) {
            if (mask.isEmpty()) {
                return new ValidationInfo(FindBundle.message("find.filter.empty.file.mask.error", new Object[0]), this.myFileMaskField);
            }
            if (mask.contains(";")) {
                return new ValidationInfo(FindBundle.message("message.file.masks.should.be.comma.separated", new Object[0]), this.myFileMaskField);
            }
            try {
                FindPopupPanel.createFileMaskRegExp(mask);
            }
            catch (PatternSyntaxException ex) {
                return new ValidationInfo(FindBundle.message("find.filter.invalid.file.mask.error", mask), this.myFileMaskField);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getStringToFind() {
        String string = this.mySearchComponent.getText();
        if (string == null) {
            FindPopupPanel.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private String getStringToReplace() {
        String string = this.myReplaceComponent.getText();
        if (string == null) {
            FindPopupPanel.$$$reportNull$$$0(13);
        }
        return string;
    }

    private void applyTo(@NotNull FindModel model2) {
        if (model2 == null) {
            FindPopupPanel.$$$reportNull$$$0(14);
        }
        model2.setCaseSensitive(this.myCaseSensitiveState.get());
        if (model2.isReplaceState()) {
            model2.setPreserveCase(this.myPreserveCaseState.get());
        }
        model2.setWholeWordsOnly(this.myWholeWordsState.get());
        FindModel.SearchContext searchContext = FindPopupPanel.parseSearchContext(this.mySelectedContextName);
        model2.setSearchContext(searchContext);
        model2.setRegularExpressions(this.myRegexState.get());
        model2.setStringToFind(this.getStringToFind());
        if (model2.isReplaceState()) {
            model2.setStringToReplace(StringUtil.convertLineSeparators((String)this.getStringToReplace()));
        }
        model2.setProjectScope(false);
        model2.setDirectoryName(null);
        model2.setModuleName(null);
        model2.setCustomScopeName(null);
        model2.setCustomScope(null);
        model2.setCustomScope(false);
        this.myScopeUI.applyTo(model2, this.mySelectedScope);
        model2.setFindAll(false);
        String mask = this.getFileTypeMask();
        model2.setFileFilter(mask);
    }

    private void navigateToSelectedUsage(@Nullable AnActionEvent e) {
        Navigatable[] navigatables;
        Navigatable[] navigatableArray = navigatables = e != null ? (Navigatable[])e.getData(CommonDataKeys.NAVIGATABLE_ARRAY) : null;
        if (navigatables != null) {
            if (this.canBeClosed()) {
                this.myDialog.doCancelAction();
            }
            OpenSourceUtil.navigate((Navigatable[])navigatables);
            return;
        }
        Map<Integer, Usage> usages = this.getSelectedUsages();
        if (usages != null) {
            if (this.canBeClosed()) {
                this.myDialog.doCancelAction();
            }
            boolean first = true;
            for (Usage usage : usages.values()) {
                if (first) {
                    usage.navigate(true);
                } else {
                    usage.highlightInEditor();
                }
                first = false;
            }
        }
    }

    @Nullable
    private Map<Integer, Usage> getSelectedUsages() {
        int[] rows = this.myResultsPreviewTable.getSelectedRows();
        LinkedHashMap<Integer, Usage> result2 = null;
        for (int i2 = rows.length - 1; i2 >= 0; --i2) {
            int row = rows[i2];
            Object valueAt = this.myResultsPreviewTable.getModel().getValueAt(row, 0);
            if (!(valueAt instanceof Usage)) continue;
            if (result2 == null) {
                result2 = new LinkedHashMap<Integer, Usage>();
            }
            result2.put(row, (Usage)valueAt);
        }
        return result2;
    }

    @NotNull
    public static ActionToolbarImpl createToolbar(AnAction ... actions) {
        if (actions == null) {
            FindPopupPanel.$$$reportNull$$$0(15);
        }
        ActionToolbarImpl toolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)new DefaultActionGroup(actions), true);
        toolbar.setForceMinimumSize(true);
        toolbar.setLayoutPolicy(0);
        ActionToolbarImpl actionToolbarImpl = toolbar;
        if (actionToolbarImpl == null) {
            FindPopupPanel.$$$reportNull$$$0(16);
        }
        return actionToolbarImpl;
    }

    private static void applyFont(@NotNull JBFont font, Component ... components) {
        if (font == null) {
            FindPopupPanel.$$$reportNull$$$0(17);
        }
        if (components == null) {
            FindPopupPanel.$$$reportNull$$$0(18);
        }
        for (Component component2 : components) {
            component2.setFont((Font)font);
        }
    }

    private static void createFileMaskRegExp(@NotNull String filter) throws PatternSyntaxException {
        List strings;
        if (filter == null) {
            FindPopupPanel.$$$reportNull$$$0(19);
        }
        String pattern = (strings = StringUtil.split((String)filter, (String)",")).size() == 1 ? PatternUtil.convertToRegex((String)filter.trim()) : StringUtil.join((Collection)strings, s -> "(" + PatternUtil.convertToRegex((String)s.trim()) + ")", (String)"|");
        Pattern.compile(pattern, 2);
    }

    @NotNull
    private static String getSearchContextName(@NotNull FindModel model2) {
        if (model2 == null) {
            FindPopupPanel.$$$reportNull$$$0(20);
        }
        String searchContext = FindBundle.message("find.context.anywhere.scope.label", new Object[0]);
        if (model2.isInCommentsOnly()) {
            searchContext = FindBundle.message("find.context.in.comments.scope.label", new Object[0]);
        } else if (model2.isInStringLiteralsOnly()) {
            searchContext = FindBundle.message("find.context.in.literals.scope.label", new Object[0]);
        } else if (model2.isExceptStringLiterals()) {
            searchContext = FindBundle.message("find.context.except.literals.scope.label", new Object[0]);
        } else if (model2.isExceptComments()) {
            searchContext = FindBundle.message("find.context.except.comments.scope.label", new Object[0]);
        } else if (model2.isExceptCommentsAndStringLiterals()) {
            searchContext = FindBundle.message("find.context.except.comments.and.literals.scope.label", new Object[0]);
        }
        String string = searchContext;
        if (string == null) {
            FindPopupPanel.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    private static FindModel.SearchContext parseSearchContext(String presentableName) {
        FindModel.SearchContext searchContext = FindModel.SearchContext.ANY;
        if (FindBundle.message("find.context.in.literals.scope.label", new Object[0]).equals(presentableName)) {
            searchContext = FindModel.SearchContext.IN_STRING_LITERALS;
        } else if (FindBundle.message("find.context.in.comments.scope.label", new Object[0]).equals(presentableName)) {
            searchContext = FindModel.SearchContext.IN_COMMENTS;
        } else if (FindBundle.message("find.context.except.comments.scope.label", new Object[0]).equals(presentableName)) {
            searchContext = FindModel.SearchContext.EXCEPT_COMMENTS;
        } else if (FindBundle.message("find.context.except.literals.scope.label", new Object[0]).equals(presentableName)) {
            searchContext = FindModel.SearchContext.EXCEPT_STRING_LITERALS;
        } else if (FindBundle.message("find.context.except.comments.and.literals.scope.label", new Object[0]).equals(presentableName)) {
            searchContext = FindModel.SearchContext.EXCEPT_COMMENTS_AND_STRING_LITERALS;
        }
        FindModel.SearchContext searchContext2 = searchContext;
        if (searchContext2 == null) {
            FindPopupPanel.$$$reportNull$$$0(22);
        }
        return searchContext2;
    }

    @NotNull
    private static JBIterable<Component> focusableComponents(@NotNull Component component2) {
        if (component2 == null) {
            FindPopupPanel.$$$reportNull$$$0(23);
        }
        JBIterable jBIterable = UIUtil.uiTraverser((Component)component2).bfsTraversal().filter(c -> c instanceof JComboBox || c instanceof AbstractButton || c instanceof JTextComponent);
        if (jBIterable == null) {
            FindPopupPanel.$$$reportNull$$$0(24);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 21: 
            case 22: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 21: 
            case 22: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/impl/FindPopupPanel";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 11: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/impl/FindPopupPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanClose";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTableModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCheckBox";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringToFind";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringToReplace";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchContextName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSearchContext";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "focusableComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 21: 
            case 22: 
            case 24: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPresentablePath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCheckBox";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "toggleOption";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getValidationInfo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "applyTo";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createToolbar";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "applyFont";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createFileMaskRegExp";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSearchContextName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "focusableComponents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 21: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JBTextAreaWithMixedAccessibleContext
    extends JBTextArea {
        private final AccessibleContext tableContext;

        private JBTextAreaWithMixedAccessibleContext(AccessibleContext context) {
            this.tableContext = context;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new TextFieldWithListAccessibleContext((JTextComponent)((Object)this), this.tableContext);
            }
            return this.accessibleContext;
        }
    }

    private final class MyEnterAction
    extends DumbAwareAction {
        private final boolean myEnterAsOK;

        private MyEnterAction(boolean enterAsOK) {
            this.myEnterAsOK = enterAsOK;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyEnterAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(e.getData(CommonDataKeys.EDITOR) == null || SwingUtilities.isDescendingFrom((Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT), FindPopupPanel.this.myFileMaskField));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyEnterAction.$$$reportNull$$$0(1);
            }
            if (SwingUtilities.isDescendingFrom((Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT), FindPopupPanel.this.myFileMaskField) && FindPopupPanel.this.myFileMaskField.isPopupVisible()) {
                FindPopupPanel.this.myFileMaskField.hidePopup();
                return;
            }
            if (FindPopupPanel.this.myScopeUI.hideAllPopups()) {
                return;
            }
            if (this.myEnterAsOK) {
                FindPopupPanel.this.myOkActionListener.actionPerformed(null);
            } else if (FindPopupPanel.this.myHelper.isReplaceState()) {
                FindPopupPanel.this.myReplaceSelectedButton.doClick();
            } else {
                FindPopupPanel.this.navigateToSelectedUsage(null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/find/impl/FindPopupPanel$MyEnterAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyPinAction
    extends ToggleAction {
        private MyPinAction() {
            super(IdeBundle.messagePointer((String)"action.ToggleAction.text.pin.window", (Object[])new Object[0]), IdeBundle.messagePointer((String)"action.ToggleAction.description.pin.window", (Object[])new Object[0]), AllIcons.General.Pin_tab);
        }

        public boolean isDumbAware() {
            return true;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MyPinAction.$$$reportNull$$$0(0);
            }
            return UISettings.getInstance().getPinFindInPath();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MyPinAction.$$$reportNull$$$0(1);
            }
            FindPopupPanel.this.myIsPinned.set(state);
            UISettings.getInstance().setPinFindInPath(state);
            FUCounterUsageLogger.getInstance().logEvent(e.getProject(), "find", "pin.toggled", new FeatureUsageData().addData("option_value", state));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/find/impl/FindPopupPanel$MyPinAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class UsageTableCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private final ColoredTableCellRenderer myUsageRenderer;
        private final ColoredTableCellRenderer myFileAndLineNumber;
        private static final int MARGIN = 2;
        private final GlobalSearchScope myScope;

        UsageTableCellRenderer(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                UsageTableCellRenderer.$$$reportNull$$$0(0);
            }
            this.myUsageRenderer = new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(@NotNull JTable table, Object value2, boolean selected2, boolean hasFocus, int row, int column) {
                    if (table == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (value2 instanceof UsageInfo2UsageAdapter) {
                        if (!((UsageInfo2UsageAdapter)value2).isValid()) {
                            myUsageRenderer.append(" " + UsageViewBundle.message((String)"node.invalid", (Object[])new Object[0]) + " ", SimpleTextAttributes.ERROR_ATTRIBUTES);
                        }
                        TextChunk[] text2 = ((UsageInfo2UsageAdapter)value2).getPresentation().getText();
                        for (int i2 = 1; i2 < text2.length; ++i2) {
                            TextChunk textChunk = text2[i2];
                            SimpleTextAttributes attributes = this.getAttributes(textChunk);
                            myUsageRenderer.append(textChunk.getText(), attributes);
                        }
                    }
                    this.setBorder(null);
                }

                @NotNull
                private SimpleTextAttributes getAttributes(@NotNull TextChunk textChunk) {
                    if (textChunk == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    SimpleTextAttributes at = textChunk.getSimpleAttributesIgnoreBackground();
                    boolean highlighted = textChunk.getType() != null || at.getFontStyle() == 1;
                    SimpleTextAttributes simpleTextAttributes = highlighted ? new SimpleTextAttributes(null, at.getFgColor(), at.getWaveColor(), at.getStyle() & 0xFFFFFFFE | 0x40) : at;
                    if (simpleTextAttributes == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return simpleTextAttributes;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "table";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "textChunk";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/find/impl/FindPopupPanel$UsageTableCellRenderer$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/find/impl/FindPopupPanel$UsageTableCellRenderer$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getAttributes";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "customizeCellRenderer";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "getAttributes";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            this.myFileAndLineNumber = new ColoredTableCellRenderer(){
                private final SimpleTextAttributes ORDINAL_ATTRIBUTES = new SimpleTextAttributes(0, (Color)JBColor.namedColor((String)"SearchResults.Ordinal.File.Foreground", (int)0x999999, (int)0x999999));
                private final SimpleTextAttributes REPEATED_FILE_ATTRIBUTES = new SimpleTextAttributes(0, (Color)JBColor.namedColor((String)"SearchResults.Repeated.File.Foreground", (int)0xCCCCCC, (int)0x5E5E5E));

                protected void customizeCellRenderer(@NotNull JTable table, Object value2, boolean selected2, boolean hasFocus, int row, int column) {
                    if (table == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (value2 instanceof UsageInfo2UsageAdapter) {
                        UsageInfo2UsageAdapter usageAdapter = (UsageInfo2UsageAdapter)value2;
                        TextChunk[] text2 = usageAdapter.getPresentation().getText();
                        VirtualFile file2 = usageAdapter.getFile();
                        String uniqueVirtualFilePath = (String)SlowOperations.allowSlowOperations(() -> this.getFilePath(usageAdapter));
                        VirtualFile prevFile = this.findPrevFile(table, row, column);
                        SimpleTextAttributes attributes = Comparing.equal((Object)file2, (Object)prevFile) ? this.REPEATED_FILE_ATTRIBUTES : this.ORDINAL_ATTRIBUTES;
                        this.append(uniqueVirtualFilePath, attributes);
                        if (text2.length > 0) {
                            this.append(" " + text2[0].getText(), this.ORDINAL_ATTRIBUTES);
                        }
                    }
                    this.setBorder(null);
                }

                @NotNull
                @NlsSafe
                private String getFilePath(@NotNull UsageInfo2UsageAdapter ua) {
                    VirtualFile file2;
                    if (ua == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (ScratchUtil.isScratch((VirtualFile)(file2 = ua.getFile()))) {
                        String string = StringUtil.notNullize((String)FindPopupPanel.getPresentablePath(ua.getUsageInfo().getProject(), ua.getFile(), 60));
                        if (string == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        return string;
                    }
                    String string = UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(ua.getUsageInfo().getProject(), file2, myScope);
                    if (string == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    return string;
                }

                @Nullable
                private VirtualFile findPrevFile(@NotNull JTable table, int row, int column) {
                    if (table == null) {
                        2.$$$reportNull$$$0(4);
                    }
                    if (row <= 0) {
                        return null;
                    }
                    Object prev2 = table.getValueAt(row - 1, column);
                    return prev2 instanceof UsageInfo2UsageAdapter ? ((UsageInfo2UsageAdapter)prev2).getFile() : null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 2: 
                        case 3: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 2: 
                        case 3: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "table";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "ua";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/find/impl/FindPopupPanel$UsageTableCellRenderer$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/find/impl/FindPopupPanel$UsageTableCellRenderer$2";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getFilePath";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "customizeCellRenderer";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "getFilePath";
                            break;
                        }
                        case 2: 
                        case 3: {
                            break;
                        }
                        case 4: {
                            objectArray = objectArray;
                            objectArray[2] = "findPrevFile";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 2: 
                        case 3: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            this.myScope = scope;
            this.setLayout(new BorderLayout());
            this.add((Component)this.myUsageRenderer, "Center");
            this.add((Component)this.myFileAndLineNumber, "East");
            this.setBorder((Border)JBUI.Borders.empty((int)2, (int)2, (int)2, (int)0));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            this.myUsageRenderer.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
            this.myFileAndLineNumber.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
            this.setBackground(this.myUsageRenderer.getBackground());
            if (!isSelected && value2 instanceof UsageInfo2UsageAdapter) {
                UsageInfo2UsageAdapter usageAdapter = (UsageInfo2UsageAdapter)value2;
                Project project = usageAdapter.getUsageInfo().getProject();
                Color color = VfsPresentationUtil.getFileBackgroundColor(project, usageAdapter.getFile());
                this.setBackground(color);
                this.myUsageRenderer.setBackground(color);
                this.myFileAndLineNumber.setBackground(color);
            }
            this.getAccessibleContext().setAccessibleName(FindBundle.message("find.popup.found.element.accesible.name", this.myUsageRenderer.getAccessibleContext().getAccessibleName(), this.myFileAndLineNumber.getAccessibleContext().getAccessibleName()));
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/find/impl/FindPopupPanel$UsageTableCellRenderer", "<init>"));
        }
    }

    private class MyShowFilterPopupAction
    extends DumbAwareAction {
        private final PopupState<JBPopup> myPopupState;
        private final DefaultActionGroup mySwitchContextGroup;

        MyShowFilterPopupAction() {
            super(FindBundle.messagePointer("find.popup.show.filter.popup", new Object[0]), Presentation.NULL_STRING, AllIcons.General.Filter);
            this.myPopupState = PopupState.forPopup();
            KeyboardShortcut keyboardShortcut = ActionManager.getInstance().getKeyboardShortcut("ShowFilterPopup");
            if (keyboardShortcut != null) {
                this.setShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{keyboardShortcut}));
            }
            this.mySwitchContextGroup = new DefaultActionGroup();
            this.mySwitchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.ANY));
            this.mySwitchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.IN_COMMENTS));
            this.mySwitchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.IN_STRING_LITERALS));
            this.mySwitchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.EXCEPT_COMMENTS));
            this.mySwitchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.EXCEPT_STRING_LITERALS));
            this.mySwitchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.EXCEPT_COMMENTS_AND_STRING_LITERALS));
            this.mySwitchContextGroup.setPopup(true);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyShowFilterPopupAction.$$$reportNull$$$0(0);
            }
            if (e.getData(PlatformDataKeys.CONTEXT_COMPONENT) == null) {
                return;
            }
            if (this.myPopupState.isRecentlyHidden()) {
                return;
            }
            ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)this.mySwitchContextGroup, e.getDataContext(), false, null, 10);
            this.myPopupState.prepareToShow((Object)listPopup);
            listPopup.showUnderneathOf((Component)FindPopupPanel.this.myFilterContextButton);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/impl/FindPopupPanel$MyShowFilterPopupAction", "actionPerformed"));
        }
    }

    private class MySelectScopeToggleAction
    extends DumbAwareToggleAction {
        private final FindPopupScopeUI.ScopeType myScope;

        MySelectScopeToggleAction(FindPopupScopeUI.ScopeType scope) {
            if (scope == null) {
                MySelectScopeToggleAction.$$$reportNull$$$0(0);
            }
            super(scope.textComputable.get(), null, scope.icon);
            this.getTemplatePresentation().setHoveredIcon(scope.icon);
            this.getTemplatePresentation().setDisabledIcon(scope.icon);
            this.myScope = scope;
        }

        public boolean displayTextInToolbar() {
            return true;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MySelectScopeToggleAction.$$$reportNull$$$0(1);
            }
            return FindPopupPanel.this.mySelectedScope == this.myScope;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MySelectScopeToggleAction.$$$reportNull$$$0(2);
            }
            if (state) {
                FindPopupPanel.this.mySelectedScope = this.myScope;
                FindPopupPanel.this.myScopeSelectionToolbar.updateActionsImmediately();
                FindPopupPanel.this.updateScopeDetailsPanel();
                FindPopupPanel.this.scheduleResultsUpdate();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/find/impl/FindPopupPanel$MySelectScopeToggleAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MySwitchContextToggleAction
    extends ToggleAction
    implements DumbAware {
        MySwitchContextToggleAction(FindModel.SearchContext context) {
            if (context == null) {
                MySwitchContextToggleAction.$$$reportNull$$$0(0);
            }
            super(FindInProjectUtil.getPresentableName(context));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MySwitchContextToggleAction.$$$reportNull$$$0(1);
            }
            return Objects.equals(FindPopupPanel.this.mySelectedContextName, this.getTemplatePresentation().getText());
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MySwitchContextToggleAction.$$$reportNull$$$0(2);
            }
            if (state) {
                FindPopupPanel.this.mySelectedContextName = this.getTemplatePresentation().getText();
                FindPopupPanel.this.myFilterContextButton.repaint();
                FindPopupPanel.this.scheduleResultsUpdate();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/find/impl/FindPopupPanel$MySwitchContextToggleAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MySwitchStateToggleAction
    extends DumbAwareToggleAction
    implements TooltipLinkProvider,
    TooltipDescriptionProvider {
        private final String myOptionName;
        private final AtomicBoolean myState;
        private final Producer<Boolean> myEnableStateProvider;
        private final TooltipLinkProvider.TooltipLink myTooltipLink;
        final /* synthetic */ FindPopupPanel this$0;

        private MySwitchStateToggleAction(@NotNull FindPopupPanel findPopupPanel, @NotNull String message2, @NotNull String optionName, @NotNull Icon icon2, @NotNull Icon hoveredIcon, @NotNull Icon selectedIcon, @NotNull AtomicBoolean state, Producer<Boolean> enableStateProvider) {
            if (message2 == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(0);
            }
            if (optionName == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(1);
            }
            if (icon2 == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(2);
            }
            if (hoveredIcon == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(3);
            }
            if (selectedIcon == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(4);
            }
            if (state == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(5);
            }
            if (enableStateProvider == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(6);
            }
            this(findPopupPanel, message2, optionName, icon2, hoveredIcon, selectedIcon, state, enableStateProvider, null);
        }

        private MySwitchStateToggleAction(@NotNull FindPopupPanel findPopupPanel, @NotNull String message2, @NotNull String optionName, @NotNull Icon icon2, @NotNull Icon hoveredIcon, @NotNull Icon selectedIcon, @NotNull AtomicBoolean state, @Nullable Producer<Boolean> enableStateProvider, TooltipLinkProvider.TooltipLink tooltipLink) {
            if (message2 == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(7);
            }
            if (optionName == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(8);
            }
            if (icon2 == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(9);
            }
            if (hoveredIcon == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(10);
            }
            if (selectedIcon == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(11);
            }
            if (state == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(12);
            }
            if (enableStateProvider == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(13);
            }
            this.this$0 = findPopupPanel;
            super(FindBundle.message(message2, new Object[0]), null, icon2);
            this.myOptionName = optionName;
            this.myState = state;
            this.myEnableStateProvider = enableStateProvider;
            this.myTooltipLink = tooltipLink;
            this.getTemplatePresentation().setHoveredIcon(hoveredIcon);
            this.getTemplatePresentation().setSelectedIcon(selectedIcon);
            ShortcutSet shortcut = ActionUtil.getMnemonicAsShortcut((AnAction)this);
            if (shortcut != null) {
                this.setShortcutSet(shortcut);
                this.registerCustomShortcutSet(shortcut, (JComponent)((Object)findPopupPanel));
            }
        }

        @Nullable
        public TooltipLinkProvider.TooltipLink getTooltipLink(@Nullable JComponent owner) {
            return this.myTooltipLink;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(14);
            }
            return this.myState.get();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(15);
            }
            e.getPresentation().setEnabled(((Boolean)this.myEnableStateProvider.produce()).booleanValue());
            Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)this.myState.get());
        }

        public void setSelected(@NotNull AnActionEvent e, boolean selected2) {
            if (e == null) {
                MySwitchStateToggleAction.$$$reportNull$$$0(16);
            }
            FUCounterUsageLogger.getInstance().logEvent("find", "check.box.toggled", new FeatureUsageData().addData("type", FindPopupPanel.FIND_TYPE).addData("option_name", this.myOptionName).addData("option_value", selected2));
            this.myState.set(selected2);
            if (this.myState == this.this$0.myRegexState) {
                this.this$0.mySuggestRegexHintForEmptyResults = false;
                if (selected2) {
                    this.this$0.myWholeWordsState.set(false);
                }
            }
            this.this$0.scheduleResultsUpdate();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "optionName";
                    break;
                }
                case 2: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 3: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hoveredIcon";
                    break;
                }
                case 4: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedIcon";
                    break;
                }
                case 5: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 6: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enableStateProvider";
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/find/impl/FindPopupPanel$MySwitchStateToggleAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

