/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetFromExternalSourcesStorage;
import com.intellij.facet.FacetManagerBase;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.impl.FacetEventsPublisher;
import com.intellij.facet.impl.FacetModelBase;
import com.intellij.facet.impl.FacetModelImpl;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.facet.impl.invalid.InvalidFacet;
import com.intellij.facet.impl.invalid.InvalidFacetConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleComponent;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.facet.FacetManagerState;
import org.jetbrains.jps.model.serialization.facet.FacetState;

@State(name="FacetManager", useLoadedStateAsExisting=false)
@ApiStatus.Internal
public final class FacetManagerImpl
extends FacetManagerBase
implements ModuleComponent,
PersistentStateComponent<FacetManagerState> {
    private static final Logger LOG = Logger.getInstance(FacetManagerImpl.class);
    private final Module myModule;
    private final FacetManagerModel myModel;
    private boolean myInsideCommit;
    private boolean myModuleAdded;
    private final FacetFromExternalSourcesStorage myExternalSourcesStorage;

    public FacetManagerImpl(@NotNull Module module) {
        if (module == null) {
            FacetManagerImpl.$$$reportNull$$$0(0);
        }
        this.myModel = new FacetManagerModel();
        this.myModule = module;
        this.myExternalSourcesStorage = FacetFromExternalSourcesStorage.getInstance(module);
    }

    @NotNull
    public ModifiableFacetModel createModifiableModel() {
        FacetModelImpl model2 = new FacetModelImpl(this);
        model2.addFacetsFromManager();
        FacetModelImpl facetModelImpl = model2;
        if (facetModelImpl == null) {
            FacetManagerImpl.$$$reportNull$$$0(1);
        }
        return facetModelImpl;
    }

    @Override
    protected FacetModel getModel() {
        return this.myModel;
    }

    @Override
    protected Module getModule() {
        return this.myModule;
    }

    private void addFacets(List<? extends FacetState> facetStates, Facet<?> underlyingFacet, ModifiableFacetModel model2) {
        FacetTypeRegistry registry = FacetTypeRegistry.getInstance();
        for (FacetState facetState : facetStates) {
            FacetType actualUnderlyingType;
            String typeId = facetState.getFacetType();
            if (typeId == null) {
                this.addInvalidFacet(facetState, model2, underlyingFacet, ProjectBundle.message((String)"error.message.facet.type.isn.t.specified", (Object[])new Object[0]));
                continue;
            }
            FacetType type = registry.findFacetType(typeId);
            if (type == null) {
                this.addInvalidFacet(facetState, model2, underlyingFacet, ProjectBundle.message((String)"error.message.unknown.facet.type.0", (Object[])new Object[]{typeId}), true);
                continue;
            }
            ModuleType moduleType = ModuleType.get((Module)this.myModule);
            if (!type.isSuitableModuleType(moduleType)) {
                this.addInvalidFacet(facetState, model2, underlyingFacet, ProjectBundle.message((String)"error.message.0.facets.are.not.allowed.in.1", (Object[])new Object[]{type.getPresentableName(), moduleType.getName()}));
                continue;
            }
            FacetType expectedUnderlyingType = null;
            FacetTypeId underlyingTypeId = type.getUnderlyingFacetType();
            if (underlyingTypeId != null) {
                expectedUnderlyingType = registry.findFacetType(underlyingTypeId);
            }
            FacetType facetType = actualUnderlyingType = underlyingFacet != null ? underlyingFacet.getType() : null;
            if (expectedUnderlyingType != null) {
                if (!expectedUnderlyingType.equals(actualUnderlyingType)) {
                    this.addInvalidFacet(facetState, model2, underlyingFacet, ProjectBundle.message((String)"error.message.0.facet.must.be.placed.under.1.facet", (Object[])new Object[]{type.getPresentableName(), expectedUnderlyingType.getPresentableName()}));
                    continue;
                }
            } else if (actualUnderlyingType != null) {
                this.addInvalidFacet(facetState, model2, underlyingFacet, ProjectBundle.message((String)"error.message.0.cannot.be.placed.under.1", (Object[])new Object[]{type.getPresentableName(), actualUnderlyingType.getPresentableName()}));
                continue;
            }
            try {
                this.addFacet(type, facetState, underlyingFacet, model2);
            }
            catch (InvalidDataException e) {
                LOG.info((Throwable)e);
                this.addInvalidFacet(facetState, model2, underlyingFacet, ProjectBundle.message((String)"error.message.cannot.load.facet.configuration.0", (Object[])new Object[]{e.getMessage()}));
            }
        }
    }

    private void addInvalidFacet(FacetState state, ModifiableFacetModel model2, Facet<?> underlyingFacet, @NlsContexts.DialogMessage String errorMessage) {
        this.addInvalidFacet(state, model2, underlyingFacet, errorMessage, false);
    }

    private void addInvalidFacet(FacetState state, ModifiableFacetModel model2, Facet<?> underlyingFacet, @NlsContexts.DialogMessage String errorMessage, boolean unknownType) {
        model2.addFacet((Facet)FacetManagerImpl.createInvalidFacet(this.getModule(), state, underlyingFacet, errorMessage, unknownType, true));
    }

    private <F extends Facet<C>, C extends FacetConfiguration> void addFacet(FacetType<F, C> type, FacetState state, Facet<?> underlyingFacet, ModifiableFacetModel model2) throws InvalidDataException {
        Element newConfiguration;
        Collection facetsOfThisType;
        Collection collection = facetsOfThisType = underlyingFacet == null ? model2.getFacetsByType(type.getId()) : model2.getFacetsByType(underlyingFacet, type.getId());
        if (type.isOnlyOneFacetAllowed() && !facetsOfThisType.isEmpty() && facetsOfThisType.stream().anyMatch(f -> !f.getName().equals(state.getName()))) {
            LOG.info("'" + state.getName() + "' facet removed from module " + this.myModule.getName() + ", because only one " + type.getPresentableName() + " facet allowed");
            return;
        }
        Facet facet = null;
        if (!facetsOfThisType.isEmpty() && ProjectUtilCore.isExternalStorageEnabled((Project)this.myModule.getProject()) && (facet = (Facet)facetsOfThisType.stream().filter(f -> f.getName().equals(state.getName())).findFirst().orElse(null)) != null && (newConfiguration = state.getConfiguration()) != null) {
            FacetUtil.loadFacetConfiguration(facet.getConfiguration(), newConfiguration);
        }
        if (facet == null) {
            facet = (Facet)FacetManagerImpl.createFacetFromState(this.getModule(), type, state, underlyingFacet);
            model2.addFacet(facet);
        }
        this.addFacets(state.subFacets, facet, model2);
    }

    @ApiStatus.Internal
    @NotNull
    public static Facet<?> createFacetFromStateRaw(@NotNull Module module, @NotNull FacetType<?, ?> type, @NotNull FacetState state, @Nullable Facet<?> underlyingFacet) {
        if (module == null) {
            FacetManagerImpl.$$$reportNull$$$0(2);
        }
        if (type == null) {
            FacetManagerImpl.$$$reportNull$$$0(3);
        }
        if (state == null) {
            FacetManagerImpl.$$$reportNull$$$0(4);
        }
        return FacetManagerImpl.createFacetFromState(module, type, state, underlyingFacet);
    }

    @NotNull
    private static <F extends Facet<C>, C extends FacetConfiguration> F createFacetFromState(Module module, FacetType<F, C> type, FacetState state, Facet<?> underlyingFacet) {
        String externalSystemId2;
        FacetConfiguration configuration2 = type.createDefaultConfiguration();
        Element config2 = state.getConfiguration();
        FacetUtil.loadFacetConfiguration(configuration2, config2);
        String name = state.getName();
        F facet = FacetManagerImpl.createFacet(module, type, name, configuration2, underlyingFacet);
        if (facet instanceof JDOMExternalizable) {
            ((JDOMExternalizable)facet).readExternal(config2);
        }
        if ((externalSystemId2 = state.getExternalSystemId()) != null) {
            facet.setExternalSource(ExternalProjectSystemRegistry.getInstance().getSourceById(externalSystemId2));
        }
        F f = facet;
        if (f == null) {
            FacetManagerImpl.$$$reportNull$$$0(5);
        }
        return f;
    }

    public void noStateLoaded() {
        this.doLoadState(null);
    }

    public void loadState(@NotNull FacetManagerState state) {
        if (state == null) {
            FacetManagerImpl.$$$reportNull$$$0(6);
        }
        this.doLoadState(state);
    }

    private void doLoadState(@Nullable FacetManagerState state) {
        FacetModelImpl model2 = new FacetModelImpl(this);
        FacetManagerState importedFacetsState = this.myExternalSourcesStorage.getLoadedState();
        this.addFacets(ContainerUtil.concat((List)(state == null ? Collections.emptyList() : state.facets), (List)importedFacetsState.facets), null, model2);
        this.commit(model2, false);
    }

    @NotNull
    public FacetManagerState getState() {
        FacetManagerState facetManagerState = this.saveState(FacetManagerImpl.getImportedFacetPredicate(this.myModule.getProject()).negate());
        if (facetManagerState == null) {
            FacetManagerImpl.$$$reportNull$$$0(7);
        }
        return facetManagerState;
    }

    @NotNull
    static Predicate<Facet<?>> getImportedFacetPredicate(@NotNull Project project) {
        if (project == null) {
            FacetManagerImpl.$$$reportNull$$$0(8);
        }
        if (ProjectUtilCore.isExternalStorageEnabled((Project)project)) {
            Predicate<Facet<?>> predicate2 = facet -> facet.getExternalSource() != null;
            if (predicate2 == null) {
                FacetManagerImpl.$$$reportNull$$$0(9);
            }
            return predicate2;
        }
        Predicate<Facet<?>> predicate3 = facet -> false;
        if (predicate3 == null) {
            FacetManagerImpl.$$$reportNull$$$0(10);
        }
        return predicate3;
    }

    @NotNull
    FacetManagerState saveState(@NotNull Predicate<? super Facet<?>> filter) {
        if (filter == null) {
            FacetManagerImpl.$$$reportNull$$$0(11);
        }
        FacetManagerState managerState = new FacetManagerState();
        Facet<?>[] facets2 = this.getSortedFacets();
        HashMap states = new HashMap();
        states.put(null, managerState.facets);
        for (Facet<?> facet : facets2) {
            if (!filter.test(facet)) continue;
            Facet underlyingFacet = facet.getUnderlyingFacet();
            FacetState facetState = FacetManagerImpl.saveFacetConfiguration(facet);
            if (facetState == null) continue;
            FacetManagerImpl.getOrCreateTargetFacetList(underlyingFacet, states, this.myModule.getProject()).add(facetState);
            states.put(facet, facetState.subFacets);
        }
        FacetManagerState facetManagerState = managerState;
        if (facetManagerState == null) {
            FacetManagerImpl.$$$reportNull$$$0(12);
        }
        return facetManagerState;
    }

    @ApiStatus.Internal
    @Nullable
    public static FacetState saveFacetConfiguration(Facet<?> facet) {
        FacetState facetState = FacetManagerImpl.createFacetState(facet, facet.getModule().getProject());
        if (!(facet instanceof InvalidFacet)) {
            Element config2 = FacetUtil.saveFacetConfiguration(facet);
            if (config2 == null) {
                return null;
            }
            facetState.setConfiguration(config2);
        }
        return facetState;
    }

    private static List<FacetState> getOrCreateTargetFacetList(Facet<?> underlyingFacet, Map<Facet<?>, List<FacetState>> states, @NotNull Project project) {
        List facetStateList;
        if (project == null) {
            FacetManagerImpl.$$$reportNull$$$0(13);
        }
        if ((facetStateList = states.get(underlyingFacet)) == null) {
            FacetState state = FacetManagerImpl.createFacetState(underlyingFacet, project);
            FacetManagerImpl.getOrCreateTargetFacetList(underlyingFacet.getUnderlyingFacet(), states, project).add(state);
            facetStateList = state.subFacets;
            states.put(underlyingFacet, facetStateList);
        }
        return facetStateList;
    }

    private static FacetState createFacetState(@NotNull Facet<?> facet, @NotNull Project project) {
        if (facet == null) {
            FacetManagerImpl.$$$reportNull$$$0(14);
        }
        if (project == null) {
            FacetManagerImpl.$$$reportNull$$$0(15);
        }
        if (facet instanceof InvalidFacet) {
            return ((InvalidFacetConfiguration)((InvalidFacet)facet).getConfiguration()).getFacetState();
        }
        FacetState facetState = new FacetState();
        ProjectModelExternalSource externalSource = facet.getExternalSource();
        if (externalSource != null && ProjectUtilCore.isExternalStorageEnabled((Project)project)) {
            facetState.setExternalSystemId(externalSource.getId());
        }
        facetState.setFacetType(facet.getType().getStringId());
        facetState.setName(facet.getName());
        return facetState;
    }

    public void commit(ModifiableFacetModel model2) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.commit(model2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(ModifiableFacetModel model2, boolean fireEvents) {
        LOG.assertTrue(!this.myInsideCommit, (Object)"Recursive commit");
        Set toRemove2 = ContainerUtil.set((Object[])this.getAllFacets());
        ArrayList<Facet> toAdd = new ArrayList<Facet>();
        ArrayList<FacetRenameInfo> toRename = new ArrayList<FacetRenameInfo>();
        try {
            this.myInsideCommit = true;
            for (Facet facet : model2.getAllFacets()) {
                boolean isNew;
                boolean bl = isNew = !toRemove2.remove(facet);
                if (!isNew) continue;
                toAdd.add(facet);
            }
            Iterator newFacets = new ArrayList<Object>();
            for (Facet<?> facet : this.getAllFacets()) {
                if (toRemove2.contains(facet)) continue;
                newFacets.add(facet);
            }
            newFacets.addAll(toAdd);
            Iterator iterator2 = newFacets.iterator();
            while (iterator2.hasNext()) {
                Facet facet = (Facet)iterator2.next();
                String newName2 = model2.getNewName(facet);
                if (newName2 == null || newName2.equals(facet.getName())) continue;
                toRename.add(new FacetRenameInfo(facet, facet.getName(), newName2));
            }
            if (fireEvents) {
                FacetEventsPublisher facetEventsPublisher = FacetEventsPublisher.getInstance(this.myModule.getProject());
                for (Facet facet : toAdd) {
                    facetEventsPublisher.fireBeforeFacetAdded(facet);
                }
                for (Facet facet : toRemove2) {
                    facetEventsPublisher.fireBeforeFacetRemoved(facet);
                }
                for (FacetRenameInfo info : toRename) {
                    facetEventsPublisher.fireBeforeFacetRenamed(info.myFacet);
                }
            }
            for (FacetRenameInfo info : toRename) {
                FacetManagerImpl.setFacetName(info.myFacet, info.myNewName);
            }
            this.myModel.setAllFacets(newFacets.toArray(Facet.EMPTY_ARRAY));
        }
        finally {
            this.myInsideCommit = false;
        }
        if (this.myModuleAdded) {
            for (Facet facet : toAdd) {
                facet.initFacet();
            }
        }
        for (Facet facet : toRemove2) {
            Disposer.dispose((Disposable)facet);
        }
        if (fireEvents) {
            FacetEventsPublisher publisher = FacetEventsPublisher.getInstance(this.myModule.getProject());
            for (Facet facet : toAdd) {
                publisher.fireFacetAdded(facet);
            }
            for (Facet facet : toRemove2) {
                publisher.fireFacetRemoved(this.myModule, facet);
            }
            for (FacetRenameInfo info : toRename) {
                publisher.fireFacetRenamed(info.myFacet, info.myOldName);
            }
        }
        for (Facet facet : toAdd) {
            FacetType type;
            Module module = facet.getModule();
            if (!module.equals(this.myModule)) {
                LOG.error(facet + " is created for module " + module + " but added to module " + this.myModule);
            }
            if (!(type = facet.getType()).isOnlyOneFacetAllowed()) continue;
            if (type.getUnderlyingFacetType() == null) {
                Collection facets2 = this.getFacetsByType(type.getId());
                if (facets2.size() <= 1) continue;
                LOG.error("Only one '" + type.getPresentableName() + "' facet per module allowed, but " + facets2.size() + " facets found in module '" + this.myModule.getName() + "'");
                continue;
            }
            Facet underlyingFacet = facet.getUnderlyingFacet();
            LOG.assertTrue(underlyingFacet != null, (Object)("Underlying facet is not specified for '" + facet.getName() + "'"));
            Collection facets3 = this.getFacetsByType(underlyingFacet, type.getId());
            if (facets3.size() <= 1) continue;
            LOG.error("Only one '" + type.getPresentableName() + "' facet per parent facet allowed, but " + facets3.size() + " sub-facets found in facet " + underlyingFacet.getName());
        }
    }

    public static void setExternalSource(@NotNull Facet<?> facet, ProjectModelExternalSource externalSource) {
        if (facet == null) {
            FacetManagerImpl.$$$reportNull$$$0(16);
        }
        facet.setExternalSource(externalSource);
    }

    Set<ProjectModelExternalSource> getExternalSources() {
        return this.myModel.myExternalSources;
    }

    public void moduleAdded() {
        if (this.myModuleAdded) {
            return;
        }
        for (Facet<?> facet : this.getAllFacets()) {
            facet.initFacet();
        }
        this.myModuleAdded = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/FacetManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/FacetManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createModifiableModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createFacetFromState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportedFacetPredicate";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "saveState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFacetFromStateRaw";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getImportedFacetPredicate";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "saveState";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateTargetFacetList";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createFacetState";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setExternalSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FacetRenameInfo {
        private final Facet<?> myFacet;
        private final String myOldName;
        private final String myNewName;

        FacetRenameInfo(Facet<?> facet, String oldName, String newName2) {
            this.myFacet = facet;
            this.myOldName = oldName;
            this.myNewName = newName2;
        }
    }

    private static class FacetManagerModel
    extends FacetModelBase {
        private Facet<?>[] myAllFacets = Facet.EMPTY_ARRAY;
        private final Set<ProjectModelExternalSource> myExternalSources = new LinkedHashSet<ProjectModelExternalSource>();

        private FacetManagerModel() {
        }

        public Facet<?> @NotNull [] getAllFacets() {
            if (this.myAllFacets == null) {
                FacetManagerModel.$$$reportNull$$$0(0);
            }
            return this.myAllFacets;
        }

        void setAllFacets(Facet<?>[] allFacets) {
            this.myExternalSources.clear();
            for (Facet<?> facet : allFacets) {
                ContainerUtil.addIfNotNull(this.myExternalSources, (Object)facet.getExternalSource());
            }
            this.myAllFacets = allFacets;
            this.facetsChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl$FacetManagerModel", "getAllFacets"));
        }
    }
}

