/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalDependencies.impl;

import com.intellij.externalDependencies.DependencyOnPlugin;
import com.intellij.externalDependencies.ExternalDependenciesManager;
import com.intellij.externalDependencies.ProjectExternalDependency;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalDependenciesConfigurable
implements SearchableConfigurable {
    private static final Logger LOG = Logger.getInstance(ExternalDependenciesConfigurable.class);
    private final ExternalDependenciesManager myDependenciesManager;
    private final CollectionListModel<ProjectExternalDependency> myListModel = new CollectionListModel((Object[])new ProjectExternalDependency[0]);
    private Map<String, String> myPluginNameById;

    public ExternalDependenciesConfigurable(Project project) {
        this.myDependenciesManager = ExternalDependenciesManager.getInstance(project);
    }

    public void reset() {
        List<ProjectExternalDependency> dependencies = this.myDependenciesManager.getAllDependencies();
        this.myListModel.replaceAll(dependencies);
    }

    public boolean isModified() {
        return !new HashSet<ProjectExternalDependency>(this.myDependenciesManager.getAllDependencies()).equals(new HashSet(this.myListModel.getItems()));
    }

    public void apply() throws ConfigurationException {
        this.myDependenciesManager.setAllDependencies(this.myListModel.getItems());
    }

    @Nls
    public String getDisplayName() {
        return IdeBundle.message((String)"configurable.ExternalDependenciesConfigurable.display.name", (Object[])new Object[0]);
    }

    @Nullable
    public JComponent createComponent() {
        final JBList dependenciesList = new JBList();
        dependenciesList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<ProjectExternalDependency>(){

            protected void customizeCellRenderer(@NotNull JList<? extends ProjectExternalDependency> list2, ProjectExternalDependency dependency, int index2, boolean selected2, boolean hasFocus) {
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (dependency instanceof DependencyOnPlugin) {
                    DependencyOnPlugin value2 = (DependencyOnPlugin)dependency;
                    this.append(ExternalDependenciesConfigurable.this.getPluginNameById(value2.getPluginId()), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    String minVersion = value2.getMinVersion();
                    String maxVersion = value2.getMaxVersion();
                    if (minVersion != null && minVersion.equals(maxVersion)) {
                        this.append(IdeBundle.message((String)"required.plugin.exact.version", (Object[])new Object[]{minVersion}));
                    } else if (minVersion != null && maxVersion != null) {
                        this.append(IdeBundle.message((String)"required.plugin.between.versions", (Object[])new Object[]{minVersion, maxVersion}));
                    } else if (minVersion != null) {
                        this.append(IdeBundle.message((String)"required.plugin.at.least.versions", (Object[])new Object[]{minVersion}));
                    } else if (maxVersion != null) {
                        this.append(IdeBundle.message((String)"required.plugin.at.most.versions", (Object[])new Object[]{maxVersion}));
                    }
                } else {
                    LOG.error("Unsupported external dependency: " + dependency.getClass());
                    @NlsSafe String dependencyDescription = dependency.toString();
                    this.append(dependencyDescription);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/externalDependencies/impl/ExternalDependenciesConfigurable$1", "customizeCellRenderer"));
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                return ExternalDependenciesConfigurable.this.editSelectedDependency(dependenciesList);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/externalDependencies/impl/ExternalDependenciesConfigurable$2", "onDoubleClick"));
            }
        }.installOn((Component)dependenciesList);
        dependenciesList.setModel(this.myListModel);
        JPanel dependenciesPanel = ToolbarDecorator.createDecorator((JList)dependenciesList).disableUpDownActions().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                ExternalDependenciesConfigurable.this.replaceDependency(new DependencyOnPlugin("", null, null), dependenciesList);
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                ExternalDependenciesConfigurable.this.editSelectedDependency(dependenciesList);
            }
        }).createPanel();
        String text2 = XmlStringUtil.wrapInHtml((CharSequence)IdeBundle.message((String)"settings.required.plugins.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}));
        return JBUI.Panels.simplePanel((int)0, (int)4).addToCenter((Component)dependenciesPanel).addToTop((Component)new JBLabel(text2));
    }

    public boolean editSelectedDependency(JBList dependenciesList) {
        DependencyOnPlugin selected2 = (DependencyOnPlugin)dependenciesList.getSelectedValue();
        if (selected2 != null) {
            this.replaceDependency(selected2, dependenciesList);
            return true;
        }
        return false;
    }

    private void replaceDependency(DependencyOnPlugin original, JBList dependenciesList) {
        DependencyOnPlugin dependency = this.editPluginDependency((JComponent)dependenciesList, original);
        if (dependency != null) {
            for (ProjectExternalDependency dependency1 : new ArrayList(this.myListModel.getItems())) {
                if (!(dependency1 instanceof DependencyOnPlugin) || !((DependencyOnPlugin)dependency1).getPluginId().equals(dependency.getPluginId())) continue;
                this.myListModel.remove((Object)dependency1);
            }
            this.myListModel.add((Object)dependency);
            dependenciesList.setSelectedValue((Object)dependency, true);
        }
    }

    @NlsContexts.ListItem
    private String getPluginNameById(@NotNull @NlsSafe String pluginId) {
        if (pluginId == null) {
            ExternalDependenciesConfigurable.$$$reportNull$$$0(0);
        }
        return (String)ObjectUtils.notNull((Object)this.getPluginNameByIdMap().get(pluginId), (Object)pluginId);
    }

    private Map<String, @NlsContexts.ListItem String> getPluginNameByIdMap() {
        if (this.myPluginNameById == null) {
            this.myPluginNameById = new HashMap<String, String>();
            for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
                String idString = descriptor2.getPluginId().getIdString();
                String name = "com.intellij".equals(idString) ? "IDE Core" : descriptor2.getName();
                this.myPluginNameById.put(idString, name);
            }
        }
        return this.myPluginNameById;
    }

    @NotNull
    public String getId() {
        return "preferences.externalDependencies";
    }

    @Nullable
    private DependencyOnPlugin editPluginDependency(@NotNull JComponent parent, @NotNull DependencyOnPlugin original) {
        if (parent == null) {
            ExternalDependenciesConfigurable.$$$reportNull$$$0(1);
        }
        if (original == null) {
            ExternalDependenciesConfigurable.$$$reportNull$$$0(2);
        }
        ArrayList<String> pluginIds2 = new ArrayList<String>(this.getPluginNameByIdMap().keySet());
        if (!original.getPluginId().isEmpty() && !pluginIds2.contains(original.getPluginId())) {
            pluginIds2.add(original.getPluginId());
        }
        pluginIds2.sort((o1, o2) -> this.getPluginNameById((String)o1).compareToIgnoreCase(this.getPluginNameById((String)o2)));
        final ComboBox pluginChooser = new ComboBox((Object[])ArrayUtilRt.toStringArray(pluginIds2), 250);
        pluginChooser.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", this::getPluginNameById));
        new ComboboxSpeedSearch((JComboBox)pluginChooser){

            @Override
            protected String getElementText(Object element2) {
                return ExternalDependenciesConfigurable.this.getPluginNameById((String)element2);
            }
        };
        pluginChooser.setSelectedItem((Object)original.getPluginId());
        JBTextField minVersionField = new JBTextField(StringUtil.notNullize((String)original.getMinVersion()));
        JBTextField maxVersionField = new JBTextField(StringUtil.notNullize((String)original.getMaxVersion()));
        minVersionField.getEmptyText().setText(IdeBundle.message((String)"label.version.any", (Object[])new Object[0]));
        minVersionField.setColumns(10);
        maxVersionField.getEmptyText().setText(IdeBundle.message((String)"label.version.any", (Object[])new Object[0]));
        maxVersionField.setColumns(10);
        JPanel panel2 = FormBuilder.createFormBuilder().addLabeledComponent(IdeBundle.message((String)"label.plugin", (Object[])new Object[0]), (JComponent)pluginChooser).addLabeledComponent(IdeBundle.message((String)"label.minimum.version", (Object[])new Object[0]), (JComponent)minVersionField).addLabeledComponent(IdeBundle.message((String)"label.maximum.version", (Object[])new Object[0]), (JComponent)maxVersionField).getPanel();
        final DialogBuilder dialogBuilder = new DialogBuilder((Component)parent).title(IdeBundle.message((String)"dialog.title.required.plugin", (Object[])new Object[0])).centerPanel((JComponent)panel2);
        dialogBuilder.setPreferredFocusComponent((JComponent)pluginChooser);
        pluginChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialogBuilder.setOkActionEnabled(!StringUtil.isEmpty((String)((String)pluginChooser.getSelectedItem())));
            }
        });
        dialogBuilder.setHelpId("Required_Plugin");
        if (dialogBuilder.show() == 0) {
            return new DependencyOnPlugin((String)pluginChooser.getSelectedItem(), StringUtil.nullize((String)minVersionField.getText().trim()), StringUtil.nullize((String)maxVersionField.getText().trim()));
        }
        return null;
    }

    @Nullable
    public String getHelpTopic() {
        return "Required_Plugin";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        objectArray2[1] = "com/intellij/externalDependencies/impl/ExternalDependenciesConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPluginNameById";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "editPluginDependency";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

