/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl.target.proxy;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.LineSeparator;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

public class WslProxy {
    private static final Logger LOG = Logger.getInstance(WslProxy.class);
    private static final String PROXY_NAME = "wsl2_proxy.py";

    @NotNull
    public static File createPyFile() throws IOException {
        VirtualFile file2 = WslProxy.findWslProxyFile();
        String content2 = VfsUtilCore.loadText((VirtualFile)file2);
        File tempFile = FileUtil.createTempFile((String)"intellij-wsl-proxy", (String)".py");
        FileUtil.writeToFile((File)tempFile, (String)StringUtil.join((String[])new String[]{content2, LineSeparator.LF.getSeparatorString()}));
        File file3 = tempFile;
        if (file3 == null) {
            WslProxy.$$$reportNull$$$0(0);
        }
        return file3;
    }

    @NotNull
    private static VirtualFile findWslProxyFile() throws IOException {
        URL url = WslProxy.class.getResource(PROXY_NAME);
        if (url == null) {
            throw new IOException("Possibly broken installation: cannot find wsl2_proxy.py");
        }
        String fileUrl = VfsUtilCore.convertFromUrl((URL)url);
        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(fileUrl);
        if (file2 != null && file2.isValid()) {
            VirtualFile virtualFile = file2;
            if (virtualFile == null) {
                WslProxy.$$$reportNull$$$0(1);
            }
            return virtualFile;
        }
        LOG.info("Cannot find virtual file for " + fileUrl + ", refreshing");
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    WslProxy.refreshByUrl(fileUrl);
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            });
            throw new IOException("Cannot refresh " + fileUrl + " under read action");
        }
        VirtualFile virtualFile = file2 = WslProxy.refreshByUrl(fileUrl);
        if (virtualFile == null) {
            WslProxy.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    @NotNull
    private static VirtualFile refreshByUrl(@NotNull String fileUrl) throws IOException {
        VirtualFile file2;
        if (fileUrl == null) {
            WslProxy.$$$reportNull$$$0(3);
        }
        if ((file2 = VirtualFileManager.getInstance().refreshAndFindFileByUrl(fileUrl)) == null || !file2.isValid()) {
            throw new IOException("Possibly broken installation: cannot find " + fileUrl + " after refresh");
        }
        VirtualFile virtualFile = file2;
        if (virtualFile == null) {
            WslProxy.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/wsl/target/proxy/WslProxy";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createPyFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findWslProxyFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/wsl/target/proxy/WslProxy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshByUrl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refreshByUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

