/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl.target;

import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentFactory;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.execution.wsl.target.WslTargetConfigurable;
import com.intellij.execution.wsl.target.WslTargetEnvironmentConfiguration;
import com.intellij.execution.wsl.target.WslTargetEnvironmentFactory;
import com.intellij.execution.wsl.target.wizard.WslTargetIntrospectionStep;
import com.intellij.execution.wsl.target.wizard.WslTargetLanguageStep;
import com.intellij.execution.wsl.target.wizard.WslTargetStepBase;
import com.intellij.execution.wsl.target.wizard.WslTargetWizardModel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0003J0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\f\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0002H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0010\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J,\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u00022\f\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012H\u0016J\u0010\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u001e\u0010!\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006#"}, d2={"Lcom/intellij/execution/wsl/target/WslTargetType;", "Lcom/intellij/execution/target/TargetEnvironmentType;", "Lcom/intellij/execution/wsl/target/WslTargetEnvironmentConfiguration;", "()V", "displayName", "", "getDisplayName", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "createConfigurable", "Lcom/intellij/execution/wsl/target/WslTargetConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "config", "defaultLanguage", "Lcom/intellij/execution/target/LanguageRuntimeType;", "parentConfigurable", "Lcom/intellij/openapi/options/Configurable;", "createDefaultConfig", "createEnvironmentFactory", "Lcom/intellij/execution/target/TargetEnvironmentFactory;", "createSerializer", "createStepsForNewWizard", "", "Lcom/intellij/ide/wizard/AbstractWizardStepEx;", "configToConfigure", "runtimeType", "duplicateConfig", "isSystemCompatible", "", "providesNewWizard", "Companion", "intellij.platform.execution.impl"})
public final class WslTargetType
extends TargetEnvironmentType<WslTargetEnvironmentConfiguration> {
    @NotNull
    private final Icon icon;
    @NotNull
    public static final String TYPE_ID = "wsl";
    @NlsSafe
    @NotNull
    public static final String DISPLAY_NAME = "WSL";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean isSystemCompatible() {
        return SystemInfo.isWin10OrNewer;
    }

    @NlsSafe
    @NotNull
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @NotNull
    public WslTargetEnvironmentConfiguration createSerializer(@NotNull WslTargetEnvironmentConfiguration config2) {
        Intrinsics.checkNotNullParameter((Object)((Object)config2), (String)"config");
        return config2;
    }

    @NotNull
    public WslTargetEnvironmentConfiguration createDefaultConfig() {
        return new WslTargetEnvironmentConfiguration();
    }

    public boolean providesNewWizard(@NotNull Project project, @Nullable LanguageRuntimeType<?> runtimeType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return true;
    }

    @NotNull
    public List<AbstractWizardStepEx> createStepsForNewWizard(@NotNull Project project, @NotNull WslTargetEnvironmentConfiguration configToConfigure, @Nullable LanguageRuntimeType<?> runtimeType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)configToConfigure), (String)"configToConfigure");
        WslTargetWizardModel model2 = new WslTargetWizardModel(project, configToConfigure, runtimeType, null);
        return CollectionsKt.listOf((Object[])new WslTargetStepBase[]{new WslTargetIntrospectionStep(model2), new WslTargetLanguageStep(model2)});
    }

    @NotNull
    public TargetEnvironmentFactory createEnvironmentFactory(@NotNull Project project, @NotNull WslTargetEnvironmentConfiguration config2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)config2), (String)"config");
        return new WslTargetEnvironmentFactory(config2);
    }

    @NotNull
    public WslTargetConfigurable createConfigurable(@NotNull Project project, @NotNull WslTargetEnvironmentConfiguration config2, @Nullable LanguageRuntimeType<?> defaultLanguage, @Nullable Configurable parentConfigurable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)config2), (String)"config");
        return new WslTargetConfigurable(config2, project);
    }

    @NotNull
    public WslTargetEnvironmentConfiguration duplicateConfig(@NotNull WslTargetEnvironmentConfiguration config2) {
        Intrinsics.checkNotNullParameter((Object)((Object)config2), (String)"config");
        return (WslTargetEnvironmentConfiguration)TargetEnvironmentType.Companion.duplicateTargetConfiguration((TargetEnvironmentType)this, (TargetEnvironmentConfiguration)config2);
    }

    public WslTargetType() {
        super(TYPE_ID);
        Icon icon2 = AllIcons.RunConfigurations.Wsl;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AllIcons.RunConfigurations.Wsl");
        this.icon = icon2;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/execution/wsl/target/WslTargetType$Companion;", "", "()V", "DISPLAY_NAME", "", "TYPE_ID", "intellij.platform.execution.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

