/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl.target;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.TaskExecutor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessWaitFor;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.target.SimpleProxy;
import com.intellij.execution.wsl.target.proxy.WslProxy;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WslTargetLocalPortBindingsSession {
    private static final Logger LOG = Logger.getInstance(WslTargetLocalPortBindingsSession.class);
    private final WSLDistribution myDistribution;
    private final List<BindingSession> mySessions;
    private final boolean myWsl1;
    private static final String PREFIX = "IntelliJ WSL proxy is listening on port ";

    public WslTargetLocalPortBindingsSession(@NotNull WSLDistribution distribution2, @NotNull Collection<TargetEnvironment.LocalPortBinding> localPortBindings) {
        if (distribution2 == null) {
            WslTargetLocalPortBindingsSession.$$$reportNull$$$0(0);
        }
        if (localPortBindings == null) {
            WslTargetLocalPortBindingsSession.$$$reportNull$$$0(1);
        }
        this.myDistribution = distribution2;
        this.mySessions = ContainerUtil.map(localPortBindings, binding -> new BindingSession((TargetEnvironment.LocalPortBinding)binding));
        this.myWsl1 = WSLUtil.isWsl1(this.myDistribution) == ThreeState.YES;
    }

    @NotNull
    public CompletableFuture<Integer> getTargetPortFuture(@NotNull TargetEnvironment.LocalPortBinding localPortBinding) {
        if (localPortBinding == null) {
            WslTargetLocalPortBindingsSession.$$$reportNull$$$0(2);
        }
        if (this.myWsl1) {
            CompletableFuture<Integer> completableFuture = CompletableFuture.completedFuture(localPortBinding.getLocal());
            if (completableFuture == null) {
                WslTargetLocalPortBindingsSession.$$$reportNull$$$0(3);
            }
            return completableFuture;
        }
        BindingSession session2 = Objects.requireNonNull((BindingSession)ContainerUtil.find(this.mySessions, s -> s.myPortBinding.equals((Object)localPortBinding)));
        CompletableFuture<Integer> completableFuture = session2.getTargetPortFuture();
        if (completableFuture == null) {
            WslTargetLocalPortBindingsSession.$$$reportNull$$$0(4);
        }
        return completableFuture;
    }

    public void start() {
        if (this.myWsl1) {
            return;
        }
        for (BindingSession session2 : this.mySessions) {
            HostPort hostAddr = session2.startProxyOnHostIp();
            if (hostAddr == null) {
                hostAddr = new HostPort(this.myDistribution.getHostIp(), session2.myPortBinding.getLocal());
            }
            session2.startProxyOnWsl(hostAddr);
        }
    }

    public void stopWhenProcessTerminated(@NotNull Process process2) {
        if (process2 == null) {
            WslTargetLocalPortBindingsSession.$$$reportNull$$$0(5);
        }
        if (this.mySessions.isEmpty()) {
            return;
        }
        TaskExecutor executor = new TaskExecutor(){

            @NotNull
            public Future<?> executeTask(@NotNull Runnable task2) {
                if (task2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                Future future2 = ApplicationManager.getApplication().executeOnPooledThread(task2);
                if (future2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return future2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "task";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/execution/wsl/target/WslTargetLocalPortBindingsSession$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/execution/wsl/target/WslTargetLocalPortBindingsSession$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "executeTask";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "executeTask";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        new ProcessWaitFor(process2, executor, "Cleanup WSL local port binding").setTerminationCallback(exitCode -> {
            for (BindingSession session2 : this.mySessions) {
                session2.stop();
            }
        });
    }

    private static int parsePort(@NotNull String text2) {
        int nextTextInd;
        int startInd;
        if (text2 == null) {
            WslTargetLocalPortBindingsSession.$$$reportNull$$$0(6);
        }
        if ((startInd = text2.indexOf(PREFIX)) >= 0 && (nextTextInd = text2.indexOf(", ready for connections", startInd)) >= 0) {
            String port = text2.substring(startInd + PREFIX.length(), nextTextInd);
            return StringUtil.parseInt((String)port, (int)-1);
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPortBindings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPortBinding";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/wsl/target/WslTargetLocalPortBindingsSession";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/wsl/target/WslTargetLocalPortBindingsSession";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPortFuture";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTargetPortFuture";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "stopWhenProcessTerminated";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parsePort";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class BindingSession {
        private final TargetEnvironment.LocalPortBinding myPortBinding;
        private SimpleProxy myHostProxy;
        private File myWslProxyPyFile;
        private KillableProcessHandler myWslProxyProcess;
        private final CompletableFuture<Integer> myTargetPortFuture = new CompletableFuture();

        private BindingSession(TargetEnvironment.LocalPortBinding portBinding) {
            this.myPortBinding = portBinding;
        }

        @Nullable
        public HostPort startProxyOnHostIp() {
            String hostIp = WslTargetLocalPortBindingsSession.this.myDistribution.getHostIp();
            try {
                this.myHostProxy = new SimpleProxy(hostIp, new HostPort("127.0.0.1", this.myPortBinding.getLocal()));
                return new HostPort(hostIp, this.myHostProxy.getListenPort());
            }
            catch (IOException e) {
                LOG.info("Cannot start local proxy", (Throwable)e);
                return null;
            }
        }

        public void startProxyOnWsl(@NotNull HostPort remoteAddr) {
            if (remoteAddr == null) {
                BindingSession.$$$reportNull$$$0(0);
            }
            String host = remoteAddr.getHost();
            int port = remoteAddr.getPort();
            try {
                this.myWslProxyPyFile = WslProxy.createPyFile();
            }
            catch (IOException e) {
                LOG.info("Cannot create wsl proxy file", (Throwable)e);
                return;
            }
            String scriptPath = WslTargetLocalPortBindingsSession.this.myDistribution.getWslPath(this.myWslProxyPyFile.getAbsolutePath());
            if (scriptPath == null) {
                return;
            }
            try {
                GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{"/usr/bin/python3", scriptPath, "127.0.0.1", host, String.valueOf(port)});
                WslTargetLocalPortBindingsSession.this.myDistribution.patchCommandLine(commandLine, null, new WSLCommandLineOptions().setExecuteCommandInShell(false));
                this.myWslProxyProcess = new KillableProcessHandler(commandLine);
                final StringBuilder output2 = new StringBuilder();
                this.myWslProxyProcess.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (outputType == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (ProcessOutputType.isStdout((Key)outputType)) {
                            output2.append(event.getText());
                            int port = WslTargetLocalPortBindingsSession.parsePort(output2.toString());
                            if (port >= 0) {
                                BindingSession.this.myTargetPortFuture.complete(port);
                            }
                        }
                        LOG.info("wsl2_proxy.py: " + StringUtil.trimEnd((String)event.getText(), (String)LineSeparator.LF.getSeparatorString()));
                    }

                    public void processTerminated(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        LOG.info("wsl2_proxy.py: terminated with " + event.getExitCode());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "event";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "outputType";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/execution/wsl/target/WslTargetLocalPortBindingsSession$BindingSession$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onTextAvailable";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processTerminated";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                this.myWslProxyProcess.startNotify();
            }
            catch (ExecutionException e) {
                LOG.info("Cannot run proxy in WSL " + WslTargetLocalPortBindingsSession.this.myDistribution.getMsId(), (Throwable)e);
            }
        }

        public void stop() {
            if (this.myWslProxyProcess != null) {
                ScriptRunnerUtil.terminateProcessHandler((ProcessHandler)this.myWslProxyProcess, 1000L, null);
            }
            if (this.myWslProxyPyFile != null) {
                FileUtil.delete((File)this.myWslProxyPyFile);
            }
            if (this.myHostProxy != null) {
                this.myHostProxy.stop();
            }
        }

        @NotNull
        public CompletableFuture<Integer> getTargetPortFuture() {
            CompletableFuture<Integer> completableFuture = this.myTargetPortFuture;
            if (completableFuture == null) {
                BindingSession.$$$reportNull$$$0(1);
            }
            return completableFuture;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remoteAddr";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/wsl/target/WslTargetLocalPortBindingsSession$BindingSession";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/wsl/target/WslTargetLocalPortBindingsSession$BindingSession";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetPortFuture";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "startProxyOnWsl";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

