/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl.target;

import com.intellij.execution.Platform;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfileState;
import com.intellij.execution.target.TargetEnvironmentFactory;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.target.WslTargetEnvironment;
import com.intellij.execution.wsl.target.WslTargetEnvironmentConfiguration;
import com.intellij.execution.wsl.target.WslTargetEnvironmentRequest;
import com.intellij.ide.IdeBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/execution/wsl/target/WslTargetEnvironmentFactory;", "Lcom/intellij/execution/target/TargetEnvironmentFactory;", "myConfig", "Lcom/intellij/execution/wsl/target/WslTargetEnvironmentConfiguration;", "(Lcom/intellij/execution/wsl/target/WslTargetEnvironmentConfiguration;)V", "createRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "getTargetConfiguration", "getTargetPlatform", "Lcom/intellij/execution/target/TargetPlatform;", "prepareRemoteEnvironment", "Lcom/intellij/execution/target/TargetEnvironment;", "request", "targetProgressIndicator", "Lcom/intellij/execution/target/TargetEnvironmentAwareRunProfileState$TargetProgressIndicator;", "intellij.platform.execution.impl"})
public final class WslTargetEnvironmentFactory
implements TargetEnvironmentFactory {
    private final WslTargetEnvironmentConfiguration myConfig;

    @NotNull
    public WslTargetEnvironmentConfiguration getTargetConfiguration() {
        return this.myConfig;
    }

    @NotNull
    public TargetPlatform getTargetPlatform() {
        return new TargetPlatform(Platform.UNIX);
    }

    @NotNull
    public TargetEnvironmentRequest createRequest() {
        return (TargetEnvironmentRequest)new WslTargetEnvironmentRequest(this.myConfig);
    }

    @NotNull
    public TargetEnvironment prepareRemoteEnvironment(@NotNull TargetEnvironmentRequest request, @NotNull TargetEnvironmentAwareRunProfileState.TargetProgressIndicator targetProgressIndicator2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)targetProgressIndicator2, (String)"targetProgressIndicator");
        WslTargetEnvironmentRequest wslRequest = (WslTargetEnvironmentRequest)request;
        WSLDistribution distribution2 = wslRequest.getConfig().getDistribution();
        if (distribution2 == null) {
            String string = IdeBundle.message((String)"wsl.no.distribution.found.error", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"wsl.n\u2026istribution.found.error\")");
            String string2 = string;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return new WslTargetEnvironment(wslRequest, distribution2);
    }

    public WslTargetEnvironmentFactory(@NotNull WslTargetEnvironmentConfiguration myConfig) {
        Intrinsics.checkNotNullParameter((Object)((Object)myConfig), (String)"myConfig");
        this.myConfig = myConfig;
    }
}

