/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl.target;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfileState;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.target.WslTargetEnvironmentRequest;
import com.intellij.execution.wsl.target.WslTargetLocalPortBindingsSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 02\u00020\u0001:\u000201B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020%H\u0002J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020.H\u0016J\u0012\u0010/\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020%H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR \u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\fR \u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\f\u00a8\u00062"}, d2={"Lcom/intellij/execution/wsl/target/WslTargetEnvironment;", "Lcom/intellij/execution/target/TargetEnvironment;", "wslRequest", "Lcom/intellij/execution/wsl/target/WslTargetEnvironmentRequest;", "distribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "(Lcom/intellij/execution/wsl/target/WslTargetEnvironmentRequest;Lcom/intellij/execution/wsl/WSLDistribution;)V", "downloadVolumes", "", "Lcom/intellij/execution/target/TargetEnvironment$DownloadRoot;", "Lcom/intellij/execution/target/TargetEnvironment$DownloadableVolume;", "getDownloadVolumes", "()Ljava/util/Map;", "localPortBindings", "Lcom/intellij/execution/target/TargetEnvironment$LocalPortBinding;", "Lcom/intellij/execution/target/HostPort;", "getLocalPortBindings", "localPortBindingsSession", "Lcom/intellij/execution/wsl/target/WslTargetLocalPortBindingsSession;", "myDownloadVolumes", "", "myLocalPortBindings", "myTargetPortBindings", "Lcom/intellij/execution/target/TargetEnvironment$TargetPortBinding;", "", "myUploadVolumes", "Lcom/intellij/execution/target/TargetEnvironment$UploadRoot;", "Lcom/intellij/execution/target/TargetEnvironment$UploadableVolume;", "targetPlatform", "Lcom/intellij/execution/target/TargetPlatform;", "getTargetPlatform", "()Lcom/intellij/execution/target/TargetPlatform;", "targetPortBindings", "getTargetPortBindings", "uploadVolumes", "getUploadVolumes", "convertUncPathToLinux", "", "localPath", "createProcess", "Ljava/lang/Process;", "commandLine", "Lcom/intellij/execution/target/TargetedCommandLine;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "shutdown", "", "toLinuxPath", "Companion", "Volume", "intellij.platform.execution.impl"})
public final class WslTargetEnvironment
extends TargetEnvironment {
    private final Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> myUploadVolumes;
    private final Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> myDownloadVolumes;
    private final Map<TargetEnvironment.TargetPortBinding, Integer> myTargetPortBindings;
    private final Map<TargetEnvironment.LocalPortBinding, HostPort> myLocalPortBindings;
    private final WslTargetLocalPortBindingsSession localPortBindingsSession;
    private final WSLDistribution distribution;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> getUploadVolumes() {
        Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> map2 = Collections.unmodifiableMap(this.myUploadVolumes);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"Collections.unmodifiableMap(myUploadVolumes)");
        return map2;
    }

    @NotNull
    public Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> getDownloadVolumes() {
        Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> map2 = Collections.unmodifiableMap(this.myDownloadVolumes);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"Collections.unmodifiableMap(myDownloadVolumes)");
        return map2;
    }

    @NotNull
    public Map<TargetEnvironment.TargetPortBinding, Integer> getTargetPortBindings() {
        Map<TargetEnvironment.TargetPortBinding, Integer> map2 = Collections.unmodifiableMap(this.myTargetPortBindings);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"Collections.unmodifiableMap(myTargetPortBindings)");
        return map2;
    }

    @NotNull
    public Map<TargetEnvironment.LocalPortBinding, HostPort> getLocalPortBindings() {
        Map<TargetEnvironment.LocalPortBinding, HostPort> map2 = Collections.unmodifiableMap(this.myLocalPortBindings);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"Collections.unmodifiableMap(myLocalPortBindings)");
        return map2;
    }

    @NotNull
    public TargetPlatform getTargetPlatform() {
        return new TargetPlatform(Platform.UNIX);
    }

    private final String toLinuxPath(String localPath) {
        String linuxPath = this.distribution.getWslPath(localPath);
        if (linuxPath != null) {
            return linuxPath;
        }
        return this.convertUncPathToLinux(localPath);
    }

    private final String convertUncPathToLinux(String localPath) {
        String root = "\\\\wsl$\\" + this.distribution.getMsId();
        String string = FileUtil.toSystemDependentName((String)localPath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.toSystemDependentName(localPath)");
        String winLocalPath = string;
        if (StringsKt.startsWith$default((String)winLocalPath, (String)root, (boolean)false, (int)2, null)) {
            CharSequence charSequence = winLocalPath;
            int n = root.length();
            boolean bl = false;
            String string2 = charSequence;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String linuxPath = string3;
            charSequence = linuxPath;
            n = 0;
            if (charSequence.length() == 0) {
                return "/";
            }
            if (StringsKt.startsWith$default((String)linuxPath, (String)"\\", (boolean)false, (int)2, null)) {
                return FileUtil.toSystemIndependentName((String)linuxPath);
            }
        }
        return null;
    }

    @NotNull
    public Process createProcess(@NotNull TargetedCommandLine commandLine, @NotNull ProgressIndicator indicator) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        GeneralCommandLine line = new GeneralCommandLine(commandLine.collectCommandsSynchronously());
        Map map2 = line.getEnvironment();
        Map map3 = commandLine.getEnvironmentVariables();
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"commandLine.environmentVariables");
        map2.putAll(map3);
        WSLCommandLineOptions wSLCommandLineOptions = new WSLCommandLineOptions().setRemoteWorkingDirectory(commandLine.getWorkingDirectory());
        Intrinsics.checkNotNullExpressionValue((Object)wSLCommandLineOptions, (String)"WSLCommandLineOptions().\u2026andLine.workingDirectory)");
        WSLCommandLineOptions options2 = wSLCommandLineOptions;
        GeneralCommandLine generalCommandLine = this.distribution.patchCommandLine(line, null, options2);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"distribution.patchCommandLine(line, null, options)");
        line = generalCommandLine;
        Process process2 = line.createProcess();
        Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"line.createProcess()");
        Process process3 = process2;
        this.localPortBindingsSession.stopWhenProcessTerminated(process3);
        return process3;
    }

    public void shutdown() {
    }

    public WslTargetEnvironment(@NotNull WslTargetEnvironmentRequest wslRequest, @NotNull WSLDistribution distribution2) {
        Intrinsics.checkNotNullParameter((Object)((Object)wslRequest), (String)"wslRequest");
        Intrinsics.checkNotNullParameter((Object)distribution2, (String)"distribution");
        super((TargetEnvironmentRequest)wslRequest);
        this.distribution = distribution2;
        this.myUploadVolumes = new HashMap();
        this.myDownloadVolumes = new HashMap();
        this.myTargetPortBindings = new HashMap();
        this.myLocalPortBindings = new HashMap();
        for (TargetEnvironment.UploadRoot uploadRoot : wslRequest.getUploadVolumes()) {
            String targetRoot = this.toLinuxPath(((Object)uploadRoot.getLocalRootPath().toAbsolutePath()).toString());
            if (targetRoot == null) continue;
            this.myUploadVolumes.put(uploadRoot, new Volume(uploadRoot.getLocalRootPath(), targetRoot));
        }
        for (TargetEnvironment.DownloadRoot downloadRoot : wslRequest.getDownloadVolumes()) {
            Path localRootPath;
            String targetRoot;
            Path path = downloadRoot.getLocalRootPath();
            if (path == null) {
                path = FileUtil.createTempDirectory((String)"intellij-target.", (String)"").toPath();
            }
            if ((targetRoot = this.toLinuxPath(((Object)(localRootPath = path).toAbsolutePath()).toString())) == null) continue;
            Path path2 = localRootPath;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"localRootPath");
            this.myDownloadVolumes.put(downloadRoot, new Volume(path2, targetRoot));
        }
        for (TargetEnvironment.TargetPortBinding targetPortBinding : wslRequest.getTargetPortBindings()) {
            int theOnlyPort = targetPortBinding.getTarget();
            if (targetPortBinding.getLocal() != null) {
                Integer n = targetPortBinding.getLocal();
                if (n == null || n != theOnlyPort) {
                    throw (Throwable)new UnsupportedOperationException("Local target's TCP port forwarder is not implemented");
                }
            }
            this.myTargetPortBindings.put(targetPortBinding, theOnlyPort);
        }
        this.localPortBindingsSession = new WslTargetLocalPortBindingsSession(this.distribution, wslRequest.getLocalPortBindings());
        this.localPortBindingsSession.start();
        for (TargetEnvironment.LocalPortBinding localPortBinding : wslRequest.getLocalPortBindings()) {
            Intrinsics.checkNotNullExpressionValue(this.localPortBindingsSession.getTargetPortFuture(localPortBinding), (String)"localPortBindingsSession\u2026tFuture(localPortBinding)");
            int targetPort = localPortBinding.getLocal();
            try {
                CompletableFuture<Integer> targetPortFuture;
                Integer n = targetPortFuture.get(10L, TimeUnit.SECONDS);
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"targetPortFuture.get(10, TimeUnit.SECONDS)");
                targetPort = ((Number)n).intValue();
            }
            catch (Exception e) {
                LOG.info("Cannot get target port for " + localPortBinding);
            }
            String string = this.distribution.getHostIp();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"distribution.hostIp");
            this.myLocalPortBindings.put(localPortBinding, new HostPort(string, targetPort));
        }
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WslTargetEnvironment.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/execution/wsl/target/WslTargetEnvironment$Volume;", "Lcom/intellij/execution/target/TargetEnvironment$UploadableVolume;", "Lcom/intellij/execution/target/TargetEnvironment$DownloadableVolume;", "localRoot", "Ljava/nio/file/Path;", "targetRoot", "", "(Lcom/intellij/execution/wsl/target/WslTargetEnvironment;Ljava/nio/file/Path;Ljava/lang/String;)V", "getLocalRoot", "()Ljava/nio/file/Path;", "getTargetRoot", "()Ljava/lang/String;", "download", "", "relativePath", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "resolveTargetPath", "upload", "targetProgressIndicator", "Lcom/intellij/execution/target/TargetEnvironmentAwareRunProfileState$TargetProgressIndicator;", "intellij.platform.execution.impl"})
    private final class Volume
    implements TargetEnvironment.UploadableVolume,
    TargetEnvironment.DownloadableVolume {
        @NotNull
        private final Path localRoot;
        @NotNull
        private final String targetRoot;

        @NotNull
        public String resolveTargetPath(@NotNull String relativePath) throws IOException {
            String localPath;
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            String string = localPath = FileUtil.toCanonicalPath((String)FileUtil.join((String[])new String[]{((Object)this.getLocalRoot()).toString(), relativePath}));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"localPath");
            String string2 = WslTargetEnvironment.this.toLinuxPath(string);
            Intrinsics.checkNotNull((Object)string2);
            return string2;
        }

        public void upload(@NotNull String relativePath, @NotNull TargetEnvironmentAwareRunProfileState.TargetProgressIndicator targetProgressIndicator2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            Intrinsics.checkNotNullParameter((Object)targetProgressIndicator2, (String)"targetProgressIndicator");
        }

        public void download(@NotNull String relativePath, @NotNull ProgressIndicator progressIndicator) throws IOException {
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
            Path path = this.getLocalRoot().resolve(relativePath);
            long previousSize = -1L;
            Path path2 = path;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
            long newSize = PathKt.size((Path)path2);
            while (previousSize < newSize) {
                Thread.sleep(100L);
                previousSize = newSize;
                newSize = PathKt.size((Path)path);
            }
        }

        @NotNull
        public Path getLocalRoot() {
            return this.localRoot;
        }

        @NotNull
        public String getTargetRoot() {
            return this.targetRoot;
        }

        public Volume(@NotNull Path localRoot, String targetRoot) {
            Intrinsics.checkNotNullParameter((Object)localRoot, (String)"localRoot");
            Intrinsics.checkNotNullParameter((Object)targetRoot, (String)"targetRoot");
            this.localRoot = localRoot;
            this.targetRoot = targetRoot;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/execution/wsl/target/WslTargetEnvironment$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.execution.impl"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

