/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl.target;

import com.intellij.execution.target.HostPort;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

final class SimpleProxy {
    private static final Logger LOG = Logger.getInstance(SimpleProxy.class);
    private static final AtomicInteger ourClientId = new AtomicInteger();
    private final String myListenHostName;
    private final HostPort myRemoteHostPort;
    private ServerSocket myServerSocket;

    SimpleProxy(@NotNull String listenHostName, @NotNull HostPort remoteHostPort) throws IOException {
        if (listenHostName == null) {
            SimpleProxy.$$$reportNull$$$0(0);
        }
        if (remoteHostPort == null) {
            SimpleProxy.$$$reportNull$$$0(1);
        }
        this.myListenHostName = listenHostName;
        this.myRemoteHostPort = remoteHostPort;
        this.start();
    }

    private void start() throws IOException {
        ServerSocket serverSocket;
        this.myServerSocket = serverSocket = new ServerSocket(0, 0, InetAddress.getByName(this.myListenHostName));
        LOG.info("Proxy is listening on " + this.getListenAddr() + " -> " + this.getRemoteAddr());
        SimpleProxy.executeOnPooledThread(() -> {
            while (!serverSocket.isClosed()) {
                try {
                    Socket client;
                    try {
                        client = serverSocket.accept();
                    }
                    catch (IOException e) {
                        if (!this.myServerSocket.isClosed()) {
                            throw e;
                        }
                        return;
                    }
                    SimpleProxy.executeOnPooledThread(() -> this.processClientAndClose(client));
                }
                catch (IOException e) {
                    LOG.info("Cannot accept socket", (Throwable)e);
                }
            }
        });
    }

    @NotNull
    private String getListenAddr() {
        String string = this.myListenHostName + ":" + this.myServerSocket.getLocalPort();
        if (string == null) {
            SimpleProxy.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private String getRemoteAddr() {
        String string = this.myRemoteHostPort.getHost() + ":" + this.myRemoteHostPort.getPort();
        if (string == null) {
            SimpleProxy.$$$reportNull$$$0(3);
        }
        return string;
    }

    private void processClientAndClose(@NotNull Socket client) {
        OutputStream remoteOutputStream;
        InputStream remoteInputStream;
        Socket remote;
        OutputStream clientOutputStream;
        InputStream clientInputStream;
        if (client == null) {
            SimpleProxy.$$$reportNull$$$0(4);
        }
        String prefix = "#" + ourClientId.incrementAndGet() + ": ";
        LOG.info(prefix + "client connected from " + client.getInetAddress() + ":" + client.getPort());
        try {
            clientInputStream = client.getInputStream();
            clientOutputStream = client.getOutputStream();
        }
        catch (IOException e) {
            LOG.info(prefix + "cannot open streams", (Throwable)e);
            return;
        }
        try {
            remote = new Socket(this.myRemoteHostPort.getHost(), this.myRemoteHostPort.getPort());
        }
        catch (IOException e) {
            LOG.info(prefix + "cannot connect to " + this.myRemoteHostPort, (Throwable)e);
            SimpleProxy.close(client);
            return;
        }
        try {
            remoteInputStream = remote.getInputStream();
            remoteOutputStream = remote.getOutputStream();
        }
        catch (IOException e) {
            LOG.info(prefix + "cannot open streams", (Throwable)e);
            return;
        }
        CompletableFuture<?> clientToRemote = SimpleProxy.copyStreamAsync(clientInputStream, remoteOutputStream, prefix + "client -> remote: ");
        CompletableFuture<?> remoteToClient = SimpleProxy.copyStreamAsync(remoteInputStream, clientOutputStream, prefix + "remote -> client: ");
        clientToRemote.whenComplete((o1, throwable1) -> remoteToClient.whenComplete((o2, throwable2) -> {
            SimpleProxy.close(clientInputStream);
            SimpleProxy.close(remoteInputStream);
            SimpleProxy.close(client);
        }));
    }

    public void stop() {
        if (!this.myServerSocket.isClosed()) {
            SimpleProxy.close(this.myServerSocket);
        }
    }

    public int getListenPort() {
        return this.myServerSocket.getLocalPort();
    }

    private static void close(@NotNull Closeable closeable) {
        if (closeable == null) {
            SimpleProxy.$$$reportNull$$$0(5);
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            LOG.info("Cannot close", (Throwable)e);
        }
    }

    @NotNull
    private static CompletableFuture<?> copyStreamAsync(@NotNull InputStream source, @NotNull OutputStream dest, @NotNull String description) {
        if (source == null) {
            SimpleProxy.$$$reportNull$$$0(6);
        }
        if (dest == null) {
            SimpleProxy.$$$reportNull$$$0(7);
        }
        if (description == null) {
            SimpleProxy.$$$reportNull$$$0(8);
        }
        return SimpleProxy.executeOnPooledThread(() -> {
            LOG.debug(description + "start copying");
            try {
                source.transferTo(dest);
            }
            catch (IOException iOException) {
            }
            finally {
                LOG.debug(description + "done");
                SimpleProxy.close(dest);
            }
        });
    }

    @NotNull
    private static CompletableFuture<?> executeOnPooledThread(@NotNull Runnable r) {
        if (r == null) {
            SimpleProxy.$$$reportNull$$$0(9);
        }
        CompletableFuture<Object> completableFuture = CompletableFuture.supplyAsync(() -> {
            r.run();
            return null;
        }, AppExecutorUtil.getAppExecutorService());
        if (completableFuture == null) {
            SimpleProxy.$$$reportNull$$$0(10);
        }
        return completableFuture;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listenHostName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteHostPort";
                break;
            }
            case 2: 
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/wsl/target/SimpleProxy";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closeable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/wsl/target/SimpleProxy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getListenAddr";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteAddr";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "executeOnPooledThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processClientAndClose";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "close";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyStreamAsync";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "executeOnPooledThread";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

