/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class WslDistributionManagerImpl
extends WslDistributionManager {
    private static final Set<String> INTERNAL_DISTRIBUTIONS = Set.of("docker-desktop-data", "docker-desktop");

    @Override
    @NotNull
    protected List<String> loadInstalledDistributionMsIds() {
        List list2;
        WslDistributionManagerImpl.checkEdtAndReadAction();
        if (!new WSLCommandLineOptions().isLaunchWithWslExe()) {
            List<String> list3 = Collections.emptyList();
            if (list3 == null) {
                WslDistributionManagerImpl.$$$reportNull$$$0(0);
            }
            return list3;
        }
        try {
            long startNano = System.nanoTime();
            Pair<GeneralCommandLine, List<String>> result2 = WslDistributionManagerImpl.doFetchDistributionsFromWslCli();
            LOG.info("Fetched WSL distributions: " + result2.second + " (\"" + ((GeneralCommandLine)result2.first).getCommandLineString() + "\" done in " + TimeoutUtil.getDurationMillis((long)startNano) + " ms)");
            list2 = (List)result2.second;
        }
        catch (IOException e) {
            LOG.info("Cannot parse WSL distributions", (Throwable)e);
            List<String> list4 = Collections.emptyList();
            if (list4 == null) {
                WslDistributionManagerImpl.$$$reportNull$$$0(2);
            }
            return list4;
        }
        if (list2 == null) {
            WslDistributionManagerImpl.$$$reportNull$$$0(1);
        }
        return list2;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private static Pair<GeneralCommandLine, List<String>> doFetchDistributionsFromWslCli() throws IOException {
        ProcessOutput output2;
        GeneralCommandLine commandLine = WslDistributionManagerImpl.createCommandLine();
        try {
            output2 = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine, (int)10000);
        }
        catch (ExecutionException e) {
            throw new IOException("Failed to run " + commandLine.getCommandLineString(), e);
        }
        if (output2.isTimeout() || output2.getExitCode() != 0 || !output2.getStderr().isEmpty()) {
            String details = StringUtil.join((Collection)ContainerUtil.newArrayList((Object[])new String[]{"timeout: " + output2.isTimeout(), "exitCode: " + output2.getExitCode(), "stdout: " + output2.getStdout(), "stderr: " + output2.getStderr()}), (String)", ");
            throw new IOException("Failed to run " + commandLine.getCommandLineString() + ": " + details);
        }
        @NlsSafe List msIds = ContainerUtil.filter((Collection)output2.getStdoutLines(true), distribution2 -> !INTERNAL_DISTRIBUTIONS.contains(distribution2));
        Pair pair = Pair.create((Object)commandLine, (Object)msIds);
        if (pair == null) {
            WslDistributionManagerImpl.$$$reportNull$$$0(3);
        }
        return pair;
    }

    @NotNull
    private static GeneralCommandLine createCommandLine() throws IOException {
        Path wslExe = WSLDistribution.findWslExe();
        if (wslExe == null) {
            throw new IOException("No wsl.exe found in %PATH%");
        }
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{wslExe.toString(), "--list", "--quiet"}).withCharset(StandardCharsets.UTF_16LE);
        if (generalCommandLine == null) {
            WslDistributionManagerImpl.$$$reportNull$$$0(4);
        }
        return generalCommandLine;
    }

    private static void checkEdtAndReadAction() {
        Application application = ApplicationManager.getApplication();
        if (application == null || !application.isInternal() || application.isHeadlessEnvironment()) {
            return;
        }
        if (application.isReadAccessAllowed()) {
            LOG.error("Please call WslDistributionManager.getInstalledDistributions on a background thread and not under read action as it runs a potentially long operation.");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/execution/wsl/WslDistributionManagerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "loadInstalledDistributionMsIds";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doFetchDistributionsFromWslCli";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

