/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.TObjectHashingStrategy;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WslDistributionManager
implements Disposable {
    static final Logger LOG = Logger.getInstance(WslDistributionManager.class);
    private static final Object LOCK = new Object();
    private volatile CachedDistributions myInstalledDistributions;
    private final Map<String, WSLDistribution> myMsIdToDistributionCache = ContainerUtil.createConcurrentWeakMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);

    @NotNull
    public static WslDistributionManager getInstance() {
        WslDistributionManager wslDistributionManager = (WslDistributionManager)ApplicationManager.getApplication().getService(WslDistributionManager.class);
        if (wslDistributionManager == null) {
            WslDistributionManager.$$$reportNull$$$0(0);
        }
        return wslDistributionManager;
    }

    public void dispose() {
        this.myMsIdToDistributionCache.clear();
        this.myInstalledDistributions = null;
    }

    @Nullable
    public List<WSLDistribution> getCachedInstalledDistributions() {
        return this.getInstalledDistributionsFuture().getNow(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<WSLDistribution> getInstalledDistributions() {
        CachedDistributions cachedDistributions = this.myInstalledDistributions;
        if (cachedDistributions != null && cachedDistributions.isUpToDate()) {
            List<WSLDistribution> list2 = cachedDistributions.myInstalledDistributions;
            if (list2 == null) {
                WslDistributionManager.$$$reportNull$$$0(1);
            }
            return list2;
        }
        this.myInstalledDistributions = null;
        Object object = LOCK;
        synchronized (object) {
            cachedDistributions = this.myInstalledDistributions;
            if (cachedDistributions == null) {
                this.myInstalledDistributions = cachedDistributions = new CachedDistributions(this.loadInstalledDistributions());
            }
        }
        List<WSLDistribution> list3 = cachedDistributions.myInstalledDistributions;
        if (list3 == null) {
            WslDistributionManager.$$$reportNull$$$0(2);
        }
        return list3;
    }

    @NotNull
    public CompletableFuture<List<WSLDistribution>> getInstalledDistributionsFuture() {
        CachedDistributions cachedDistributions = this.myInstalledDistributions;
        if (cachedDistributions != null && cachedDistributions.isUpToDate()) {
            CompletableFuture<List<WSLDistribution>> completableFuture = CompletableFuture.completedFuture(cachedDistributions.myInstalledDistributions);
            if (completableFuture == null) {
                WslDistributionManager.$$$reportNull$$$0(3);
            }
            return completableFuture;
        }
        CompletableFuture<List<WSLDistribution>> completableFuture = CompletableFuture.supplyAsync(this::getInstalledDistributions, AppExecutorUtil.getAppExecutorService());
        if (completableFuture == null) {
            WslDistributionManager.$$$reportNull$$$0(4);
        }
        return completableFuture;
    }

    @NotNull
    public WSLDistribution getOrCreateDistributionByMsId(@NonNls @NotNull String msId) {
        if (msId == null) {
            WslDistributionManager.$$$reportNull$$$0(5);
        }
        return this.getOrCreateDistributionByMsId(msId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private WSLDistribution getOrCreateDistributionByMsId(@NonNls @NotNull String msId, boolean overrideCaseInsensitively) {
        if (msId == null) {
            WslDistributionManager.$$$reportNull$$$0(6);
        }
        if (msId.isEmpty()) {
            throw new IllegalArgumentException("WSL msId is empty");
        }
        WSLDistribution d = this.myMsIdToDistributionCache.get(msId);
        if (d == null || overrideCaseInsensitively && !d.getMsId().equals(msId)) {
            Map<String, WSLDistribution> map2 = this.myMsIdToDistributionCache;
            synchronized (map2) {
                d = this.myMsIdToDistributionCache.get(msId);
                if (d == null || overrideCaseInsensitively && !d.getMsId().equals(msId)) {
                    d = new WSLDistribution(msId);
                    this.myMsIdToDistributionCache.put(msId, d);
                }
            }
        }
        WSLDistribution wSLDistribution = d;
        if (wSLDistribution == null) {
            WslDistributionManager.$$$reportNull$$$0(7);
        }
        return wSLDistribution;
    }

    public static boolean isWslPath(@NotNull String path) {
        if (path == null) {
            WslDistributionManager.$$$reportNull$$$0(8);
        }
        return FileUtil.toSystemDependentName((String)path).startsWith("\\\\wsl$\\");
    }

    @NotNull
    private List<WSLDistribution> loadInstalledDistributions() {
        List list2 = ContainerUtil.map(this.loadInstalledDistributionMsIds(), msId -> this.getOrCreateDistributionByMsId((String)msId, true));
        if (list2 == null) {
            WslDistributionManager.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @NotNull
    protected abstract List<String> loadInstalledDistributionMsIds();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/wsl/WslDistributionManager";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledDistributions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledDistributionsFuture";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/wsl/WslDistributionManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateDistributionByMsId";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "loadInstalledDistributions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateDistributionByMsId";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isWslPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CachedDistributions {
        @NotNull
        private final List<WSLDistribution> myInstalledDistributions;
        private final long myExternalChangesCount;

        private CachedDistributions(@NotNull List<WSLDistribution> installedDistributions) {
            if (installedDistributions == null) {
                CachedDistributions.$$$reportNull$$$0(0);
            }
            this.myInstalledDistributions = List.copyOf(installedDistributions);
            this.myExternalChangesCount = CachedDistributions.getCurrentExternalChangesCount();
        }

        public boolean isUpToDate() {
            return CachedDistributions.getCurrentExternalChangesCount() == this.myExternalChangesCount;
        }

        private static long getCurrentExternalChangesCount() {
            return SaveAndSyncHandler.getInstance().getExternalChangesTracker().getModificationCount();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installedDistributions", "com/intellij/execution/wsl/WslDistributionManager$CachedDistributions", "<init>"));
        }
    }
}

