/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="descriptor")
final class WslDistributionDescriptor {
    private static final int PROBE_TIMEOUT = SystemProperties.getIntProperty((String)"ide.wsl.probe.timeout", (int)60000);
    @Tag(value="id")
    @NlsSafe
    private String myId;
    @Tag(value="microsoft-id")
    @NlsSafe
    private String myMsId;
    @Tag(value="executable-path")
    @NlsSafe
    @Nullable
    private String myExecutablePath;
    @Tag(value="presentable-name")
    @NlsSafe
    private String myPresentableName;
    private final NotNullLazyValue<String> myMntRootProvider;
    private final NullableLazyValue<String> myUserHomeProvider;

    WslDistributionDescriptor() {
        this.myMntRootProvider = NotNullLazyValue.atomicLazy(this::computeMntRoot);
        this.myUserHomeProvider = AtomicNullableLazyValue.createValue(this::computeUserHome);
    }

    WslDistributionDescriptor(@NotNull String msId) {
        if (msId == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(0);
        }
        this(msId, msId, null, msId);
    }

    WslDistributionDescriptor(@NotNull String msId, @Nullable String executablePath, @NotNull String presentableName) {
        if (msId == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(1);
        }
        if (presentableName == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(2);
        }
        this(msId, msId, executablePath, presentableName);
    }

    WslDistributionDescriptor(@NotNull String id2, @NotNull String msId, @Nullable String executablePath, @NotNull String presentableName) {
        if (id2 == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(3);
        }
        if (msId == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(4);
        }
        if (presentableName == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(5);
        }
        this.myMntRootProvider = NotNullLazyValue.atomicLazy(this::computeMntRoot);
        this.myUserHomeProvider = AtomicNullableLazyValue.createValue(this::computeUserHome);
        this.myId = id2;
        this.myMsId = msId;
        this.myExecutablePath = executablePath;
        this.myPresentableName = presentableName;
    }

    @NotNull
    @NlsSafe
    public String getId() {
        String string = Objects.requireNonNull(this.myId);
        if (string == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getMsId() {
        String string = Objects.requireNonNull(this.myMsId);
        if (string == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    @NlsSafe
    public String getExecutablePath() {
        return this.myExecutablePath;
    }

    @NotNull
    @NlsSafe
    public String getPresentableName() {
        String string = Objects.requireNonNull(this.myPresentableName);
        if (string == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(8);
        }
        return string;
    }

    boolean isValid() {
        return StringUtil.isNotEmpty((String)this.myId) && StringUtil.isNotEmpty((String)this.myMsId) && StringUtil.isNotEmpty((String)this.myExecutablePath) && StringUtil.isNotEmpty((String)this.myPresentableName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WslDistributionDescriptor that = (WslDistributionDescriptor)o;
        return Objects.equals(this.getId(), that.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return "WslDistributionDescriptor{id='" + this.myId + "', msId='" + this.myMsId + "'}";
    }

    @NotNull
    @NlsSafe
    final String getMntRoot() {
        String string = (String)this.myMntRootProvider.getValue();
        if (string == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    @NlsSafe
    public final String getUserHome() {
        return (String)this.myUserHomeProvider.getValue();
    }

    @NotNull
    @NlsSafe
    private String computeMntRoot() {
        String windowsCurrentDirectory = System.getProperty("user.dir");
        if (StringUtil.isEmpty((String)windowsCurrentDirectory) || windowsCurrentDirectory.length() < 3) {
            WSLUtil.LOG.warn("Could not obtain current directory from user.dir (or path is too short): " + windowsCurrentDirectory);
            return "/mnt/";
        }
        WSLCommandLineOptions options2 = new WSLCommandLineOptions().setLaunchWithWslExe(true).setExecuteCommandInShell(false);
        String wslCurrentDirectory = this.readWslOutputLine(options2, List.of("pwd"));
        if (wslCurrentDirectory == null) {
            return "/mnt/";
        }
        String currentPathSuffix = WSLDistribution.convertWindowsPath(windowsCurrentDirectory);
        if (StringUtil.endsWithIgnoreCase((String)wslCurrentDirectory, (String)currentPathSuffix)) {
            String string = StringUtil.trimEnd((String)wslCurrentDirectory, (String)currentPathSuffix, (boolean)true);
            if (string == null) {
                WslDistributionDescriptor.$$$reportNull$$$0(10);
            }
            return string;
        }
        WSLUtil.LOG.warn("Wsl current directory does not ends with windows converted suffix: [pwd=" + wslCurrentDirectory + "; suffix=" + currentPathSuffix + "]");
        return "/mnt/";
    }

    @Nullable
    private String readWslOutputLine(WSLCommandLineOptions options2, List<String> command) {
        List<String> pwdOutputLines = this.readWSLOutput(options2, command);
        if (pwdOutputLines == null) {
            return null;
        }
        if (pwdOutputLines.size() != 1) {
            WSLUtil.LOG.warn("One line response expected: [id=" + this.getId() + "; stdout=" + pwdOutputLines + "]");
            return null;
        }
        return pwdOutputLines.get(0).trim();
    }

    @Nullable
    private List<String> readWSLOutput(WSLCommandLineOptions options2, List<String> command) {
        ProcessOutput output2;
        WSLDistribution distribution2 = WslDistributionManager.getInstance().getOrCreateDistributionByMsId(this.getId());
        try {
            output2 = distribution2.executeOnWsl(command, options2, PROBE_TIMEOUT, null);
        }
        catch (ExecutionException e) {
            WSLUtil.LOG.warn("Start failed on " + this.getId(), (Throwable)e);
            return null;
        }
        if (output2.getExitCode() != 0) {
            WSLUtil.LOG.info("Execution failed on " + this.getId() + " [exitCode=" + output2.getExitCode() + "; stderr=" + output2.getStderr() + "; stdout=" + output2.getStdout() + "]");
            return null;
        }
        return output2.getStdoutLines();
    }

    @Nullable
    private String computeUserHome() {
        return this.getEnvironmentVariable("HOME");
    }

    @Nullable
    String getEnvironmentVariable(String name) {
        return this.readWslOutputLine(new WSLCommandLineOptions().setExecuteCommandInInteractiveShell(true).setExecuteCommandInLoginShell(true), List.of("printenv", name));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msId";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/wsl/WslDistributionDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/wsl/WslDistributionDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMsId";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMntRoot";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "computeMntRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

