/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLDistributionLegacy;
import com.intellij.execution.wsl.WSLDistributionService;
import com.intellij.execution.wsl.WslDistributionDescriptor;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WSLUtil {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.wsl");

    @Deprecated
    public static boolean hasAvailableDistributions() {
        return !WSLUtil.getAvailableDistributions().isEmpty();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static List<WSLDistribution> getAvailableDistributions() {
        if (!WSLUtil.isSystemCompatible()) {
            List<WSLDistribution> list2 = Collections.emptyList();
            if (list2 == null) {
                WSLUtil.$$$reportNull$$$0(0);
            }
            return list2;
        }
        Path executableRoot = WSLUtil.getExecutableRootPath();
        if (executableRoot == null) {
            List<WSLDistribution> list3 = Collections.emptyList();
            if (list3 == null) {
                WSLUtil.$$$reportNull$$$0(1);
            }
            return list3;
        }
        Collection<WslDistributionDescriptor> descriptors2 = WSLDistributionService.getInstance().getDescriptors();
        ArrayList<WSLDistribution> result2 = new ArrayList<WSLDistribution>(descriptors2.size() + 1);
        for (WslDistributionDescriptor descriptor2 : descriptors2) {
            String executablePathStr = descriptor2.getExecutablePath();
            if (executablePathStr == null) continue;
            Path executablePath = Paths.get(executablePathStr, new String[0]);
            if (!executablePath.isAbsolute()) {
                executablePath = executableRoot.resolve(executablePath);
            }
            if (!Files.exists(executablePath, LinkOption.NOFOLLOW_LINKS)) continue;
            result2.add(new WSLDistribution(descriptor2, executablePath));
        }
        if (Experiments.getInstance().isFeatureEnabled("wsl.legacy.distribution")) {
            ContainerUtil.addIfNotNull(result2, (Object)WSLDistributionLegacy.getInstance());
        }
        ArrayList<WSLDistribution> arrayList = result2;
        if (arrayList == null) {
            WSLUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Nullable
    private static Path getExecutableRootPath() {
        String localAppDataPath = System.getenv().get("LOCALAPPDATA");
        return StringUtil.isEmpty((String)localAppDataPath) ? null : Paths.get(localAppDataPath, "Microsoft\\WindowsApps");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Nullable
    public static WSLDistribution getDistributionById(@Nullable String id2) {
        if (id2 == null) {
            return null;
        }
        for (WSLDistribution distribution2 : WSLUtil.getAvailableDistributions()) {
            if (!id2.equals(distribution2.getId())) continue;
            return distribution2;
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static WSLDistribution getDistributionByMsId(@Nullable String name) {
        if (name == null) {
            return null;
        }
        for (WSLDistribution distribution2 : WSLUtil.getAvailableDistributions()) {
            if (!name.equals(distribution2.getMsId())) continue;
            return distribution2;
        }
        return null;
    }

    public static boolean isSystemCompatible() {
        return SystemInfo.isWin10OrNewer;
    }

    @Nullable
    public static String getWindowsPath(@NotNull String wslPath, @NotNull String mntRoot) {
        if (wslPath == null) {
            WSLUtil.$$$reportNull$$$0(3);
        }
        if (mntRoot == null) {
            WSLUtil.$$$reportNull$$$0(4);
        }
        if (!wslPath.startsWith(mntRoot)) {
            return null;
        }
        int driveLetterIndex = mntRoot.length();
        if (driveLetterIndex >= wslPath.length() || !Character.isLetter(wslPath.charAt(driveLetterIndex))) {
            return null;
        }
        int slashIndex = driveLetterIndex + 1;
        if (slashIndex < wslPath.length() && wslPath.charAt(slashIndex) != '/') {
            return null;
        }
        return FileUtil.toSystemDependentName((String)(Character.toUpperCase(wslPath.charAt(driveLetterIndex)) + ":" + wslPath.substring(slashIndex)));
    }

    @NotNull
    public static ThreeState isWsl1(@NotNull WSLDistribution distribution2) {
        ProcessOutput output2;
        block7: {
            ThreeState threeState;
            if (distribution2 == null) {
                WSLUtil.$$$reportNull$$$0(5);
            }
            try {
                output2 = distribution2.executeOnWsl(10000, "uname", "-v");
                if (output2.getExitCode() == 0) break block7;
                threeState = ThreeState.UNSURE;
            }
            catch (ExecutionException e) {
                LOG.warn((Throwable)e);
                ThreeState threeState2 = ThreeState.UNSURE;
                if (threeState2 == null) {
                    WSLUtil.$$$reportNull$$$0(8);
                }
                return threeState2;
            }
            if (threeState == null) {
                WSLUtil.$$$reportNull$$$0(6);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.fromBoolean((boolean)output2.getStdout().contains("Microsoft"));
        if (threeState == null) {
            WSLUtil.$$$reportNull$$$0(7);
        }
        return threeState;
    }

    @NotNull
    @NlsSafe
    public static String getMsId(@NotNull @NlsSafe String msOrInternalId) {
        WslDistributionDescriptor descriptor2;
        if (msOrInternalId == null) {
            WSLUtil.$$$reportNull$$$0(9);
        }
        String string = (descriptor2 = (WslDistributionDescriptor)ContainerUtil.find(WSLDistributionService.getInstance().getDescriptors(), d -> d.getId().equals(msOrInternalId))) != null ? descriptor2.getMsId() : msOrInternalId;
        if (string == null) {
            WSLUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/wsl/WSLUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mntRoot";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msOrInternalId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDistributions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/wsl/WSLUtil";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "isWsl1";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMsId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getWindowsPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isWsl1";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMsId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

